/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.estimation;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math.estimation.AbstractEstimator;
import org.apache.commons.math.estimation.EstimationException;
import org.apache.commons.math.estimation.EstimationProblem;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

@Deprecated
public class LevenbergMarquardtEstimator
extends AbstractEstimator
implements Serializable {
    private static final long serialVersionUID = -5705952631533171019L;
    private int solvedCols;
    private double[] diagR;
    private double[] jacNorm;
    private double[] beta;
    private int[] permutation;
    private int rank;
    private double lmPar;
    private double[] lmDir;
    private double initialStepBoundFactor;
    private double costRelativeTolerance;
    private double parRelativeTolerance;
    private double orthoTolerance;

    public LevenbergMarquardtEstimator() {
        this.setMaxCostEval(1000);
        this.setInitialStepBoundFactor(100.0);
        this.setCostRelativeTolerance(1.0E-10);
        this.setParRelativeTolerance(1.0E-10);
        this.setOrthoTolerance(1.0E-10);
    }

    public void setInitialStepBoundFactor(double initialStepBoundFactor) {
        this.initialStepBoundFactor = initialStepBoundFactor;
    }

    public void setCostRelativeTolerance(double costRelativeTolerance) {
        this.costRelativeTolerance = costRelativeTolerance;
    }

    public void setParRelativeTolerance(double parRelativeTolerance) {
        this.parRelativeTolerance = parRelativeTolerance;
    }

    public void setOrthoTolerance(double orthoTolerance) {
        this.orthoTolerance = orthoTolerance;
    }

    public void estimate(EstimationProblem problem) throws EstimationException {
        this.initializeEstimate(problem);
        this.solvedCols = FastMath.min(this.rows, this.cols);
        this.diagR = new double[this.cols];
        this.jacNorm = new double[this.cols];
        this.beta = new double[this.cols];
        this.permutation = new int[this.cols];
        this.lmDir = new double[this.cols];
        double delta = 0.0;
        double xNorm = 0.0;
        double[] diag = new double[this.cols];
        double[] oldX = new double[this.cols];
        double[] oldRes = new double[this.rows];
        double[] work1 = new double[this.cols];
        double[] work2 = new double[this.cols];
        double[] work3 = new double[this.cols];
        this.updateResidualsAndCost();
        this.lmPar = 0.0;
        boolean firstIteration = true;
        block0: while (true) {
            int j2;
            int k2;
            this.updateJacobian();
            this.qrDecomposition();
            this.qTy(this.residuals);
            for (k2 = 0; k2 < this.solvedCols; ++k2) {
                int pk = this.permutation[k2];
                this.jacobian[k2 * this.cols + pk] = this.diagR[pk];
            }
            if (firstIteration) {
                xNorm = 0.0;
                for (k2 = 0; k2 < this.cols; ++k2) {
                    double dk = this.jacNorm[k2];
                    if (dk == 0.0) {
                        dk = 1.0;
                    }
                    double xk = dk * this.parameters[k2].getEstimate();
                    xNorm += xk * xk;
                    diag[k2] = dk;
                }
                delta = (xNorm = FastMath.sqrt(xNorm)) == 0.0 ? this.initialStepBoundFactor : this.initialStepBoundFactor * xNorm;
            }
            double maxCosine = 0.0;
            if (this.cost != 0.0) {
                for (j2 = 0; j2 < this.solvedCols; ++j2) {
                    int pj = this.permutation[j2];
                    double s2 = this.jacNorm[pj];
                    if (s2 == 0.0) continue;
                    double sum = 0.0;
                    int index = pj;
                    for (int i2 = 0; i2 <= j2; ++i2) {
                        sum += this.jacobian[index] * this.residuals[i2];
                        index += this.cols;
                    }
                    maxCosine = FastMath.max(maxCosine, FastMath.abs(sum) / (s2 * this.cost));
                }
            }
            if (maxCosine <= this.orthoTolerance) {
                return;
            }
            for (j2 = 0; j2 < this.cols; ++j2) {
                diag[j2] = FastMath.max(diag[j2], this.jacNorm[j2]);
            }
            double ratio = 0.0;
            do {
                if (!(ratio < 1.0E-4)) continue block0;
                for (int j3 = 0; j3 < this.solvedCols; ++j3) {
                    int pj = this.permutation[j3];
                    oldX[pj] = this.parameters[pj].getEstimate();
                }
                double previousCost = this.cost;
                double[] tmpVec = this.residuals;
                this.residuals = oldRes;
                oldRes = tmpVec;
                this.determineLMParameter(oldRes, delta, diag, work1, work2, work3);
                double lmNorm = 0.0;
                for (int j4 = 0; j4 < this.solvedCols; ++j4) {
                    int pj = this.permutation[j4];
                    this.lmDir[pj] = -this.lmDir[pj];
                    this.parameters[pj].setEstimate(oldX[pj] + this.lmDir[pj]);
                    double s3 = diag[pj] * this.lmDir[pj];
                    lmNorm += s3 * s3;
                }
                lmNorm = FastMath.sqrt(lmNorm);
                if (firstIteration) {
                    delta = FastMath.min(delta, lmNorm);
                }
                this.updateResidualsAndCost();
                double actRed = -1.0;
                if (0.1 * this.cost < previousCost) {
                    double r2 = this.cost / previousCost;
                    actRed = 1.0 - r2 * r2;
                }
                for (int j5 = 0; j5 < this.solvedCols; ++j5) {
                    int pj = this.permutation[j5];
                    double dirJ = this.lmDir[pj];
                    work1[j5] = 0.0;
                    int index = pj;
                    int i3 = 0;
                    while (i3 <= j5) {
                        int n2 = i3++;
                        work1[n2] = work1[n2] + this.jacobian[index] * dirJ;
                        index += this.cols;
                    }
                }
                double coeff1 = 0.0;
                for (int j6 = 0; j6 < this.solvedCols; ++j6) {
                    coeff1 += work1[j6] * work1[j6];
                }
                double pc2 = previousCost * previousCost;
                double coeff2 = this.lmPar * lmNorm * lmNorm / pc2;
                double preRed = (coeff1 /= pc2) + 2.0 * coeff2;
                double dirDer = -(coeff1 + coeff2);
                double d2 = ratio = preRed == 0.0 ? 0.0 : actRed / preRed;
                if (ratio <= 0.25) {
                    double tmp;
                    double d3 = tmp = actRed < 0.0 ? 0.5 * dirDer / (dirDer + 0.5 * actRed) : 0.5;
                    if (0.1 * this.cost >= previousCost || tmp < 0.1) {
                        tmp = 0.1;
                    }
                    delta = tmp * FastMath.min(delta, 10.0 * lmNorm);
                    this.lmPar /= tmp;
                } else if (this.lmPar == 0.0 || ratio >= 0.75) {
                    delta = 2.0 * lmNorm;
                    this.lmPar *= 0.5;
                }
                if (ratio >= 1.0E-4) {
                    firstIteration = false;
                    xNorm = 0.0;
                    for (int k3 = 0; k3 < this.cols; ++k3) {
                        double xK = diag[k3] * this.parameters[k3].getEstimate();
                        xNorm += xK * xK;
                    }
                    xNorm = FastMath.sqrt(xNorm);
                } else {
                    this.cost = previousCost;
                    for (int j7 = 0; j7 < this.solvedCols; ++j7) {
                        int pj = this.permutation[j7];
                        this.parameters[pj].setEstimate(oldX[pj]);
                    }
                    tmpVec = this.residuals;
                    this.residuals = oldRes;
                    oldRes = tmpVec;
                }
                if (FastMath.abs(actRed) <= this.costRelativeTolerance && preRed <= this.costRelativeTolerance && ratio <= 2.0 || delta <= this.parRelativeTolerance * xNorm) {
                    return;
                }
                if (FastMath.abs(actRed) <= 2.2204E-16 && preRed <= 2.2204E-16 && ratio <= 2.0) {
                    throw new EstimationException("cost relative tolerance is too small ({0}), no further reduction in the sum of squares is possible", this.costRelativeTolerance);
                }
                if (!(delta <= 2.2204E-16 * xNorm)) continue;
                throw new EstimationException("parameters relative tolerance is too small ({0}), no further improvement in the approximate solution is possible", this.parRelativeTolerance);
            } while (!(maxCosine <= 2.2204E-16));
            break;
        }
        throw new EstimationException("orthogonality tolerance is too small ({0}), solution is orthogonal to the jacobian", this.orthoTolerance);
    }

    private void determineLMParameter(double[] qy, double delta, double[] diag, double[] work1, double[] work2, double[] work3) {
        int index;
        double sum;
        int pj;
        int j2;
        int j3;
        for (j3 = 0; j3 < this.rank; ++j3) {
            this.lmDir[this.permutation[j3]] = qy[j3];
        }
        for (j3 = this.rank; j3 < this.cols; ++j3) {
            this.lmDir[this.permutation[j3]] = 0.0;
        }
        for (int k2 = this.rank - 1; k2 >= 0; --k2) {
            int pk = this.permutation[k2];
            double ypk = this.lmDir[pk] / this.diagR[pk];
            int index2 = pk;
            for (int i2 = 0; i2 < k2; ++i2) {
                int n2 = this.permutation[i2];
                this.lmDir[n2] = this.lmDir[n2] - ypk * this.jacobian[index2];
                index2 += this.cols;
            }
            this.lmDir[pk] = ypk;
        }
        double dxNorm = 0.0;
        for (int j4 = 0; j4 < this.solvedCols; ++j4) {
            double s2;
            int pj2 = this.permutation[j4];
            work1[pj2] = s2 = diag[pj2] * this.lmDir[pj2];
            dxNorm += s2 * s2;
        }
        double fp = (dxNorm = FastMath.sqrt(dxNorm)) - delta;
        if (fp <= 0.1 * delta) {
            this.lmPar = 0.0;
            return;
        }
        double parl = 0.0;
        if (this.rank == this.solvedCols) {
            for (j2 = 0; j2 < this.solvedCols; ++j2) {
                int n3 = pj = this.permutation[j2];
                work1[n3] = work1[n3] * (diag[pj] / dxNorm);
            }
            double sum2 = 0.0;
            for (j2 = 0; j2 < this.solvedCols; ++j2) {
                double s3;
                pj = this.permutation[j2];
                sum = 0.0;
                index = pj;
                for (int i3 = 0; i3 < j2; ++i3) {
                    sum += this.jacobian[index] * work1[this.permutation[i3]];
                    index += this.cols;
                }
                work1[pj] = s3 = (work1[pj] - sum) / this.diagR[pj];
                sum2 += s3 * s3;
            }
            parl = fp / (delta * sum2);
        }
        double sum2 = 0.0;
        for (j2 = 0; j2 < this.solvedCols; ++j2) {
            pj = this.permutation[j2];
            sum = 0.0;
            index = pj;
            for (int i4 = 0; i4 <= j2; ++i4) {
                sum += this.jacobian[index] * qy[i4];
                index += this.cols;
            }
            sum2 += (sum /= diag[pj]) * sum;
        }
        double gNorm = FastMath.sqrt(sum2);
        double paru = gNorm / delta;
        if (paru == 0.0) {
            paru = 2.2251E-308 / FastMath.min(delta, 0.1);
        }
        this.lmPar = FastMath.min(paru, FastMath.max(this.lmPar, parl));
        if (this.lmPar == 0.0) {
            this.lmPar = gNorm / dxNorm;
        }
        for (int countdown = 10; countdown >= 0; --countdown) {
            int pj3;
            int j5;
            int pj4;
            int j6;
            if (this.lmPar == 0.0) {
                this.lmPar = FastMath.max(2.2251E-308, 0.001 * paru);
            }
            double sPar = FastMath.sqrt(this.lmPar);
            for (j6 = 0; j6 < this.solvedCols; ++j6) {
                pj4 = this.permutation[j6];
                work1[pj4] = sPar * diag[pj4];
            }
            this.determineLMDirection(qy, work1, work2, work3);
            dxNorm = 0.0;
            for (j6 = 0; j6 < this.solvedCols; ++j6) {
                double s4;
                pj4 = this.permutation[j6];
                work3[pj4] = s4 = diag[pj4] * this.lmDir[pj4];
                dxNorm += s4 * s4;
            }
            dxNorm = FastMath.sqrt(dxNorm);
            double previousFP = fp;
            fp = dxNorm - delta;
            if (FastMath.abs(fp) <= 0.1 * delta || parl == 0.0 && fp <= previousFP && previousFP < 0.0) {
                return;
            }
            for (j5 = 0; j5 < this.solvedCols; ++j5) {
                pj3 = this.permutation[j5];
                work1[pj3] = work3[pj3] * diag[pj3] / dxNorm;
            }
            for (j5 = 0; j5 < this.solvedCols; ++j5) {
                int n4 = pj3 = this.permutation[j5];
                work1[n4] = work1[n4] / work2[j5];
                double tmp = work1[pj3];
                for (int i5 = j5 + 1; i5 < this.solvedCols; ++i5) {
                    int n5 = this.permutation[i5];
                    work1[n5] = work1[n5] - this.jacobian[i5 * this.cols + pj3] * tmp;
                }
            }
            sum2 = 0.0;
            for (j5 = 0; j5 < this.solvedCols; ++j5) {
                double s5 = work1[this.permutation[j5]];
                sum2 += s5 * s5;
            }
            double correction = fp / (delta * sum2);
            if (fp > 0.0) {
                parl = FastMath.max(parl, this.lmPar);
            } else if (fp < 0.0) {
                paru = FastMath.min(paru, this.lmPar);
            }
            this.lmPar = FastMath.max(parl, this.lmPar + correction);
        }
    }

    private void determineLMDirection(double[] qy, double[] diag, double[] lmDiag, double[] work) {
        int j2;
        int pj;
        int j3;
        for (j3 = 0; j3 < this.solvedCols; ++j3) {
            pj = this.permutation[j3];
            for (int i2 = j3 + 1; i2 < this.solvedCols; ++i2) {
                this.jacobian[i2 * this.cols + pj] = this.jacobian[j3 * this.cols + this.permutation[i2]];
            }
            this.lmDir[j3] = this.diagR[pj];
            work[j3] = qy[j3];
        }
        for (j3 = 0; j3 < this.solvedCols; ++j3) {
            pj = this.permutation[j3];
            double dpj = diag[pj];
            if (dpj != 0.0) {
                Arrays.fill(lmDiag, j3 + 1, lmDiag.length, 0.0);
            }
            lmDiag[j3] = dpj;
            double qtbpj = 0.0;
            for (int k2 = j3; k2 < this.solvedCols; ++k2) {
                double cos;
                double sin;
                int pk = this.permutation[k2];
                if (lmDiag[k2] == 0.0) continue;
                double rkk = this.jacobian[k2 * this.cols + pk];
                if (FastMath.abs(rkk) < FastMath.abs(lmDiag[k2])) {
                    double cotan = rkk / lmDiag[k2];
                    sin = 1.0 / FastMath.sqrt(1.0 + cotan * cotan);
                    cos = sin * cotan;
                } else {
                    double tan = lmDiag[k2] / rkk;
                    cos = 1.0 / FastMath.sqrt(1.0 + tan * tan);
                    sin = cos * tan;
                }
                this.jacobian[k2 * this.cols + pk] = cos * rkk + sin * lmDiag[k2];
                double temp = cos * work[k2] + sin * qtbpj;
                qtbpj = -sin * work[k2] + cos * qtbpj;
                work[k2] = temp;
                for (int i3 = k2 + 1; i3 < this.solvedCols; ++i3) {
                    double rik = this.jacobian[i3 * this.cols + pk];
                    double temp2 = cos * rik + sin * lmDiag[i3];
                    lmDiag[i3] = -sin * rik + cos * lmDiag[i3];
                    this.jacobian[i3 * this.cols + pk] = temp2;
                }
            }
            int index = j3 * this.cols + this.permutation[j3];
            lmDiag[j3] = this.jacobian[index];
            this.jacobian[index] = this.lmDir[j3];
        }
        int nSing = this.solvedCols;
        for (j2 = 0; j2 < this.solvedCols; ++j2) {
            if (lmDiag[j2] == 0.0 && nSing == this.solvedCols) {
                nSing = j2;
            }
            if (nSing >= this.solvedCols) continue;
            work[j2] = 0.0;
        }
        if (nSing > 0) {
            for (j2 = nSing - 1; j2 >= 0; --j2) {
                int pj2 = this.permutation[j2];
                double sum = 0.0;
                for (int i4 = j2 + 1; i4 < nSing; ++i4) {
                    sum += this.jacobian[i4 * this.cols + pj2] * work[i4];
                }
                work[j2] = (work[j2] - sum) / lmDiag[j2];
            }
        }
        for (j2 = 0; j2 < this.lmDir.length; ++j2) {
            this.lmDir[this.permutation[j2]] = work[j2];
        }
    }

    private void qrDecomposition() throws EstimationException {
        int k2;
        for (k2 = 0; k2 < this.cols; ++k2) {
            this.permutation[k2] = k2;
            double norm2 = 0.0;
            for (int index = k2; index < this.jacobian.length; index += this.cols) {
                double akk = this.jacobian[index];
                norm2 += akk * akk;
            }
            this.jacNorm[k2] = FastMath.sqrt(norm2);
        }
        for (k2 = 0; k2 < this.cols; ++k2) {
            double betak;
            int nextColumn = -1;
            double ak2 = Double.NEGATIVE_INFINITY;
            for (int i2 = k2; i2 < this.cols; ++i2) {
                int iDiag;
                double norm2 = 0.0;
                for (int index = iDiag = k2 * this.cols + this.permutation[i2]; index < this.jacobian.length; index += this.cols) {
                    double aki = this.jacobian[index];
                    norm2 += aki * aki;
                }
                if (Double.isInfinite(norm2) || Double.isNaN(norm2)) {
                    throw new EstimationException(LocalizedFormats.UNABLE_TO_PERFORM_QR_DECOMPOSITION_ON_JACOBIAN, this.rows, this.cols);
                }
                if (!(norm2 > ak2)) continue;
                nextColumn = i2;
                ak2 = norm2;
            }
            if (ak2 == 0.0) {
                this.rank = k2;
                return;
            }
            int pk = this.permutation[nextColumn];
            this.permutation[nextColumn] = this.permutation[k2];
            this.permutation[k2] = pk;
            int kDiag = k2 * this.cols + pk;
            double akk = this.jacobian[kDiag];
            double alpha = akk > 0.0 ? -FastMath.sqrt(ak2) : FastMath.sqrt(ak2);
            this.beta[pk] = betak = 1.0 / (ak2 - akk * alpha);
            this.diagR[pk] = alpha;
            int n2 = kDiag;
            this.jacobian[n2] = this.jacobian[n2] - alpha;
            for (int dk = this.cols - 1 - k2; dk > 0; --dk) {
                int index;
                int dkp = this.permutation[k2 + dk] - pk;
                double gamma = 0.0;
                for (index = kDiag; index < this.jacobian.length; index += this.cols) {
                    gamma += this.jacobian[index] * this.jacobian[index + dkp];
                }
                gamma *= betak;
                for (index = kDiag; index < this.jacobian.length; index += this.cols) {
                    int n3 = index + dkp;
                    this.jacobian[n3] = this.jacobian[n3] - gamma * this.jacobian[index];
                }
            }
        }
        this.rank = this.solvedCols;
    }

    private void qTy(double[] y) {
        for (int k2 = 0; k2 < this.cols; ++k2) {
            int i2;
            int pk = this.permutation[k2];
            int kDiag = k2 * this.cols + pk;
            double gamma = 0.0;
            int index = kDiag;
            for (i2 = k2; i2 < this.rows; ++i2) {
                gamma += this.jacobian[index] * y[i2];
                index += this.cols;
            }
            gamma *= this.beta[pk];
            index = kDiag;
            i2 = k2;
            while (i2 < this.rows) {
                int n2 = i2++;
                y[n2] = y[n2] - gamma * this.jacobian[index];
                index += this.cols;
            }
        }
    }
}

