/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.CSSEngineListener;
import org.apache.batik.css.engine.CSSEngineUserAgent;
import org.apache.batik.css.engine.CSSNavigableDocument;
import org.apache.batik.css.engine.CSSNavigableDocumentListener;
import org.apache.batik.css.engine.CSSNavigableNode;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.CSSStyleSheetNode;
import org.apache.batik.css.engine.FontFaceRule;
import org.apache.batik.css.engine.ImportRule;
import org.apache.batik.css.engine.MediaRule;
import org.apache.batik.css.engine.Messages;
import org.apache.batik.css.engine.Rule;
import org.apache.batik.css.engine.StringIntMap;
import org.apache.batik.css.engine.StyleDeclaration;
import org.apache.batik.css.engine.StyleDeclarationProvider;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.StyleRule;
import org.apache.batik.css.engine.StyleSheet;
import org.apache.batik.css.engine.sac.CSSConditionFactory;
import org.apache.batik.css.engine.sac.CSSSelectorFactory;
import org.apache.batik.css.engine.sac.ExtendedSelector;
import org.apache.batik.css.engine.value.ComputedValue;
import org.apache.batik.css.engine.value.InheritValue;
import org.apache.batik.css.engine.value.ShorthandManager;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.css.parser.ExtendedParser;
import org.apache.batik.util.ParsedURL;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public abstract class CSSEngine {
    protected CSSEngineUserAgent userAgent;
    protected CSSContext cssContext;
    protected Document document;
    protected ParsedURL documentURI;
    protected boolean isCSSNavigableDocument;
    protected StringIntMap indexes;
    protected StringIntMap shorthandIndexes;
    protected ValueManager[] valueManagers;
    protected ShorthandManager[] shorthandManagers;
    protected ExtendedParser parser;
    protected String[] pseudoElementNames;
    protected int fontSizeIndex = -1;
    protected int lineHeightIndex = -1;
    protected int colorIndex = -1;
    protected StyleSheet userAgentStyleSheet;
    protected StyleSheet userStyleSheet;
    protected SACMediaList media;
    protected List styleSheetNodes;
    protected List fontFaces = new LinkedList();
    protected String styleNamespaceURI;
    protected String styleLocalName;
    protected String classNamespaceURI;
    protected String classLocalName;
    protected Set nonCSSPresentationalHints;
    protected String nonCSSPresentationalHintsNamespaceURI;
    protected StyleDeclarationDocumentHandler styleDeclarationDocumentHandler = new StyleDeclarationDocumentHandler();
    protected StyleDeclarationUpdateHandler styleDeclarationUpdateHandler;
    protected StyleSheetDocumentHandler styleSheetDocumentHandler = new StyleSheetDocumentHandler();
    protected StyleDeclarationBuilder styleDeclarationBuilder = new StyleDeclarationBuilder();
    protected CSSStylableElement element;
    protected ParsedURL cssBaseURI;
    protected String alternateStyleSheet;
    protected CSSNavigableDocumentHandler cssNavigableDocumentListener;
    protected EventListener domAttrModifiedListener;
    protected EventListener domNodeInsertedListener;
    protected EventListener domNodeRemovedListener;
    protected EventListener domSubtreeModifiedListener;
    protected EventListener domCharacterDataModifiedListener;
    protected boolean styleSheetRemoved;
    protected Node removedStylableElementSibling;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected Set selectorAttributes;
    protected final int[] ALL_PROPERTIES;
    protected CSSConditionFactory cssConditionFactory;
    protected static final CSSEngineListener[] LISTENER_ARRAY = new CSSEngineListener[0];

    public static Node getCSSParentNode(Node n2) {
        if (n2 instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)n2)).getCSSParentNode();
        }
        return n2.getParentNode();
    }

    protected static Node getCSSFirstChild(Node n2) {
        if (n2 instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)n2)).getCSSFirstChild();
        }
        return n2.getFirstChild();
    }

    protected static Node getCSSNextSibling(Node n2) {
        if (n2 instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)n2)).getCSSNextSibling();
        }
        return n2.getNextSibling();
    }

    protected static Node getCSSPreviousSibling(Node n2) {
        if (n2 instanceof CSSNavigableNode) {
            return ((CSSNavigableNode)((Object)n2)).getCSSPreviousSibling();
        }
        return n2.getPreviousSibling();
    }

    public static CSSStylableElement getParentCSSStylableElement(Element elt) {
        Node n2 = CSSEngine.getCSSParentNode(elt);
        while (n2 != null) {
            if (n2 instanceof CSSStylableElement) {
                return (CSSStylableElement)n2;
            }
            n2 = CSSEngine.getCSSParentNode(n2);
        }
        return null;
    }

    protected CSSEngine(Document doc, ParsedURL uri, ExtendedParser p2, ValueManager[] vm, ShorthandManager[] sm, String[] pe, String sns, String sln, String cns, String cln, boolean hints, String hintsNS, CSSContext ctx) {
        int i2;
        this.document = doc;
        this.documentURI = uri;
        this.parser = p2;
        this.pseudoElementNames = pe;
        this.styleNamespaceURI = sns;
        this.styleLocalName = sln;
        this.classNamespaceURI = cns;
        this.classLocalName = cln;
        this.cssContext = ctx;
        this.isCSSNavigableDocument = doc instanceof CSSNavigableDocument;
        this.cssConditionFactory = new CSSConditionFactory(cns, cln, null, "id");
        int len = vm.length;
        this.indexes = new StringIntMap(len);
        this.valueManagers = vm;
        int i3 = len - 1;
        while (i3 >= 0) {
            String pn = vm[i3].getPropertyName();
            this.indexes.put(pn, i3);
            if (this.fontSizeIndex == -1 && pn.equals("font-size")) {
                this.fontSizeIndex = i3;
            }
            if (this.lineHeightIndex == -1 && pn.equals("line-height")) {
                this.lineHeightIndex = i3;
            }
            if (this.colorIndex == -1 && pn.equals("color")) {
                this.colorIndex = i3;
            }
            --i3;
        }
        len = sm.length;
        this.shorthandIndexes = new StringIntMap(len);
        this.shorthandManagers = sm;
        int i4 = len - 1;
        while (i4 >= 0) {
            this.shorthandIndexes.put(sm[i4].getPropertyName(), i4);
            --i4;
        }
        if (hints) {
            this.nonCSSPresentationalHints = new HashSet(vm.length + sm.length);
            this.nonCSSPresentationalHintsNamespaceURI = hintsNS;
            len = vm.length;
            i2 = 0;
            while (i2 < len) {
                String pn = vm[i2].getPropertyName();
                this.nonCSSPresentationalHints.add(pn);
                ++i2;
            }
            len = sm.length;
            int i5 = 0;
            while (i5 < len) {
                String pn = sm[i5].getPropertyName();
                this.nonCSSPresentationalHints.add(pn);
                ++i5;
            }
        }
        if (this.cssContext.isDynamic() && this.document instanceof EventTarget) {
            this.addEventListeners((EventTarget)((Object)this.document));
            this.styleDeclarationUpdateHandler = new StyleDeclarationUpdateHandler();
        }
        this.ALL_PROPERTIES = new int[this.getNumberOfProperties()];
        i2 = this.getNumberOfProperties() - 1;
        while (i2 >= 0) {
            this.ALL_PROPERTIES[i2] = i2;
            --i2;
        }
    }

    protected void addEventListeners(EventTarget doc) {
        if (this.isCSSNavigableDocument) {
            this.cssNavigableDocumentListener = new CSSNavigableDocumentHandler();
            CSSNavigableDocument cnd = (CSSNavigableDocument)((Object)doc);
            cnd.addCSSNavigableDocumentListener(this.cssNavigableDocumentListener);
        } else {
            this.domAttrModifiedListener = new DOMAttrModifiedListener();
            doc.addEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            this.domNodeInsertedListener = new DOMNodeInsertedListener();
            doc.addEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            this.domNodeRemovedListener = new DOMNodeRemovedListener();
            doc.addEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            this.domSubtreeModifiedListener = new DOMSubtreeModifiedListener();
            doc.addEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            this.domCharacterDataModifiedListener = new DOMCharacterDataModifiedListener();
            doc.addEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
        }
    }

    protected void removeEventListeners(EventTarget doc) {
        if (this.isCSSNavigableDocument) {
            CSSNavigableDocument cnd = (CSSNavigableDocument)((Object)doc);
            cnd.removeCSSNavigableDocumentListener(this.cssNavigableDocumentListener);
        } else {
            doc.removeEventListener("DOMAttrModified", this.domAttrModifiedListener, false);
            doc.removeEventListener("DOMNodeInserted", this.domNodeInsertedListener, false);
            doc.removeEventListener("DOMNodeRemoved", this.domNodeRemovedListener, false);
            doc.removeEventListener("DOMSubtreeModified", this.domSubtreeModifiedListener, false);
            doc.removeEventListener("DOMCharacterDataModified", this.domCharacterDataModifiedListener, false);
        }
    }

    public void dispose() {
        this.setCSSEngineUserAgent(null);
        this.disposeStyleMaps(this.document.getDocumentElement());
        if (this.document instanceof EventTarget) {
            this.removeEventListeners((EventTarget)((Object)this.document));
        }
    }

    protected void disposeStyleMaps(Node node) {
        if (node instanceof CSSStylableElement) {
            ((CSSStylableElement)node).setComputedStyleMap(null, null);
        }
        Node n2 = CSSEngine.getCSSFirstChild(node);
        while (n2 != null) {
            if (n2.getNodeType() == 1) {
                this.disposeStyleMaps(n2);
            }
            n2 = CSSEngine.getCSSNextSibling(n2);
        }
    }

    public CSSContext getCSSContext() {
        return this.cssContext;
    }

    public Document getDocument() {
        return this.document;
    }

    public int getFontSizeIndex() {
        return this.fontSizeIndex;
    }

    public int getLineHeightIndex() {
        return this.lineHeightIndex;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public int getNumberOfProperties() {
        return this.valueManagers.length;
    }

    public int getPropertyIndex(String name) {
        return this.indexes.get(name);
    }

    public int getShorthandIndex(String name) {
        return this.shorthandIndexes.get(name);
    }

    public String getPropertyName(int idx) {
        return this.valueManagers[idx].getPropertyName();
    }

    public void setCSSEngineUserAgent(CSSEngineUserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public CSSEngineUserAgent getCSSEngineUserAgent() {
        return this.userAgent;
    }

    public void setUserAgentStyleSheet(StyleSheet ss) {
        this.userAgentStyleSheet = ss;
    }

    public void setUserStyleSheet(StyleSheet ss) {
        this.userStyleSheet = ss;
    }

    public ValueManager[] getValueManagers() {
        return this.valueManagers;
    }

    public ShorthandManager[] getShorthandManagers() {
        return this.shorthandManagers;
    }

    public List getFontFaces() {
        return this.fontFaces;
    }

    public void setMedia(String str) {
        try {
            this.media = this.parser.parseMedia(str);
        }
        catch (Exception e2) {
            String m2 = e2.getMessage();
            if (m2 == null) {
                m2 = "";
            }
            String s2 = Messages.formatMessage("media.error", new Object[]{str, m2});
            throw new DOMException(12, s2);
        }
    }

    public void setAlternateStyleSheet(String str) {
        this.alternateStyleSheet = str;
    }

    public void importCascadedStyleMaps(Element src, CSSEngine srceng, Element dest) {
        if (src instanceof CSSStylableElement) {
            CSSStylableElement csrc = (CSSStylableElement)src;
            CSSStylableElement cdest = (CSSStylableElement)dest;
            StyleMap sm = srceng.getCascadedStyleMap(csrc, null);
            sm.setFixedCascadedStyle(true);
            cdest.setComputedStyleMap(null, sm);
            if (this.pseudoElementNames != null) {
                int len = this.pseudoElementNames.length;
                int i2 = 0;
                while (i2 < len) {
                    String pe = this.pseudoElementNames[i2];
                    sm = srceng.getCascadedStyleMap(csrc, pe);
                    cdest.setComputedStyleMap(pe, sm);
                    ++i2;
                }
            }
        }
        Node dn = CSSEngine.getCSSFirstChild(dest);
        Node sn = CSSEngine.getCSSFirstChild(src);
        while (dn != null) {
            if (sn.getNodeType() == 1) {
                this.importCascadedStyleMaps((Element)sn, srceng, (Element)dn);
            }
            dn = CSSEngine.getCSSNextSibling(dn);
            sn = CSSEngine.getCSSNextSibling(sn);
        }
    }

    public ParsedURL getCSSBaseURI() {
        if (this.cssBaseURI == null) {
            this.cssBaseURI = this.element.getCSSBase();
        }
        return this.cssBaseURI;
    }

    public StyleMap getCascadedStyleMap(CSSStylableElement elt, String pseudo) {
        ArrayList rules;
        int props = this.getNumberOfProperties();
        final StyleMap result = new StyleMap(props);
        if (this.userAgentStyleSheet != null) {
            rules = new ArrayList();
            this.addMatchingRules(rules, this.userAgentStyleSheet, elt, pseudo);
            this.addRules(elt, pseudo, result, rules, (short)0);
        }
        if (this.userStyleSheet != null) {
            rules = new ArrayList();
            this.addMatchingRules(rules, this.userStyleSheet, elt, pseudo);
            this.addRules(elt, pseudo, result, rules, (short)8192);
        }
        this.element = elt;
        try {
            StyleDeclaration over;
            StyleDeclarationProvider p2;
            String style;
            CSSEngine eng;
            List snodes;
            int slen;
            if (this.nonCSSPresentationalHints != null) {
                ShorthandManager.PropertyHandler ph = new ShorthandManager.PropertyHandler(){

                    public void property(String pname, LexicalUnit lu, boolean important) {
                        int idx = CSSEngine.this.getPropertyIndex(pname);
                        if (idx != -1) {
                            ValueManager vm = CSSEngine.this.valueManagers[idx];
                            Value v2 = vm.createValue(lu, CSSEngine.this);
                            CSSEngine.this.putAuthorProperty(result, idx, v2, important, (short)16384);
                            return;
                        }
                        idx = CSSEngine.this.getShorthandIndex(pname);
                        if (idx == -1) {
                            return;
                        }
                        CSSEngine.this.shorthandManagers[idx].setValues(CSSEngine.this, this, lu, important);
                    }
                };
                NamedNodeMap attrs = elt.getAttributes();
                int len = attrs.getLength();
                int i2 = 0;
                while (i2 < len) {
                    Node attr = attrs.item(i2);
                    String an = attr.getNodeName();
                    if (this.nonCSSPresentationalHints.contains(an)) {
                        String attrValue = attr.getNodeValue();
                        try {
                            LexicalUnit lu = this.parser.parsePropertyValue(attr.getNodeValue());
                            ph.property(an, lu, false);
                        }
                        catch (Exception e2) {
                            System.err.println("\n***** CSSEngine: exception property.syntax.error:" + e2);
                            System.err.println("\nAttrValue:" + attrValue);
                            System.err.println("\nException:" + e2.getClass().getName());
                            e2.printStackTrace(System.err);
                            System.err.println("\n***** CSSEngine: exception....");
                            String m2 = e2.getMessage();
                            if (m2 == null) {
                                m2 = "";
                            }
                            String u2 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                            String s2 = Messages.formatMessage("property.syntax.error.at", new Object[]{u2, an, attr.getNodeValue(), m2});
                            DOMException de = new DOMException(12, s2);
                            if (this.userAgent == null) {
                                throw de;
                            }
                            this.userAgent.displayError(de);
                        }
                    }
                    ++i2;
                }
            }
            if ((slen = (snodes = (eng = this.cssContext.getCSSEngineForElement(elt)).getStyleSheetNodes()).size()) > 0) {
                ArrayList rules2 = new ArrayList();
                int i3 = 0;
                while (i3 < slen) {
                    CSSStyleSheetNode ssn = (CSSStyleSheetNode)snodes.get(i3);
                    StyleSheet ss = ssn.getCSSStyleSheet();
                    if (ss != null && (!ss.isAlternate() || ss.getTitle() == null || ss.getTitle().equals(this.alternateStyleSheet)) && this.mediaMatch(ss.getMedia())) {
                        this.addMatchingRules(rules2, ss, elt, pseudo);
                    }
                    ++i3;
                }
                this.addRules(elt, pseudo, result, rules2, (short)24576);
            }
            if (this.styleLocalName != null && (style = elt.getAttributeNS(this.styleNamespaceURI, this.styleLocalName)).length() > 0) {
                try {
                    this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                    this.parser.setConditionFactory(this.cssConditionFactory);
                    this.styleDeclarationDocumentHandler.styleMap = result;
                    this.parser.setDocumentHandler(this.styleDeclarationDocumentHandler);
                    this.parser.parseStyleDeclaration(style);
                    this.styleDeclarationDocumentHandler.styleMap = null;
                }
                catch (Exception e3) {
                    String m3 = e3.getMessage();
                    if (m3 == null) {
                        m3 = e3.getClass().getName();
                    }
                    String u3 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                    String s3 = Messages.formatMessage("style.syntax.error.at", new Object[]{u3, this.styleLocalName, style, m3});
                    DOMException de = new DOMException(12, s3);
                    if (this.userAgent == null) {
                        throw de;
                    }
                    this.userAgent.displayError(de);
                }
            }
            if ((p2 = elt.getOverrideStyleDeclarationProvider()) != null && (over = p2.getStyleDeclaration()) != null) {
                int ol = over.size();
                int i4 = 0;
                while (i4 < ol) {
                    int idx = over.getIndex(i4);
                    Value value = over.getValue(i4);
                    boolean important = over.getPriority(i4);
                    if (!result.isImportant(idx) || important) {
                        result.putValue(idx, value);
                        result.putImportant(idx, important);
                        result.putOrigin(idx, (short)-24576);
                    }
                    ++i4;
                }
            }
            Object var18_28 = null;
            this.element = null;
            this.cssBaseURI = null;
        }
        catch (Throwable throwable) {
            Object var18_29 = null;
            this.element = null;
            this.cssBaseURI = null;
            throw throwable;
        }
        return result;
    }

    public Value getComputedStyle(CSSStylableElement elt, String pseudo, int propidx) {
        StyleMap sm = elt.getComputedStyleMap(pseudo);
        if (sm == null) {
            sm = this.getCascadedStyleMap(elt, pseudo);
            elt.setComputedStyleMap(pseudo, sm);
        }
        Value value = sm.getValue(propidx);
        if (sm.isComputed(propidx)) {
            return value;
        }
        Value result = value;
        ValueManager vm = this.valueManagers[propidx];
        CSSStylableElement p2 = CSSEngine.getParentCSSStylableElement(elt);
        if (value == null) {
            if (p2 == null || !vm.isInheritedProperty()) {
                result = vm.getDefaultValue();
            }
        } else if (p2 != null && value == InheritValue.INSTANCE) {
            result = null;
        }
        if (result == null) {
            result = this.getComputedStyle(p2, null, propidx);
            sm.putParentRelative(propidx, true);
            sm.putInherited(propidx, true);
        } else {
            result = vm.computeValue(elt, pseudo, this, propidx, sm, result);
        }
        if (value == null) {
            sm.putValue(propidx, result);
            sm.putNullCascaded(propidx, true);
        } else if (result != value) {
            ComputedValue cv = new ComputedValue(value);
            cv.setComputedValue(result);
            sm.putValue(propidx, cv);
            result = cv;
        }
        sm.putComputed(propidx, true);
        return result;
    }

    public List getStyleSheetNodes() {
        if (this.styleSheetNodes == null) {
            this.styleSheetNodes = new ArrayList();
            this.selectorAttributes = new HashSet();
            this.findStyleSheetNodes(this.document);
            int len = this.styleSheetNodes.size();
            int i2 = 0;
            while (i2 < len) {
                CSSStyleSheetNode ssn = (CSSStyleSheetNode)this.styleSheetNodes.get(i2);
                StyleSheet ss = ssn.getCSSStyleSheet();
                if (ss != null) {
                    this.findSelectorAttributes(this.selectorAttributes, ss);
                }
                ++i2;
            }
        }
        return this.styleSheetNodes;
    }

    protected void findStyleSheetNodes(Node n2) {
        if (n2 instanceof CSSStyleSheetNode) {
            this.styleSheetNodes.add(n2);
        }
        Node nd = CSSEngine.getCSSFirstChild(n2);
        while (nd != null) {
            this.findStyleSheetNodes(nd);
            nd = CSSEngine.getCSSNextSibling(nd);
        }
    }

    protected void findSelectorAttributes(Set attrs, StyleSheet ss) {
        int len = ss.getSize();
        int i2 = 0;
        while (i2 < len) {
            Rule r2 = ss.getRule(i2);
            switch (r2.getType()) {
                case 0: {
                    StyleRule style = (StyleRule)r2;
                    SelectorList sl = style.getSelectorList();
                    int slen = sl.getLength();
                    int j2 = 0;
                    while (j2 < slen) {
                        ExtendedSelector s2 = (ExtendedSelector)sl.item(j2);
                        s2.fillAttributeSet(attrs);
                        ++j2;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    MediaRule mr = (MediaRule)r2;
                    if (!this.mediaMatch(mr.getMediaList())) break;
                    this.findSelectorAttributes(attrs, mr);
                }
            }
            ++i2;
        }
    }

    public void setMainProperties(CSSStylableElement elt, final MainPropertyReceiver dst, String pname, String value, boolean important) {
        try {
            try {
                this.element = elt;
                LexicalUnit lu = this.parser.parsePropertyValue(value);
                ShorthandManager.PropertyHandler ph = new ShorthandManager.PropertyHandler(){

                    public void property(String pname, LexicalUnit lu, boolean important) {
                        int idx = CSSEngine.this.getPropertyIndex(pname);
                        if (idx != -1) {
                            ValueManager vm = CSSEngine.this.valueManagers[idx];
                            Value v2 = vm.createValue(lu, CSSEngine.this);
                            dst.setMainProperty(pname, v2, important);
                            return;
                        }
                        idx = CSSEngine.this.getShorthandIndex(pname);
                        if (idx == -1) {
                            return;
                        }
                        CSSEngine.this.shorthandManagers[idx].setValues(CSSEngine.this, this, lu, important);
                    }
                };
                ph.property(pname, lu, important);
            }
            catch (Exception e2) {
                String m2 = e2.getMessage();
                if (m2 == null) {
                    m2 = "";
                }
                String u2 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                String s2 = Messages.formatMessage("property.syntax.error.at", new Object[]{u2, pname, value, m2});
                DOMException de = new DOMException(12, s2);
                if (this.userAgent == null) {
                    throw de;
                }
                this.userAgent.displayError(de);
                Object var12_11 = null;
                this.element = null;
                this.cssBaseURI = null;
            }
            Object var12_10 = null;
            this.element = null;
            this.cssBaseURI = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.element = null;
            this.cssBaseURI = null;
            throw throwable;
        }
    }

    public Value parsePropertyValue(CSSStylableElement elt, String prop, String value) {
        int idx = this.getPropertyIndex(prop);
        if (idx == -1) {
            return null;
        }
        ValueManager vm = this.valueManagers[idx];
        try {
            try {
                this.element = elt;
                LexicalUnit lu = this.parser.parsePropertyValue(value);
                Value value2 = vm.createValue(lu, this);
                Object var12_10 = null;
                this.element = null;
                this.cssBaseURI = null;
                return value2;
            }
            catch (Exception e2) {
                String m2 = e2.getMessage();
                if (m2 == null) {
                    m2 = "";
                }
                String u2 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                String s2 = Messages.formatMessage("property.syntax.error.at", new Object[]{u2, prop, value, m2});
                DOMException de = new DOMException(12, s2);
                if (this.userAgent == null) {
                    throw de;
                }
                this.userAgent.displayError(de);
                Object var12_11 = null;
                this.element = null;
                this.cssBaseURI = null;
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.element = null;
            this.cssBaseURI = null;
            throw throwable;
        }
        return vm.getDefaultValue();
    }

    public StyleDeclaration parseStyleDeclaration(CSSStylableElement elt, String value) {
        this.styleDeclarationBuilder.styleDeclaration = new StyleDeclaration();
        try {
            try {
                this.element = elt;
                this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                this.parser.setConditionFactory(this.cssConditionFactory);
                this.parser.setDocumentHandler(this.styleDeclarationBuilder);
                this.parser.parseStyleDeclaration(value);
            }
            catch (Exception e2) {
                String m2 = e2.getMessage();
                if (m2 == null) {
                    m2 = "";
                }
                String u2 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                String s2 = Messages.formatMessage("syntax.error.at", new Object[]{u2, m2});
                DOMException de = new DOMException(12, s2);
                if (this.userAgent == null) {
                    throw de;
                }
                this.userAgent.displayError(de);
                Object var9_4 = null;
                this.element = null;
                this.cssBaseURI = null;
            }
            Object var9_3 = null;
            this.element = null;
            this.cssBaseURI = null;
        }
        catch (Throwable throwable) {
            Object var9_5 = null;
            this.element = null;
            this.cssBaseURI = null;
            throw throwable;
        }
        return this.styleDeclarationBuilder.styleDeclaration;
    }

    public StyleSheet parseStyleSheet(ParsedURL uri, String media) throws DOMException {
        StyleSheet ss = new StyleSheet();
        try {
            ss.setMedia(this.parser.parseMedia(media));
        }
        catch (Exception e2) {
            String m2 = e2.getMessage();
            if (m2 == null) {
                m2 = "";
            }
            String u2 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s2 = Messages.formatMessage("syntax.error.at", new Object[]{u2, m2});
            DOMException de = new DOMException(12, s2);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
            return ss;
        }
        this.parseStyleSheet(ss, uri);
        return ss;
    }

    public StyleSheet parseStyleSheet(InputSource is, ParsedURL uri, String media) throws DOMException {
        StyleSheet ss = new StyleSheet();
        try {
            ss.setMedia(this.parser.parseMedia(media));
            this.parseStyleSheet(ss, is, uri);
        }
        catch (Exception e2) {
            String m2 = e2.getMessage();
            if (m2 == null) {
                m2 = "";
            }
            String u2 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s2 = Messages.formatMessage("syntax.error.at", new Object[]{u2, m2});
            DOMException de = new DOMException(12, s2);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
        return ss;
    }

    public void parseStyleSheet(StyleSheet ss, ParsedURL uri) throws DOMException {
        if (uri == null) {
            String s2 = Messages.formatMessage("syntax.error.at", new Object[]{"Null Document reference", ""});
            DOMException de = new DOMException(12, s2);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
            return;
        }
        try {
            this.cssContext.checkLoadExternalResource(uri, this.documentURI);
            this.parseStyleSheet(ss, new InputSource(uri.toString()), uri);
        }
        catch (SecurityException e2) {
            throw e2;
        }
        catch (Exception e3) {
            String m2 = e3.getMessage();
            if (m2 == null) {
                m2 = e3.getClass().getName();
            }
            String s3 = Messages.formatMessage("syntax.error.at", new Object[]{uri.toString(), m2});
            DOMException de = new DOMException(12, s3);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
    }

    public StyleSheet parseStyleSheet(String rules, ParsedURL uri, String media) throws DOMException {
        StyleSheet ss = new StyleSheet();
        try {
            ss.setMedia(this.parser.parseMedia(media));
        }
        catch (Exception e2) {
            String m2 = e2.getMessage();
            if (m2 == null) {
                m2 = "";
            }
            String u2 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
            String s2 = Messages.formatMessage("syntax.error.at", new Object[]{u2, m2});
            DOMException de = new DOMException(12, s2);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
            return ss;
        }
        this.parseStyleSheet(ss, rules, uri);
        return ss;
    }

    public void parseStyleSheet(StyleSheet ss, String rules, ParsedURL uri) throws DOMException {
        try {
            this.parseStyleSheet(ss, new InputSource(new StringReader(rules)), uri);
        }
        catch (Exception e2) {
            String m2 = e2.getMessage();
            if (m2 == null) {
                m2 = "";
            }
            String s2 = Messages.formatMessage("stylesheet.syntax.error", new Object[]{uri.toString(), rules, m2});
            DOMException de = new DOMException(12, s2);
            if (this.userAgent == null) {
                throw de;
            }
            this.userAgent.displayError(de);
        }
    }

    protected void parseStyleSheet(StyleSheet ss, InputSource is, ParsedURL uri) throws IOException {
        this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
        this.parser.setConditionFactory(this.cssConditionFactory);
        try {
            this.cssBaseURI = uri;
            this.styleSheetDocumentHandler.styleSheet = ss;
            this.parser.setDocumentHandler(this.styleSheetDocumentHandler);
            this.parser.parseStyleSheet(is);
            int len = ss.getSize();
            int i2 = 0;
            while (i2 < len) {
                Rule r2 = ss.getRule(i2);
                if (r2.getType() != 2) break;
                ImportRule ir = (ImportRule)r2;
                this.parseStyleSheet(ir, ir.getURI());
                ++i2;
            }
            Object var9_8 = null;
            this.cssBaseURI = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.cssBaseURI = null;
            throw throwable;
        }
    }

    protected void putAuthorProperty(StyleMap dest, int idx, Value sval, boolean imp, short origin) {
        boolean cond;
        Value dval = dest.getValue(idx);
        short dorg = dest.getOrigin(idx);
        boolean dimp = dest.isImportant(idx);
        boolean bl = cond = dval == null;
        if (!cond) {
            switch (dorg) {
                case 8192: {
                    cond = !dimp;
                    break;
                }
                case 24576: {
                    cond = !dimp || imp;
                    break;
                }
                case -24576: {
                    cond = false;
                    break;
                }
                default: {
                    cond = true;
                }
            }
        }
        if (cond) {
            dest.putValue(idx, sval);
            dest.putImportant(idx, imp);
            dest.putOrigin(idx, origin);
        }
    }

    protected void addMatchingRules(List rules, StyleSheet ss, Element elt, String pseudo) {
        int len = ss.getSize();
        int i2 = 0;
        while (i2 < len) {
            Rule r2 = ss.getRule(i2);
            switch (r2.getType()) {
                case 0: {
                    StyleRule style = (StyleRule)r2;
                    SelectorList sl = style.getSelectorList();
                    int slen = sl.getLength();
                    int j2 = 0;
                    while (j2 < slen) {
                        ExtendedSelector s2 = (ExtendedSelector)sl.item(j2);
                        if (s2.match(elt, pseudo)) {
                            rules.add(style);
                        }
                        ++j2;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    MediaRule mr = (MediaRule)r2;
                    if (!this.mediaMatch(mr.getMediaList())) break;
                    this.addMatchingRules(rules, mr, elt, pseudo);
                }
            }
            ++i2;
        }
    }

    protected void addRules(Element elt, String pseudo, StyleMap sm, ArrayList rules, short origin) {
        this.sortRules(rules, elt, pseudo);
        int rlen = rules.size();
        if (origin == 24576) {
            int r2 = 0;
            while (r2 < rlen) {
                StyleRule sr = (StyleRule)rules.get(r2);
                StyleDeclaration sd = sr.getStyleDeclaration();
                int len = sd.size();
                int i2 = 0;
                while (i2 < len) {
                    this.putAuthorProperty(sm, sd.getIndex(i2), sd.getValue(i2), sd.getPriority(i2), origin);
                    ++i2;
                }
                ++r2;
            }
        } else {
            int r3 = 0;
            while (r3 < rlen) {
                StyleRule sr = (StyleRule)rules.get(r3);
                StyleDeclaration sd = sr.getStyleDeclaration();
                int len = sd.size();
                int i3 = 0;
                while (i3 < len) {
                    int idx = sd.getIndex(i3);
                    sm.putValue(idx, sd.getValue(i3));
                    sm.putImportant(idx, sd.getPriority(i3));
                    sm.putOrigin(idx, origin);
                    ++i3;
                }
                ++r3;
            }
        }
    }

    protected void sortRules(ArrayList rules, Element elt, String pseudo) {
        int spec;
        int len = rules.size();
        int[] specificities = new int[len];
        int i2 = 0;
        while (i2 < len) {
            StyleRule r2 = (StyleRule)rules.get(i2);
            SelectorList sl = r2.getSelectorList();
            spec = 0;
            int slen = sl.getLength();
            int k2 = 0;
            while (k2 < slen) {
                int sp;
                ExtendedSelector s2 = (ExtendedSelector)sl.item(k2);
                if (s2.match(elt, pseudo) && (sp = s2.getSpecificity()) > spec) {
                    spec = sp;
                }
                ++k2;
            }
            specificities[i2] = spec;
            ++i2;
        }
        int i3 = 1;
        while (i3 < len) {
            Object rule = rules.get(i3);
            spec = specificities[i3];
            int j2 = i3 - 1;
            while (j2 >= 0 && specificities[j2] > spec) {
                rules.set(j2 + 1, rules.get(j2));
                specificities[j2 + 1] = specificities[j2];
                --j2;
            }
            rules.set(j2 + 1, rule);
            specificities[j2 + 1] = spec;
            ++i3;
        }
    }

    protected boolean mediaMatch(SACMediaList ml) {
        if (this.media == null || ml == null || this.media.getLength() == 0 || ml.getLength() == 0) {
            return true;
        }
        int i2 = 0;
        while (i2 < ml.getLength()) {
            if (ml.item(i2).equalsIgnoreCase("all")) {
                return true;
            }
            int j2 = 0;
            while (j2 < this.media.getLength()) {
                if (this.media.item(j2).equalsIgnoreCase("all") || ml.item(i2).equalsIgnoreCase(this.media.item(j2))) {
                    return true;
                }
                ++j2;
            }
            ++i2;
        }
        return false;
    }

    public void addCSSEngineListener(CSSEngineListener l2) {
        this.listeners.add(l2);
    }

    public void removeCSSEngineListener(CSSEngineListener l2) {
        this.listeners.remove(l2);
    }

    protected void firePropertiesChangedEvent(Element target, int[] props) {
        CSSEngineListener[] ll = this.listeners.toArray(LISTENER_ARRAY);
        int len = ll.length;
        if (len > 0) {
            CSSEngineEvent evt = new CSSEngineEvent(this, target, props);
            int i2 = 0;
            while (i2 < len) {
                ll[i2].propertiesChanged(evt);
                ++i2;
            }
        }
    }

    protected void inlineStyleAttributeUpdated(CSSStylableElement elt, StyleMap style, short attrChange, String prevValue, String newValue) {
        boolean[] updated = this.styleDeclarationUpdateHandler.updatedProperties;
        int i2 = this.getNumberOfProperties() - 1;
        while (i2 >= 0) {
            updated[i2] = false;
            --i2;
        }
        switch (attrChange) {
            case 1: 
            case 2: {
                if (newValue.length() > 0) {
                    this.element = elt;
                    try {
                        Object var14_8;
                        try {
                            this.parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
                            this.parser.setConditionFactory(this.cssConditionFactory);
                            this.styleDeclarationUpdateHandler.styleMap = style;
                            this.parser.setDocumentHandler(this.styleDeclarationUpdateHandler);
                            this.parser.parseStyleDeclaration(newValue);
                            this.styleDeclarationUpdateHandler.styleMap = null;
                        }
                        catch (Exception e2) {
                            String m2 = e2.getMessage();
                            if (m2 == null) {
                                m2 = "";
                            }
                            String u2 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                            String s2 = Messages.formatMessage("style.syntax.error.at", new Object[]{u2, this.styleLocalName, newValue, m2});
                            DOMException de = new DOMException(12, s2);
                            if (this.userAgent == null) {
                                throw de;
                            }
                            this.userAgent.displayError(de);
                            var14_8 = null;
                            this.element = null;
                            this.cssBaseURI = null;
                        }
                        var14_8 = null;
                        this.element = null;
                        this.cssBaseURI = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_9 = null;
                        this.element = null;
                        this.cssBaseURI = null;
                        throw throwable;
                    }
                }
            }
            case 3: {
                boolean removed = false;
                if (prevValue != null && prevValue.length() > 0) {
                    int i3 = this.getNumberOfProperties() - 1;
                    while (i3 >= 0) {
                        short origin;
                        if (style.isComputed(i3) && !updated[i3] && (origin = style.getOrigin(i3)) >= Short.MIN_VALUE) {
                            removed = true;
                            updated[i3] = true;
                        }
                        --i3;
                    }
                }
                if (removed) {
                    this.invalidateProperties(elt, null, updated, true);
                    break;
                }
                int count = 0;
                boolean fs = this.fontSizeIndex == -1 ? false : updated[this.fontSizeIndex];
                boolean lh = this.lineHeightIndex == -1 ? false : updated[this.lineHeightIndex];
                boolean cl = this.colorIndex == -1 ? false : updated[this.colorIndex];
                int i4 = this.getNumberOfProperties() - 1;
                while (i4 >= 0) {
                    if (updated[i4]) {
                        ++count;
                    } else if (fs && style.isFontSizeRelative(i4) || lh && style.isLineHeightRelative(i4) || cl && style.isColorRelative(i4)) {
                        updated[i4] = true;
                        CSSEngine.clearComputedValue(style, i4);
                        ++count;
                    }
                    --i4;
                }
                if (count <= 0) break;
                int[] props = new int[count];
                count = 0;
                int i5 = this.getNumberOfProperties() - 1;
                while (i5 >= 0) {
                    if (updated[i5]) {
                        props[count++] = i5;
                    }
                    --i5;
                }
                this.invalidateProperties(elt, props, null, true);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid attrChangeType");
            }
        }
    }

    private static void clearComputedValue(StyleMap style, int n2) {
        if (style.isNullCascaded(n2)) {
            style.putValue(n2, null);
        } else {
            Value v2 = style.getValue(n2);
            if (v2 instanceof ComputedValue) {
                ComputedValue cv = (ComputedValue)v2;
                v2 = cv.getCascadedValue();
                style.putValue(n2, v2);
            }
        }
        style.putComputed(n2, false);
    }

    protected void invalidateProperties(Node node, int[] properties, boolean[] updated, boolean recascade) {
        int i2;
        int count;
        boolean[] diffs;
        CSSStylableElement elt;
        block16: {
            StyleMap style;
            block15: {
                if (!(node instanceof CSSStylableElement)) {
                    return;
                }
                elt = (CSSStylableElement)node;
                style = elt.getComputedStyleMap(null);
                if (style == null) {
                    return;
                }
                diffs = new boolean[this.getNumberOfProperties()];
                if (updated != null) {
                    System.arraycopy(updated, 0, diffs, 0, updated.length);
                }
                if (properties != null) {
                    int i3 = 0;
                    while (i3 < properties.length) {
                        diffs[properties[i3]] = true;
                        ++i3;
                    }
                }
                count = 0;
                if (recascade) break block15;
                int i4 = 0;
                while (i4 < diffs.length) {
                    if (diffs[i4]) {
                        ++count;
                    }
                    ++i4;
                }
                break block16;
            }
            StyleMap newStyle = this.getCascadedStyleMap(elt, null);
            elt.setComputedStyleMap(null, newStyle);
            i2 = 0;
            while (i2 < diffs.length) {
                block18: {
                    block19: {
                        block17: {
                            if (!diffs[i2]) break block17;
                            ++count;
                            break block18;
                        }
                        Value nv = newStyle.getValue(i2);
                        Value ov = null;
                        if (!style.isNullCascaded(i2) && (ov = style.getValue(i2)) instanceof ComputedValue) {
                            ov = ((ComputedValue)ov).getCascadedValue();
                        }
                        if (nv == ov) break block18;
                        if (nv == null || ov == null) break block19;
                        if (nv.equals(ov)) break block18;
                        String ovCssText = ov.getCssText();
                        String nvCssText = nv.getCssText();
                        if (nvCssText == ovCssText || nvCssText != null && nvCssText.equals(ovCssText)) break block18;
                    }
                    ++count;
                    diffs[i2] = true;
                }
                ++i2;
            }
        }
        int[] props = null;
        if (count != 0) {
            props = new int[count];
            count = 0;
            i2 = 0;
            while (i2 < diffs.length) {
                if (diffs[i2]) {
                    props[count++] = i2;
                }
                ++i2;
            }
        }
        this.propagateChanges(elt, props, recascade);
    }

    protected void propagateChanges(Node node, int[] props, boolean recascade) {
        int i2;
        if (!(node instanceof CSSStylableElement)) {
            return;
        }
        CSSStylableElement elt = (CSSStylableElement)node;
        StyleMap style = elt.getComputedStyleMap(null);
        if (style != null) {
            boolean[] updated = this.styleDeclarationUpdateHandler.updatedProperties;
            int i3 = this.getNumberOfProperties() - 1;
            while (i3 >= 0) {
                updated[i3] = false;
                --i3;
            }
            if (props != null) {
                i2 = props.length - 1;
                while (i2 >= 0) {
                    int idx = props[i2];
                    updated[idx] = true;
                    --i2;
                }
            }
            boolean fs = this.fontSizeIndex == -1 ? false : updated[this.fontSizeIndex];
            boolean lh = this.lineHeightIndex == -1 ? false : updated[this.lineHeightIndex];
            boolean cl = this.colorIndex == -1 ? false : updated[this.colorIndex];
            int count = 0;
            int i4 = this.getNumberOfProperties() - 1;
            while (i4 >= 0) {
                if (updated[i4]) {
                    ++count;
                } else if (fs && style.isFontSizeRelative(i4) || lh && style.isLineHeightRelative(i4) || cl && style.isColorRelative(i4)) {
                    updated[i4] = true;
                    CSSEngine.clearComputedValue(style, i4);
                    ++count;
                }
                --i4;
            }
            if (count == 0) {
                props = null;
            } else {
                props = new int[count];
                count = 0;
                int i5 = this.getNumberOfProperties() - 1;
                while (i5 >= 0) {
                    if (updated[i5]) {
                        props[count++] = i5;
                    }
                    --i5;
                }
                this.firePropertiesChangedEvent(elt, props);
            }
        }
        int[] inherited = props;
        if (props != null) {
            int count = 0;
            i2 = 0;
            while (i2 < props.length) {
                ValueManager vm = this.valueManagers[props[i2]];
                if (vm.isInheritedProperty()) {
                    ++count;
                } else {
                    props[i2] = -1;
                }
                ++i2;
            }
            if (count == 0) {
                inherited = null;
            } else {
                inherited = new int[count];
                count = 0;
                int i6 = 0;
                while (i6 < props.length) {
                    if (props[i6] != -1) {
                        inherited[count++] = props[i6];
                    }
                    ++i6;
                }
            }
        }
        Node n2 = CSSEngine.getCSSFirstChild(node);
        while (n2 != null) {
            if (n2.getNodeType() == 1) {
                this.invalidateProperties(n2, inherited, null, recascade);
            }
            n2 = CSSEngine.getCSSNextSibling(n2);
        }
    }

    protected void nonCSSPresentationalHintUpdated(CSSStylableElement elt, StyleMap style, String property, short attrChange, String newValue) {
        int idx = this.getPropertyIndex(property);
        if (style.isImportant(idx)) {
            return;
        }
        if (style.getOrigin(idx) >= 24576) {
            return;
        }
        switch (attrChange) {
            case 1: 
            case 2: {
                this.element = elt;
                try {
                    Object var13_14;
                    try {
                        LexicalUnit lu = this.parser.parsePropertyValue(newValue);
                        ValueManager vm = this.valueManagers[idx];
                        Value v2 = vm.createValue(lu, this);
                        style.putMask(idx, (short)0);
                        style.putValue(idx, v2);
                        style.putOrigin(idx, (short)16384);
                    }
                    catch (Exception e2) {
                        String m2 = e2.getMessage();
                        if (m2 == null) {
                            m2 = "";
                        }
                        String u2 = this.documentURI == null ? "<unknown>" : this.documentURI.toString();
                        String s2 = Messages.formatMessage("property.syntax.error.at", new Object[]{u2, property, newValue, m2});
                        DOMException de = new DOMException(12, s2);
                        if (this.userAgent == null) {
                            throw de;
                        }
                        this.userAgent.displayError(de);
                        var13_14 = null;
                        this.element = null;
                        this.cssBaseURI = null;
                        break;
                    }
                    var13_14 = null;
                    this.element = null;
                    this.cssBaseURI = null;
                    break;
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    this.element = null;
                    this.cssBaseURI = null;
                    throw throwable;
                }
            }
            case 3: {
                int[] invalid = new int[]{idx};
                this.invalidateProperties(elt, invalid, null, true);
                return;
            }
        }
        boolean[] updated = this.styleDeclarationUpdateHandler.updatedProperties;
        int i2 = this.getNumberOfProperties() - 1;
        while (i2 >= 0) {
            updated[i2] = false;
            --i2;
        }
        updated[idx] = true;
        boolean fs = idx == this.fontSizeIndex;
        boolean lh = idx == this.lineHeightIndex;
        boolean cl = idx == this.colorIndex;
        int count = 0;
        int i3 = this.getNumberOfProperties() - 1;
        while (i3 >= 0) {
            if (updated[i3]) {
                ++count;
            } else if (fs && style.isFontSizeRelative(i3) || lh && style.isLineHeightRelative(i3) || cl && style.isColorRelative(i3)) {
                updated[i3] = true;
                CSSEngine.clearComputedValue(style, i3);
                ++count;
            }
            --i3;
        }
        int[] props = new int[count];
        count = 0;
        int i4 = this.getNumberOfProperties() - 1;
        while (i4 >= 0) {
            if (updated[i4]) {
                props[count++] = i4;
            }
            --i4;
        }
        this.invalidateProperties(elt, props, null, true);
    }

    protected boolean hasStyleSheetNode(Node n2) {
        if (n2 instanceof CSSStyleSheetNode) {
            return true;
        }
        n2 = CSSEngine.getCSSFirstChild(n2);
        while (n2 != null) {
            if (this.hasStyleSheetNode(n2)) {
                return true;
            }
            n2 = CSSEngine.getCSSNextSibling(n2);
        }
        return false;
    }

    protected void handleAttrModified(Element e2, Attr attr, short attrChange, String prevValue, String newValue) {
        if (!(e2 instanceof CSSStylableElement)) {
            return;
        }
        if (newValue.equals(prevValue)) {
            return;
        }
        String attrNS = attr.getNamespaceURI();
        String name = attrNS == null ? attr.getNodeName() : attr.getLocalName();
        CSSStylableElement elt = (CSSStylableElement)e2;
        StyleMap style = elt.getComputedStyleMap(null);
        if (style != null) {
            if ((attrNS == this.styleNamespaceURI || attrNS != null && attrNS.equals(this.styleNamespaceURI)) && name.equals(this.styleLocalName)) {
                this.inlineStyleAttributeUpdated(elt, style, attrChange, prevValue, newValue);
                return;
            }
            if (this.nonCSSPresentationalHints != null && (attrNS == this.nonCSSPresentationalHintsNamespaceURI || attrNS != null && attrNS.equals(this.nonCSSPresentationalHintsNamespaceURI)) && this.nonCSSPresentationalHints.contains(name)) {
                this.nonCSSPresentationalHintUpdated(elt, style, name, attrChange, newValue);
                return;
            }
        }
        if (this.selectorAttributes != null && this.selectorAttributes.contains(name)) {
            this.invalidateProperties(elt, null, null, true);
            Node n2 = CSSEngine.getCSSNextSibling(elt);
            while (n2 != null) {
                this.invalidateProperties(n2, null, null, true);
                n2 = CSSEngine.getCSSNextSibling(n2);
            }
        }
    }

    protected void handleNodeInserted(Node n2) {
        if (this.hasStyleSheetNode(n2)) {
            this.styleSheetNodes = null;
            this.invalidateProperties(this.document.getDocumentElement(), null, null, true);
        } else if (n2 instanceof CSSStylableElement) {
            n2 = CSSEngine.getCSSNextSibling(n2);
            while (n2 != null) {
                this.invalidateProperties(n2, null, null, true);
                n2 = CSSEngine.getCSSNextSibling(n2);
            }
        }
    }

    protected void handleNodeRemoved(Node n2) {
        if (this.hasStyleSheetNode(n2)) {
            this.styleSheetRemoved = true;
        } else if (n2 instanceof CSSStylableElement) {
            this.removedStylableElementSibling = CSSEngine.getCSSNextSibling(n2);
        }
        this.disposeStyleMaps(n2);
    }

    protected void handleSubtreeModified(Node ignored) {
        if (this.styleSheetRemoved) {
            this.styleSheetRemoved = false;
            this.styleSheetNodes = null;
            this.invalidateProperties(this.document.getDocumentElement(), null, null, true);
        } else if (this.removedStylableElementSibling != null) {
            Node n2 = this.removedStylableElementSibling;
            while (n2 != null) {
                this.invalidateProperties(n2, null, null, true);
                n2 = CSSEngine.getCSSNextSibling(n2);
            }
            this.removedStylableElementSibling = null;
        }
    }

    protected void handleCharacterDataModified(Node n2) {
        if (CSSEngine.getCSSParentNode(n2) instanceof CSSStyleSheetNode) {
            this.styleSheetNodes = null;
            this.invalidateProperties(this.document.getDocumentElement(), null, null, true);
        }
    }

    protected class DOMAttrModifiedListener
    implements EventListener {
        protected DOMAttrModifiedListener() {
        }

        public void handleEvent(Event evt) {
            MutationEvent mevt = (MutationEvent)evt;
            CSSEngine.this.handleAttrModified((Element)((Object)evt.getTarget()), (Attr)mevt.getRelatedNode(), mevt.getAttrChange(), mevt.getPrevValue(), mevt.getNewValue());
        }
    }

    protected class DOMCharacterDataModifiedListener
    implements EventListener {
        protected DOMCharacterDataModifiedListener() {
        }

        public void handleEvent(Event evt) {
            CSSEngine.this.handleCharacterDataModified((Node)((Object)evt.getTarget()));
        }
    }

    protected class DOMSubtreeModifiedListener
    implements EventListener {
        protected DOMSubtreeModifiedListener() {
        }

        public void handleEvent(Event evt) {
            CSSEngine.this.handleSubtreeModified((Node)((Object)evt.getTarget()));
        }
    }

    protected class DOMNodeRemovedListener
    implements EventListener {
        protected DOMNodeRemovedListener() {
        }

        public void handleEvent(Event evt) {
            CSSEngine.this.handleNodeRemoved((Node)((Object)evt.getTarget()));
        }
    }

    protected class DOMNodeInsertedListener
    implements EventListener {
        protected DOMNodeInsertedListener() {
        }

        public void handleEvent(Event evt) {
            CSSEngine.this.handleNodeInserted((Node)((Object)evt.getTarget()));
        }
    }

    protected class CSSNavigableDocumentHandler
    implements CSSNavigableDocumentListener,
    MainPropertyReceiver {
        protected boolean[] mainPropertiesChanged;
        protected StyleDeclaration declaration;

        protected CSSNavigableDocumentHandler() {
        }

        public void nodeInserted(Node newNode) {
            CSSEngine.this.handleNodeInserted(newNode);
        }

        public void nodeToBeRemoved(Node oldNode) {
            CSSEngine.this.handleNodeRemoved(oldNode);
        }

        public void subtreeModified(Node rootOfModifications) {
            CSSEngine.this.handleSubtreeModified(rootOfModifications);
        }

        public void characterDataModified(Node text) {
            CSSEngine.this.handleCharacterDataModified(text);
        }

        public void attrModified(Element e2, Attr attr, short attrChange, String prevValue, String newValue) {
            CSSEngine.this.handleAttrModified(e2, attr, attrChange, prevValue, newValue);
        }

        public void overrideStyleTextChanged(CSSStylableElement elt, String text) {
            StyleDeclarationProvider p2 = elt.getOverrideStyleDeclarationProvider();
            StyleDeclaration declaration = p2.getStyleDeclaration();
            int ds = declaration.size();
            boolean[] updated = new boolean[CSSEngine.this.getNumberOfProperties()];
            int i2 = 0;
            while (i2 < ds) {
                updated[declaration.getIndex((int)i2)] = true;
                ++i2;
            }
            declaration = CSSEngine.this.parseStyleDeclaration(elt, text);
            p2.setStyleDeclaration(declaration);
            ds = declaration.size();
            int i3 = 0;
            while (i3 < ds) {
                updated[declaration.getIndex((int)i3)] = true;
                ++i3;
            }
            CSSEngine.this.invalidateProperties(elt, null, updated, true);
        }

        public void overrideStylePropertyRemoved(CSSStylableElement elt, String name) {
            StyleDeclarationProvider p2 = elt.getOverrideStyleDeclarationProvider();
            StyleDeclaration declaration = p2.getStyleDeclaration();
            int idx = CSSEngine.this.getPropertyIndex(name);
            int ds = declaration.size();
            int i2 = 0;
            while (i2 < ds) {
                if (idx == declaration.getIndex(i2)) {
                    declaration.remove(i2);
                    StyleMap style = elt.getComputedStyleMap(null);
                    if (style == null || style.getOrigin(idx) != -24576) break;
                    CSSEngine.this.invalidateProperties(elt, new int[]{idx}, null, true);
                    break;
                }
                ++i2;
            }
        }

        public void overrideStylePropertyChanged(CSSStylableElement elt, String name, String val, String prio) {
            boolean important = prio != null && prio.length() != 0;
            StyleDeclarationProvider p2 = elt.getOverrideStyleDeclarationProvider();
            this.declaration = p2.getStyleDeclaration();
            CSSEngine.this.setMainProperties(elt, this, name, val, important);
            this.declaration = null;
            CSSEngine.this.invalidateProperties(elt, null, this.mainPropertiesChanged, true);
        }

        public void setMainProperty(String name, Value v2, boolean important) {
            int idx = CSSEngine.this.getPropertyIndex(name);
            if (idx == -1) {
                return;
            }
            int i2 = 0;
            while (i2 < this.declaration.size()) {
                if (idx == this.declaration.getIndex(i2)) break;
                ++i2;
            }
            if (i2 < this.declaration.size()) {
                this.declaration.put(i2, v2, idx, important);
            } else {
                this.declaration.append(v2, idx, important);
            }
        }
    }

    protected class StyleDeclarationUpdateHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;
        public boolean[] updatedProperties;

        protected StyleDeclarationUpdateHandler() {
            this.updatedProperties = new boolean[CSSEngine.this.getNumberOfProperties()];
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            int i2 = CSSEngine.this.getPropertyIndex(name);
            if (i2 == -1) {
                i2 = CSSEngine.this.getShorthandIndex(name);
                if (i2 == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[i2].setValues(CSSEngine.this, this, value, important);
            } else {
                if (this.styleMap.isImportant(i2)) {
                    return;
                }
                this.updatedProperties[i2] = true;
                Value v2 = CSSEngine.this.valueManagers[i2].createValue(value, CSSEngine.this);
                this.styleMap.putMask(i2, (short)0);
                this.styleMap.putValue(i2, v2);
                this.styleMap.putOrigin(i2, (short)Short.MIN_VALUE);
            }
        }
    }

    protected static class DocumentAdapter
    implements DocumentHandler {
        protected DocumentAdapter() {
        }

        public void startDocument(InputSource source) {
            this.throwUnsupportedEx();
        }

        public void endDocument(InputSource source) {
            this.throwUnsupportedEx();
        }

        public void comment(String text) {
        }

        public void ignorableAtRule(String atRule) {
            this.throwUnsupportedEx();
        }

        public void namespaceDeclaration(String prefix, String uri) {
            this.throwUnsupportedEx();
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) {
            this.throwUnsupportedEx();
        }

        public void startMedia(SACMediaList media) {
            this.throwUnsupportedEx();
        }

        public void endMedia(SACMediaList media) {
            this.throwUnsupportedEx();
        }

        public void startPage(String name, String pseudo_page) {
            this.throwUnsupportedEx();
        }

        public void endPage(String name, String pseudo_page) {
            this.throwUnsupportedEx();
        }

        public void startFontFace() {
            this.throwUnsupportedEx();
        }

        public void endFontFace() {
            this.throwUnsupportedEx();
        }

        public void startSelector(SelectorList selectors) {
            this.throwUnsupportedEx();
        }

        public void endSelector(SelectorList selectors) {
            this.throwUnsupportedEx();
        }

        public void property(String name, LexicalUnit value, boolean important) {
            this.throwUnsupportedEx();
        }

        private void throwUnsupportedEx() {
            throw new UnsupportedOperationException("you try to use an empty method in Adapter-class");
        }
    }

    protected class StyleSheetDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleSheet styleSheet;
        protected StyleRule styleRule;
        protected StyleDeclaration styleDeclaration;

        protected StyleSheetDocumentHandler() {
        }

        public void startDocument(InputSource source) throws CSSException {
        }

        public void endDocument(InputSource source) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
            ImportRule ir = new ImportRule();
            ir.setMediaList(media);
            ir.setParent(this.styleSheet);
            ParsedURL base = CSSEngine.this.getCSSBaseURI();
            ParsedURL url = base == null ? new ParsedURL(uri) : new ParsedURL(base, uri);
            ir.setURI(url);
            this.styleSheet.append(ir);
        }

        public void startMedia(SACMediaList media) throws CSSException {
            MediaRule mr = new MediaRule();
            mr.setMediaList(media);
            mr.setParent(this.styleSheet);
            this.styleSheet.append(mr);
            this.styleSheet = mr;
        }

        public void endMedia(SACMediaList media) throws CSSException {
            this.styleSheet = this.styleSheet.getParent();
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
        }

        public void startFontFace() throws CSSException {
            this.styleDeclaration = new StyleDeclaration();
        }

        public void endFontFace() throws CSSException {
            StyleMap sm = new StyleMap(CSSEngine.this.getNumberOfProperties());
            int len = this.styleDeclaration.size();
            int i2 = 0;
            while (i2 < len) {
                int idx = this.styleDeclaration.getIndex(i2);
                sm.putValue(idx, this.styleDeclaration.getValue(i2));
                sm.putImportant(idx, this.styleDeclaration.getPriority(i2));
                sm.putOrigin(idx, (short)24576);
                ++i2;
            }
            this.styleDeclaration = null;
            int pidx = CSSEngine.this.getPropertyIndex("font-family");
            Value fontFamily = sm.getValue(pidx);
            if (fontFamily == null) {
                return;
            }
            ParsedURL base = CSSEngine.this.getCSSBaseURI();
            CSSEngine.this.fontFaces.add(new FontFaceRule(sm, base));
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            this.styleRule = new StyleRule();
            this.styleRule.setSelectorList(selectors);
            this.styleDeclaration = new StyleDeclaration();
            this.styleRule.setStyleDeclaration(this.styleDeclaration);
            this.styleSheet.append(this.styleRule);
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            this.styleRule = null;
            this.styleDeclaration = null;
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            int i2 = CSSEngine.this.getPropertyIndex(name);
            if (i2 == -1) {
                i2 = CSSEngine.this.getShorthandIndex(name);
                if (i2 == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[i2].setValues(CSSEngine.this, this, value, important);
            } else {
                Value v2 = CSSEngine.this.valueManagers[i2].createValue(value, CSSEngine.this);
                this.styleDeclaration.append(v2, i2, important);
            }
        }
    }

    protected class StyleDeclarationBuilder
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleDeclaration styleDeclaration;

        protected StyleDeclarationBuilder() {
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            int i2 = CSSEngine.this.getPropertyIndex(name);
            if (i2 == -1) {
                i2 = CSSEngine.this.getShorthandIndex(name);
                if (i2 == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[i2].setValues(CSSEngine.this, this, value, important);
            } else {
                Value v2 = CSSEngine.this.valueManagers[i2].createValue(value, CSSEngine.this);
                this.styleDeclaration.append(v2, i2, important);
            }
        }
    }

    protected class StyleDeclarationDocumentHandler
    extends DocumentAdapter
    implements ShorthandManager.PropertyHandler {
        public StyleMap styleMap;

        protected StyleDeclarationDocumentHandler() {
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            int i2 = CSSEngine.this.getPropertyIndex(name);
            if (i2 == -1) {
                i2 = CSSEngine.this.getShorthandIndex(name);
                if (i2 == -1) {
                    return;
                }
                CSSEngine.this.shorthandManagers[i2].setValues(CSSEngine.this, this, value, important);
            } else {
                Value v2 = CSSEngine.this.valueManagers[i2].createValue(value, CSSEngine.this);
                CSSEngine.this.putAuthorProperty(this.styleMap, i2, v2, important, (short)Short.MIN_VALUE);
            }
        }
    }

    public static interface MainPropertyReceiver {
        public void setMainProperty(String var1, Value var2, boolean var3);
    }
}

