/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class LittleEndianOutputStream
extends FilterOutputStream {
    protected long written;

    public LittleEndianOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b2) throws IOException {
        this.out.write(b2);
        ++this.written;
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        this.out.write(data, offset, length);
        this.written += (long)length;
    }

    public void writeBoolean(boolean b2) throws IOException {
        if (b2) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public void writeByte(int b2) throws IOException {
        this.out.write(b2);
        ++this.written;
    }

    public void writeShort(int s2) throws IOException {
        this.out.write(s2 & 0xFF);
        this.out.write(s2 >>> 8 & 0xFF);
        this.written += 2L;
    }

    public void writeChar(int c2) throws IOException {
        this.out.write(c2 & 0xFF);
        this.out.write(c2 >>> 8 & 0xFF);
        this.written += 2L;
    }

    public void writeInt(int i2) throws IOException {
        this.out.write(i2 & 0xFF);
        this.out.write(i2 >>> 8 & 0xFF);
        this.out.write(i2 >>> 16 & 0xFF);
        this.out.write(i2 >>> 24 & 0xFF);
        this.written += 4L;
    }

    public void writeLong(long l2) throws IOException {
        this.out.write((int)l2 & 0xFF);
        this.out.write((int)(l2 >>> 8) & 0xFF);
        this.out.write((int)(l2 >>> 16) & 0xFF);
        this.out.write((int)(l2 >>> 24) & 0xFF);
        this.out.write((int)(l2 >>> 32) & 0xFF);
        this.out.write((int)(l2 >>> 40) & 0xFF);
        this.out.write((int)(l2 >>> 48) & 0xFF);
        this.out.write((int)(l2 >>> 56) & 0xFF);
        this.written += 8L;
    }

    public final void writeFloat(float f2) throws IOException {
        this.writeInt(Float.floatToIntBits(f2));
    }

    public final void writeDouble(double d2) throws IOException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    public void writeBytes(String s2) throws IOException {
        int length = s2.length();
        for (int i2 = 0; i2 < length; ++i2) {
            this.out.write((byte)s2.charAt(i2));
        }
        this.written += (long)length;
    }

    public void writeString(String s2) throws IOException {
        this.writeBytes(s2);
        this.write(0);
    }

    public long getWrittenCount() {
        return this.written;
    }

    public void setWrittenCount(long count) {
        this.written = count;
    }
}

