/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.TextTagCodec;
import htsjdk.samtools.util.AsciiWriter;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;

public class SAMTextWriter
extends SAMFileWriterImpl {
    private static final String FIELD_SEPARATOR = "\t";
    private final Writer out;
    private final File file;
    private final TextTagCodec tagCodec = new TextTagCodec();
    private final SAMTagUtil tagUtil = new SAMTagUtil();
    private static SAMTextWriter textWriter = null;
    private static StringWriter stringWriter = null;

    public SAMTextWriter(Writer out) {
        this.out = out;
        this.file = null;
    }

    public SAMTextWriter(File file) {
        try {
            this.file = file;
            this.out = new AsciiWriter(new FileOutputStream(file));
        }
        catch (IOException e2) {
            throw new RuntimeIOException(e2);
        }
    }

    public Writer getWriter() {
        return this.out;
    }

    public SAMTextWriter(OutputStream stream) {
        this.file = null;
        this.out = new AsciiWriter(stream);
    }

    @Override
    public void writeAlignment(SAMRecord alignment) {
        try {
            this.out.write(alignment.getReadName());
            this.out.write(FIELD_SEPARATOR);
            this.out.write(Integer.toString(alignment.getFlags()));
            this.out.write(FIELD_SEPARATOR);
            this.out.write(alignment.getReferenceName());
            this.out.write(FIELD_SEPARATOR);
            this.out.write(Integer.toString(alignment.getAlignmentStart()));
            this.out.write(FIELD_SEPARATOR);
            this.out.write(Integer.toString(alignment.getMappingQuality()));
            this.out.write(FIELD_SEPARATOR);
            this.out.write(alignment.getCigarString());
            this.out.write(FIELD_SEPARATOR);
            if (alignment.getReferenceName() == alignment.getMateReferenceName() && "*" != alignment.getReferenceName()) {
                this.out.write("=");
            } else {
                this.out.write(alignment.getMateReferenceName());
            }
            this.out.write(FIELD_SEPARATOR);
            this.out.write(Integer.toString(alignment.getMateAlignmentStart()));
            this.out.write(FIELD_SEPARATOR);
            this.out.write(Integer.toString(alignment.getInferredInsertSize()));
            this.out.write(FIELD_SEPARATOR);
            this.out.write(alignment.getReadString());
            this.out.write(FIELD_SEPARATOR);
            this.out.write(alignment.getBaseQualityString());
            for (SAMBinaryTagAndValue attribute = alignment.getBinaryAttributes(); attribute != null; attribute = attribute.getNext()) {
                this.out.write(FIELD_SEPARATOR);
                String encodedTag = attribute.isUnsignedArray() ? this.tagCodec.encodeUnsignedArray(this.tagUtil.makeStringTag(attribute.tag), attribute.value) : this.tagCodec.encode(this.tagUtil.makeStringTag(attribute.tag), attribute.value);
                this.out.write(encodedTag);
            }
            this.out.write("\n");
        }
        catch (IOException e2) {
            throw new RuntimeIOException(e2);
        }
    }

    static synchronized String getSAMString(SAMRecord alignment) {
        if (stringWriter == null) {
            stringWriter = new StringWriter();
        }
        if (textWriter == null) {
            textWriter = new SAMTextWriter(stringWriter);
        }
        stringWriter.getBuffer().setLength(0);
        textWriter.writeAlignment(alignment);
        return stringWriter.toString();
    }

    @Override
    public void writeHeader(String textHeader) {
        try {
            this.out.write(textHeader);
        }
        catch (IOException e2) {
            throw new RuntimeIOException(e2);
        }
    }

    @Override
    public void finish() {
        try {
            this.out.close();
        }
        catch (IOException e2) {
            throw new RuntimeIOException(e2);
        }
    }

    @Override
    public String getFilename() {
        if (this.file == null) {
            return null;
        }
        return this.file.getAbsolutePath();
    }
}

