/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import picard.PicardException;
import picard.illumina.parser.IntensityChannel;
import picard.util.UnsignedTypeUtil;

class ClusterIntensityFileReader {
    private static final byte[] IDENTIFIER = StringUtil.stringToBytes("CIF");
    private static final byte FILE_VERSION = 1;
    private static final int HEADER_SIZE = 13;
    private static final int NUM_CHANNELS = IntensityChannel.values().length;
    private final File file;
    private final MappedByteBuffer buf;
    private final ClusterIntensityFileHeader header;
    private final int cycleSize;
    private final int channelSize;

    public ClusterIntensityFileReader(File file) {
        try {
            this.file = file;
            FileInputStream is = new FileInputStream(this.file);
            FileChannel channel = is.getChannel();
            long fileSize = channel.size();
            this.buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileSize);
            this.buf.order(ByteOrder.LITTLE_ENDIAN);
            CloserUtil.close(channel);
            CloserUtil.close(is);
            byte[] headerBytes = new byte[13];
            this.buf.get(headerBytes);
            this.header = new ClusterIntensityFileHeader(headerBytes, this.file);
        }
        catch (IOException e2) {
            throw new PicardException("IOException opening cluster intensity file " + file, e2);
        }
        this.cycleSize = NUM_CHANNELS * this.header.numClusters * this.header.elementSize;
        this.channelSize = this.header.numClusters * this.header.elementSize;
    }

    public short getValue(int cluster, IntensityChannel channel, int cycle) {
        if (cycle < this.header.firstCycle || cycle >= this.header.firstCycle + this.header.numCycles) {
            throw new IllegalArgumentException("Requested cycle (" + cycle + ") number out of range.  First cycle=" + this.header.firstCycle + "; numCycles=" + this.header.numCycles);
        }
        if (cluster < 0 || cluster >= this.header.numClusters) {
            throw new IllegalArgumentException("Requested cluster (" + cluster + ") number out of range. numClustersInTile=" + this.header.numClusters);
        }
        int relativeCycle = cycle - this.header.firstCycle;
        int position = 13 + relativeCycle * this.cycleSize + channel.ordinal() * this.channelSize + cluster * this.header.elementSize;
        this.buf.position(position);
        if (this.header.elementSize == 1) {
            return this.buf.get();
        }
        return this.buf.getShort();
    }

    public File getFile() {
        return this.file;
    }

    public int getFirstCycle() {
        return this.header.firstCycle;
    }

    public int getNumClusters() {
        return this.header.numClusters;
    }

    public int getNumCycles() {
        return this.header.numCycles;
    }

    public int getElementSize() {
        return this.header.elementSize;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClusterIntensityFileHeader readHeaders(File intensityFile) {
        FileInputStream reader = null;
        byte[] headerBytes = new byte[13];
        int bytesRead = 0;
        try {
            reader = new FileInputStream(intensityFile);
            bytesRead = reader.read(headerBytes);
        }
        catch (FileNotFoundException fnfExc) {
            try {
                throw new PicardException("Error opening intensity file (" + intensityFile.getAbsolutePath() + ")", fnfExc);
                catch (IOException ioExc) {
                    throw new PicardException("Error reading values from header for intensity file (" + intensityFile.getAbsolutePath() + ")", ioExc);
                }
            }
            catch (Throwable throwable) {
                CloserUtil.close(reader);
                throw throwable;
            }
        }
        CloserUtil.close(reader);
        if (bytesRead == 13) {
            return new ClusterIntensityFileHeader(headerBytes, intensityFile);
        }
        throw new PicardException("Error reading intensity file header, too few bytes read, expected( 13) read(" + bytesRead + ")");
    }

    public static class ClusterIntensityFileHeader {
        public final int elementSize;
        public final int firstCycle;
        public final int numCycles;
        public final int numClusters;

        public ClusterIntensityFileHeader(byte[] headerBytes, File file) {
            if (headerBytes.length < 13) {
                throw new PicardException("Bytes past to header constructor are too short excpected(13) received (" + headerBytes.length);
            }
            ByteBuffer buf = ByteBuffer.allocate(headerBytes.length);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            buf.put(headerBytes);
            buf.position(0);
            byte[] identifierBuf = new byte[IDENTIFIER.length];
            buf.get(identifierBuf);
            if (!Arrays.equals(identifierBuf, IDENTIFIER)) {
                throw new PicardException("Cluster intensity file " + file + " contains unexpected header: " + StringUtil.bytesToString(identifierBuf));
            }
            byte fileVersion = buf.get();
            if (fileVersion != 1) {
                throw new PicardException("Cluster intensity file " + file + " contains unexpected version: " + fileVersion);
            }
            this.elementSize = buf.get();
            if (this.elementSize < 1 || this.elementSize > 2) {
                throw new PicardException("Cluster intensity file " + file + " contains unexpected element size: " + this.elementSize);
            }
            this.firstCycle = UnsignedTypeUtil.uShortToInt(buf.getShort());
            this.numCycles = UnsignedTypeUtil.uShortToInt(buf.getShort());
            if (this.numCycles == 0) {
                throw new PicardException("Cluster intensity file " + file + " has zero cycles.");
            }
            this.numClusters = buf.getInt();
            if (this.numClusters < 0) {
                throw new PicardException("Cluster intensity file " + file + " has negative number of clusters: " + this.numClusters);
            }
        }
    }
}

