/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.CheckAnnotationAdapter;
import org.objectweb.asm.util.CheckMethodAdapter$1;

public class CheckMethodAdapter
extends MethodAdapter {
    public int version;
    private boolean startCode;
    private boolean endCode;
    private boolean endMethod;
    private final Map labels;
    private static final int[] TYPE;
    private static Field labelStatusField;
    static /* synthetic */ Class class$org$objectweb$asm$Label;

    public CheckMethodAdapter(MethodVisitor methodVisitor) {
        this(methodVisitor, new HashMap());
    }

    public CheckMethodAdapter(MethodVisitor methodVisitor, Map map) {
        super(methodVisitor);
        this.labels = map;
    }

    public CheckMethodAdapter(int n2, String string, String string2, MethodVisitor methodVisitor, Map map) {
        this(new CheckMethodAdapter$1(n2, string, string2, null, null, methodVisitor), map);
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.checkEndMethod();
        CheckMethodAdapter.checkDesc(string, false);
        return new CheckAnnotationAdapter(this.mv.visitAnnotation(string, bl));
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.checkEndMethod();
        return new CheckAnnotationAdapter(this.mv.visitAnnotationDefault(), false);
    }

    public AnnotationVisitor visitParameterAnnotation(int n2, String string, boolean bl) {
        this.checkEndMethod();
        CheckMethodAdapter.checkDesc(string, false);
        return new CheckAnnotationAdapter(this.mv.visitParameterAnnotation(n2, string, bl));
    }

    public void visitAttribute(Attribute attribute) {
        this.checkEndMethod();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        this.mv.visitAttribute(attribute);
    }

    public void visitCode() {
        this.startCode = true;
        this.mv.visitCode();
    }

    public void visitFrame(int n2, int n3, Object[] objectArray, int n4, Object[] objectArray2) {
        int n5;
        int n6;
        int n7;
        switch (n2) {
            case -1: 
            case 0: {
                n7 = Integer.MAX_VALUE;
                n6 = Integer.MAX_VALUE;
                break;
            }
            case 3: {
                n7 = 0;
                n6 = 0;
                break;
            }
            case 4: {
                n7 = 0;
                n6 = 1;
                break;
            }
            case 1: 
            case 2: {
                n7 = 3;
                n6 = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid frame type " + n2);
            }
        }
        if (n3 > n7) {
            throw new IllegalArgumentException("Invalid nLocal=" + n3 + " for frame type " + n2);
        }
        if (n4 > n6) {
            throw new IllegalArgumentException("Invalid nStack=" + n4 + " for frame type " + n2);
        }
        if (n2 != 2) {
            if (n3 > 0 && (objectArray == null || objectArray.length < n3)) {
                throw new IllegalArgumentException("Array local[] is shorter than nLocal");
            }
            for (n5 = 0; n5 < n3; ++n5) {
                CheckMethodAdapter.checkFrameValue(objectArray[n5]);
            }
        }
        if (n4 > 0 && (objectArray2 == null || objectArray2.length < n4)) {
            throw new IllegalArgumentException("Array stack[] is shorter than nStack");
        }
        for (n5 = 0; n5 < n4; ++n5) {
            CheckMethodAdapter.checkFrameValue(objectArray2[n5]);
        }
        this.mv.visitFrame(n2, n3, objectArray, n4, objectArray2);
    }

    public void visitInsn(int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n2, 0);
        this.mv.visitInsn(n2);
    }

    public void visitIntInsn(int n2, int n3) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n2, 1);
        switch (n2) {
            case 16: {
                CheckMethodAdapter.checkSignedByte(n3, "Invalid operand");
                break;
            }
            case 17: {
                CheckMethodAdapter.checkSignedShort(n3, "Invalid operand");
                break;
            }
            default: {
                if (n3 >= 4 && n3 <= 11) break;
                throw new IllegalArgumentException("Invalid operand (must be an array type code T_...): " + n3);
            }
        }
        this.mv.visitIntInsn(n2, n3);
    }

    public void visitVarInsn(int n2, int n3) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n2, 2);
        CheckMethodAdapter.checkUnsignedShort(n3, "Invalid variable index");
        this.mv.visitVarInsn(n2, n3);
    }

    public void visitTypeInsn(int n2, String string) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n2, 3);
        CheckMethodAdapter.checkInternalName(string, "type");
        if (n2 == 187 && string.charAt(0) == '[') {
            throw new IllegalArgumentException("NEW cannot be used to create arrays: " + string);
        }
        this.mv.visitTypeInsn(n2, string);
    }

    public void visitFieldInsn(int n2, String string, String string2, String string3) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n2, 4);
        CheckMethodAdapter.checkInternalName(string, "owner");
        CheckMethodAdapter.checkUnqualifiedName(this.version, string2, "name");
        CheckMethodAdapter.checkDesc(string3, false);
        this.mv.visitFieldInsn(n2, string, string2, string3);
    }

    public void visitMethodInsn(int n2, String string, String string2, String string3) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n2, 5);
        CheckMethodAdapter.checkMethodIdentifier(this.version, string2, "name");
        CheckMethodAdapter.checkInternalName(string, "owner");
        CheckMethodAdapter.checkMethodDesc(string3);
        if (n2 == 186 && string != "java/lang/dyn/Dynamic") {
            throw new IllegalArgumentException("INVOKEDYNAMIC cannot be used with another owner than INVOKEDYNAMIC_OWNER");
        }
        this.mv.visitMethodInsn(n2, string, string2, string3);
    }

    public void visitJumpInsn(int n2, Label label) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(n2, 6);
        this.checkLabel(label, false, "label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        this.mv.visitJumpInsn(n2, label);
    }

    public void visitLabel(Label label) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLabel(label, false, "label");
        if (this.labels.get(label) != null) {
            throw new IllegalArgumentException("Already visited label");
        }
        this.labels.put(label, new Integer(this.labels.size()));
        this.mv.visitLabel(label);
    }

    public void visitLdcInsn(Object object) {
        this.checkStartCode();
        this.checkEndCode();
        if (!(object instanceof Type)) {
            CheckMethodAdapter.checkConstant(object);
        }
        this.mv.visitLdcInsn(object);
    }

    public void visitIincInsn(int n2, int n3) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnsignedShort(n2, "Invalid variable index");
        CheckMethodAdapter.checkSignedShort(n3, "Invalid increment");
        this.mv.visitIincInsn(n2, n3);
    }

    public void visitTableSwitchInsn(int n2, int n3, Label label, Label[] labelArray) {
        this.checkStartCode();
        this.checkEndCode();
        if (n3 < n2) {
            throw new IllegalArgumentException("Max = " + n3 + " must be greater than or equal to min = " + n2);
        }
        this.checkLabel(label, false, "default label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        if (labelArray == null || labelArray.length != n3 - n2 + 1) {
            throw new IllegalArgumentException("There must be max - min + 1 labels");
        }
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            this.checkLabel(labelArray[i2], false, "label at index " + i2);
            CheckMethodAdapter.checkNonDebugLabel(labelArray[i2]);
        }
        this.mv.visitTableSwitchInsn(n2, n3, label, labelArray);
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.checkEndCode();
        this.checkStartCode();
        this.checkLabel(label, false, "default label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        if (nArray == null || labelArray == null || nArray.length != labelArray.length) {
            throw new IllegalArgumentException("There must be the same number of keys and labels");
        }
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            this.checkLabel(labelArray[i2], false, "label at index " + i2);
            CheckMethodAdapter.checkNonDebugLabel(labelArray[i2]);
        }
        this.mv.visitLookupSwitchInsn(label, nArray, labelArray);
    }

    public void visitMultiANewArrayInsn(String string, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkDesc(string, false);
        if (string.charAt(0) != '[') {
            throw new IllegalArgumentException("Invalid descriptor (must be an array type descriptor): " + string);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Invalid dimensions (must be greater than 0): " + n2);
        }
        if (n2 > string.lastIndexOf(91) + 1) {
            throw new IllegalArgumentException("Invalid dimensions (must not be greater than dims(desc)): " + n2);
        }
        this.mv.visitMultiANewArrayInsn(string, n2);
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLabel(label, false, "start label");
        this.checkLabel(label2, false, "end label");
        this.checkLabel(label3, false, "handler label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        CheckMethodAdapter.checkNonDebugLabel(label2);
        CheckMethodAdapter.checkNonDebugLabel(label3);
        if (this.labels.get(label) != null || this.labels.get(label2) != null || this.labels.get(label3) != null) {
            throw new IllegalStateException("Try catch blocks must be visited before their labels");
        }
        if (string != null) {
            CheckMethodAdapter.checkInternalName(string, "type");
        }
        this.mv.visitTryCatchBlock(label, label2, label3, string);
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnqualifiedName(this.version, string, "name");
        CheckMethodAdapter.checkDesc(string2, false);
        this.checkLabel(label, true, "start label");
        this.checkLabel(label2, true, "end label");
        CheckMethodAdapter.checkUnsignedShort(n2, "Invalid variable index");
        int n3 = (Integer)this.labels.get(label);
        int n4 = (Integer)this.labels.get(label2);
        if (n4 < n3) {
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        this.mv.visitLocalVariable(string, string2, string3, label, label2, n2);
    }

    public void visitLineNumber(int n2, Label label) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnsignedShort(n2, "Invalid line number");
        this.checkLabel(label, true, "start label");
        this.mv.visitLineNumber(n2, label);
    }

    public void visitMaxs(int n2, int n3) {
        this.checkStartCode();
        this.checkEndCode();
        this.endCode = true;
        CheckMethodAdapter.checkUnsignedShort(n2, "Invalid max stack");
        CheckMethodAdapter.checkUnsignedShort(n3, "Invalid max locals");
        this.mv.visitMaxs(n2, n3);
    }

    public void visitEnd() {
        this.checkEndMethod();
        this.endMethod = true;
        this.mv.visitEnd();
    }

    void checkStartCode() {
        if (!this.startCode) {
            throw new IllegalStateException("Cannot visit instructions before visitCode has been called.");
        }
    }

    void checkEndCode() {
        if (this.endCode) {
            throw new IllegalStateException("Cannot visit instructions after visitMaxs has been called.");
        }
    }

    void checkEndMethod() {
        if (this.endMethod) {
            throw new IllegalStateException("Cannot visit elements after visitEnd has been called.");
        }
    }

    static void checkFrameValue(Object object) {
        if (object == Opcodes.TOP || object == Opcodes.INTEGER || object == Opcodes.FLOAT || object == Opcodes.LONG || object == Opcodes.DOUBLE || object == Opcodes.NULL || object == Opcodes.UNINITIALIZED_THIS) {
            return;
        }
        if (object instanceof String) {
            CheckMethodAdapter.checkInternalName((String)object, "Invalid stack frame value");
            return;
        }
        if (!(object instanceof Label)) {
            throw new IllegalArgumentException("Invalid stack frame value: " + object);
        }
    }

    static void checkOpcode(int n2, int n3) {
        if (n2 < 0 || n2 > 199 || TYPE[n2] != n3) {
            throw new IllegalArgumentException("Invalid opcode: " + n2);
        }
    }

    static void checkSignedByte(int n2, String string) {
        if (n2 < -128 || n2 > 127) {
            throw new IllegalArgumentException(string + " (must be a signed byte): " + n2);
        }
    }

    static void checkSignedShort(int n2, String string) {
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new IllegalArgumentException(string + " (must be a signed short): " + n2);
        }
    }

    static void checkUnsignedShort(int n2, String string) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException(string + " (must be an unsigned short): " + n2);
        }
    }

    static void checkConstant(Object object) {
        if (!(object instanceof Integer || object instanceof Float || object instanceof Long || object instanceof Double || object instanceof String)) {
            throw new IllegalArgumentException("Invalid constant: " + object);
        }
    }

    static void checkUnqualifiedName(int n2, String string, String string2) {
        if ((n2 & 0xFFFF) < 49) {
            CheckMethodAdapter.checkIdentifier(string, string2);
        } else {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (".;[/".indexOf(string.charAt(i2)) == -1) continue;
                throw new IllegalArgumentException("Invalid " + string2 + " (must be a valid unqualified name): " + string);
            }
        }
    }

    static void checkIdentifier(String string, String string2) {
        CheckMethodAdapter.checkIdentifier(string, 0, -1, string2);
    }

    static void checkIdentifier(String string, int n2, int n3, String string2) {
        if (string == null || (n3 == -1 ? string.length() <= n2 : n3 <= n2)) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must not be null or empty)");
        }
        if (!Character.isJavaIdentifierStart(string.charAt(n2))) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must be a valid Java identifier): " + string);
        }
        int n4 = n3 == -1 ? string.length() : n3;
        for (int i2 = n2 + 1; i2 < n4; ++i2) {
            if (Character.isJavaIdentifierPart(string.charAt(i2))) continue;
            throw new IllegalArgumentException("Invalid " + string2 + " (must be a valid Java identifier): " + string);
        }
    }

    static void checkMethodIdentifier(int n2, String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must not be null or empty)");
        }
        if ("<init>".equals(string) || "<clinit>".equals(string)) {
            return;
        }
        if ((n2 & 0xFFFF) >= 49) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (".;[/<>".indexOf(string.charAt(i2)) == -1) continue;
                throw new IllegalArgumentException("Invalid " + string2 + " (must be a valid unqualified name): " + string);
            }
            return;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must be a '<init>', '<clinit>' or a valid Java identifier): " + string);
        }
        for (int i3 = 1; i3 < string.length(); ++i3) {
            if (Character.isJavaIdentifierPart(string.charAt(i3))) continue;
            throw new IllegalArgumentException("Invalid " + string2 + " (must be '<init>' or '<clinit>' or a valid Java identifier): " + string);
        }
    }

    static void checkInternalName(String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must not be null or empty)");
        }
        if (string.charAt(0) == '[') {
            CheckMethodAdapter.checkDesc(string, false);
        } else {
            CheckMethodAdapter.checkInternalName(string, 0, -1, string2);
        }
    }

    static void checkInternalName(String string, int n2, int n3, String string2) {
        int n4 = n3 == -1 ? string.length() : n3;
        try {
            int n5;
            int n6 = n2;
            do {
                if ((n5 = string.indexOf(47, n6 + 1)) == -1 || n5 > n4) {
                    n5 = n4;
                }
                CheckMethodAdapter.checkIdentifier(string, n6, n5, null);
                n6 = n5 + 1;
            } while (n5 != n4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid " + string2 + " (must be a fully qualified class name in internal form): " + string);
        }
    }

    static void checkDesc(String string, boolean bl) {
        int n2 = CheckMethodAdapter.checkDesc(string, 0, bl);
        if (n2 != string.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + string);
        }
    }

    static int checkDesc(String string, int n2, boolean bl) {
        if (string == null || n2 >= string.length()) {
            throw new IllegalArgumentException("Invalid type descriptor (must not be null or empty)");
        }
        switch (string.charAt(n2)) {
            case 'V': {
                if (bl) {
                    return n2 + 1;
                }
                throw new IllegalArgumentException("Invalid descriptor: " + string);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n2 + 1;
            }
            case '[': {
                int n3;
                for (n3 = n2 + 1; n3 < string.length() && string.charAt(n3) == '['; ++n3) {
                }
                if (n3 < string.length()) {
                    return CheckMethodAdapter.checkDesc(string, n3, false);
                }
                throw new IllegalArgumentException("Invalid descriptor: " + string);
            }
            case 'L': {
                int n4 = string.indexOf(59, n2);
                if (n4 == -1 || n4 - n2 < 2) {
                    throw new IllegalArgumentException("Invalid descriptor: " + string);
                }
                try {
                    CheckMethodAdapter.checkInternalName(string, n2 + 1, n4, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Invalid descriptor: " + string);
                }
                return n4 + 1;
            }
        }
        throw new IllegalArgumentException("Invalid descriptor: " + string);
    }

    static void checkMethodDesc(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid method descriptor (must not be null or empty)");
        }
        if (string.charAt(0) != '(' || string.length() < 3) {
            throw new IllegalArgumentException("Invalid descriptor: " + string);
        }
        int n2 = 1;
        if (string.charAt(n2) != ')') {
            do {
                if (string.charAt(n2) != 'V') continue;
                throw new IllegalArgumentException("Invalid descriptor: " + string);
            } while ((n2 = CheckMethodAdapter.checkDesc(string, n2, false)) < string.length() && string.charAt(n2) != ')');
        }
        if ((n2 = CheckMethodAdapter.checkDesc(string, n2 + 1, true)) != string.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + string);
        }
    }

    static void checkClassSignature(String string) {
        int n2 = 0;
        if (CheckMethodAdapter.getChar(string, 0) == '<') {
            n2 = CheckMethodAdapter.checkFormalTypeParameters(string, n2);
        }
        n2 = CheckMethodAdapter.checkClassTypeSignature(string, n2);
        while (CheckMethodAdapter.getChar(string, n2) == 'L') {
            n2 = CheckMethodAdapter.checkClassTypeSignature(string, n2);
        }
        if (n2 != string.length()) {
            throw new IllegalArgumentException(string + ": error at index " + n2);
        }
    }

    static void checkMethodSignature(String string) {
        int n2 = 0;
        if (CheckMethodAdapter.getChar(string, 0) == '<') {
            n2 = CheckMethodAdapter.checkFormalTypeParameters(string, n2);
        }
        n2 = CheckMethodAdapter.checkChar('(', string, n2);
        while ("ZCBSIFJDL[T".indexOf(CheckMethodAdapter.getChar(string, n2)) != -1) {
            n2 = CheckMethodAdapter.checkTypeSignature(string, n2);
        }
        n2 = CheckMethodAdapter.getChar(string, n2 = CheckMethodAdapter.checkChar(')', string, n2)) == 'V' ? ++n2 : CheckMethodAdapter.checkTypeSignature(string, n2);
        while (CheckMethodAdapter.getChar(string, n2) == '^') {
            if (CheckMethodAdapter.getChar(string, ++n2) == 'L') {
                n2 = CheckMethodAdapter.checkClassTypeSignature(string, n2);
                continue;
            }
            n2 = CheckMethodAdapter.checkTypeVariableSignature(string, n2);
        }
        if (n2 != string.length()) {
            throw new IllegalArgumentException(string + ": error at index " + n2);
        }
    }

    static void checkFieldSignature(String string) {
        int n2 = CheckMethodAdapter.checkFieldTypeSignature(string, 0);
        if (n2 != string.length()) {
            throw new IllegalArgumentException(string + ": error at index " + n2);
        }
    }

    private static int checkFormalTypeParameters(String string, int n2) {
        n2 = CheckMethodAdapter.checkChar('<', string, n2);
        n2 = CheckMethodAdapter.checkFormalTypeParameter(string, n2);
        while (CheckMethodAdapter.getChar(string, n2) != '>') {
            n2 = CheckMethodAdapter.checkFormalTypeParameter(string, n2);
        }
        return n2 + 1;
    }

    private static int checkFormalTypeParameter(String string, int n2) {
        n2 = CheckMethodAdapter.checkIdentifier(string, n2);
        if ("L[T".indexOf(CheckMethodAdapter.getChar(string, n2 = CheckMethodAdapter.checkChar(':', string, n2))) != -1) {
            n2 = CheckMethodAdapter.checkFieldTypeSignature(string, n2);
        }
        while (CheckMethodAdapter.getChar(string, n2) == ':') {
            n2 = CheckMethodAdapter.checkFieldTypeSignature(string, n2 + 1);
        }
        return n2;
    }

    private static int checkFieldTypeSignature(String string, int n2) {
        switch (CheckMethodAdapter.getChar(string, n2)) {
            case 'L': {
                return CheckMethodAdapter.checkClassTypeSignature(string, n2);
            }
            case '[': {
                return CheckMethodAdapter.checkTypeSignature(string, n2 + 1);
            }
        }
        return CheckMethodAdapter.checkTypeVariableSignature(string, n2);
    }

    private static int checkClassTypeSignature(String string, int n2) {
        n2 = CheckMethodAdapter.checkChar('L', string, n2);
        n2 = CheckMethodAdapter.checkIdentifier(string, n2);
        while (CheckMethodAdapter.getChar(string, n2) == '/') {
            n2 = CheckMethodAdapter.checkIdentifier(string, n2 + 1);
        }
        if (CheckMethodAdapter.getChar(string, n2) == '<') {
            n2 = CheckMethodAdapter.checkTypeArguments(string, n2);
        }
        while (CheckMethodAdapter.getChar(string, n2) == '.') {
            if (CheckMethodAdapter.getChar(string, n2 = CheckMethodAdapter.checkIdentifier(string, n2 + 1)) != '<') continue;
            n2 = CheckMethodAdapter.checkTypeArguments(string, n2);
        }
        return CheckMethodAdapter.checkChar(';', string, n2);
    }

    private static int checkTypeArguments(String string, int n2) {
        n2 = CheckMethodAdapter.checkChar('<', string, n2);
        n2 = CheckMethodAdapter.checkTypeArgument(string, n2);
        while (CheckMethodAdapter.getChar(string, n2) != '>') {
            n2 = CheckMethodAdapter.checkTypeArgument(string, n2);
        }
        return n2 + 1;
    }

    private static int checkTypeArgument(String string, int n2) {
        char c2 = CheckMethodAdapter.getChar(string, n2);
        if (c2 == '*') {
            return n2 + 1;
        }
        if (c2 == '+' || c2 == '-') {
            ++n2;
        }
        return CheckMethodAdapter.checkFieldTypeSignature(string, n2);
    }

    private static int checkTypeVariableSignature(String string, int n2) {
        n2 = CheckMethodAdapter.checkChar('T', string, n2);
        n2 = CheckMethodAdapter.checkIdentifier(string, n2);
        return CheckMethodAdapter.checkChar(';', string, n2);
    }

    private static int checkTypeSignature(String string, int n2) {
        switch (CheckMethodAdapter.getChar(string, n2)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n2 + 1;
            }
        }
        return CheckMethodAdapter.checkFieldTypeSignature(string, n2);
    }

    private static int checkIdentifier(String string, int n2) {
        if (!Character.isJavaIdentifierStart(CheckMethodAdapter.getChar(string, n2))) {
            throw new IllegalArgumentException(string + ": identifier expected at index " + n2);
        }
        ++n2;
        while (Character.isJavaIdentifierPart(CheckMethodAdapter.getChar(string, n2))) {
            ++n2;
        }
        return n2;
    }

    private static int checkChar(char c2, String string, int n2) {
        if (CheckMethodAdapter.getChar(string, n2) == c2) {
            return n2 + 1;
        }
        throw new IllegalArgumentException(string + ": '" + c2 + "' expected at index " + n2);
    }

    private static char getChar(String string, int n2) {
        return n2 < string.length() ? string.charAt(n2) : (char)'\u0000';
    }

    void checkLabel(Label label, boolean bl, String string) {
        if (label == null) {
            throw new IllegalArgumentException("Invalid " + string + " (must not be null)");
        }
        if (bl && this.labels.get(label) == null) {
            throw new IllegalArgumentException("Invalid " + string + " (must be visited first)");
        }
    }

    private static void checkNonDebugLabel(Label label) {
        Field field = CheckMethodAdapter.getLabelStatusField();
        int n2 = 0;
        try {
            n2 = field == null ? 0 : (Integer)field.get(label);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Internal error");
        }
        if ((n2 & 1) != 0) {
            throw new IllegalArgumentException("Labels used for debug info cannot be reused for control flow");
        }
    }

    private static Field getLabelStatusField() {
        if (labelStatusField == null && (labelStatusField = CheckMethodAdapter.getLabelField("a")) == null) {
            labelStatusField = CheckMethodAdapter.getLabelField("status");
        }
        return labelStatusField;
    }

    private static Field getLabelField(String string) {
        try {
            Field field = (class$org$objectweb$asm$Label == null ? (class$org$objectweb$asm$Label = CheckMethodAdapter.class$("org.objectweb.asm.Label")) : class$org$objectweb$asm$Label).getDeclaredField(string);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string = "BBBBBBBBBBBBBBBBCCIAADDDDDAAAAAAAAAAAAAAAAAAAABBBBBBBBDDDDDAAAAAAAAAAAAAAAAAAAABBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBJBBBBBBBBBBBBBBBBBBBBHHHHHHHHHHHHHHHHDKLBBBBBBFFFFGGGGGECEBBEEBBAMHHAA";
        TYPE = new int[string.length()];
        for (int i2 = 0; i2 < TYPE.length; ++i2) {
            CheckMethodAdapter.TYPE[i2] = string.charAt(i2) - 65 - 1;
        }
    }
}

