/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.graph.GraphPathImpl;
import org.jgrapht.traverse.ClosestFirstIterator;

public final class DijkstraShortestPath<V, E> {
    private GraphPath<V, E> path;

    public DijkstraShortestPath(Graph<V, E> graph, V v2, V v3) {
        this(graph, v2, v3, Double.POSITIVE_INFINITY);
    }

    public DijkstraShortestPath(Graph<V, E> graph, V v2, V v3, double d2) {
        if (!graph.containsVertex(v3)) {
            throw new IllegalArgumentException("graph must contain the end vertex");
        }
        ClosestFirstIterator<V, E> closestFirstIterator = new ClosestFirstIterator<V, E>(graph, v2, d2);
        while (closestFirstIterator.hasNext()) {
            Object v4 = closestFirstIterator.next();
            if (!v4.equals(v3)) continue;
            this.createEdgeList(graph, closestFirstIterator, v2, v3);
            return;
        }
        this.path = null;
    }

    public List<E> getPathEdgeList() {
        if (this.path == null) {
            return null;
        }
        return this.path.getEdgeList();
    }

    public GraphPath<V, E> getPath() {
        return this.path;
    }

    public double getPathLength() {
        if (this.path == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.path.getWeight();
    }

    public static <V, E> List<E> findPathBetween(Graph<V, E> graph, V v2, V v3) {
        DijkstraShortestPath<V, E> dijkstraShortestPath = new DijkstraShortestPath<V, E>(graph, v2, v3);
        return dijkstraShortestPath.getPathEdgeList();
    }

    private void createEdgeList(Graph<V, E> graph, ClosestFirstIterator<V, E> closestFirstIterator, V v2, V v3) {
        E e2;
        ArrayList<E> arrayList = new ArrayList<E>();
        V v4 = v3;
        while ((e2 = closestFirstIterator.getSpanningTreeEdge(v4)) != null) {
            arrayList.add(e2);
            v4 = Graphs.getOppositeVertex(graph, e2, v4);
        }
        Collections.reverse(arrayList);
        double d2 = closestFirstIterator.getShortestPathLength(v3);
        this.path = new GraphPathImpl<V, E>(graph, v2, v3, arrayList, d2);
    }
}

