/*
 * Decompiled with CFR 0.152.
 */
package org.bson.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.bson.util.CopyOnWriteMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassAncestry {
    private static final ConcurrentMap<Class<?>, List<Class<?>>> _ancestryCache = CopyOnWriteMap.newHashMap();

    ClassAncestry() {
    }

    public static <T> List<Class<?>> getAncestry(Class<T> c2) {
        ConcurrentMap<Class<?>, List<Class<?>>> cache = ClassAncestry.getClassAncestryCache();
        List cachedResult;
        while ((cachedResult = (List)cache.get(c2)) == null) {
            cache.putIfAbsent(c2, ClassAncestry.computeAncestry(c2));
        }
        return cachedResult;
    }

    private static List<Class<?>> computeAncestry(Class<?> c2) {
        ArrayList result = new ArrayList();
        result.add(Object.class);
        ClassAncestry.computeAncestry(c2, result);
        Collections.reverse(result);
        return Collections.unmodifiableList(new ArrayList(result));
    }

    private static <T> void computeAncestry(Class<T> c2, List<Class<?>> result) {
        if (c2 == null || c2 == Object.class) {
            return;
        }
        Class<?>[] interfaces = c2.getInterfaces();
        for (int i2 = interfaces.length - 1; i2 >= 0; --i2) {
            ClassAncestry.computeAncestry(interfaces[i2], result);
        }
        ClassAncestry.computeAncestry(c2.getSuperclass(), result);
        if (!result.contains(c2)) {
            result.add(c2);
        }
    }

    private static ConcurrentMap<Class<?>, List<Class<?>>> getClassAncestryCache() {
        return _ancestryCache;
    }
}

