/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import java.lang.annotation.Annotation;
import java.util.List;
import org.broadinstitute.gatk.utils.Utils;
import org.broadinstitute.gatk.utils.commandline.ArgumentIOType;
import org.broadinstitute.gatk.utils.commandline.CommandLineUtils;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;

public class ArgumentDefinition {
    public final ArgumentIOType ioType;
    public final Class argumentType;
    public final String fullName;
    public final String shortName;
    public final String doc;
    public final boolean required;
    public final boolean isFlag;
    public final boolean isMultiValued;
    public final Class componentType;
    public final boolean isHidden;
    public final String exclusiveOf;
    public final String validation;
    public final List<String> validOptions;

    public ArgumentDefinition(ArgumentIOType ioType, Class argumentType, String fullName, String shortName, String doc, boolean required, boolean isFlag, boolean isMultiValued, boolean isHidden, Class componentType, String exclusiveOf, String validation, List<String> validOptions) {
        this.ioType = ioType;
        this.argumentType = argumentType;
        this.fullName = fullName;
        this.shortName = shortName;
        this.doc = doc;
        this.required = required;
        this.isFlag = isFlag;
        this.isMultiValued = isMultiValued;
        this.isHidden = isHidden;
        this.componentType = componentType;
        this.exclusiveOf = exclusiveOf;
        this.validation = validation;
        this.validOptions = validOptions;
        this.validateName(shortName);
        this.validateName(fullName);
    }

    public ArgumentDefinition(Annotation annotation, ArgumentIOType ioType, Class argumentType, String defaultFullName, String defaultShortName, String doc, boolean isRequired, boolean isFlag, boolean isMultiValued, boolean isHidden, Class componentType, String exclusiveOf, String validation, List<String> validOptions) {
        String fullName = (String)CommandLineUtils.getValue(annotation, "fullName");
        String shortName = (String)CommandLineUtils.getValue(annotation, "shortName");
        boolean isFullNameProvided = fullName.trim().length() > 0;
        boolean isShortNameProvided = shortName.trim().length() > 0;
        String string = fullName = isFullNameProvided ? fullName.trim() : defaultFullName;
        shortName = isShortNameProvided ? shortName.trim() : (!isFullNameProvided ? defaultShortName : null);
        this.validateName(shortName);
        this.validateName(fullName);
        this.ioType = ioType;
        this.argumentType = argumentType;
        this.fullName = fullName;
        this.shortName = shortName;
        this.doc = doc;
        this.required = isRequired;
        this.isFlag = isFlag;
        this.isMultiValued = isMultiValued;
        this.isHidden = isHidden;
        this.componentType = componentType;
        this.exclusiveOf = exclusiveOf;
        this.validation = validation;
        this.validOptions = validOptions;
    }

    public int hashCode() {
        int hashCode = this.fullName.hashCode();
        if (this.shortName != null) {
            hashCode ^= this.shortName.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object o2) {
        if (o2 == null) {
            return false;
        }
        if (!(o2 instanceof ArgumentDefinition)) {
            return false;
        }
        ArgumentDefinition other = (ArgumentDefinition)o2;
        return Utils.equals(this.fullName, other.fullName) && Utils.equals(this.shortName, other.shortName);
    }

    public static String getFullName(Annotation annotation, String fieldName) {
        String fullName = (String)CommandLineUtils.getValue(annotation, "fullName");
        return fullName.trim().length() > 0 ? fullName.trim() : fieldName.toLowerCase();
    }

    public static String getShortName(Annotation annotation) {
        String shortName = (String)CommandLineUtils.getValue(annotation, "shortName");
        return shortName.trim().length() > 0 ? shortName.trim() : null;
    }

    public static String getDoc(Annotation annotation) {
        return (String)CommandLineUtils.getValue(annotation, "doc");
    }

    public static String getExclusiveOf(Annotation annotation) {
        String exclusiveOf = (String)CommandLineUtils.getValue(annotation, "exclusiveOf");
        return exclusiveOf.trim().length() > 0 ? exclusiveOf.trim() : null;
    }

    public static String getValidationRegex(Annotation annotation) {
        String validation = (String)CommandLineUtils.getValue(annotation, "validation");
        return validation.trim().length() > 0 ? validation.trim() : null;
    }

    private void validateName(String name) {
        if (name != null && name.startsWith("-")) {
            throw new ReviewedGATKException("Invalid argument definition: " + name + " begins with a -");
        }
    }
}

