/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.converters;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.broad.igv.util.ParsingUtils;

public class DensitiesToBedGraph {
    public static void main(String[] args) throws IOException {
        File inputDir = new File(args[0]);
        File outputDir = new File(args[1]);
        DensitiesToBedGraph.convertAll(inputDir, outputDir);
    }

    private static void convertAll(File inputDir, File outputDir) throws IOException {
        File[] files;
        for (File f2 : files = inputDir.listFiles()) {
            if (!f2.getAbsolutePath().endsWith(".densities.txt.gz")) continue;
            String ofile = f2.getName().replace(".densities.txt.gz", ".bedgraph");
            DensitiesToBedGraph.convert(f2, new File(outputDir, ofile));
        }
    }

    public static void convert(File ifile, File ofile) throws IOException {
        String nextLine;
        BufferedReader reader = null;
        PrintWriter pw = null;
        reader = ParsingUtils.openBufferedReader(ifile.getAbsolutePath());
        pw = new PrintWriter(new BufferedWriter(new FileWriter(ofile)));
        while ((nextLine = reader.readLine()) != null) {
            String[] tokens = nextLine.split("\t");
            float counts = Float.parseFloat(tokens[2]);
            if (!(counts > 0.0f)) continue;
            int start = Integer.parseInt(tokens[1]);
            pw.println(tokens[0] + "\t" + start + "\t" + (start + 25) + "\t" + counts);
        }
        reader.close();
        pw.close();
    }
}

