/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.StreamUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class DERGeneralizedTime
extends ASN1Primitive {
    private byte[] time;

    public static ASN1GeneralizedTime getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1GeneralizedTime) {
            return (ASN1GeneralizedTime)obj;
        }
        if (obj instanceof DERGeneralizedTime) {
            return new ASN1GeneralizedTime(((DERGeneralizedTime)obj).time);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1GeneralizedTime getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o2 = obj.getObject();
        if (explicit || o2 instanceof DERGeneralizedTime) {
            return DERGeneralizedTime.getInstance(o2);
        }
        return new ASN1GeneralizedTime(((ASN1OctetString)o2).getOctets());
    }

    public DERGeneralizedTime(String time) {
        this.time = Strings.toByteArray(time);
        try {
            this.getDate();
        }
        catch (ParseException e2) {
            throw new IllegalArgumentException("invalid date string: " + e2.getMessage());
        }
    }

    public DERGeneralizedTime(Date time) {
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = Strings.toByteArray(dateF.format(time));
    }

    DERGeneralizedTime(byte[] bytes) {
        this.time = bytes;
    }

    public String getTimeString() {
        return Strings.fromByteArray(this.time);
    }

    public String getTime() {
        String stime = Strings.fromByteArray(this.time);
        if (stime.charAt(stime.length() - 1) == 'Z') {
            return stime.substring(0, stime.length() - 1) + "GMT+00:00";
        }
        int signPos = stime.length() - 5;
        char sign = stime.charAt(signPos);
        if (sign == '-' || sign == '+') {
            return stime.substring(0, signPos) + "GMT" + stime.substring(signPos, signPos + 3) + ":" + stime.substring(signPos + 3);
        }
        signPos = stime.length() - 3;
        sign = stime.charAt(signPos);
        if (sign == '-' || sign == '+') {
            return stime.substring(0, signPos) + "GMT" + stime.substring(signPos) + ":00";
        }
        return stime + this.calculateGMTOffset();
    }

    private String calculateGMTOffset() {
        String sign = "+";
        TimeZone timeZone = TimeZone.getDefault();
        int offset = timeZone.getRawOffset();
        if (offset < 0) {
            sign = "-";
            offset = -offset;
        }
        int hours = offset / 3600000;
        int minutes = (offset - hours * 60 * 60 * 1000) / 60000;
        try {
            if (timeZone.useDaylightTime() && timeZone.inDaylightTime(this.getDate())) {
                hours += sign.equals("+") ? 1 : -1;
            }
        }
        catch (ParseException e2) {
            // empty catch block
        }
        return "GMT" + sign + this.convert(hours) + ":" + this.convert(minutes);
    }

    private String convert(int time) {
        if (time < 10) {
            return "0" + time;
        }
        return Integer.toString(time);
    }

    public Date getDate() throws ParseException {
        SimpleDateFormat dateF;
        String stime;
        String d2 = stime = Strings.fromByteArray(this.time);
        if (stime.endsWith("Z")) {
            dateF = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'") : new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else if (stime.indexOf(45) > 0 || stime.indexOf(43) > 0) {
            d2 = this.getTime();
            dateF = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSSz") : new SimpleDateFormat("yyyyMMddHHmmssz");
            dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else {
            dateF = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS") : new SimpleDateFormat("yyyyMMddHHmmss");
            dateF.setTimeZone(new SimpleTimeZone(0, TimeZone.getDefault().getID()));
        }
        if (this.hasFractionalSeconds()) {
            char ch;
            int index;
            String frac = d2.substring(14);
            for (index = 1; index < frac.length() && '0' <= (ch = frac.charAt(index)) && ch <= '9'; ++index) {
            }
            if (index - 1 > 3) {
                frac = frac.substring(0, 4) + frac.substring(index);
                d2 = d2.substring(0, 14) + frac;
            } else if (index - 1 == 1) {
                frac = frac.substring(0, index) + "00" + frac.substring(index);
                d2 = d2.substring(0, 14) + frac;
            } else if (index - 1 == 2) {
                frac = frac.substring(0, index) + "0" + frac.substring(index);
                d2 = d2.substring(0, 14) + frac;
            }
        }
        return dateF.parse(d2);
    }

    private boolean hasFractionalSeconds() {
        for (int i2 = 0; i2 != this.time.length; ++i2) {
            if (this.time[i2] != 46 || i2 != 14) continue;
            return true;
        }
        return false;
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() {
        int length = this.time.length;
        return 1 + StreamUtil.calculateBodyLength(length) + length;
    }

    void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(24, this.time);
    }

    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof DERGeneralizedTime)) {
            return false;
        }
        return Arrays.areEqual(this.time, ((DERGeneralizedTime)o2).time);
    }

    public int hashCode() {
        return Arrays.hashCode(this.time);
    }
}

