/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.transform;

import java.io.Serializable;
import java.lang.reflect.Array;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class FastFourierTransformer
implements Serializable {
    static final long serialVersionUID = 5138259215438106000L;
    private RootsOfUnity roots = new RootsOfUnity();

    public Complex[] transform(double[] f2) throws IllegalArgumentException {
        return this.fft(f2, false);
    }

    public Complex[] transform(UnivariateRealFunction f2, double min, double max, int n2) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f2, min, max, n2);
        return this.fft(data, false);
    }

    public Complex[] transform(Complex[] f2) throws IllegalArgumentException {
        this.roots.computeOmega(f2.length);
        return this.fft(f2);
    }

    public Complex[] transform2(double[] f2) throws IllegalArgumentException {
        double scaling_coefficient = 1.0 / FastMath.sqrt(f2.length);
        return FastFourierTransformer.scaleArray(this.fft(f2, false), scaling_coefficient);
    }

    public Complex[] transform2(UnivariateRealFunction f2, double min, double max, int n2) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f2, min, max, n2);
        double scaling_coefficient = 1.0 / FastMath.sqrt(n2);
        return FastFourierTransformer.scaleArray(this.fft(data, false), scaling_coefficient);
    }

    public Complex[] transform2(Complex[] f2) throws IllegalArgumentException {
        this.roots.computeOmega(f2.length);
        double scaling_coefficient = 1.0 / FastMath.sqrt(f2.length);
        return FastFourierTransformer.scaleArray(this.fft(f2), scaling_coefficient);
    }

    public Complex[] inversetransform(double[] f2) throws IllegalArgumentException {
        double scaling_coefficient = 1.0 / (double)f2.length;
        return FastFourierTransformer.scaleArray(this.fft(f2, true), scaling_coefficient);
    }

    public Complex[] inversetransform(UnivariateRealFunction f2, double min, double max, int n2) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f2, min, max, n2);
        double scaling_coefficient = 1.0 / (double)n2;
        return FastFourierTransformer.scaleArray(this.fft(data, true), scaling_coefficient);
    }

    public Complex[] inversetransform(Complex[] f2) throws IllegalArgumentException {
        this.roots.computeOmega(-f2.length);
        double scaling_coefficient = 1.0 / (double)f2.length;
        return FastFourierTransformer.scaleArray(this.fft(f2), scaling_coefficient);
    }

    public Complex[] inversetransform2(double[] f2) throws IllegalArgumentException {
        double scaling_coefficient = 1.0 / FastMath.sqrt(f2.length);
        return FastFourierTransformer.scaleArray(this.fft(f2, true), scaling_coefficient);
    }

    public Complex[] inversetransform2(UnivariateRealFunction f2, double min, double max, int n2) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f2, min, max, n2);
        double scaling_coefficient = 1.0 / FastMath.sqrt(n2);
        return FastFourierTransformer.scaleArray(this.fft(data, true), scaling_coefficient);
    }

    public Complex[] inversetransform2(Complex[] f2) throws IllegalArgumentException {
        this.roots.computeOmega(-f2.length);
        double scaling_coefficient = 1.0 / FastMath.sqrt(f2.length);
        return FastFourierTransformer.scaleArray(this.fft(f2), scaling_coefficient);
    }

    protected Complex[] fft(double[] f2, boolean isInverse) throws IllegalArgumentException {
        FastFourierTransformer.verifyDataSet(f2);
        Complex[] F = new Complex[f2.length];
        if (f2.length == 1) {
            F[0] = new Complex(f2[0], 0.0);
            return F;
        }
        int N = f2.length >> 1;
        Complex[] c2 = new Complex[N];
        for (int i2 = 0; i2 < N; ++i2) {
            c2[i2] = new Complex(f2[2 * i2], f2[2 * i2 + 1]);
        }
        this.roots.computeOmega(isInverse ? -N : N);
        Complex[] z = this.fft(c2);
        this.roots.computeOmega(isInverse ? -2 * N : 2 * N);
        F[0] = new Complex(2.0 * (z[0].getReal() + z[0].getImaginary()), 0.0);
        F[N] = new Complex(2.0 * (z[0].getReal() - z[0].getImaginary()), 0.0);
        for (int i3 = 1; i3 < N; ++i3) {
            Complex A = z[N - i3].conjugate();
            Complex B = z[i3].add(A);
            Complex C = z[i3].subtract(A);
            Complex D = new Complex(-this.roots.getOmegaImaginary(i3), this.roots.getOmegaReal(i3));
            F[i3] = B.subtract(C.multiply(D));
            F[2 * N - i3] = F[i3].conjugate();
        }
        return FastFourierTransformer.scaleArray(F, 0.5);
    }

    protected Complex[] fft(Complex[] data) throws IllegalArgumentException {
        int i2;
        int n2 = data.length;
        Complex[] f2 = new Complex[n2];
        FastFourierTransformer.verifyDataSet(data);
        if (n2 == 1) {
            f2[0] = data[0];
            return f2;
        }
        if (n2 == 2) {
            f2[0] = data[0].add(data[1]);
            f2[1] = data[0].subtract(data[1]);
            return f2;
        }
        int ii = 0;
        for (i2 = 0; i2 < n2; ++i2) {
            int k2;
            f2[i2] = data[ii];
            for (k2 = n2 >> 1; ii >= k2 && k2 > 0; ii -= k2, k2 >>= 1) {
            }
            ii += k2;
        }
        for (i2 = 0; i2 < n2; i2 += 4) {
            Complex a2 = f2[i2].add(f2[i2 + 1]);
            Complex b2 = f2[i2 + 2].add(f2[i2 + 3]);
            Complex c2 = f2[i2].subtract(f2[i2 + 1]);
            Complex d2 = f2[i2 + 2].subtract(f2[i2 + 3]);
            Complex e1 = c2.add(d2.multiply(Complex.I));
            Complex e2 = c2.subtract(d2.multiply(Complex.I));
            f2[i2] = a2.add(b2);
            f2[i2 + 2] = a2.subtract(b2);
            f2[i2 + 1] = this.roots.isForward() ? e2 : e1;
            f2[i2 + 3] = this.roots.isForward() ? e1 : e2;
        }
        for (i2 = 4; i2 < n2; i2 <<= 1) {
            int m2 = n2 / (i2 << 1);
            for (int j2 = 0; j2 < n2; j2 += i2 << 1) {
                for (int k3 = 0; k3 < i2; ++k3) {
                    int k_times_m = k3 * m2;
                    double omega_k_times_m_real = this.roots.getOmegaReal(k_times_m);
                    double omega_k_times_m_imaginary = this.roots.getOmegaImaginary(k_times_m);
                    Complex z = new Complex(f2[i2 + j2 + k3].getReal() * omega_k_times_m_real - f2[i2 + j2 + k3].getImaginary() * omega_k_times_m_imaginary, f2[i2 + j2 + k3].getReal() * omega_k_times_m_imaginary + f2[i2 + j2 + k3].getImaginary() * omega_k_times_m_real);
                    f2[i2 + j2 + k3] = f2[j2 + k3].subtract(z);
                    f2[j2 + k3] = f2[j2 + k3].add(z);
                }
            }
        }
        return f2;
    }

    public static double[] sample(UnivariateRealFunction f2, double min, double max, int n2) throws FunctionEvaluationException, IllegalArgumentException {
        if (n2 <= 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POSITIVE_NUMBER_OF_SAMPLES, n2);
        }
        FastFourierTransformer.verifyInterval(min, max);
        double[] s2 = new double[n2];
        double h2 = (max - min) / (double)n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            s2[i2] = f2.value(min + (double)i2 * h2);
        }
        return s2;
    }

    public static double[] scaleArray(double[] f2, double d2) {
        int i2 = 0;
        while (i2 < f2.length) {
            int n2 = i2++;
            f2[n2] = f2[n2] * d2;
        }
        return f2;
    }

    public static Complex[] scaleArray(Complex[] f2, double d2) {
        for (int i2 = 0; i2 < f2.length; ++i2) {
            f2[i2] = new Complex(d2 * f2[i2].getReal(), d2 * f2[i2].getImaginary());
        }
        return f2;
    }

    public static boolean isPowerOf2(long n2) {
        return n2 > 0L && (n2 & n2 - 1L) == 0L;
    }

    public static void verifyDataSet(double[] d2) throws IllegalArgumentException {
        if (!FastFourierTransformer.isPowerOf2(d2.length)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO_CONSIDER_PADDING, d2.length);
        }
    }

    public static void verifyDataSet(Object[] o2) throws IllegalArgumentException {
        if (!FastFourierTransformer.isPowerOf2(o2.length)) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO_CONSIDER_PADDING, o2.length);
        }
    }

    public static void verifyInterval(double lower, double upper) throws IllegalArgumentException {
        if (lower >= upper) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.ENDPOINTS_NOT_AN_INTERVAL, lower, upper);
        }
    }

    public Object mdfft(Object mdca, boolean forward) throws IllegalArgumentException {
        MultiDimensionalComplexMatrix mdcm = (MultiDimensionalComplexMatrix)new MultiDimensionalComplexMatrix(mdca).clone();
        int[] dimensionSize = mdcm.getDimensionSizes();
        for (int i2 = 0; i2 < dimensionSize.length; ++i2) {
            this.mdfft(mdcm, forward, i2, new int[0]);
        }
        return mdcm.getArray();
    }

    private void mdfft(MultiDimensionalComplexMatrix mdcm, boolean forward, int d2, int[] subVector) throws IllegalArgumentException {
        int[] dimensionSize = mdcm.getDimensionSizes();
        if (subVector.length == dimensionSize.length) {
            int i2;
            Complex[] temp = new Complex[dimensionSize[d2]];
            for (i2 = 0; i2 < dimensionSize[d2]; ++i2) {
                subVector[d2] = i2;
                temp[i2] = mdcm.get(subVector);
            }
            temp = forward ? this.transform2(temp) : this.inversetransform2(temp);
            for (i2 = 0; i2 < dimensionSize[d2]; ++i2) {
                subVector[d2] = i2;
                mdcm.set(temp[i2], subVector);
            }
        } else {
            int[] vector = new int[subVector.length + 1];
            System.arraycopy(subVector, 0, vector, 0, subVector.length);
            if (subVector.length == d2) {
                vector[d2] = 0;
                this.mdfft(mdcm, forward, d2, vector);
            } else {
                int i3 = 0;
                while (i3 < dimensionSize[subVector.length]) {
                    vector[subVector.length] = i3++;
                    this.mdfft(mdcm, forward, d2, vector);
                }
            }
        }
    }

    private static class RootsOfUnity
    implements Serializable {
        private static final long serialVersionUID = 6404784357747329667L;
        private int omegaCount = 0;
        private double[] omegaReal = null;
        private double[] omegaImaginaryForward = null;
        private double[] omegaImaginaryInverse = null;
        private boolean isForward = true;

        public synchronized boolean isForward() throws IllegalStateException {
            if (this.omegaCount == 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.ROOTS_OF_UNITY_NOT_COMPUTED_YET, new Object[0]);
            }
            return this.isForward;
        }

        public synchronized void computeOmega(int n2) throws IllegalArgumentException {
            if (n2 == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.CANNOT_COMPUTE_0TH_ROOT_OF_UNITY, new Object[0]);
            }
            this.isForward = n2 > 0;
            int absN = FastMath.abs(n2);
            if (absN == this.omegaCount) {
                return;
            }
            double t2 = Math.PI * 2 / (double)absN;
            double cosT = FastMath.cos(t2);
            double sinT = FastMath.sin(t2);
            this.omegaReal = new double[absN];
            this.omegaImaginaryForward = new double[absN];
            this.omegaImaginaryInverse = new double[absN];
            this.omegaReal[0] = 1.0;
            this.omegaImaginaryForward[0] = 0.0;
            this.omegaImaginaryInverse[0] = 0.0;
            for (int i2 = 1; i2 < absN; ++i2) {
                this.omegaReal[i2] = this.omegaReal[i2 - 1] * cosT + this.omegaImaginaryForward[i2 - 1] * sinT;
                this.omegaImaginaryForward[i2] = this.omegaImaginaryForward[i2 - 1] * cosT - this.omegaReal[i2 - 1] * sinT;
                this.omegaImaginaryInverse[i2] = -this.omegaImaginaryForward[i2];
            }
            this.omegaCount = absN;
        }

        public synchronized double getOmegaReal(int k2) throws IllegalStateException, IllegalArgumentException {
            if (this.omegaCount == 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.ROOTS_OF_UNITY_NOT_COMPUTED_YET, new Object[0]);
            }
            if (k2 < 0 || k2 >= this.omegaCount) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_RANGE_ROOT_OF_UNITY_INDEX, k2, 0, this.omegaCount - 1);
            }
            return this.omegaReal[k2];
        }

        public synchronized double getOmegaImaginary(int k2) throws IllegalStateException, IllegalArgumentException {
            if (this.omegaCount == 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.ROOTS_OF_UNITY_NOT_COMPUTED_YET, new Object[0]);
            }
            if (k2 < 0 || k2 >= this.omegaCount) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_RANGE_ROOT_OF_UNITY_INDEX, k2, 0, this.omegaCount - 1);
            }
            return this.isForward ? this.omegaImaginaryForward[k2] : this.omegaImaginaryInverse[k2];
        }
    }

    private static class MultiDimensionalComplexMatrix
    implements Cloneable {
        protected int[] dimensionSize;
        protected Object multiDimensionalComplexArray;

        public MultiDimensionalComplexMatrix(Object multiDimensionalComplexArray) {
            Object[] array;
            this.multiDimensionalComplexArray = multiDimensionalComplexArray;
            int numOfDimensions = 0;
            Object lastDimension = multiDimensionalComplexArray;
            while (lastDimension instanceof Object[]) {
                array = (Object[])lastDimension;
                ++numOfDimensions;
                lastDimension = array[0];
            }
            this.dimensionSize = new int[numOfDimensions];
            numOfDimensions = 0;
            lastDimension = multiDimensionalComplexArray;
            while (lastDimension instanceof Object[]) {
                array = (Object[])lastDimension;
                this.dimensionSize[numOfDimensions++] = array.length;
                lastDimension = array[0];
            }
        }

        public Complex get(int ... vector) throws IllegalArgumentException {
            if (vector == null) {
                if (this.dimensionSize.length > 0) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, 0, this.dimensionSize.length);
                }
                return null;
            }
            if (vector.length != this.dimensionSize.length) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, vector.length, this.dimensionSize.length);
            }
            Object lastDimension = this.multiDimensionalComplexArray;
            for (int i2 = 0; i2 < this.dimensionSize.length; ++i2) {
                lastDimension = ((Object[])lastDimension)[vector[i2]];
            }
            return (Complex)lastDimension;
        }

        public Complex set(Complex magnitude, int ... vector) throws IllegalArgumentException {
            if (vector == null) {
                if (this.dimensionSize.length > 0) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, 0, this.dimensionSize.length);
                }
                return null;
            }
            if (vector.length != this.dimensionSize.length) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, vector.length, this.dimensionSize.length);
            }
            Object[] lastDimension = (Object[])this.multiDimensionalComplexArray;
            for (int i2 = 0; i2 < this.dimensionSize.length - 1; ++i2) {
                lastDimension = (Object[])lastDimension[vector[i2]];
            }
            Complex lastValue = (Complex)lastDimension[vector[this.dimensionSize.length - 1]];
            lastDimension[vector[this.dimensionSize.length - 1]] = magnitude;
            return lastValue;
        }

        public int[] getDimensionSizes() {
            return (int[])this.dimensionSize.clone();
        }

        public Object getArray() {
            return this.multiDimensionalComplexArray;
        }

        public Object clone() {
            MultiDimensionalComplexMatrix mdcm = new MultiDimensionalComplexMatrix(Array.newInstance(Complex.class, this.dimensionSize));
            this.clone(mdcm);
            return mdcm;
        }

        private void clone(MultiDimensionalComplexMatrix mdcm) {
            int[][] vectorList;
            int[] vector = new int[this.dimensionSize.length];
            int size = 1;
            for (int i2 = 0; i2 < this.dimensionSize.length; ++i2) {
                size *= this.dimensionSize[i2];
            }
            block1: for (int[] nextVector : vectorList = new int[size][this.dimensionSize.length]) {
                System.arraycopy(vector, 0, nextVector, 0, this.dimensionSize.length);
                for (int i3 = 0; i3 < this.dimensionSize.length; ++i3) {
                    int n2 = i3;
                    vector[n2] = vector[n2] + 1;
                    if (vector[i3] < this.dimensionSize[i3]) continue block1;
                    vector[i3] = 0;
                }
            }
            for (int[] nextVector : vectorList) {
                mdcm.set(this.get(nextVector), nextVector);
            }
        }
    }
}

