/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.swing.JideLabel;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public class BasicJideLabelUI
extends BasicLabelUI {
    private static final LabelUI INSTANCE = new BasicJideLabelUI();
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent c2) {
        return INSTANCE;
    }

    protected void installDefaults(JLabel c2) {
        super.installDefaults(c2);
        LookAndFeel.installColorsAndFont(c2, "JideLabel.background", "JideLabel.foreground", "JideLabel.font");
    }

    public Dimension getMinimumSize(JComponent c2) {
        Dimension d2 = super.getMinimumSize(c2);
        if (JideSwingUtilities.getOrientationOf(c2) == 0) {
            return d2;
        }
        return new Dimension(d2.height, d2.width);
    }

    public Dimension getMaximumSize(JComponent c2) {
        Dimension d2 = super.getMaximumSize(c2);
        if (JideSwingUtilities.getOrientationOf(c2) == 0) {
            return d2;
        }
        return new Dimension(d2.height, d2.width);
    }

    public Dimension getPreferredSize(JComponent c2) {
        Dimension d2 = super.getPreferredSize(c2);
        if (JideSwingUtilities.getOrientationOf(c2) == 0) {
            return d2;
        }
        return new Dimension(d2.height, d2.width);
    }

    public void paint(Graphics g2, JComponent c2) {
        if (JideSwingUtilities.getOrientationOf(c2) == 1) {
            boolean clockwise = true;
            if (c2 instanceof JideLabel) {
                clockwise = ((JideLabel)c2).isClockwise();
            }
            this.paintVertically(g2, c2, clockwise);
        } else {
            super.paint(g2, c2);
        }
    }

    public void paintVertically(Graphics g2, JComponent c2, boolean clockwise) {
        Icon icon;
        JLabel label = (JLabel)c2;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = g2.getFontMetrics();
        paintViewInsets = c2.getInsets(paintViewInsets);
        BasicJideLabelUI.paintViewR.x = BasicJideLabelUI.paintViewInsets.left;
        BasicJideLabelUI.paintViewR.y = BasicJideLabelUI.paintViewInsets.top;
        BasicJideLabelUI.paintViewR.height = c2.getWidth() - (BasicJideLabelUI.paintViewInsets.left + BasicJideLabelUI.paintViewInsets.right);
        BasicJideLabelUI.paintViewR.width = c2.getHeight() - (BasicJideLabelUI.paintViewInsets.top + BasicJideLabelUI.paintViewInsets.bottom);
        BasicJideLabelUI.paintIconR.height = 0;
        BasicJideLabelUI.paintIconR.width = 0;
        BasicJideLabelUI.paintIconR.y = 0;
        BasicJideLabelUI.paintIconR.x = 0;
        BasicJideLabelUI.paintTextR.height = 0;
        BasicJideLabelUI.paintTextR.width = 0;
        BasicJideLabelUI.paintTextR.y = 0;
        BasicJideLabelUI.paintTextR.x = 0;
        String clippedText = this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
        Graphics2D g22 = (Graphics2D)g2;
        AffineTransform tr = g22.getTransform();
        if (clockwise) {
            g22.rotate(1.5707963267948966);
            g22.translate(0, -c2.getWidth());
        } else {
            g22.rotate(-1.5707963267948966);
            g22.translate(-c2.getHeight(), 0);
        }
        if (icon != null) {
            icon.paintIcon(c2, g2, BasicJideLabelUI.paintIconR.x, BasicJideLabelUI.paintIconR.y);
        }
        if (text != null) {
            View v2 = (View)c2.getClientProperty("html");
            if (v2 != null) {
                v2.paint(g2, paintTextR);
            } else {
                int textX = BasicJideLabelUI.paintTextR.x;
                int textY = BasicJideLabelUI.paintTextR.y + fm.getAscent();
                if (label.isEnabled()) {
                    this.paintEnabledText(label, g2, clippedText, textX, textY);
                } else {
                    this.paintDisabledText(label, g2, clippedText, textX, textY);
                }
            }
        }
        g22.setTransform(tr);
    }

    public void propertyChange(PropertyChangeEvent e2) {
        super.propertyChange(e2);
        if ("orientation" == e2.getPropertyName()) {
            if (e2.getSource() instanceof JLabel) {
                JLabel label = (JLabel)e2.getSource();
                label.revalidate();
            }
        } else if ("clockwise".equals(e2.getPropertyName()) && e2.getSource() instanceof JLabel) {
            JLabel label = (JLabel)e2.getSource();
            label.repaint();
        }
    }
}

