/*
 * Decompiled with CFR 0.152.
 */
package com.iontorrent.data;

import com.iontorrent.data.ReadInfo;
import java.util.ArrayList;
import java.util.TreeMap;

public class FlowDistribution {
    private TreeMap<Short, Integer> map;
    private String information;
    private String name;
    private char base;
    private int nrflows;
    private int location;
    private ArrayList<ReadInfo> readinfos;
    private boolean forward;
    private boolean reverse;

    public FlowDistribution(int location, int nrflows, TreeMap<Short, Integer> map, String name, char base, boolean forward, boolean reverse, String information) {
        this.map = map;
        this.information = information;
        this.name = name;
        this.nrflows = nrflows;
        this.location = location;
        this.forward = forward;
        this.reverse = reverse;
        this.base = base;
    }

    public int getNrFlows() {
        return this.nrflows;
    }

    public String getName() {
        return this.name;
    }

    public String toCsv(int binsize) {
        int[] bins = this.getBinnedData(binsize);
        String nl = "\n";
        StringBuilder csv = new StringBuilder();
        csv = csv.append(this.getInformation());
        csv = csv.append(nl).append("flow value, count\n");
        for (int b2 = 0; b2 < bins.length; ++b2) {
            csv = csv.append(b2 * binsize).append(",").append(bins[b2]).append(nl);
        }
        csv = csv.append(nl);
        return csv.toString();
    }

    public String toJson() {
        StringBuilder buf = new StringBuilder();
        buf.append("{\n");
        for (Short key : this.map.keySet()) {
            buf.append("    \"").append(key).append("\" : \"").append(this.map.get(key)).append("\"\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    public String getReadInfoString() {
        String nl = "\n";
        StringBuilder csv = new StringBuilder();
        csv = csv.append(this.getInformation());
        csv = csv.append(nl).append(ReadInfo.getHeader()).append(nl);
        for (ReadInfo ri : this.readinfos) {
            csv = csv.append(ri.toCsv()).append(nl);
        }
        csv = csv.append(nl);
        return csv.toString();
    }

    public String getReadNames() {
        StringBuilder names = new StringBuilder();
        for (ReadInfo ri : this.readinfos) {
            names = names.append(ri.getReadName()).append("_");
        }
        return names.toString();
    }

    public int[] getBinnedData(int binsize) {
        short maxx = 0;
        for (Short x2 : this.map.keySet()) {
            if (x2 <= maxx) continue;
            maxx = x2;
        }
        int nrbins = maxx / binsize + 1;
        int[] bins = new int[nrbins];
        for (Short x3 : this.map.keySet()) {
            int y = this.map.get(x3);
            int n2 = x3 / binsize;
            bins[n2] = bins[n2] + y;
        }
        return bins;
    }

    public TreeMap<Short, Integer> getMap() {
        return this.map;
    }

    public void setMap(TreeMap<Short, Integer> map) {
        this.map = map;
    }

    public String getInformation() {
        return this.information;
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int location) {
        this.location = location;
    }

    public int getMaxX() {
        short maxx = 0;
        for (Short x2 : this.map.keySet()) {
            if (x2 <= maxx) continue;
            maxx = x2;
        }
        return maxx;
    }

    public void setReadInfos(ArrayList<ReadInfo> readinfos) {
        this.readinfos = readinfos;
    }

    public char getBase() {
        return this.base;
    }

    public boolean isForward() {
        return this.forward;
    }

    public boolean isReverse() {
        return this.reverse;
    }
}

