/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.alg.color;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.experimental.alg.ApproximationAlgorithm;
import org.jgrapht.experimental.alg.IntArrayGraphAlgorithm;

public class GreedyColoring<V, E>
extends IntArrayGraphAlgorithm<V, E>
implements ApproximationAlgorithm<Integer, V> {
    public static final int BEST_ORDER = 0;
    public static final int NATURAL_ORDER = 1;
    public static final int SMALLEST_DEGREE_LAST_ORDER = 2;
    public static final int LARGEST_SATURATION_FIRST_ORDER = 3;
    private int _order = 0;

    public GreedyColoring(Graph<V, E> graph) {
        this(graph, 0);
    }

    public GreedyColoring(Graph<V, E> graph, int n2) {
        super(graph);
        this._order = n2;
    }

    int color(int[] nArray) {
        int[] nArray2 = new int[this._neighbors.length];
        int n2 = 1;
        BitSet bitSet = new BitSet(this._neighbors.length);
        for (int i2 = 0; i2 < this._neighbors.length; ++i2) {
            int n3 = nArray == null ? i2 : nArray[i2];
            bitSet.clear();
            for (int i3 = 0; i3 < this._neighbors[n3].length; ++i3) {
                int n4 = this._neighbors[n3][i3];
                if (nArray2[n4] <= 0) continue;
                bitSet.set(nArray2[n4]);
            }
            nArray2[n3] = bitSet.nextClearBit(1);
            if (nArray2[n3] <= n2) continue;
            n2 = nArray2[n3];
        }
        return n2;
    }

    int[] smallestDegreeLastOrder() {
        int n2;
        int[] nArray = new int[this._neighbors.length];
        int[] nArray2 = new int[this._neighbors.length];
        ArrayList arrayList = new ArrayList(this._neighbors.length);
        int n3 = this._neighbors.length - 1;
        for (n2 = 0; n2 < this._neighbors.length; ++n2) {
            arrayList.add(new ArrayList());
            nArray2[n2] = this._neighbors[n2].length;
        }
        for (n2 = 0; n2 < this._neighbors.length; ++n2) {
            ((List)arrayList.get(nArray2[n2])).add(n2);
        }
        for (n2 = 0; n2 < this._neighbors.length; ++n2) {
            while (((List)arrayList.get(n2)).size() > 0) {
                int n4 = ((List)arrayList.get(n2)).size() - 1;
                int n5 = (Integer)((List)arrayList.get(n2)).get(n4);
                ((List)arrayList.get(n2)).remove(n4);
                nArray2[n5] = -1;
                nArray[n3--] = n5;
                for (int i2 = 0; i2 < this._neighbors[n5].length; ++i2) {
                    int n6 = this._neighbors[n5][i2];
                    if (nArray2[n6] < 0) continue;
                    ((List)arrayList.get(nArray2[n6])).remove(new Integer(n6));
                    int n7 = n6;
                    nArray2[n7] = nArray2[n7] - 1;
                    ((List)arrayList.get(nArray2[n6])).add(n6);
                    if (nArray2[n6] >= n2) continue;
                    n2 = nArray2[n6];
                }
            }
        }
        return nArray;
    }

    int[] largestSaturationFirstOrder() {
        int n2;
        int[] nArray = new int[this._neighbors.length];
        int[] nArray2 = new int[this._neighbors.length];
        int[] nArray3 = new int[this._neighbors.length];
        int[] nArray4 = new int[this._neighbors.length];
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this._neighbors.length; ++n2) {
            nArray2[n2] = n2;
            nArray4[n2] = n2;
        }
        nArray3[0] = this._neighbors.length;
        while (n3 < this._neighbors.length) {
            while (n4 > 0 && nArray3[n4] == nArray3[n4 - 1]) {
                nArray3[n4--] = 0;
            }
            n2 = nArray2[nArray3[n4] - 1];
            int n5 = n4;
            nArray3[n5] = nArray3[n5] - 1;
            nArray[n2] = -1;
            ++n3;
            for (int i2 = 0; i2 < this._neighbors[n2].length; ++i2) {
                int n6 = this._neighbors[n2][i2];
                int n7 = nArray4[n6];
                if (nArray[n6] < 0) continue;
                if (n7 != nArray3[nArray[n6]] - 1) {
                    nArray2[n7] = nArray2[nArray3[nArray[n6]] - 1];
                    nArray2[nArray3[nArray[n6]] - 1] = n6;
                    nArray4[n6] = nArray3[nArray[n6]] - 1;
                    nArray4[nArray2[n7]] = n7;
                }
                int n8 = nArray[n6];
                nArray3[n8] = nArray3[n8] - 1;
                int n9 = n6;
                nArray[n9] = nArray[n9] + 1;
                if (nArray3[nArray[n6]] == 0) {
                    nArray3[nArray[n6]] = nArray3[nArray[n6] - 1] + 1;
                }
                if (nArray[n6] <= n4) continue;
                n4 = nArray[n6];
            }
        }
        Collections.reverse(Arrays.asList(new int[][]{nArray2}));
        return nArray2;
    }

    @Override
    public Integer getLowerBound(Map<V, Object> map) {
        return 0;
    }

    @Override
    public Integer getUpperBound(Map<V, Object> map) {
        switch (this._order) {
            case 0: {
                return Math.min(Math.min(this.color(null), this.color(this.smallestDegreeLastOrder())), this.color(this.largestSaturationFirstOrder()));
            }
            case 1: {
                return this.color(null);
            }
            case 2: {
                return this.color(this.smallestDegreeLastOrder());
            }
            case 3: {
                return this.color(this.largestSaturationFirstOrder());
            }
        }
        return this._neighbors.length;
    }

    @Override
    public boolean isExact() {
        return false;
    }
}

