/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.LazyGenotypesContext;

public class GenotypesContext
implements List<Genotype> {
    public static final GenotypesContext NO_GENOTYPES = new GenotypesContext(new ArrayList<Genotype>(0), new HashMap<String, Integer>(0), Collections.<String>emptyList()).immutable();
    List<String> sampleNamesInOrder = null;
    Map<String, Integer> sampleNameToOffset = null;
    ArrayList<Genotype> notToBeDirectlyAccessedGenotypes;
    private int maxPloidy = -1;
    boolean immutable = false;

    protected GenotypesContext() {
        this(10);
    }

    @Requires(value={"n >= 0"})
    protected GenotypesContext(int n2) {
        this(new ArrayList<Genotype>(n2));
    }

    @Requires(value={"genotypes != null"})
    protected GenotypesContext(ArrayList<Genotype> genotypes) {
        this.notToBeDirectlyAccessedGenotypes = genotypes;
        this.sampleNameToOffset = null;
    }

    @Requires(value={"genotypes != null", "sampleNameToOffset != null", "sampleNamesInOrder != null", "genotypes.size() == sampleNameToOffset.size()", "genotypes.size() == sampleNamesInOrder.size()"})
    protected GenotypesContext(ArrayList<Genotype> genotypes, Map<String, Integer> sampleNameToOffset, List<String> sampleNamesInOrder) {
        this.notToBeDirectlyAccessedGenotypes = genotypes;
        this.sampleNameToOffset = sampleNameToOffset;
        this.sampleNamesInOrder = sampleNamesInOrder;
    }

    @Ensures(value={"result != null"})
    public static final GenotypesContext create() {
        return new GenotypesContext();
    }

    @Requires(value={"nGenotypes >= 0"})
    @Ensures(value={"result != null"})
    public static final GenotypesContext create(int nGenotypes) {
        return new GenotypesContext(nGenotypes);
    }

    @Requires(value={"genotypes != null", "sampleNameToOffset != null", "sampleNamesInOrder != null"})
    @Ensures(value={"result != null"})
    public static final GenotypesContext create(ArrayList<Genotype> genotypes, Map<String, Integer> sampleNameToOffset, List<String> sampleNamesInOrder) {
        return new GenotypesContext(genotypes, sampleNameToOffset, sampleNamesInOrder);
    }

    @Requires(value={"genotypes != null"})
    @Ensures(value={"result != null"})
    public static final GenotypesContext create(ArrayList<Genotype> genotypes) {
        return genotypes == null ? NO_GENOTYPES : new GenotypesContext(genotypes);
    }

    @Requires(value={"genotypes != null"})
    @Ensures(value={"result != null"})
    public static final GenotypesContext create(Genotype ... genotypes) {
        return GenotypesContext.create(new ArrayList<Genotype>(Arrays.asList(genotypes)));
    }

    @Requires(value={"toCopy != null"})
    @Ensures(value={"result != null"})
    public static final GenotypesContext copy(GenotypesContext toCopy) {
        return GenotypesContext.create(new ArrayList<Genotype>(toCopy.getGenotypes()));
    }

    @Ensures(value={"result != null"})
    public static final GenotypesContext copy(Collection<Genotype> toCopy) {
        return toCopy == null ? NO_GENOTYPES : GenotypesContext.create(new ArrayList<Genotype>(toCopy));
    }

    public final GenotypesContext immutable() {
        this.immutable = true;
        return this;
    }

    public boolean isMutable() {
        return !this.immutable;
    }

    public final void checkImmutability() {
        if (this.immutable) {
            throw new IllegalAccessError("GenotypeMap is currently immutable, but a mutator method was invoked on it");
        }
    }

    @Ensures(value={"sampleNameToOffset == null"})
    protected void invalidateSampleNameMap() {
        this.sampleNameToOffset = null;
    }

    @Ensures(value={"sampleNamesInOrder == null"})
    protected void invalidateSampleOrdering() {
        this.sampleNamesInOrder = null;
    }

    @Ensures(value={"sampleNamesInOrder != null"})
    protected void ensureSampleOrdering() {
        if (this.sampleNamesInOrder == null) {
            this.sampleNamesInOrder = new ArrayList<String>(this.size());
            for (int i2 = 0; i2 < this.size(); ++i2) {
                this.sampleNamesInOrder.add(this.getGenotypes().get(i2).getSampleName());
            }
            Collections.sort(this.sampleNamesInOrder);
        }
    }

    @Ensures(value={"sampleNameToOffset != null"})
    protected void ensureSampleNameMap() {
        if (this.sampleNameToOffset == null) {
            this.sampleNameToOffset = new HashMap<String, Integer>(this.size());
            for (int i2 = 0; i2 < this.size(); ++i2) {
                this.sampleNameToOffset.put(this.getGenotypes().get(i2).getSampleName(), i2);
            }
        }
    }

    public boolean isLazyWithData() {
        return this instanceof LazyGenotypesContext && ((LazyGenotypesContext)this).getUnparsedGenotypeData() != null;
    }

    protected ArrayList<Genotype> getGenotypes() {
        return this.notToBeDirectlyAccessedGenotypes;
    }

    @Override
    public void clear() {
        this.checkImmutability();
        this.invalidateSampleNameMap();
        this.invalidateSampleOrdering();
        this.getGenotypes().clear();
    }

    @Override
    public int size() {
        return this.getGenotypes().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getGenotypes().isEmpty();
    }

    @Override
    @Requires(value={"genotype != null", "get(genotype.getSampleName()) == null"})
    public boolean add(Genotype genotype) {
        this.checkImmutability();
        this.invalidateSampleOrdering();
        if (this.sampleNameToOffset != null) {
            this.sampleNameToOffset.put(genotype.getSampleName(), this.size());
        }
        return this.getGenotypes().add(genotype);
    }

    @Override
    @Requires(value={"! contains(genotype)"})
    public void add(int i2, Genotype genotype) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Requires(value={"! containsAny(genotypes)"})
    public boolean addAll(Collection<? extends Genotype> genotypes) {
        this.checkImmutability();
        this.invalidateSampleOrdering();
        if (this.sampleNameToOffset != null) {
            int pos = this.size();
            for (Genotype genotype : genotypes) {
                this.sampleNameToOffset.put(genotype.getSampleName(), pos++);
            }
        }
        return this.getGenotypes().addAll(genotypes);
    }

    @Override
    public boolean addAll(int i2, Collection<? extends Genotype> genotypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o2) {
        return this.getGenotypes().contains(o2);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return this.getGenotypes().containsAll(objects);
    }

    private boolean containsAny(Collection<? extends Genotype> genotypes) {
        for (Genotype genotype : genotypes) {
            if (!this.contains(genotype)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Genotype get(int i2) {
        return this.getGenotypes().get(i2);
    }

    @Ensures(value={"result >= 0"})
    public int getMaxPloidy(int defaultPloidy) {
        if (defaultPloidy < 0) {
            throw new IllegalArgumentException("defaultPloidy must be greater than or equal to 0");
        }
        if (this.maxPloidy == -1) {
            this.maxPloidy = 0;
            for (Genotype g2 : this.getGenotypes()) {
                this.maxPloidy = Math.max(g2.getPloidy(), this.maxPloidy);
            }
            if (this.maxPloidy == 0) {
                this.maxPloidy = defaultPloidy;
            }
        }
        return this.maxPloidy;
    }

    public Genotype get(String sampleName) {
        Integer offset = this.getSampleI(sampleName);
        return offset == null ? null : this.getGenotypes().get(offset);
    }

    private Integer getSampleI(String sampleName) {
        this.ensureSampleNameMap();
        return this.sampleNameToOffset.get(sampleName);
    }

    @Override
    public int indexOf(Object o2) {
        return this.getGenotypes().indexOf(o2);
    }

    @Override
    public Iterator<Genotype> iterator() {
        return this.getGenotypes().iterator();
    }

    @Override
    public int lastIndexOf(Object o2) {
        return this.getGenotypes().lastIndexOf(o2);
    }

    @Override
    public ListIterator<Genotype> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Genotype> listIterator(int i2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Genotype remove(int i2) {
        this.checkImmutability();
        this.invalidateSampleNameMap();
        this.invalidateSampleOrdering();
        return this.getGenotypes().remove(i2);
    }

    @Override
    public boolean remove(Object o2) {
        this.checkImmutability();
        this.invalidateSampleNameMap();
        this.invalidateSampleOrdering();
        return this.getGenotypes().remove(o2);
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        this.checkImmutability();
        this.invalidateSampleNameMap();
        this.invalidateSampleOrdering();
        return this.getGenotypes().removeAll(objects);
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        this.checkImmutability();
        this.invalidateSampleNameMap();
        this.invalidateSampleOrdering();
        return this.getGenotypes().retainAll(objects);
    }

    @Override
    public Genotype set(int i2, Genotype genotype) {
        this.checkImmutability();
        Genotype prev = this.getGenotypes().set(i2, genotype);
        this.invalidateSampleOrdering();
        if (this.sampleNameToOffset != null) {
            this.sampleNameToOffset.remove(prev.getSampleName());
            this.sampleNameToOffset.put(genotype.getSampleName(), i2);
        }
        return prev;
    }

    @Requires(value={"genotype != null"})
    public Genotype replace(Genotype genotype) {
        this.checkImmutability();
        Integer offset = this.getSampleI(genotype.getSampleName());
        if (offset == null) {
            return null;
        }
        return this.set((int)offset, genotype);
    }

    @Override
    public List<Genotype> subList(int i2, int i1) {
        return this.getGenotypes().subList(i2, i1);
    }

    @Override
    public Object[] toArray() {
        return this.getGenotypes().toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.getGenotypes().toArray(ts);
    }

    @Requires(value={"sampleNamesInOrder != null"})
    public Iterable<Genotype> iterateInSampleNameOrder(final Iterable<String> sampleNamesInOrder) {
        return new Iterable<Genotype>(){

            @Override
            public Iterator<Genotype> iterator() {
                return new InOrderIterator(sampleNamesInOrder.iterator());
            }
        };
    }

    public Iterable<Genotype> iterateInSampleNameOrder() {
        return this.iterateInSampleNameOrder(this.getSampleNamesOrderedByName());
    }

    @Ensures(value={"result != null"})
    public Set<String> getSampleNames() {
        this.ensureSampleNameMap();
        return this.sampleNameToOffset.keySet();
    }

    @Ensures(value={"result != null"})
    public List<String> getSampleNamesOrderedByName() {
        this.ensureSampleOrdering();
        return this.sampleNamesInOrder;
    }

    @Requires(value={"sample != null"})
    public boolean containsSample(String sample) {
        this.ensureSampleNameMap();
        return this.sampleNameToOffset.containsKey(sample);
    }

    @Requires(value={"samples != null"})
    public boolean containsSamples(Collection<String> samples) {
        return this.getSampleNames().containsAll(samples);
    }

    @Requires(value={"samples != null"})
    @Ensures(value={"result != null"})
    public GenotypesContext subsetToSamples(Set<String> samples) {
        int nSamples = samples.size();
        if (nSamples == 0) {
            return NO_GENOTYPES;
        }
        GenotypesContext subset = GenotypesContext.create(samples.size());
        for (String sample : samples) {
            Genotype g2 = this.get(sample);
            if (g2 == null) continue;
            subset.add(g2);
        }
        return subset;
    }

    public String toString() {
        ArrayList<String> gS = new ArrayList<String>();
        for (Genotype g2 : this.iterateInSampleNameOrder()) {
            gS.add(g2.toString());
        }
        return "[" + GenotypesContext.join(",", gS) + "]";
    }

    private static <T> String join(String separator, Collection<T> objects) {
        if (objects.isEmpty()) {
            return "";
        }
        Iterator<T> iter = objects.iterator();
        T first = iter.next();
        if (!iter.hasNext()) {
            return first.toString();
        }
        StringBuilder ret = new StringBuilder(first.toString());
        while (iter.hasNext()) {
            ret.append(separator);
            ret.append(iter.next().toString());
        }
        return ret.toString();
    }

    private final class InOrderIterator
    implements Iterator<Genotype> {
        final Iterator<String> sampleNamesInOrder;

        private InOrderIterator(Iterator<String> sampleNamesInOrder) {
            this.sampleNamesInOrder = sampleNamesInOrder;
        }

        @Override
        public boolean hasNext() {
            return this.sampleNamesInOrder.hasNext();
        }

        @Override
        public Genotype next() {
            return GenotypesContext.this.get(this.sampleNamesInOrder.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

