/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.bcf2;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.broad.tribble.BinaryFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.LineIteratorImpl;
import org.broad.tribble.readers.LineReaderUtil;
import org.broad.tribble.readers.PositionalBufferedStream;
import org.broadinstitute.variant.bcf2.BCF2Decoder;
import org.broadinstitute.variant.bcf2.BCF2GenotypeFieldDecoders;
import org.broadinstitute.variant.bcf2.BCF2LazyGenotypesDecoder;
import org.broadinstitute.variant.bcf2.BCF2Type;
import org.broadinstitute.variant.bcf2.BCF2Utils;
import org.broadinstitute.variant.bcf2.BCFVersion;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.LazyGenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.VariantContextUtils;
import org.broadinstitute.variant.vcf.VCFCodec;
import org.broadinstitute.variant.vcf.VCFCompoundHeaderLine;
import org.broadinstitute.variant.vcf.VCFContigHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;

public final class BCF2Codec
extends BinaryFeatureCodec<VariantContext> {
    private static final int ALLOWED_MAJOR_VERSION = 2;
    private static final int MIN_MINOR_VERSION = 1;
    private BCFVersion bcfVersion = null;
    private VCFHeader header = null;
    private final ArrayList<String> contigNames = new ArrayList();
    private ArrayList<String> dictionary;
    private final BCF2Decoder decoder = new BCF2Decoder();
    private static final int MAX_HEADER_SIZE = 0x8000000;
    private BCF2GenotypeFieldDecoders gtFieldDecoders = null;
    private GenotypeBuilder[] builders = null;
    private int recordNo = 0;
    private int pos = 0;

    @Override
    public Feature decodeLoc(PositionalBufferedStream inputStream) {
        return this.decode(inputStream);
    }

    @Override
    public VariantContext decode(PositionalBufferedStream inputStream) {
        try {
            ++this.recordNo;
            VariantContextBuilder builder = new VariantContextBuilder();
            int sitesBlockSize = this.decoder.readBlockSize(inputStream);
            int genotypeBlockSize = this.decoder.readBlockSize(inputStream);
            this.decoder.readNextBlock(sitesBlockSize, inputStream);
            this.decodeSiteLoc(builder);
            SitesInfoForDecoding info = this.decodeSitesExtendedInfo(builder);
            this.decoder.readNextBlock(genotypeBlockSize, inputStream);
            this.createLazyGenotypesDecoder(info, builder);
            return builder.fullyDecoded(true).make();
        }
        catch (IOException e2) {
            throw new TribbleException("Failed to read BCF file", e2);
        }
    }

    @Override
    public Class<VariantContext> getFeatureType() {
        return VariantContext.class;
    }

    @Override
    public FeatureCodecHeader readHeader(PositionalBufferedStream inputStream) {
        try {
            byte[] headerBytes;
            int headerSizeInBytes;
            this.bcfVersion = BCFVersion.readBCFVersion(inputStream);
            if (this.bcfVersion == null) {
                this.error("Input stream does not contain a BCF encoded file; BCF magic header info not found");
            }
            if (this.bcfVersion.getMajorVersion() != 2) {
                this.error("BCF2Codec can only process BCF2 files, this file has major version " + this.bcfVersion.getMajorVersion());
            }
            if (this.bcfVersion.getMinorVersion() < 1) {
                this.error("BCF2Codec can only process BCF2 files with minor version >= 1 but this file has minor version " + this.bcfVersion.getMinorVersion());
            }
            if ((headerSizeInBytes = BCF2Type.INT32.read(inputStream)) <= 0 || headerSizeInBytes > 0x8000000) {
                this.error("BCF2 header has invalid length: " + headerSizeInBytes + " must be >= 0 and < " + 0x8000000);
            }
            if (inputStream.read(headerBytes = new byte[headerSizeInBytes]) != headerSizeInBytes) {
                this.error("Couldn't read all of the bytes specified in the header length = " + headerSizeInBytes);
            }
            PositionalBufferedStream bps = new PositionalBufferedStream(new ByteArrayInputStream(headerBytes));
            LineIteratorImpl lineIterator = new LineIteratorImpl(LineReaderUtil.fromBufferedStream(bps, LineReaderUtil.LineReaderOption.SYNCHRONOUS));
            VCFCodec headerParser = new VCFCodec();
            this.header = (VCFHeader)headerParser.readActualHeader(lineIterator);
            bps.close();
        }
        catch (IOException e2) {
            throw new TribbleException("I/O error while reading BCF2 header");
        }
        if (!this.header.getContigLines().isEmpty()) {
            this.contigNames.clear();
            for (VCFContigHeaderLine contig : this.header.getContigLines()) {
                if (contig.getID() == null || contig.getID().equals("")) {
                    this.error("found a contig with an invalid ID " + contig);
                }
                this.contigNames.add(contig.getID());
            }
        } else {
            this.error("Didn't find any contig lines in BCF2 file header");
        }
        this.dictionary = this.parseDictionary(this.header);
        this.gtFieldDecoders = new BCF2GenotypeFieldDecoders(this.header);
        int nSamples = this.header.getNGenotypeSamples();
        this.builders = new GenotypeBuilder[nSamples];
        for (int i2 = 0; i2 < nSamples; ++i2) {
            this.builders[i2] = new GenotypeBuilder(this.header.getGenotypeSamples().get(i2));
        }
        return new FeatureCodecHeader(this.header, inputStream.getPosition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDecode(String path) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(path);
            BCFVersion version = BCFVersion.readBCFVersion(fis);
            boolean bl = version != null && version.getMajorVersion() == 2;
            return bl;
        }
        catch (FileNotFoundException e2) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e3) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e4) {}
        }
    }

    @Requires(value={"builder != null"})
    private final void decodeSiteLoc(VariantContextBuilder builder) throws IOException {
        int contigOffset = this.decoder.decodeInt(BCF2Type.INT32);
        String contig = this.lookupContigName(contigOffset);
        builder.chr(contig);
        this.pos = this.decoder.decodeInt(BCF2Type.INT32) + 1;
        int refLength = this.decoder.decodeInt(BCF2Type.INT32);
        builder.start(this.pos);
        builder.stop(this.pos + refLength - 1);
    }

    @Requires(value={"builder != null", "decoder != null"})
    @Ensures(value={"result != null", "result.isValid()"})
    private final SitesInfoForDecoding decodeSitesExtendedInfo(VariantContextBuilder builder) throws IOException {
        Object qual = this.decoder.decodeSingleValue(BCF2Type.FLOAT);
        if (qual != null) {
            builder.log10PError((Double)qual / -10.0);
        }
        int nAlleleInfo = this.decoder.decodeInt(BCF2Type.INT32);
        int nFormatSamples = this.decoder.decodeInt(BCF2Type.INT32);
        int nAlleles = nAlleleInfo >> 16;
        int nInfo = nAlleleInfo & 0xFFFF;
        int nFormatFields = nFormatSamples >> 24;
        int nSamples = nFormatSamples & 0xFFFFF;
        if (this.header.getNGenotypeSamples() != nSamples) {
            this.error("Reading BCF2 files with different numbers of samples per record is not currently supported.  Saw " + this.header.getNGenotypeSamples() + " samples in header but have a record with " + nSamples + " samples");
        }
        this.decodeID(builder);
        List<Allele> alleles = this.decodeAlleles(builder, this.pos, nAlleles);
        this.decodeFilter(builder);
        this.decodeInfo(builder, nInfo);
        SitesInfoForDecoding info = new SitesInfoForDecoding(nFormatFields, nSamples, alleles);
        if (!info.isValid()) {
            this.error("Sites info is malformed: " + info);
        }
        return info;
    }

    private void decodeID(VariantContextBuilder builder) throws IOException {
        String id = (String)this.decoder.decodeTypedValue();
        if (id == null) {
            builder.noID();
        } else {
            builder.id(id);
        }
    }

    @Requires(value={"nAlleles > 0"})
    private List<Allele> decodeAlleles(VariantContextBuilder builder, int pos, int nAlleles) throws IOException {
        ArrayList<Allele> alleles = new ArrayList<Allele>(nAlleles);
        String ref = null;
        for (int i2 = 0; i2 < nAlleles; ++i2) {
            String alleleBases = (String)this.decoder.decodeTypedValue();
            boolean isRef = i2 == 0;
            Allele allele = Allele.create(alleleBases, isRef);
            if (isRef) {
                ref = alleleBases;
            }
            alleles.add(allele);
        }
        assert (ref != null);
        builder.alleles((Collection<Allele>)alleles);
        assert (ref.length() > 0);
        return alleles;
    }

    private void decodeFilter(VariantContextBuilder builder) throws IOException {
        Object value = this.decoder.decodeTypedValue();
        if (value == null) {
            builder.unfiltered();
        } else if (value instanceof Integer) {
            String filterString = this.getDictionaryString((Integer)value);
            if ("PASS".equals(filterString)) {
                builder.passFilters();
            } else {
                builder.filter(filterString);
            }
        } else {
            Iterator i$ = ((List)value).iterator();
            while (i$.hasNext()) {
                int offset = (Integer)i$.next();
                builder.filter(this.getDictionaryString(offset));
            }
        }
    }

    @Requires(value={"numInfoFields >= 0"})
    private void decodeInfo(VariantContextBuilder builder, int numInfoFields) throws IOException {
        if (numInfoFields == 0) {
            return;
        }
        HashMap<String, Object> infoFieldEntries = new HashMap<String, Object>(numInfoFields);
        for (int i2 = 0; i2 < numInfoFields; ++i2) {
            String key = this.getDictionaryString();
            Object value = this.decoder.decodeTypedValue();
            VCFCompoundHeaderLine metaData = VariantContextUtils.getMetaDataForField(this.header, key);
            if (metaData.getType() == VCFHeaderLineType.Flag) {
                value = true;
            }
            infoFieldEntries.put(key, value);
        }
        builder.attributes(infoFieldEntries);
    }

    private void createLazyGenotypesDecoder(SitesInfoForDecoding siteInfo, VariantContextBuilder builder) {
        if (siteInfo.nSamples > 0) {
            BCF2LazyGenotypesDecoder lazyParser = new BCF2LazyGenotypesDecoder(this, siteInfo.alleles, siteInfo.nSamples, siteInfo.nFormatFields, this.builders);
            LazyData lazyData = new LazyData(this.header, siteInfo.nFormatFields, this.decoder.getRecordBytes());
            LazyGenotypesContext lazy = new LazyGenotypesContext(lazyParser, lazyData, this.header.getNGenotypeSamples());
            if (!this.header.samplesWereAlreadySorted()) {
                lazy.decode();
            }
            builder.genotypesNoValidation(lazy);
        }
    }

    @Ensures(value={"result != null"})
    private final String getDictionaryString() throws IOException {
        return this.getDictionaryString((Integer)this.decoder.decodeTypedValue());
    }

    @Requires(value={"offset < dictionary.size()"})
    @Ensures(value={"result != null"})
    protected final String getDictionaryString(int offset) {
        return this.dictionary.get(offset);
    }

    @Requires(value={"contigOffset >= 0", "contigOffset < contigNames.size()"})
    @Ensures(value={"result != null"})
    private final String lookupContigName(int contigOffset) {
        return this.contigNames.get(contigOffset);
    }

    @Requires(value={"header != null"})
    @Ensures(value={"result != null", "! result.isEmpty()"})
    private final ArrayList<String> parseDictionary(VCFHeader header) {
        ArrayList<String> dict = BCF2Utils.makeDictionary(header);
        if (dict.isEmpty()) {
            this.error("Dictionary header element was absent or empty");
        }
        return dict;
    }

    protected VCFHeader getHeader() {
        return this.header;
    }

    @Requires(value={"field != null"})
    @Ensures(value={"result != null"})
    protected BCF2GenotypeFieldDecoders.Decoder getGenotypeFieldDecoder(String field) {
        return this.gtFieldDecoders.getDecoder(field);
    }

    private void error(String message) throws RuntimeException {
        throw new TribbleException(String.format("%s, at record %d with position %d:", message, this.recordNo, this.pos));
    }

    public static class LazyData {
        public final VCFHeader header;
        public final int nGenotypeFields;
        public final byte[] bytes;

        @Requires(value={"nGenotypeFields > 0", "bytes != null"})
        public LazyData(VCFHeader header, int nGenotypeFields, byte[] bytes) {
            this.header = header;
            this.nGenotypeFields = nGenotypeFields;
            this.bytes = bytes;
        }
    }

    protected static final class SitesInfoForDecoding {
        final int nFormatFields;
        final int nSamples;
        final List<Allele> alleles;

        private SitesInfoForDecoding(int nFormatFields, int nSamples, List<Allele> alleles) {
            this.nFormatFields = nFormatFields;
            this.nSamples = nSamples;
            this.alleles = alleles;
        }

        public boolean isValid() {
            return this.nFormatFields >= 0 && this.nSamples >= 0 && this.alleles != null && !this.alleles.isEmpty() && this.alleles.get(0).isReference();
        }

        public String toString() {
            return String.format("nFormatFields = %d, nSamples = %d, alleles = %s", this.nFormatFields, this.nSamples, this.alleles);
        }
    }
}

