/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.readers.PositionalBufferedStream;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFCodec;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFSimpleHeaderLine;
import org.broadinstitute.variant.vcf.VCFUtils;

public class GATKVCFUtils {
    public static final String GATK_COMMAND_LINE_KEY = "GATKCommandLine";

    private GATKVCFUtils() {
    }

    public static VCFHeaderLine getCommandLineArgumentHeaderLine(GenomeAnalysisEngine engine, Collection<Object> argumentSources) {
        if (engine == null) {
            throw new IllegalArgumentException("engine cannot be null");
        }
        if (argumentSources == null) {
            throw new IllegalArgumentException("argumentSources cannot be null");
        }
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("ID", engine.getWalkerName());
        attributes.put("Version", CommandLineGATK.getVersionNumber());
        Date date = new Date();
        attributes.put("Date", date.toString());
        attributes.put("Epoch", Long.toString(date.getTime()));
        attributes.put("CommandLineOptions", engine.createApproximateCommandLineArgumentString(argumentSources.toArray()));
        return new VCFSimpleHeaderLine(GATK_COMMAND_LINE_KEY, attributes, Collections.emptyList());
    }

    public static <T extends Feature> Map<String, VCFHeader> getVCFHeadersFromRods(GenomeAnalysisEngine toolkit, List<RodBinding<T>> rodBindings) {
        TreeSet<String> names = new TreeSet<String>();
        for (RodBinding<T> evalRod : rodBindings) {
            names.add(evalRod.getName());
        }
        return GATKVCFUtils.getVCFHeadersFromRods(toolkit, names);
    }

    public static Map<String, VCFHeader> getVCFHeadersFromRods(GenomeAnalysisEngine toolkit) {
        return GATKVCFUtils.getVCFHeadersFromRods(toolkit, (Collection<String>)null);
    }

    public static Map<String, VCFHeader> getVCFHeadersFromRods(GenomeAnalysisEngine toolkit, Collection<String> rodNames) {
        HashMap<String, VCFHeader> data = new HashMap<String, VCFHeader>();
        List dataSources = toolkit.getRodDataSources();
        for (ReferenceOrderedDataSource source : dataSources) {
            if (rodNames != null && !rodNames.contains(source.getName()) || source.getHeader() == null || !(source.getHeader() instanceof VCFHeader)) continue;
            data.put(source.getName(), (VCFHeader)source.getHeader());
        }
        return data;
    }

    public static Map<String, VCFHeader> getVCFHeadersFromRodPrefix(GenomeAnalysisEngine toolkit, String prefix) {
        HashMap<String, VCFHeader> data = new HashMap<String, VCFHeader>();
        List dataSources = toolkit.getRodDataSources();
        for (ReferenceOrderedDataSource source : dataSources) {
            if (!source.getName().startsWith(prefix) || source.getHeader() == null || !(source.getHeader() instanceof VCFHeader)) continue;
            data.put(source.getName(), (VCFHeader)source.getHeader());
        }
        return data;
    }

    public static Set<VCFHeaderLine> getHeaderFields(GenomeAnalysisEngine toolkit) {
        return GATKVCFUtils.getHeaderFields(toolkit, null);
    }

    public static Set<VCFHeaderLine> getHeaderFields(GenomeAnalysisEngine toolkit, Collection<String> rodNames) {
        TreeSet<VCFHeaderLine> fields = new TreeSet<VCFHeaderLine>();
        List dataSources = toolkit.getRodDataSources();
        for (ReferenceOrderedDataSource source : dataSources) {
            VCFHeader header;
            if (rodNames != null && !rodNames.contains(source.getName()) || !source.getRecordType().equals(VariantContext.class) || (header = (VCFHeader)source.getHeader()) == null) continue;
            fields.addAll(header.getMetaDataInSortedOrder());
        }
        return fields;
    }

    public static VCFHeader withUpdatedContigs(VCFHeader header, GenomeAnalysisEngine engine) {
        return VCFUtils.withUpdatedContigs(header, engine.getArguments().referenceFile, engine.getMasterSequenceDictionary());
    }

    public static final Pair<VCFHeader, VCIterable> readAllVCs(File source, FeatureCodec<VariantContext> codec) throws IOException {
        PositionalBufferedStream pbs = new PositionalBufferedStream(new FileInputStream(source));
        FeatureCodecHeader header = codec.readHeader(pbs);
        pbs.close();
        pbs = new PositionalBufferedStream(new FileInputStream(source));
        pbs.skip(header.getHeaderEnd());
        VCFHeader vcfHeader = (VCFHeader)header.getHeaderValue();
        return new Pair<VCFHeader, VCIterable>(vcfHeader, new VCIterable(pbs, codec, vcfHeader));
    }

    public static Pair<VCFHeader, List<VariantContext>> readVCF(File source) throws IOException {
        ArrayList<VariantContext> vcs = new ArrayList<VariantContext>();
        VCFCodec codec = new VCFCodec();
        PositionalBufferedStream pbs = new PositionalBufferedStream(new FileInputStream(source));
        FeatureCodecHeader header = codec.readHeader(pbs);
        pbs.close();
        pbs = new PositionalBufferedStream(new FileInputStream(source));
        pbs.skip(header.getHeaderEnd());
        VCFHeader vcfHeader = (VCFHeader)header.getHeaderValue();
        while (!pbs.isDone()) {
            VariantContext vc = (VariantContext)codec.decode(pbs);
            if (vc == null) continue;
            vcs.add(vc);
        }
        return new Pair<VCFHeader, List<VariantContext>>(vcfHeader, vcs);
    }

    public static class VCIterable
    implements Iterable<VariantContext>,
    Iterator<VariantContext> {
        final PositionalBufferedStream pbs;
        final FeatureCodec<VariantContext> codec;
        final VCFHeader header;

        private VCIterable(PositionalBufferedStream pbs, FeatureCodec<VariantContext> codec, VCFHeader header) {
            this.pbs = pbs;
            this.codec = codec;
            this.header = header;
        }

        @Override
        public Iterator<VariantContext> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            try {
                return !this.pbs.isDone();
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }

        @Override
        public VariantContext next() {
            try {
                VariantContext vc = (VariantContext)this.codec.decode(this.pbs);
                return vc == null ? null : vc.fullyDecode(this.header, false);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }

        @Override
        public void remove() {
        }
    }
}

