/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.iterators.ReadTransformer;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class MisencodedBaseQualityReadTransformer
extends ReadTransformer {
    private static final int samplingFrequency = 1000;
    private static final int encodingFixValue = 31;
    private boolean disabled;
    private boolean fixQuals;
    protected static int currentReadCounter = 0;

    public ReadTransformer.ApplicationTime initializeSub(GenomeAnalysisEngine engine, Walker walker) {
        this.fixQuals = engine.getArguments().FIX_MISENCODED_QUALS;
        this.disabled = !this.fixQuals && engine.getArguments().ALLOW_POTENTIALLY_MISENCODED_QUALS;
        return ReadTransformer.ApplicationTime.ON_INPUT;
    }

    public boolean enabled() {
        return !this.disabled;
    }

    public GATKSAMRecord apply(GATKSAMRecord read) {
        if (this.fixQuals) {
            return MisencodedBaseQualityReadTransformer.fixMisencodedQuals(read);
        }
        MisencodedBaseQualityReadTransformer.checkForMisencodedQuals(read);
        return read;
    }

    protected static GATKSAMRecord fixMisencodedQuals(GATKSAMRecord read) {
        byte[] quals = read.getBaseQualities();
        for (int i2 = 0; i2 < quals.length; ++i2) {
            int n2 = i2;
            quals[n2] = (byte)(quals[n2] - 31);
            if (quals[i2] >= 0) continue;
            throw new UserException.BadInput("while fixing mis-encoded base qualities we encountered a read that was correctly encoded; we cannot handle such a mixture of reads so unfortunately the BAM must be fixed with some other tool");
        }
        read.setBaseQualities(quals);
        return read;
    }

    protected static void checkForMisencodedQuals(GATKSAMRecord read) {
        if (++currentReadCounter >= 1000) {
            byte[] quals;
            currentReadCounter = 0;
            for (byte qual : quals = read.getBaseQualities()) {
                if (qual <= 60) continue;
                throw new UserException.MisencodedBAM(read, "we encountered an extremely high quality score of " + qual);
            }
        }
    }
}

