/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;
import org.broadinstitute.sting.gatk.iterators.StingSAMIteratorAdapter;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.ArtificialSAMUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class ArtificialSingleSampleReadStream
implements Iterable<SAMRecord> {
    private SAMFileHeader header;
    private String readGroupID;
    private int numContigs;
    private int numStacksPerContig;
    private int minReadsPerStack;
    private int maxReadsPerStack;
    private int minDistanceBetweenStacks;
    private int maxDistanceBetweenStacks;
    private int minReadLength;
    private int maxReadLength;
    private int numUnmappedReads;
    private static final String READ_GROUP_TAG = "RG";

    public ArtificialSingleSampleReadStream(SAMFileHeader header, String readGroupID, int numContigs, int numStacksPerContig, int minReadsPerStack, int maxReadsPerStack, int minDistanceBetweenStacks, int maxDistanceBetweenStacks, int minReadLength, int maxReadLength, int numUnmappedReads) {
        this.header = header;
        this.readGroupID = readGroupID;
        this.numContigs = numContigs;
        this.numStacksPerContig = numStacksPerContig;
        this.minReadsPerStack = minReadsPerStack;
        this.maxReadsPerStack = maxReadsPerStack;
        this.minDistanceBetweenStacks = minDistanceBetweenStacks;
        this.maxDistanceBetweenStacks = maxDistanceBetweenStacks;
        this.minReadLength = minReadLength;
        this.maxReadLength = maxReadLength;
        this.numUnmappedReads = numUnmappedReads;
        this.validateStreamParameters();
    }

    private void validateStreamParameters() {
        if (this.header == null || this.readGroupID == null) {
            throw new ReviewedStingException("null SAMFileHeader or read group ID");
        }
        if (this.header.getReadGroup(this.readGroupID) == null) {
            throw new ReviewedStingException(String.format("Read group %s not found in SAMFileHeader", this.readGroupID));
        }
        if (this.numContigs < 0 || this.numStacksPerContig < 0 || this.minReadsPerStack < 0 || this.maxReadsPerStack < 0 || this.minDistanceBetweenStacks < 0 || this.maxDistanceBetweenStacks < 0 || this.minReadLength < 0 || this.maxReadLength < 0 || this.numUnmappedReads < 0) {
            throw new ReviewedStingException("Read stream parameters must be >= 0");
        }
        if (this.numContigs == 0 && this.numStacksPerContig != 0 || this.numContigs != 0 && this.numStacksPerContig == 0) {
            throw new ReviewedStingException("numContigs and numStacksPerContig must either both be > 0, or both be 0");
        }
        if (this.minReadsPerStack > this.maxReadsPerStack) {
            throw new ReviewedStingException("minReadsPerStack > maxReadsPerStack");
        }
        if (this.minDistanceBetweenStacks > this.maxDistanceBetweenStacks) {
            throw new ReviewedStingException("minDistanceBetweenStacks > maxDistanceBetweenStacks");
        }
        if (this.minReadLength > this.maxReadLength) {
            throw new ReviewedStingException("minReadLength > maxReadLength");
        }
    }

    @Override
    public Iterator<SAMRecord> iterator() {
        return this.makeReads().iterator();
    }

    public StingSAMIterator getStingSAMIterator() {
        return StingSAMIteratorAdapter.adapt(this.iterator());
    }

    public Collection<SAMRecord> makeReads() {
        ArrayList<SAMRecord> reads = new ArrayList<SAMRecord>(this.numContigs * this.numStacksPerContig * this.maxReadsPerStack);
        for (int contig = 0; contig < this.numContigs; ++contig) {
            int alignmentStart = 1;
            for (int stack = 0; stack < this.numStacksPerContig; ++stack) {
                reads.addAll(this.makeReadStack(contig, alignmentStart, MathUtils.randomIntegerInRange(this.minReadsPerStack, this.maxReadsPerStack)));
                alignmentStart += MathUtils.randomIntegerInRange(this.minDistanceBetweenStacks, this.maxDistanceBetweenStacks);
            }
        }
        if (this.numUnmappedReads > 0) {
            reads.addAll(this.makeReadStack(-1, 0, this.numUnmappedReads));
        }
        return reads;
    }

    private Collection<SAMRecord> makeReadStack(int contig, int alignmentStart, int stackSize) {
        ArrayList<SAMRecord> readStack = new ArrayList<SAMRecord>(stackSize);
        for (int i2 = 0; i2 < stackSize; ++i2) {
            GATKSAMRecord read = ArtificialSAMUtils.createArtificialRead(this.header, "foo", contig, alignmentStart, MathUtils.randomIntegerInRange(this.minReadLength, this.maxReadLength));
            read.setAttribute(READ_GROUP_TAG, (Object)this.readGroupID);
            readStack.add(read);
        }
        return readStack;
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }

    public String getReadGroupID() {
        return this.readGroupID;
    }

    public int getNumContigs() {
        return this.numContigs;
    }

    public int getNumStacksPerContig() {
        return this.numStacksPerContig;
    }

    public int getMinReadsPerStack() {
        return this.minReadsPerStack;
    }

    public int getMaxReadsPerStack() {
        return this.maxReadsPerStack;
    }

    public int getMinDistanceBetweenStacks() {
        return this.minDistanceBetweenStacks;
    }

    public int getMaxDistanceBetweenStacks() {
        return this.maxDistanceBetweenStacks;
    }

    public int getMinReadLength() {
        return this.minReadLength;
    }

    public int getMaxReadLength() {
        return this.maxReadLength;
    }

    public int getNumUnmappedReads() {
        return this.numUnmappedReads;
    }
}

