/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecordCoordinateComparator;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.NGSPlatform;
import org.broadinstitute.sting.utils.sam.ArtificialSAMUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMReadGroupRecord;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class ArtificialBAMBuilder {
    public static final int BAM_SHARD_SIZE = 16384;
    private final IndexedFastaSequenceFile reference;
    private final GenomeLocParser parser;
    final int nReadsPerLocus;
    final int nLoci;
    int skipNLoci = 0;
    int alignmentStart = 1;
    int readLength = 10;
    private final ArrayList<String> samples = new ArrayList();
    private List<GATKSAMRecord> createdReads = null;
    private LinkedList<GATKSAMRecord> additionalReads = new LinkedList();
    final SAMFileWriterFactory factory = new SAMFileWriterFactory();
    SAMFileHeader header;

    public ArtificialBAMBuilder(IndexedFastaSequenceFile reference, int nReadsPerLocus, int nLoci) {
        this.factory.setCreateIndex(true);
        this.nReadsPerLocus = nReadsPerLocus;
        this.nLoci = nLoci;
        this.reference = reference;
        this.parser = new GenomeLocParser(reference);
        this.createAndSetHeader(1);
    }

    public ArtificialBAMBuilder(int nReadsPerLocus, int nLoci) {
        this(ArtificialSAMUtils.createArtificialSamHeader(1, 1, 1000000).getSequenceDictionary(), nReadsPerLocus, nLoci);
    }

    public ArtificialBAMBuilder(SAMSequenceDictionary dict, int nReadsPerLocus, int nLoci) {
        this.factory.setCreateIndex(true);
        this.nReadsPerLocus = nReadsPerLocus;
        this.nLoci = nLoci;
        this.reference = null;
        this.parser = new GenomeLocParser(dict);
        this.createAndSetHeader(1);
    }

    public IndexedFastaSequenceFile getReference() {
        return this.reference;
    }

    public GenomeLocParser getGenomeLocParser() {
        return this.parser;
    }

    public ArtificialBAMBuilder createAndSetHeader(int nSamples) {
        this.createdReads = null;
        this.header = new SAMFileHeader();
        this.header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        this.header.setSequenceDictionary(this.parser.getContigs());
        this.samples.clear();
        for (int i2 = 0; i2 < nSamples; ++i2) {
            GATKSAMReadGroupRecord rg = new GATKSAMReadGroupRecord("rg" + i2);
            String sample = "sample" + i2;
            this.samples.add(sample);
            rg.setSample(sample);
            rg.setPlatform(NGSPlatform.ILLUMINA.getDefaultPlatform());
            this.header.addReadGroup(rg);
        }
        return this;
    }

    public void addReads(GATKSAMRecord readToAdd) {
        this.createdReads = null;
        this.additionalReads.add(readToAdd);
    }

    public void addReads(Collection<GATKSAMRecord> readsToAdd) {
        this.createdReads = null;
        this.additionalReads.addAll(readsToAdd);
    }

    public List<String> getSamples() {
        return this.samples;
    }

    public List<GATKSAMRecord> makeReads() {
        if (this.createdReads == null) {
            String baseName = "read";
            LinkedList<GATKSAMReadGroupRecord> readGroups = new LinkedList<GATKSAMReadGroupRecord>();
            for (SAMReadGroupRecord rg : this.header.getReadGroups()) {
                readGroups.add(new GATKSAMReadGroupRecord(rg));
            }
            ArrayList<GATKSAMRecord> reads = new ArrayList<GATKSAMRecord>(this.nReadsPerLocus * this.nLoci);
            for (int locusI = 0; locusI < this.nLoci; ++locusI) {
                int locus = locusI * (this.skipNLoci + 1);
                for (int readI = 0; readI < this.nReadsPerLocus; ++readI) {
                    for (GATKSAMReadGroupRecord rg : readGroups) {
                        String readName = String.format("%s.%d.%d.%s", "read", locus, readI, rg.getId());
                        GATKSAMRecord read = ArtificialSAMUtils.createArtificialRead(this.header, readName, 0, this.alignmentStart + locus, this.readLength);
                        read.setReadGroup(rg);
                        reads.add(read);
                    }
                }
            }
            if (!this.additionalReads.isEmpty()) {
                reads.addAll(this.additionalReads);
                Collections.sort(reads, new SAMRecordCoordinateComparator());
            }
            this.createdReads = new ArrayList<GATKSAMRecord>(reads);
        }
        return this.createdReads;
    }

    public File makeTemporarilyBAMFile() {
        try {
            File file = File.createTempFile("tempBAM", ".bam");
            file.deleteOnExit();
            new File(file.getAbsolutePath().replace(".bam", ".bai")).deleteOnExit();
            new File(file.getAbsolutePath() + ".bai").deleteOnExit();
            return this.makeBAMFile(file);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public File makeBAMFile(File output) {
        SAMFileWriter writer = this.factory.makeBAMWriter(this.header, true, output, 0);
        for (GATKSAMRecord read : this.makeReads()) {
            writer.addAlignment(read);
        }
        writer.close();
        return output;
    }

    public int getnReadsPerLocus() {
        return this.nReadsPerLocus;
    }

    public int getnLoci() {
        return this.nLoci;
    }

    public int getSkipNLoci() {
        return this.skipNLoci;
    }

    public ArtificialBAMBuilder setSkipNLoci(int skipNLoci) {
        this.skipNLoci = skipNLoci;
        this.createdReads = null;
        return this;
    }

    public int getAlignmentStart() {
        return this.alignmentStart;
    }

    public ArtificialBAMBuilder setAlignmentStart(int alignmentStart) {
        this.alignmentStart = alignmentStart;
        this.createdReads = null;
        return this;
    }

    public int getReadLength() {
        return this.readLength;
    }

    public ArtificialBAMBuilder setReadLength(int readLength) {
        this.readLength = readLength;
        this.createdReads = null;
        return this;
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }

    public ArtificialBAMBuilder setHeader(SAMFileHeader header) {
        this.header = header;
        this.createdReads = null;
        return this;
    }

    public int getAlignmentEnd() {
        return this.alignmentStart + this.nLoci * (this.skipNLoci + 1) + this.readLength;
    }

    public int getNSamples() {
        return this.samples.size();
    }

    public int expectedNumberOfReads() {
        return this.nLoci * this.nReadsPerLocus * this.header.getReadGroups().size();
    }

    public String toString() {
        return "ArtificialBAMBuilder{samples=" + this.samples + ", readLength=" + this.readLength + ", alignmentStart=" + this.alignmentStart + ", skipNLoci=" + this.skipNLoci + ", nLoci=" + this.nLoci + ", nReadsPerLocus=" + this.nReadsPerLocus + '}';
    }
}

