/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration;

import com.google.java.contract.Ensures;
import java.io.PrintStream;
import java.util.ArrayList;
import org.broadinstitute.sting.utils.collections.LoggingNestedIntegerArray;
import org.broadinstitute.sting.utils.collections.NestedIntegerArray;
import org.broadinstitute.sting.utils.recalibration.EventType;
import org.broadinstitute.sting.utils.recalibration.RecalDatum;
import org.broadinstitute.sting.utils.recalibration.RecalUtils;
import org.broadinstitute.sting.utils.recalibration.covariates.Covariate;

public final class RecalibrationTables {
    private final ArrayList<NestedIntegerArray<RecalDatum>> tables;
    private final int qualDimension;
    private final int eventDimension = EventType.values().length;
    private final int numReadGroups;
    private final PrintStream log;

    public RecalibrationTables(Covariate[] covariates) {
        this(covariates, covariates[TableType.READ_GROUP_TABLE.ordinal()].maximumKeyValue() + 1, null);
    }

    public RecalibrationTables(Covariate[] covariates, int numReadGroups) {
        this(covariates, numReadGroups, null);
    }

    public RecalibrationTables(Covariate[] covariates, int numReadGroups, PrintStream log) {
        int i2;
        this.tables = new ArrayList(covariates.length);
        for (i2 = 0; i2 < covariates.length; ++i2) {
            this.tables.add(i2, null);
        }
        this.qualDimension = covariates[TableType.QUALITY_SCORE_TABLE.ordinal()].maximumKeyValue() + 1;
        this.numReadGroups = numReadGroups;
        this.log = log;
        this.tables.set(TableType.READ_GROUP_TABLE.ordinal(), log == null ? new NestedIntegerArray(numReadGroups, this.eventDimension) : new LoggingNestedIntegerArray(log, "READ_GROUP_TABLE", numReadGroups, this.eventDimension));
        this.tables.set(TableType.QUALITY_SCORE_TABLE.ordinal(), this.makeQualityScoreTable());
        for (i2 = TableType.OPTIONAL_COVARIATE_TABLES_START.ordinal(); i2 < covariates.length; ++i2) {
            this.tables.set(i2, log == null ? new NestedIntegerArray(numReadGroups, this.qualDimension, covariates[i2].maximumKeyValue() + 1, this.eventDimension) : new LoggingNestedIntegerArray(log, String.format("OPTIONAL_COVARIATE_TABLE_%d", i2 - TableType.OPTIONAL_COVARIATE_TABLES_START.ordinal() + 1), numReadGroups, this.qualDimension, covariates[i2].maximumKeyValue() + 1, this.eventDimension));
        }
    }

    @Ensures(value={"result != null"})
    public NestedIntegerArray<RecalDatum> getReadGroupTable() {
        return this.getTable(TableType.READ_GROUP_TABLE.ordinal());
    }

    @Ensures(value={"result != null"})
    public NestedIntegerArray<RecalDatum> getQualityScoreTable() {
        return this.getTable(TableType.QUALITY_SCORE_TABLE.ordinal());
    }

    @Ensures(value={"result != null"})
    public NestedIntegerArray<RecalDatum> getTable(int index) {
        return this.tables.get(index);
    }

    @Ensures(value={"result >= 0"})
    public int numTables() {
        return this.tables.size();
    }

    public boolean isEmpty() {
        for (NestedIntegerArray<RecalDatum> table : this.tables) {
            if (table.getAllValues().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public NestedIntegerArray<RecalDatum> makeQualityScoreTable() {
        return this.log == null ? new NestedIntegerArray<RecalDatum>(this.numReadGroups, this.qualDimension, this.eventDimension) : new LoggingNestedIntegerArray(this.log, "QUALITY_SCORE_TABLE", this.numReadGroups, this.qualDimension, this.eventDimension);
    }

    public void combine(RecalibrationTables toMerge) {
        if (this.numTables() != toMerge.numTables()) {
            throw new IllegalArgumentException("Attempting to merge RecalibrationTables with different sizes");
        }
        for (int i2 = 0; i2 < this.numTables(); ++i2) {
            NestedIntegerArray<RecalDatum> myTable = this.getTable(i2);
            NestedIntegerArray<RecalDatum> otherTable = toMerge.getTable(i2);
            RecalUtils.combineTables(myTable, otherTable);
        }
    }

    public static enum TableType {
        READ_GROUP_TABLE,
        QUALITY_SCORE_TABLE,
        OPTIONAL_COVARIATE_TABLES_START;

    }
}

