/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pairhmm;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.pairhmm.N2MemoryPairHMM;

public final class LoglessPairHMM
extends N2MemoryPairHMM {
    protected static final double INITIAL_CONDITION = Math.pow(2.0, 1020.0);
    protected static final double INITIAL_CONDITION_LOG10 = Math.log10(INITIAL_CONDITION);
    private static final int matchToMatch = 0;
    private static final int indelToMatch = 1;
    private static final int matchToInsertion = 2;
    private static final int insertionToInsertion = 3;
    private static final int matchToDeletion = 4;
    private static final int deletionToDeletion = 5;

    @Override
    public void initialize(int readMaxLength, int haplotypeMaxLength) {
        super.initialize(readMaxLength, haplotypeMaxLength);
        this.transition = new double[this.paddedMaxReadLength][6];
        this.prior = new double[this.paddedMaxReadLength][this.paddedMaxHaplotypeLength];
    }

    @Override
    public double subComputeReadLikelihoodGivenHaplotypeLog10(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, int hapStartIndex, boolean recacheReadValues) {
        if (this.previousHaplotypeBases == null || this.previousHaplotypeBases.length != haplotypeBases.length) {
            double initialValue = INITIAL_CONDITION / (double)haplotypeBases.length;
            for (int j2 = 0; j2 < this.paddedHaplotypeLength; ++j2) {
                this.deletionMatrix[0][j2] = initialValue;
            }
        }
        if (!this.constantsAreInitialized || recacheReadValues) {
            LoglessPairHMM.initializeProbabilities(this.transition, insertionGOP, deletionGOP, overallGCP);
            this.constantsAreInitialized = true;
        }
        this.initializePriors(haplotypeBases, readBases, readQuals, hapStartIndex);
        for (int i2 = 1; i2 < this.paddedReadLength; ++i2) {
            for (int j3 = hapStartIndex + 1; j3 < this.paddedHaplotypeLength; ++j3) {
                this.updateCell(i2, j3, this.prior[i2][j3], this.transition[i2]);
            }
        }
        int endI = this.paddedReadLength - 1;
        double finalSumProbabilities = 0.0;
        for (int j4 = 1; j4 < this.paddedHaplotypeLength; ++j4) {
            finalSumProbabilities += this.matchMatrix[endI][j4] + this.insertionMatrix[endI][j4];
        }
        return Math.log10(finalSumProbabilities) - INITIAL_CONDITION_LOG10;
    }

    public void initializePriors(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, int startIndex) {
        for (int i2 = 0; i2 < readBases.length; ++i2) {
            byte x2 = readBases[i2];
            byte qual = readQuals[i2];
            for (int j2 = startIndex; j2 < haplotypeBases.length; ++j2) {
                byte y = haplotypeBases[j2];
                this.prior[i2 + 1][j2 + 1] = x2 == y || x2 == 78 || y == 78 ? QualityUtils.qualToProb(qual) : QualityUtils.qualToErrorProb(qual);
            }
        }
    }

    @Requires(value={"insertionGOP != null", "deletionGOP != null", "overallGCP != null"})
    @Ensures(value={"constantsAreInitialized"})
    protected static void initializeProbabilities(double[][] transition, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP) {
        for (int i2 = 0; i2 < insertionGOP.length; ++i2) {
            int qualIndexGOP = Math.min(insertionGOP[i2] + deletionGOP[i2], 127);
            transition[i2 + 1][0] = QualityUtils.qualToProb((byte)qualIndexGOP);
            transition[i2 + 1][1] = QualityUtils.qualToProb(overallGCP[i2]);
            transition[i2 + 1][2] = QualityUtils.qualToErrorProb(insertionGOP[i2]);
            transition[i2 + 1][3] = QualityUtils.qualToErrorProb(overallGCP[i2]);
            transition[i2 + 1][4] = QualityUtils.qualToErrorProb(deletionGOP[i2]);
            transition[i2 + 1][5] = QualityUtils.qualToErrorProb(overallGCP[i2]);
        }
    }

    private void updateCell(int indI, int indJ, double prior, double[] transition) {
        this.matchMatrix[indI][indJ] = prior * (this.matchMatrix[indI - 1][indJ - 1] * transition[0] + this.insertionMatrix[indI - 1][indJ - 1] * transition[1] + this.deletionMatrix[indI - 1][indJ - 1] * transition[1]);
        this.insertionMatrix[indI][indJ] = this.matchMatrix[indI - 1][indJ] * transition[2] + this.insertionMatrix[indI - 1][indJ] * transition[3];
        this.deletionMatrix[indI][indJ] = this.matchMatrix[indI][indJ - 1] * transition[4] + this.deletionMatrix[indI][indJ - 1] * transition[5];
    }
}

