/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pairhmm;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.Arrays;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.pairhmm.N2MemoryPairHMM;

public final class Log10PairHMM
extends N2MemoryPairHMM {
    private final boolean doExactLog10;
    private static final int matchToMatch = 0;
    private static final int indelToMatch = 1;
    private static final int matchToInsertion = 2;
    private static final int insertionToInsertion = 3;
    private static final int matchToDeletion = 4;
    private static final int deletionToDeletion = 5;

    public Log10PairHMM(boolean doExactLog10) {
        this.doExactLog10 = doExactLog10;
    }

    public boolean isDoingExactLog10Calculations() {
        return this.doExactLog10;
    }

    @Override
    public void initialize(int readMaxLength, int haplotypeMaxLength) {
        super.initialize(readMaxLength, haplotypeMaxLength);
        for (int iii = 0; iii < this.paddedMaxReadLength; ++iii) {
            Arrays.fill(this.matchMatrix[iii], Double.NEGATIVE_INFINITY);
            Arrays.fill(this.insertionMatrix[iii], Double.NEGATIVE_INFINITY);
            Arrays.fill(this.deletionMatrix[iii], Double.NEGATIVE_INFINITY);
        }
        this.transition = new double[this.paddedMaxReadLength][6];
        this.prior = new double[this.paddedMaxReadLength][this.paddedMaxHaplotypeLength];
    }

    @Override
    public double subComputeReadLikelihoodGivenHaplotypeLog10(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, int hapStartIndex, boolean recacheReadValues) {
        if (this.previousHaplotypeBases == null || this.previousHaplotypeBases.length != haplotypeBases.length) {
            double initialValue = Math.log10(1.0 / (double)haplotypeBases.length);
            for (int j2 = 0; j2 < this.paddedHaplotypeLength; ++j2) {
                this.deletionMatrix[0][j2] = initialValue;
            }
        }
        if (!this.constantsAreInitialized || recacheReadValues) {
            this.initializeProbabilities(insertionGOP, deletionGOP, overallGCP);
        }
        this.initializePriors(haplotypeBases, readBases, readQuals, hapStartIndex);
        for (int i2 = 1; i2 < this.paddedReadLength; ++i2) {
            for (int j3 = hapStartIndex + 1; j3 < this.paddedHaplotypeLength; ++j3) {
                this.updateCell(i2, j3, this.prior[i2][j3], this.transition[i2]);
            }
        }
        int endI = this.paddedReadLength - 1;
        double finalSumProbabilities = this.myLog10SumLog10(new double[]{this.matchMatrix[endI][1], this.insertionMatrix[endI][1]});
        for (int j4 = 2; j4 < this.paddedHaplotypeLength; ++j4) {
            finalSumProbabilities = this.myLog10SumLog10(new double[]{finalSumProbabilities, this.matchMatrix[endI][j4], this.insertionMatrix[endI][j4]});
        }
        return finalSumProbabilities;
    }

    public void initializePriors(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, int startIndex) {
        for (int i2 = 0; i2 < readBases.length; ++i2) {
            byte x2 = readBases[i2];
            byte qual = readQuals[i2];
            for (int j2 = startIndex; j2 < haplotypeBases.length; ++j2) {
                byte y = haplotypeBases[j2];
                this.prior[i2 + 1][j2 + 1] = x2 == y || x2 == 78 || y == 78 ? QualityUtils.qualToProbLog10(qual) : QualityUtils.qualToErrorProbLog10(qual);
            }
        }
    }

    @Requires(value={"insertionGOP != null", "deletionGOP != null", "overallGCP != null"})
    @Ensures(value={"constantsAreInitialized"})
    private void initializeProbabilities(byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP) {
        for (int i2 = 0; i2 < insertionGOP.length; ++i2) {
            int qualIndexGOP = Math.min(insertionGOP[i2] + deletionGOP[i2], 127);
            this.transition[i2 + 1][0] = QualityUtils.qualToProbLog10((byte)qualIndexGOP);
            this.transition[i2 + 1][1] = QualityUtils.qualToProbLog10(overallGCP[i2]);
            this.transition[i2 + 1][2] = QualityUtils.qualToErrorProbLog10(insertionGOP[i2]);
            this.transition[i2 + 1][3] = QualityUtils.qualToErrorProbLog10(overallGCP[i2]);
            this.transition[i2 + 1][4] = QualityUtils.qualToErrorProbLog10(deletionGOP[i2]);
            this.transition[i2 + 1][5] = QualityUtils.qualToErrorProbLog10(overallGCP[i2]);
        }
        this.constantsAreInitialized = true;
    }

    @Requires(value={"values != null"})
    private double myLog10SumLog10(double[] values) {
        return this.doExactLog10 ? MathUtils.log10sumLog10(values) : MathUtils.approximateLog10SumLog10(values);
    }

    private void updateCell(int indI, int indJ, double prior, double[] transition) {
        this.matchMatrix[indI][indJ] = prior + this.myLog10SumLog10(new double[]{this.matchMatrix[indI - 1][indJ - 1] + transition[0], this.insertionMatrix[indI - 1][indJ - 1] + transition[1], this.deletionMatrix[indI - 1][indJ - 1] + transition[1]});
        this.insertionMatrix[indI][indJ] = this.myLog10SumLog10(new double[]{this.matchMatrix[indI - 1][indJ] + transition[2], this.insertionMatrix[indI - 1][indJ] + transition[3]});
        this.deletionMatrix[indI][indJ] = this.myLog10SumLog10(new double[]{this.matchMatrix[indI][indJ - 1] + transition[4], this.deletionMatrix[indI][indJ - 1] + transition[5]});
    }
}

