/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.io.FileExtension;
import org.broadinstitute.sting.utils.io.Resource;

public class IOUtils {
    private static Logger logger = Logger.getLogger(IOUtils.class);
    private static final File DEV_DIR = new File("/dev");

    public static void checkTempDir(File tempDir) {
        if (IOUtils.isDefaultTempDir(tempDir)) {
            throw new UserException.BadTmpDir("java.io.tmpdir must be explicitly set");
        }
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw new UserException.BadTmpDir("Could not create directory: " + tempDir.getAbsolutePath());
        }
    }

    public static boolean isDefaultTempDir(File tempDir) {
        String tempDirPath = tempDir.getAbsolutePath();
        return tempDirPath.startsWith("/var/folders/") || tempDirPath.equals("/tmp") || tempDirPath.equals("/tmp/");
    }

    public static File tempDir(String prefix, String suffix) {
        return IOUtils.tempDir(prefix, suffix, null);
    }

    public static File tempDir(String prefix, String suffix, File tempDirParent) {
        try {
            if (tempDirParent == null) {
                tempDirParent = FileUtils.getTempDirectory();
            }
            if (!tempDirParent.exists() && !tempDirParent.mkdirs()) {
                throw new UserException.BadTmpDir("Could not create temp directory: " + tempDirParent);
            }
            File temp = File.createTempFile(prefix, suffix, tempDirParent);
            if (!temp.delete()) {
                throw new UserException.BadTmpDir("Could not delete sub file: " + temp.getAbsolutePath());
            }
            if (!temp.mkdir()) {
                throw new UserException.BadTmpDir("Could not create sub directory: " + temp.getAbsolutePath());
            }
            return IOUtils.absolute(temp);
        }
        catch (IOException e2) {
            throw new UserException.BadTmpDir(e2.getMessage());
        }
    }

    public static File writeTempFile(String content, String prefix, String suffix) {
        return IOUtils.writeTempFile(content, prefix, suffix, null);
    }

    public static File writeTempFile(String content, String prefix, String suffix, File directory) {
        try {
            File tempFile = IOUtils.absolute(File.createTempFile(prefix, suffix, directory));
            FileUtils.writeStringToFile(tempFile, content);
            return tempFile;
        }
        catch (IOException e2) {
            throw new UserException.BadTmpDir(e2.getMessage());
        }
    }

    public static boolean waitFor(File file, int seconds) {
        return IOUtils.waitFor(Collections.singletonList(file), seconds).isEmpty();
    }

    public static List<File> waitFor(Collection<File> files, int seconds) {
        long timeout = 0L;
        long tick = 0L;
        ArrayList<File> missingFiles = new ArrayList<File>();
        for (File file : files) {
            if (file.exists()) continue;
            missingFiles.add(file);
        }
        while (!missingFiles.isEmpty() && timeout <= (long)seconds) {
            if (tick >= 10L) {
                tick = 0L;
                ++timeout;
            }
            ++tick;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            ArrayList<File> newMissingFiles = new ArrayList<File>();
            for (File file : missingFiles) {
                if (file.exists()) continue;
                newMissingFiles.add(file);
            }
            missingFiles = newMissingFiles;
        }
        return missingFiles;
    }

    public static File dirLevel(File dir, int level) {
        ArrayList<File> directories = new ArrayList<File>();
        for (File parentDir = IOUtils.absolute(dir); parentDir != null; parentDir = parentDir.getParentFile()) {
            directories.add(0, parentDir);
        }
        if (directories.size() <= level) {
            return (File)directories.get(directories.size() - 1);
        }
        return (File)directories.get(level);
    }

    public static File absolute(File parent, String path) {
        return IOUtils.absolute(parent, new File(path));
    }

    public static File absolute(File parent, File file) {
        String newPath = file.isAbsolute() ? IOUtils.absolutePath(file) : IOUtils.absolutePath(new File(parent, file.getPath()));
        return IOUtils.replacePath(file, newPath);
    }

    public static File absolute(File file) {
        return IOUtils.replacePath(file, IOUtils.absolutePath(file));
    }

    private static String absolutePath(File file) {
        LinkedList<String> names = new LinkedList<String>();
        for (File fileAbs = file.getAbsoluteFile(); fileAbs != null; fileAbs = fileAbs.getParentFile()) {
            String name = fileAbs.getName();
            if (".".equals(name)) continue;
            names.add(0, name);
        }
        return "/" + StringUtils.join(names, "/");
    }

    private static File replacePath(File file, String path) {
        if (file instanceof FileExtension) {
            return ((FileExtension)((Object)file)).withPath(path);
        }
        if (!File.class.equals(file.getClass())) {
            throw new StingException("Sub classes of java.io.File must also implement FileExtension");
        }
        return new File(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> tail(File file, int count) throws IOException {
        LinkedList<String> tailLines = new LinkedList<String>();
        FileReader reader = new FileReader(file);
        try {
            LineIterator iterator = org.apache.commons.io.IOUtils.lineIterator(reader);
            int lineCount = 0;
            while (iterator.hasNext()) {
                String line = iterator.nextLine();
                if (++lineCount > count) {
                    tailLines.removeFirst();
                }
                tailLines.offer(line);
            }
        }
        finally {
            org.apache.commons.io.IOUtils.closeQuietly(reader);
        }
        return tailLines;
    }

    public static boolean tryDelete(File file) {
        if (IOUtils.isSpecialFile(file)) {
            logger.debug("Not trying to delete " + file);
            return false;
        }
        boolean deleted = FileUtils.deleteQuietly(file);
        if (deleted) {
            logger.debug("Deleted " + file);
        } else if (file.exists()) {
            logger.warn("Unable to delete " + file);
        }
        return deleted;
    }

    public static File writeTempResource(Resource resource) {
        File temp;
        try {
            temp = File.createTempFile(FilenameUtils.getBaseName(resource.getPath()) + ".", "." + FilenameUtils.getExtension(resource.getPath()));
        }
        catch (IOException e2) {
            throw new UserException.BadTmpDir(e2.getMessage());
        }
        IOUtils.writeResource(resource, temp);
        return temp;
    }

    public static void writeResource(Resource resource, File file) {
        String path = resource.getPath();
        InputStream inputStream = resource.getResourceContentsAsStream();
        FileOutputStream outputStream = null;
        try {
            outputStream = FileUtils.openOutputStream(file);
            org.apache.commons.io.IOUtils.copy(inputStream, (OutputStream)outputStream);
        }
        catch (IOException e2) {
            throw new StingException(String.format("Unable to copy resource '%s' to '%s'", path, file), e2);
        }
        finally {
            org.apache.commons.io.IOUtils.closeQuietly(inputStream);
            org.apache.commons.io.IOUtils.closeQuietly(outputStream);
        }
    }

    public static LineIterator lineIterator(String path) {
        return IOUtils.lineIterator(new File(path));
    }

    public static LineIterator lineIterator(File file) {
        try {
            return FileUtils.lineIterator(file);
        }
        catch (IOException e2) {
            throw new UserException.CouldNotReadInputFile(file, (Exception)e2);
        }
    }

    public static boolean isSpecialFile(File file) {
        return file != null && (file.getAbsolutePath().startsWith("/dev/") || file.equals(DEV_DIR));
    }

    public static byte[] readFileIntoByteArray(File source) {
        return IOUtils.readFileIntoByteArray(source, 4096);
    }

    public static byte[] readFileIntoByteArray(File source, int readBufferSize) {
        byte[] fileContents;
        if (source == null) {
            throw new ReviewedStingException("Source file was null");
        }
        try {
            fileContents = IOUtils.readStreamIntoByteArray(new FileInputStream(source), readBufferSize);
        }
        catch (FileNotFoundException e2) {
            throw new UserException.CouldNotReadInputFile(source, (Exception)e2);
        }
        if ((long)fileContents.length != source.length()) {
            throw new UserException.CouldNotReadInputFile(String.format("Unable to completely read file %s: read only %d/%d bytes", source.getAbsolutePath(), fileContents.length, source.length()));
        }
        return fileContents;
    }

    public static byte[] readStreamIntoByteArray(InputStream in) {
        return IOUtils.readStreamIntoByteArray(in, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readStreamIntoByteArray(InputStream in, int readBufferSize) {
        if (in == null) {
            throw new ReviewedStingException("Input stream was null");
        }
        if (readBufferSize <= 0) {
            throw new ReviewedStingException("Read buffer size must be > 0");
        }
        byte[] readBuffer = new byte[readBufferSize];
        ByteArrayOutputStream fileBuffer = new ByteArrayOutputStream(readBufferSize * 4);
        try {
            try {
                int currentBytesRead;
                while ((currentBytesRead = in.read(readBuffer, 0, readBuffer.length)) >= 0) {
                    fileBuffer.write(readBuffer, 0, currentBytesRead);
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException e2) {
            throw new UserException.CouldNotReadInputFile("I/O error reading from input stream", (Exception)e2);
        }
        return fileBuffer.toByteArray();
    }

    public static void writeByteArrayToFile(byte[] bytes, File destination) {
        if (destination == null) {
            throw new ReviewedStingException("Destination file was null");
        }
        try {
            IOUtils.writeByteArrayToStream(bytes, new FileOutputStream(destination));
        }
        catch (FileNotFoundException e2) {
            throw new UserException.CouldNotCreateOutputFile(destination, (Exception)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByteArrayToStream(byte[] bytes, OutputStream out) {
        if (bytes == null || out == null) {
            throw new ReviewedStingException("Data to write or output stream was null");
        }
        try {
            try {
                out.write(bytes);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e2) {
            throw new UserException.CouldNotCreateOutputFile("I/O error writing to output stream", (Exception)e2);
        }
    }

    public static int getGZIPFileUncompressedSize(File gzipFile) {
        if (gzipFile == null) {
            throw new ReviewedStingException("GZIP file to examine was null");
        }
        try {
            RandomAccessFile in = new RandomAccessFile(gzipFile, "r");
            in.seek(gzipFile.length() - 4L);
            byte[] sizeBytes = new byte[4];
            in.read(sizeBytes, 0, 4);
            ByteBuffer byteBuf = ByteBuffer.wrap(sizeBytes);
            byteBuf.order(ByteOrder.LITTLE_ENDIAN);
            int uncompressedSize = byteBuf.getInt();
            if (uncompressedSize < 0) {
                throw new UserException.CouldNotReadInputFile(String.format("Cannot accurately determine the uncompressed size of file %s because it's either larger than %d bytes or the GZIP ISIZE field is corrupt", gzipFile.getAbsolutePath(), Integer.MAX_VALUE));
            }
            return uncompressedSize;
        }
        catch (IOException e2) {
            throw new UserException.CouldNotReadInputFile(gzipFile, (Exception)e2);
        }
    }
}

