/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.io;

import java.io.IOException;
import org.apache.commons.io.output.ThresholdingOutputStream;

public abstract class HardThresholdingOutputStream
extends ThresholdingOutputStream {
    protected HardThresholdingOutputStream(int threshold) {
        super(threshold);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        int remaining = this.getThreshold() - (int)this.getByteCount();
        if (!this.isThresholdExceeded() && len > remaining) {
            super.write(b2, off, remaining);
            super.write(b2, off + remaining, len - remaining);
        } else {
            super.write(b2, off, len);
        }
    }
}

