/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.instrumentation;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class Sizeof {
    private static Instrumentation instrumentation;

    public static void premain(String args, Instrumentation inst) {
        instrumentation = inst;
    }

    public static boolean isEnabled() {
        return instrumentation != null;
    }

    public static long getObjectSize(Object o2) {
        if (!Sizeof.isEnabled()) {
            throw new ReviewedStingException("Sizeof operator is currently disabled!  To enable, review the documentation in Sizeof.java");
        }
        return instrumentation.getObjectSize(o2);
    }

    public static long getObjectGraphSize(Object o2) {
        if (!Sizeof.isEnabled()) {
            throw new ReviewedStingException("Sizeof operator is currently disabled!  To enable, review the documentation in Sizeof.java");
        }
        IdentityHashMap<Object, Object> objectsSeen = new IdentityHashMap<Object, Object>();
        return Sizeof.getObjectGraphSize(o2, objectsSeen);
    }

    private static long getObjectGraphSize(Object o2, IdentityHashMap<Object, Object> objectsSeen) {
        if (o2 == null) {
            return 0L;
        }
        if (objectsSeen.containsKey(o2)) {
            return 0L;
        }
        objectsSeen.put(o2, o2);
        long totalSize = instrumentation.getObjectSize(o2);
        Class<?> classToInspect = o2.getClass();
        if (classToInspect.isArray() && !classToInspect.getComponentType().isPrimitive()) {
            for (int i2 = 0; i2 < Array.getLength(o2); ++i2) {
                totalSize += Sizeof.getObjectGraphSize(Array.get(o2, i2), objectsSeen);
            }
        }
        while (classToInspect != null) {
            for (Field field : classToInspect.getDeclaredFields()) {
                Object fieldValue;
                if (field.getType().isPrimitive() || Modifier.isStatic(field.getModifiers()) || field.isSynthetic()) continue;
                field.setAccessible(true);
                try {
                    fieldValue = field.get(o2);
                }
                catch (IllegalAccessException ex) {
                    throw new ReviewedStingException("Unable to access field " + field.getName(), ex);
                }
                totalSize += Sizeof.getObjectGraphSize(fieldValue, objectsSeen);
            }
            classToInspect = classToInspect.getSuperclass();
        }
        return totalSize;
    }
}

