/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.help;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.commandline.CommandLineProgram;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.refdata.tracks.FeatureManager;
import org.broadinstitute.sting.gatk.walkers.ActiveRegionTraversalParameters;
import org.broadinstitute.sting.gatk.walkers.Downsample;
import org.broadinstitute.sting.gatk.walkers.PartitionBy;
import org.broadinstitute.sting.gatk.walkers.ReadFilters;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.classloader.JVMUtils;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.help.DocletUtils;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeatureHandler;
import org.broadinstitute.sting.utils.help.GATKDocUtils;
import org.broadinstitute.sting.utils.help.GATKDocWorkUnit;

public class GenericDocumentationHandler
extends DocumentedGATKFeatureHandler {
    private static Logger logger = Logger.getLogger(GenericDocumentationHandler.class);
    private static final int MAX_DISPLAY_NAME = 30;
    private GATKDocWorkUnit toProcess;

    @Override
    public boolean includeInDocs(ClassDoc doc) {
        try {
            Class type = DocletUtils.getClassForDoc((ProgramElementDoc)doc);
            boolean hidden = !this.getDoclet().showHiddenFeatures() && type.isAnnotationPresent(Hidden.class);
            return !hidden && JVMUtils.isConcrete(type);
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
    }

    @Override
    public String getTemplateName(ClassDoc doc) throws IOException {
        return "generic.template.html";
    }

    @Override
    public void processOne(GATKDocWorkUnit toProcessArg) {
        this.toProcess = toProcessArg;
        HashMap<String, Object> root = new HashMap<String, Object>();
        this.addHighLevelBindings(root);
        this.addArgumentBindings(root);
        this.addRelatedBindings(root);
        root.put("group", this.toProcess.group);
        this.getClazzAnnotations(this.toProcess.clazz, root);
        this.toProcess.setHandlerContent((String)root.get("summary"), root);
    }

    protected void addHighLevelBindings(Map<String, Object> root) {
        root.put("name", this.toProcess.classDoc.name());
        StringBuilder summaryBuilder = new StringBuilder();
        for (Tag tag : this.toProcess.classDoc.firstSentenceTags()) {
            summaryBuilder.append(tag.text());
        }
        root.put("summary", summaryBuilder.toString());
        root.put("description", this.toProcess.classDoc.commentText().substring(summaryBuilder.toString().length()));
        root.put("timestamp", this.toProcess.buildTimestamp);
        root.put("version", this.toProcess.absoluteVersion);
        for (Tag tag : this.toProcess.classDoc.tags()) {
            root.put(tag.name(), tag.text());
        }
    }

    protected void addRelatedBindings(Map<String, Object> root) {
        ArrayList<1> extraDocsData = new ArrayList<1>();
        for (Class extraDocClass : this.toProcess.annotation.extraDocs()) {
            final GATKDocWorkUnit otherUnit = this.getDoclet().findWorkUnitForClass(extraDocClass);
            if (otherUnit == null) {
                throw new ReviewedStingException("Requested extraDocs for class without any documentation: " + extraDocClass);
            }
            extraDocsData.add(new HashMap<String, Object>(){
                {
                    this.put("filename", otherUnit.filename);
                    this.put("name", otherUnit.name);
                }
            });
        }
        root.put("extradocs", extraDocsData);
    }

    protected void addArgumentBindings(Map<String, Object> root) {
        ParsingEngine parsingEngine = this.createStandardGATKParsingEngine();
        Map<String, List<Map<String, Object>>> args = this.createArgumentMap();
        root.put("arguments", args);
        try {
            for (ArgumentSource argumentSource : parsingEngine.extractArgumentSources(DocletUtils.getClassForDoc((ProgramElementDoc)this.toProcess.classDoc))) {
                ArgumentDefinition argDef = argumentSource.createArgumentDefinitions().get(0);
                FieldDoc fieldDoc = this.getFieldDoc(this.toProcess.classDoc, argumentSource.field.getName());
                Map<String, Object> argBindings = this.docForArgument(fieldDoc, argumentSource, argDef);
                if (argumentSource.isHidden() && !this.getDoclet().showHiddenFeatures()) continue;
                String kind = this.docKindOfArg(argumentSource);
                Object value = this.argumentValue(this.toProcess.clazz, argumentSource);
                if (value != null) {
                    argBindings.put("defaultValue", this.prettyPrintValueString(value));
                }
                args.get(kind).add(argBindings);
                args.get("all").add(argBindings);
            }
            for (Map.Entry entry : args.entrySet()) {
                entry.setValue(this.sortArguments((List)entry.getValue()));
            }
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Requires(value={"argumentSource != null"})
    @Ensures(value={"result != null"})
    private String docKindOfArg(ArgumentSource argumentSource) {
        if (argumentSource.isRequired()) {
            return "required";
        }
        if (argumentSource.isAdvanced()) {
            return "advanced";
        }
        if (argumentSource.isHidden()) {
            return "hidden";
        }
        if (argumentSource.isDeprecated()) {
            return "depreciated";
        }
        return "optional";
    }

    @Requires(value={"c != null", "argumentSource != null"})
    private Object argumentValue(Class c2, ArgumentSource argumentSource) {
        Object instance = this.makeInstanceIfPossible(this.toProcess.clazz);
        if (instance != null) {
            Object value = this.getFieldValue(instance, argumentSource.field.getName());
            if (value != null) {
                return value;
            }
            if (argumentSource.createsTypeDefault()) {
                try {
                    return argumentSource.typeDefaultDocString();
                }
                catch (ReviewedStingException e2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private Map<String, List<Map<String, Object>>> createArgumentMap() {
        HashMap<String, List<Map<String, Object>>> args = new HashMap<String, List<Map<String, Object>>>();
        args.put("all", new ArrayList());
        args.put("required", new ArrayList());
        args.put("optional", new ArrayList());
        args.put("advanced", new ArrayList());
        args.put("hidden", new ArrayList());
        args.put("depreciated", new ArrayList());
        return args;
    }

    private List<Map<String, Object>> sortArguments(List<Map<String, Object>> unsorted) {
        Collections.sort(unsorted, new CompareArgumentsByName());
        return unsorted;
    }

    private void getClazzAnnotations(Class classToProcess, Map<String, Object> root) {
        Object instance = this.makeInstanceIfPossible(classToProcess);
        if (instance != null) {
            Class<?> myClass = instance.getClass();
            HashSet<HashMap<String, Object>> parallelOptions = this.getParallelism(myClass, new HashSet<HashMap<String, Object>>());
            root.put("parallel", parallelOptions);
            HashSet<String> annotInfo = this.getAnnotInfo(myClass, new HashSet<String>());
            root.put("annotinfo", StringUtils.join(annotInfo, ", "));
            root.put("walkertype", this.getWalkerType(myClass));
            root.put("partitiontype", this.getPartitionType(myClass));
            HashSet<HashMap<String, Object>> bucket = this.getReadFilters(myClass, new HashSet<HashMap<String, Object>>());
            root.put("readfilters", bucket);
            HashMap<String, Object> dsSettings = this.getDownSamplingSettings(myClass, new HashMap<String, Object>());
            root.put("downsampling", dsSettings);
            HashMap<String, Object> refwindow = this.getRefWindow(myClass, new HashMap<String, Object>());
            root.put("refwindow", refwindow);
            HashMap<String, Object> activeRegion = this.getActiveRegion(myClass, new HashMap<String, Object>());
            root.put("activeregion", activeRegion);
        } else {
            root.put("parallel", new HashSet());
            root.put("annotinfo", "");
            root.put("walkertype", "");
            root.put("partitiontype", "");
            root.put("readfilters", new HashSet());
            root.put("downsampling", new HashMap());
            root.put("refwindow", new HashMap());
            root.put("activeregion", new HashMap());
        }
    }

    private HashSet<HashMap<String, Object>> getParallelism(Class myClass, HashSet<HashMap<String, Object>> parallelOptions) {
        Class<?>[] implementedInterfaces;
        for (Class<?> intfClass : implementedInterfaces = myClass.getInterfaces()) {
            HashMap<String, String> nugget = new HashMap<String, String>();
            if (intfClass.getSimpleName().equals("TreeReducible")) {
                nugget.put("name", intfClass.getSimpleName());
                nugget.put("arg", "-nt");
                nugget.put("link", "http://www.broadinstitute.org/gatk/gatkdocs/org_broadinstitute_sting_gatk_CommandLineGATK.html#-nt");
            } else {
                if (!intfClass.getSimpleName().equals("NanoSchedulable")) continue;
                nugget.put("name", intfClass.getSimpleName());
                nugget.put("arg", "-nct");
                nugget.put("link", "http://www.broadinstitute.org/gatk/gatkdocs/org_broadinstitute_sting_gatk_CommandLineGATK.html#-nct");
            }
            parallelOptions.add(nugget);
        }
        Class mySuperClass = myClass.getSuperclass();
        if (mySuperClass.getSimpleName().equals("Object")) {
            return parallelOptions;
        }
        return this.getParallelism(mySuperClass, parallelOptions);
    }

    private HashSet<String> getAnnotInfo(Class myClass, HashSet<String> annotInfo) {
        Class<?>[] implementedInterfaces;
        for (Class<?> intfClass : implementedInterfaces = myClass.getInterfaces()) {
            if (!intfClass.getName().contains("Annotation")) continue;
            annotInfo.add(intfClass.getSimpleName());
        }
        Class mySuperClass = myClass.getSuperclass();
        if (mySuperClass.getSimpleName().equals("Object")) {
            return annotInfo;
        }
        return this.getAnnotInfo(mySuperClass, annotInfo);
    }

    private HashMap<String, Object> getDownSamplingSettings(Class myClass, HashMap<String, Object> dsSettings) {
        Downsample thisAnnotation;
        if (myClass.isAnnotationPresent(Downsample.class) && (thisAnnotation = myClass.getAnnotation(Downsample.class)) instanceof Downsample) {
            Downsample dsAnnotation = thisAnnotation;
            dsSettings.put("by", dsAnnotation.by().toString());
            dsSettings.put("to_cov", dsAnnotation.toCoverage());
        }
        return dsSettings;
    }

    private HashMap<String, Object> getRefWindow(Class myClass, HashMap<String, Object> refWindow) {
        Reference thisAnnotation;
        if (myClass.isAnnotationPresent(Reference.class) && (thisAnnotation = myClass.getAnnotation(Reference.class)) instanceof Reference) {
            Reference refAnnotation = thisAnnotation;
            refWindow.put("start", refAnnotation.window().start());
            refWindow.put("stop", refAnnotation.window().stop());
        }
        return refWindow;
    }

    private HashMap<String, Object> getActiveRegion(Class myClass, HashMap<String, Object> activeRegion) {
        ActiveRegionTraversalParameters thisAnnotation;
        if (myClass.isAnnotationPresent(ActiveRegionTraversalParameters.class) && (thisAnnotation = myClass.getAnnotation(ActiveRegionTraversalParameters.class)) instanceof ActiveRegionTraversalParameters) {
            ActiveRegionTraversalParameters arAnnotation = thisAnnotation;
            activeRegion.put("ext", arAnnotation.extension());
            activeRegion.put("max", arAnnotation.maxRegion());
            activeRegion.put("min", arAnnotation.minRegion());
        }
        return activeRegion;
    }

    private String getPartitionType(Class myClass) {
        PartitionBy thisAnnotation;
        if (myClass.isAnnotationPresent(PartitionBy.class) && (thisAnnotation = myClass.getAnnotation(PartitionBy.class)) instanceof PartitionBy) {
            PartitionBy partAnnotation = thisAnnotation;
            return partAnnotation.value().toString();
        }
        return "";
    }

    private String getWalkerType(Class myClass) {
        Class mySuperClass = myClass.getSuperclass();
        if (mySuperClass.getSimpleName().equals("Walker")) {
            return myClass.getSimpleName();
        }
        if (mySuperClass.getSimpleName().equals("Object")) {
            return "";
        }
        return this.getWalkerType(mySuperClass);
    }

    private HashSet<HashMap<String, Object>> getReadFilters(Class myClass, HashSet<HashMap<String, Object>> bucket) {
        Class mySuperClass;
        ReadFilters thisAnnotation;
        if (myClass.isAnnotationPresent(ReadFilters.class) && (thisAnnotation = myClass.getAnnotation(ReadFilters.class)) instanceof ReadFilters) {
            ReadFilters rfAnnotation = thisAnnotation;
            for (Class filter : rfAnnotation.value()) {
                HashMap<String, String> nugget = new HashMap<String, String>();
                nugget.put("name", filter.getSimpleName());
                nugget.put("filename", GATKDocUtils.htmlFilenameForClass(filter));
                bucket.add(nugget);
            }
        }
        if ((mySuperClass = myClass.getSuperclass()).getSimpleName().equals("Object")) {
            return bucket;
        }
        return this.getReadFilters(mySuperClass, bucket);
    }

    private Object getFieldValue(Object instance, String fieldName) {
        for (Field field : JVMUtils.getAllFields(instance.getClass())) {
            if (field.isAnnotationPresent(ArgumentCollection.class)) {
                Object fieldValue = JVMUtils.getFieldValue(field, instance);
                Object value = this.getFieldValue(fieldValue, fieldName);
                if (value == null) continue;
                return value;
            }
            if (!field.getName().equals(fieldName)) continue;
            return JVMUtils.getFieldValue(field, instance);
        }
        return null;
    }

    private Object prettyPrintValueString(Object value) {
        if (value.getClass().isArray()) {
            Class<?> type = value.getClass().getComponentType();
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return Arrays.toString((boolean[])value);
            }
            if (Byte.TYPE.isAssignableFrom(type)) {
                return Arrays.toString((byte[])value);
            }
            if (Character.TYPE.isAssignableFrom(type)) {
                return Arrays.toString((char[])value);
            }
            if (Double.TYPE.isAssignableFrom(type)) {
                return Arrays.toString((double[])value);
            }
            if (Float.TYPE.isAssignableFrom(type)) {
                return Arrays.toString((float[])value);
            }
            if (Integer.TYPE.isAssignableFrom(type)) {
                return Arrays.toString((int[])value);
            }
            if (Long.TYPE.isAssignableFrom(type)) {
                return Arrays.toString((long[])value);
            }
            if (Short.TYPE.isAssignableFrom(type)) {
                return Arrays.toString((short[])value);
            }
            if (Object.class.isAssignableFrom(type)) {
                return Arrays.toString((Object[])value);
            }
            throw new RuntimeException("Unexpected array type in prettyPrintValue.  Value was " + value + " type is " + type);
        }
        if (RodBinding.class.isAssignableFrom(value.getClass())) {
            return "none";
        }
        if (value instanceof String) {
            return value.equals("") ? "\"\"" : value;
        }
        return value.toString();
    }

    private Object makeInstanceIfPossible(Class c2) {
        Object instance = null;
        try {
            if (!(c2.isEnum() || c2.isAnnotation() || c2.isAnonymousClass() || c2.isArray() || !(!c2.isPrimitive() & JVMUtils.isConcrete(c2)))) {
                instance = c2.newInstance();
                return instance;
            }
            return null;
        }
        catch (IllegalAccessException e2) {
        }
        catch (InstantiationException e3) {
        }
        catch (ExceptionInInitializerError e4) {
        }
        catch (SecurityException e5) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return instance;
    }

    private ParsingEngine createStandardGATKParsingEngine() {
        CommandLineGATK clp = new CommandLineGATK();
        try {
            CommandLineProgram.start((CommandLineProgram)clp, new String[0], true);
            return clp.parser;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private FieldDoc getFieldDoc(ClassDoc classDoc, String name) {
        return this.getFieldDoc(classDoc, name, true);
    }

    private FieldDoc getFieldDoc(ClassDoc classDoc, String name, boolean primary) {
        for (FieldDoc fieldDoc : classDoc.fields(false)) {
            if (fieldDoc.name().equals(name)) {
                return fieldDoc;
            }
            Field field = DocletUtils.getFieldForFieldDoc(fieldDoc);
            if (field == null) {
                throw new RuntimeException("Could not find the field corresponding to " + fieldDoc + ", presumably because the field is inaccessible");
            }
            if (!field.isAnnotationPresent(ArgumentCollection.class)) continue;
            ClassDoc typeDoc = this.getRootDoc().classNamed(fieldDoc.type().qualifiedTypeName());
            if (typeDoc == null) {
                throw new ReviewedStingException("Tried to get javadocs for ArgumentCollection field " + fieldDoc + " but could't find the class in the RootDoc");
            }
            FieldDoc result = this.getFieldDoc(typeDoc, name, false);
            if (result == null) continue;
            return result;
        }
        if (classDoc.superclass() != null) {
            return this.getFieldDoc(classDoc.superclass(), name, false);
        }
        if (primary) {
            throw new RuntimeException("No field found for expected field " + name);
        }
        return null;
    }

    Pair<String, String> displayNames(String s1, String s2) {
        String s3;
        s1 = s1 == null ? null : "-" + s1;
        String string = s2 = s2 == null ? null : "--" + s2;
        if (s1 == null) {
            return new Pair<String, Object>(s2, null);
        }
        if (s2 == null) {
            return new Pair<String, Object>(s1, null);
        }
        String l2 = s1.length() > s2.length() ? s1 : s2;
        String string2 = s3 = s1.length() > s2.length() ? s2 : s1;
        if (l2.length() > 30) {
            return new Pair<String, String>(s3, l2);
        }
        return new Pair<String, String>(l2, s3);
    }

    protected String argumentTypeString(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            ArrayList<String> subs = new ArrayList<String>();
            for (Type actualType : parameterizedType.getActualTypeArguments()) {
                subs.add(this.argumentTypeString(actualType));
            }
            return this.argumentTypeString(((ParameterizedType)type).getRawType()) + "[" + Utils.join(",", subs) + "]";
        }
        if (type instanceof GenericArrayType) {
            return this.argumentTypeString(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        if (type instanceof WildcardType) {
            throw new RuntimeException("We don't support wildcards in arguments: " + type);
        }
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        throw new StingException("Unknown type: " + type);
    }

    protected Class<? extends Feature> getFeatureTypeIfPossible(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            if (RodBinding.class.isAssignableFrom((Class)paramType.getRawType())) {
                return JVMUtils.getParameterizedTypeClass(type);
            }
            for (Type paramtype : paramType.getActualTypeArguments()) {
                Class<? extends Feature> x2 = this.getFeatureTypeIfPossible(paramtype);
                if (x2 == null) continue;
                return x2;
            }
        }
        return null;
    }

    protected Map<String, Object> docForArgument(FieldDoc fieldDoc, ArgumentSource source, ArgumentDefinition def) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        Pair<String, String> names = this.displayNames(def.shortName, def.fullName);
        root.put("name", names.getFirst());
        if (names.getSecond() != null) {
            root.put("synonyms", names.getSecond());
        }
        root.put("required", def.required ? "yes" : "no");
        root.put("type", this.argumentTypeString(source.field.getGenericType()));
        Class<? extends Feature> featureClass = this.getFeatureTypeIfPossible(source.field.getGenericType());
        if (featureClass != null) {
            FeatureManager manager = new FeatureManager();
            ArrayList<String> rodTypes = new ArrayList<String>();
            for (FeatureManager.FeatureDescriptor descriptor : manager.getByFeature(featureClass)) {
                rodTypes.add(String.format("<a href=%s>%s</a>", GATKDocUtils.htmlFilenameForClass(descriptor.getCodecClass()), descriptor.getName()));
            }
            root.put("rodTypes", Utils.join(", ", rodTypes));
        }
        root.put("summary", def.doc != null ? def.doc : "");
        root.put("fulltext", fieldDoc.commentText());
        if (def.validOptions != null) {
            root.put("options", this.docForEnumArgument(source.field.getType()));
        }
        ArrayList<String> attributes = new ArrayList<String>();
        if (def.required) {
            attributes.add("required");
        }
        if (source.isDeprecated()) {
            attributes.add("depreciated");
        }
        if (attributes.size() > 0) {
            root.put("attributes", Utils.join(", ", attributes));
        }
        return root;
    }

    @Requires(value={"enumClass.isEnum()"})
    private List<Map<String, Object>> docForEnumArgument(Class enumClass) {
        ClassDoc doc = this.getDoclet().getClassDocForClass(enumClass);
        if (doc == null) {
            throw new RuntimeException("Tried to get docs for enum " + enumClass + " but got null instead");
        }
        Set<String> enumConstantFieldNames = this.enumConstantsNames(enumClass);
        ArrayList<Map<String, Object>> bindings = new ArrayList<Map<String, Object>>();
        for (final FieldDoc fieldDoc : doc.fields(false)) {
            if (!enumConstantFieldNames.contains(fieldDoc.name())) continue;
            bindings.add((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("name", fieldDoc.name());
                    this.put("summary", fieldDoc.commentText());
                }
            });
        }
        return bindings;
    }

    private Set<String> enumConstantsNames(Class enumClass) {
        HashSet<String> enumConstantFieldNames = new HashSet<String>();
        for (Field field : enumClass.getFields()) {
            if (!field.isEnumConstant()) continue;
            enumConstantFieldNames.add(field.getName());
        }
        return enumConstantFieldNames;
    }

    private class CompareArgumentsByName
    implements Comparator<Map<String, Object>> {
        private CompareArgumentsByName() {
        }

        @Override
        public int compare(Map<String, Object> x2, Map<String, Object> y) {
            return this.elt(x2).compareTo(this.elt(y));
        }

        private String elt(Map<String, Object> m2) {
            String v2 = m2.get("name").toString().toLowerCase();
            if (v2.startsWith("--")) {
                return v2.substring(2);
            }
            if (v2.startsWith("-")) {
                return v2.substring(1);
            }
            throw new RuntimeException("Expect to see arguments beginning with at least one -, but found " + v2);
        }
    }
}

