/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.haplotype;

import com.google.java.contract.Requires;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import org.apache.commons.lang.ArrayUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.haplotype.EventMap;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.variant.variantcontext.Allele;

public class Haplotype
extends Allele {
    private GenomeLoc genomeLocation = null;
    private EventMap eventMap = null;
    private Cigar cigar;
    private int alignmentStartHapwrtRef;
    private double score = 0.0;

    public Haplotype(byte[] bases, boolean isRef) {
        super((byte[])bases.clone(), isRef);
    }

    public Haplotype(byte[] bases) {
        this(bases, false);
    }

    public Haplotype(byte[] bases, boolean isRef, int alignmentStartHapwrtRef, Cigar cigar) {
        this(bases, isRef);
        this.alignmentStartHapwrtRef = alignmentStartHapwrtRef;
        this.setCigar(cigar);
    }

    public Haplotype(Allele allele) {
        super(allele, true);
    }

    public Haplotype(byte[] bases, GenomeLoc loc) {
        this(bases, false);
        this.genomeLocation = loc;
    }

    public Haplotype trim(GenomeLoc loc) {
        if (loc == null) {
            throw new IllegalArgumentException("Loc cannot be null");
        }
        if (this.genomeLocation == null) {
            throw new IllegalStateException("Cannot trim a Haplotype without containing GenomeLoc");
        }
        if (!this.genomeLocation.containsP(loc)) {
            throw new IllegalArgumentException("Can only trim a Haplotype to a containing span.  My loc is " + this.genomeLocation + " but wanted trim to " + loc);
        }
        if (this.getCigar() == null) {
            throw new IllegalArgumentException("Cannot trim haplotype without a cigar " + this);
        }
        int newStart = loc.getStart() - this.genomeLocation.getStart();
        int newStop = newStart + loc.size() - 1;
        byte[] newBases = AlignmentUtils.getBasesCoveringRefInterval(newStart, newStop, this.getBases(), 0, this.getCigar());
        Cigar newCigar = AlignmentUtils.trimCigarByReference(this.getCigar(), newStart, newStop);
        if (newBases == null || AlignmentUtils.startsOrEndsWithInsertionOrDeletion(newCigar)) {
            return null;
        }
        Haplotype ret = new Haplotype(newBases, this.isReference());
        ret.setCigar(newCigar);
        ret.setGenomeLocation(loc);
        ret.setAlignmentStartHapwrtRef(newStart + this.getAlignmentStartHapwrtRef());
        return ret;
    }

    @Override
    public boolean equals(Object h2) {
        return h2 instanceof Haplotype && Arrays.equals(this.getBases(), ((Haplotype)h2).getBases());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.getBases());
    }

    public EventMap getEventMap() {
        return this.eventMap;
    }

    public void setEventMap(EventMap eventMap) {
        this.eventMap = eventMap;
    }

    @Override
    public String toString() {
        return this.getDisplayString();
    }

    public GenomeLoc getGenomeLocation() {
        return this.genomeLocation;
    }

    public void setGenomeLocation(GenomeLoc genomeLocation) {
        this.genomeLocation = genomeLocation;
    }

    public long getStartPosition() {
        return this.genomeLocation.getStart();
    }

    public long getStopPosition() {
        return this.genomeLocation.getStop();
    }

    public int getAlignmentStartHapwrtRef() {
        return this.alignmentStartHapwrtRef;
    }

    public void setAlignmentStartHapwrtRef(int alignmentStartHapwrtRef) {
        this.alignmentStartHapwrtRef = alignmentStartHapwrtRef;
    }

    public Cigar getCigar() {
        return this.cigar;
    }

    public Cigar getConsolidatedPaddedCigar(int padSize) {
        if (padSize < 0) {
            throw new IllegalArgumentException("padSize must be >= 0 but got " + padSize);
        }
        Cigar extendedHaplotypeCigar = new Cigar(this.getCigar().getCigarElements());
        if (padSize > 0) {
            extendedHaplotypeCigar.add(new CigarElement(padSize, CigarOperator.M));
        }
        return AlignmentUtils.consolidateCigar(extendedHaplotypeCigar);
    }

    public void setCigar(Cigar cigar) {
        this.cigar = AlignmentUtils.consolidateCigar(cigar);
        if (this.cigar.getReadLength() != this.length()) {
            throw new IllegalArgumentException("Read length " + this.length() + " not equal to the read length of the cigar " + cigar.getReadLength());
        }
    }

    @Requires(value={"refInsertLocation >= 0"})
    public Haplotype insertAllele(Allele refAllele, Allele altAllele, int refInsertLocation, int genomicInsertLocation) {
        int haplotypeInsertLocation = ReadUtils.getReadCoordinateForReferenceCoordinate(this.alignmentStartHapwrtRef, this.cigar, refInsertLocation, ReadUtils.ClippingTail.RIGHT_TAIL, true);
        byte[] myBases = this.getBases();
        if (haplotypeInsertLocation == -1 || haplotypeInsertLocation + refAllele.length() >= myBases.length) {
            return null;
        }
        byte[] newHaplotypeBases = new byte[]{};
        newHaplotypeBases = ArrayUtils.addAll(newHaplotypeBases, ArrayUtils.subarray(myBases, 0, haplotypeInsertLocation));
        newHaplotypeBases = ArrayUtils.addAll(newHaplotypeBases, altAllele.getBases());
        newHaplotypeBases = ArrayUtils.addAll(newHaplotypeBases, ArrayUtils.subarray(myBases, haplotypeInsertLocation + refAllele.length(), myBases.length));
        return new Haplotype(newHaplotypeBases);
    }

    public static LinkedHashMap<Allele, Haplotype> makeHaplotypeListFromAlleles(List<Allele> alleleList, int startPos, ReferenceContext ref, int haplotypeSize, int numPrefBases) {
        LinkedHashMap<Allele, Haplotype> haplotypeMap = new LinkedHashMap<Allele, Haplotype>();
        Allele refAllele = null;
        for (Allele a2 : alleleList) {
            if (!a2.isReference()) continue;
            refAllele = a2;
            break;
        }
        if (refAllele == null) {
            throw new ReviewedStingException("BUG: no ref alleles in input to makeHaplotypeListfrom Alleles at loc: " + startPos);
        }
        byte[] refBases = ref.getBases();
        int startIdxInReference = 1 + startPos - numPrefBases - ref.getWindow().getStart();
        String basesBeforeVariant = new String(Arrays.copyOfRange(refBases, startIdxInReference, startIdxInReference + numPrefBases));
        int startAfter = Math.min(startIdxInReference + numPrefBases + refAllele.getBases().length - 1, refBases.length);
        String basesAfterVariant = new String(Arrays.copyOfRange(refBases, startAfter, refBases.length));
        int startLoc = ref.getWindow().getStart() + startIdxInReference;
        int stopLoc = startLoc + haplotypeSize - 1;
        GenomeLoc locus = ref.getGenomeLocParser().createGenomeLoc(ref.getLocus().getContig(), startLoc, stopLoc);
        for (Allele a3 : alleleList) {
            byte[] alleleBases = a3.getBases();
            String haplotypeString = basesBeforeVariant + new String(Arrays.copyOfRange(alleleBases, 1, alleleBases.length)) + basesAfterVariant;
            haplotypeString = haplotypeString.substring(0, haplotypeSize);
            haplotypeMap.put(a3, new Haplotype(haplotypeString.getBytes(), locus));
        }
        return haplotypeMap;
    }

    public double getScore() {
        return this.isReference() ? Double.MAX_VALUE : this.score;
    }

    public void setScore(double score) {
        this.score = this.isReference() ? Double.MAX_VALUE : score;
    }

    private static class Event {
        public Allele ref;
        public Allele alt;
        public int pos;

        public Event(Allele ref, Allele alt, int pos) {
            this.ref = ref;
            this.alt = alt;
            this.pos = pos;
        }
    }
}

