/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMProgramRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.io.StingSAMFileWriter;
import org.broadinstitute.sting.utils.text.TextFormattingUtils;

public class Utils {
    private static Logger logger = Logger.getLogger(Utils.class);
    public static final float JAVA_DEFAULT_HASH_LOAD_FACTOR = 0.75f;

    public static boolean xor(boolean x2, boolean y) {
        return x2 != y;
    }

    public static int optimumHashSize(int maxElements) {
        return (int)((float)maxElements / 0.75f) + 2;
    }

    public static boolean equals(Object lhs, Object rhs) {
        return lhs == null && rhs == null || lhs != null && lhs.equals(rhs);
    }

    public static <T> List<T> cons(T elt, List<T> l2) {
        ArrayList<T> l22 = new ArrayList<T>();
        l22.add(elt);
        if (l2 != null) {
            l22.addAll(l2);
        }
        return l22;
    }

    public static void warnUser(String msg) {
        Utils.warnUser(logger, msg);
    }

    public static void warnUser(Logger logger, String msg) {
        logger.warn(String.format("********************************************************************************", new Object[0]));
        logger.warn(String.format("* WARNING:", new Object[0]));
        logger.warn(String.format("*", new Object[0]));
        Utils.prettyPrintWarningMessage(logger, msg);
        logger.warn(String.format("********************************************************************************", new Object[0]));
    }

    private static void prettyPrintWarningMessage(Logger logger, String message) {
        StringBuilder builder = new StringBuilder(message);
        while (builder.length() > 70) {
            int space = builder.lastIndexOf(" ", 70);
            if (space <= 0) {
                space = 70;
            }
            logger.warn(String.format("* %s", builder.substring(0, space)));
            builder.delete(0, space + 1);
        }
        logger.warn(String.format("* %s", builder));
    }

    public static <L, R> String joinMap(String keyValueSeperator, String recordSeperator, Map<L, R> map) {
        if (map.size() < 1) {
            return null;
        }
        String[] joinedKeyValues = new String[map.size()];
        int index = 0;
        for (L key : map.keySet()) {
            joinedKeyValues[index++] = String.format("%s%s%s", key.toString(), keyValueSeperator, map.get(key).toString());
        }
        return Utils.join(recordSeperator, joinedKeyValues);
    }

    public static ArrayList<String> split(String str, String delimiter) {
        return Utils.split(str, delimiter, 10);
    }

    public static ArrayList<String> split(String str, String delimiter, int expectedNumTokens) {
        ArrayList<String> result = new ArrayList<String>(expectedNumTokens);
        int delimiterIdx = -1;
        do {
            int tokenStartIdx;
            String token = (delimiterIdx = str.indexOf(delimiter, tokenStartIdx = delimiterIdx + 1)) != -1 ? str.substring(tokenStartIdx, delimiterIdx) : str.substring(tokenStartIdx);
            result.add(token);
        } while (delimiterIdx != -1);
        return result;
    }

    public static String join(String separator, String[] strings) {
        return Utils.join(separator, strings, 0, strings.length);
    }

    public static String join(String separator, String[] strings, int start, int end) {
        if (end - start == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder(strings[start]);
        for (int i2 = start + 1; i2 < end; ++i2) {
            ret.append(separator);
            ret.append(strings[i2]);
        }
        return ret.toString();
    }

    public static String join(String separator, int[] ints) {
        if (ints == null || ints.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        ret.append(ints[0]);
        for (int i2 = 1; i2 < ints.length; ++i2) {
            ret.append(separator);
            ret.append(ints[i2]);
        }
        return ret.toString();
    }

    public static <T> List<T> append(List<T> left, T ... elts) {
        LinkedList<T> l2 = new LinkedList<T>(left);
        l2.addAll(Arrays.asList(elts));
        return l2;
    }

    public static String join(String separator, double[] doubles) {
        if (doubles == null || doubles.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        ret.append(doubles[0]);
        for (int i2 = 1; i2 < doubles.length; ++i2) {
            ret.append(separator);
            ret.append(doubles[i2]);
        }
        return ret.toString();
    }

    public static <T> String join(String separator, Collection<T> objects) {
        if (objects.isEmpty()) {
            return "";
        }
        Iterator<T> iter = objects.iterator();
        T first = iter.next();
        if (!iter.hasNext()) {
            return first.toString();
        }
        StringBuilder ret = new StringBuilder(first.toString());
        while (iter.hasNext()) {
            ret.append(separator);
            ret.append(iter.next().toString());
        }
        return ret.toString();
    }

    public static <T> String join(String separator, T ... objects) {
        return Utils.join(separator, Arrays.asList(objects));
    }

    public static String dupString(String s2, int nCopies) {
        if (s2 == null || s2.equals("")) {
            throw new IllegalArgumentException("Bad s " + s2);
        }
        if (nCopies < 0) {
            throw new IllegalArgumentException("nCopies must be >= 0 but got " + nCopies);
        }
        StringBuilder b2 = new StringBuilder();
        for (int i2 = 0; i2 < nCopies; ++i2) {
            b2.append(s2);
        }
        return b2.toString();
    }

    public static String dupString(char c2, int nCopies) {
        char[] chars = new char[nCopies];
        Arrays.fill(chars, c2);
        return new String(chars);
    }

    public static byte[] dupBytes(byte b2, int nCopies) {
        byte[] bytes = new byte[nCopies];
        Arrays.fill(bytes, b2);
        return bytes;
    }

    public static String trim(String str, char ch) {
        int end;
        int start;
        char[] array = str.toCharArray();
        for (start = 0; start < array.length && array[start] == ch; ++start) {
        }
        for (end = array.length - 1; end > start && array[end] == ch; --end) {
        }
        return str.substring(start, end + 1);
    }

    public static String[] escapeExpressions(String args) {
        if (args.indexOf(39) != -1) {
            return Utils.escapeExpressions(args, "'");
        }
        if (args.indexOf(34) != -1) {
            return Utils.escapeExpressions(args, "\"");
        }
        return args.trim().split(" +");
    }

    private static String[] escapeExpressions(String args, String delimiter) {
        String arg;
        String[] command = new String[]{};
        String[] split = args.split(delimiter);
        for (int i2 = 0; i2 < split.length - 1; i2 += 2) {
            arg = split[i2].trim();
            if (arg.length() > 0) {
                command = Utils.concatArrays(command, arg.split(" +"));
            }
            command = Utils.concatArrays(command, new String[]{split[i2 + 1]});
        }
        arg = split[split.length - 1].trim();
        if (split.length % 2 == 1 && arg.length() > 0) {
            command = Utils.concatArrays(command, arg.split(" +"));
        }
        return command;
    }

    public static String[] concatArrays(String[] A, String[] B) {
        String[] C = new String[A.length + B.length];
        System.arraycopy(A, 0, C, 0, A.length);
        System.arraycopy(B, 0, C, A.length, B.length);
        return C;
    }

    public static byte[] concat(byte[] ... allBytes) {
        int size = 0;
        for (byte[] bytes : allBytes) {
            size += bytes.length;
        }
        byte[] c2 = new byte[size];
        int offset = 0;
        for (byte[] bytes : allBytes) {
            System.arraycopy(bytes, 0, c2, offset, bytes.length);
            offset += bytes.length;
        }
        return c2;
    }

    public static String[] appendArray(String[] A, String ... B) {
        return Utils.concatArrays(A, B);
    }

    public static <T extends Comparable<T>> List<T> sorted(Collection<T> c2) {
        return Utils.sorted(c2, false);
    }

    public static <T extends Comparable<T>> List<T> sorted(Collection<T> c2, boolean reverse) {
        ArrayList<T> l2 = new ArrayList<T>(c2);
        Collections.sort(l2);
        if (reverse) {
            Collections.reverse(l2);
        }
        return l2;
    }

    public static <T extends Comparable<T>, V> List<V> sorted(Map<T, V> c2) {
        return Utils.sorted(c2, false);
    }

    public static <T extends Comparable<T>, V> List<V> sorted(Map<T, V> c2, boolean reverse) {
        ArrayList<T> t2 = new ArrayList<T>(c2.keySet());
        Collections.sort(t2);
        if (reverse) {
            Collections.reverse(t2);
        }
        ArrayList<V> l2 = new ArrayList<V>();
        for (Comparable k2 : t2) {
            l2.add(c2.get(k2));
        }
        return l2;
    }

    public static byte[] reverse(byte[] bases) {
        byte[] rcbases = new byte[bases.length];
        for (int i2 = 0; i2 < bases.length; ++i2) {
            rcbases[i2] = bases[bases.length - i2 - 1];
        }
        return rcbases;
    }

    public static <T> List<T> reverse(List<T> l2) {
        ArrayList<T> newL = new ArrayList<T>(l2);
        Collections.reverse(newL);
        return newL;
    }

    public static int[] reverse(int[] bases) {
        int[] rcbases = new int[bases.length];
        for (int i2 = 0; i2 < bases.length; ++i2) {
            rcbases[i2] = bases[bases.length - i2 - 1];
        }
        return rcbases;
    }

    public static String reverse(String bases) {
        return new String(Utils.reverse(bases.getBytes()));
    }

    public static boolean isFlagSet(int value, int flag) {
        return (value & flag) == flag;
    }

    public static String resolveHostname() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            return "unresolvable";
        }
    }

    public static byte[] arrayFromArrayWithLength(byte[] array, int length) {
        byte[] output = new byte[length];
        for (int j2 = 0; j2 < length; ++j2) {
            output[j2] = array[j2 % array.length];
        }
        return output;
    }

    public static void fillArrayWithByte(byte[] array, byte value) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = value;
        }
    }

    public static SAMFileHeader setupWriter(SAMFileHeader originalHeader, SAMProgramRecord programRecord) {
        SAMFileHeader header = originalHeader.clone();
        List<SAMProgramRecord> oldRecords = header.getProgramRecords();
        ArrayList<SAMProgramRecord> newRecords = new ArrayList<SAMProgramRecord>(oldRecords.size() + 1);
        for (SAMProgramRecord record : oldRecords) {
            if (programRecord == null || record.getId().startsWith(programRecord.getId())) continue;
            newRecords.add(record);
        }
        if (programRecord != null) {
            newRecords.add(programRecord);
            header.setProgramRecords(newRecords);
        }
        return header;
    }

    public static SAMFileHeader setupWriter(GenomeAnalysisEngine toolkit, SAMFileHeader originalHeader, Object walker, String PROGRAM_RECORD_NAME) {
        SAMProgramRecord programRecord = Utils.createProgramRecord(toolkit, walker, PROGRAM_RECORD_NAME);
        return Utils.setupWriter(originalHeader, programRecord);
    }

    public static void setupWriter(StingSAMFileWriter writer, GenomeAnalysisEngine toolkit, SAMFileHeader originalHeader, boolean preSorted, Object walker, String PROGRAM_RECORD_NAME) {
        SAMFileHeader header = Utils.setupWriter(toolkit, originalHeader, walker, PROGRAM_RECORD_NAME);
        writer.writeHeader(header);
        writer.setPresorted(preSorted);
    }

    public static SAMProgramRecord createProgramRecord(GenomeAnalysisEngine toolkit, Object walker, String PROGRAM_RECORD_NAME) {
        SAMProgramRecord programRecord = new SAMProgramRecord(PROGRAM_RECORD_NAME);
        ResourceBundle headerInfo = TextFormattingUtils.loadResourceBundle("StingText");
        try {
            String version = headerInfo.getString("org.broadinstitute.sting.gatk.version");
            programRecord.setProgramVersion(version);
        }
        catch (MissingResourceException e2) {
            // empty catch block
        }
        programRecord.setCommandLine(toolkit.createApproximateCommandLineArgumentString(new Object[]{toolkit, walker}));
        return programRecord;
    }

    @Requires(value={"options != null"})
    public static <T> int nCombinations(Collection<T>[] options) {
        int nStates = 1;
        for (Collection<T> states : options) {
            nStates *= states.size();
        }
        return nStates;
    }

    @Requires(value={"options != null"})
    public static <T> int nCombinations(List<List<T>> options) {
        if (options.isEmpty()) {
            return 0;
        }
        int nStates = 1;
        for (Collection collection : options) {
            nStates *= collection.size();
        }
        return nStates;
    }

    public static <T> List<List<T>> makePermutations(List<T> objects, int n2, boolean withReplacement) {
        ArrayList<List<T>> combinations;
        block4: {
            block3: {
                combinations = new ArrayList<List<T>>();
                if (n2 != 1) break block3;
                for (T o2 : objects) {
                    combinations.add(Collections.singletonList(o2));
                }
                break block4;
            }
            if (n2 <= 1) break block4;
            List<List<T>> sub = Utils.makePermutations(objects, n2 - 1, withReplacement);
            for (List<T> subI : sub) {
                for (T a2 : objects) {
                    if (!withReplacement && subI.contains(a2)) continue;
                    combinations.add(Utils.cons(a2, subI));
                }
            }
        }
        return combinations;
    }

    public static String formattedNoveltyRate(int known, int all) {
        return Utils.formattedPercent(all - known, all);
    }

    public static String formattedPercent(long x2, long total) {
        return total == 0L ? "NA" : String.format("%.2f", 100.0 * (double)x2 / (double)total);
    }

    public static String formattedRatio(long num, long denom) {
        return denom == 0L ? "NA" : String.format("%.2f", (double)num / (1.0 * (double)denom));
    }

    public static <T> boolean addAll(Collection<T> dest, T ... elements) {
        boolean result = false;
        for (T e2 : elements) {
            result = dest.add(e2) | result;
        }
        return result;
    }

    public static <T> Map<T, T> makeIdentityFunctionMap(Collection<T> values) {
        HashMap<T, T> map = new HashMap<T, T>(values.size());
        for (T value : values) {
            map.put(value, value);
        }
        return Collections.unmodifiableMap(map);
    }

    public static <T> List<List<T>> groupList(List<T> list, int groupSize) {
        if (groupSize < 1) {
            throw new IllegalArgumentException("groupSize >= 1");
        }
        LinkedList<List<T>> subLists = new LinkedList<List<T>>();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; i2 += groupSize) {
            subLists.add(list.subList(i2, Math.min(i2 + groupSize, n2)));
        }
        return subLists;
    }

    public static String calcMD5(String s2) {
        return Utils.calcMD5(s2.getBytes());
    }

    @Ensures(value={"result != null", "result.length() == 32"})
    public static String calcMD5(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null");
        }
        try {
            byte[] thedigest = MessageDigest.getInstance("MD5").digest(bytes);
            BigInteger bigInt = new BigInteger(1, thedigest);
            String md5String = bigInt.toString(16);
            while (md5String.length() < 32) {
                md5String = "0" + md5String;
            }
            return md5String;
        }
        catch (NoSuchAlgorithmException e2) {
            throw new IllegalStateException("MD5 digest algorithm not present");
        }
    }

    public static boolean endsWith(byte[] big, byte[] suffix) {
        if (big == null) {
            throw new IllegalArgumentException("big cannot be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("suffix cannot be null");
        }
        return new String(big).endsWith(new String(suffix));
    }

    public static int longestCommonPrefix(byte[] seq1, byte[] seq2, int maxLength) {
        if (seq1 == null) {
            throw new IllegalArgumentException("seq1 is null");
        }
        if (seq2 == null) {
            throw new IllegalArgumentException("seq2 is null");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("maxLength < 0 " + maxLength);
        }
        int end = Math.min(seq1.length, Math.min(seq2.length, maxLength));
        for (int i2 = 0; i2 < end; ++i2) {
            if (seq1[i2] == seq2[i2]) continue;
            return i2;
        }
        return end;
    }

    public static int longestCommonSuffix(byte[] seq1, byte[] seq2, int maxLength) {
        if (seq1 == null) {
            throw new IllegalArgumentException("seq1 is null");
        }
        if (seq2 == null) {
            throw new IllegalArgumentException("seq2 is null");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("maxLength < 0 " + maxLength);
        }
        int end = Math.min(seq1.length, Math.min(seq2.length, maxLength));
        for (int i2 = 0; i2 < end; ++i2) {
            if (seq1[seq1.length - i2 - 1] == seq2[seq2.length - i2 - 1]) continue;
            return i2;
        }
        return end;
    }

    public static byte[] trimArray(byte[] seq, int trimFromFront, int trimFromBack) {
        if (trimFromFront + trimFromBack > seq.length) {
            throw new IllegalArgumentException("trimming total is larger than the original array");
        }
        return trimFromFront == 0 && trimFromBack == 0 ? seq : Arrays.copyOfRange(seq, trimFromFront, seq.length - trimFromBack);
    }

    public static List<Integer> listFromPrimitives(int[] ar) {
        ArrayList<Integer> lst = new ArrayList<Integer>(ar.length);
        for (int d2 : ar) {
            lst.add(d2);
        }
        return lst;
    }
}

