/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.samtools.util.SortingCollection;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.bed.BEDCodec;
import org.broad.tribble.dbsnp.OldDbSNPCodec;
import org.broad.tribble.gelitext.GeliTextCodec;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.PositionalBufferedStream;
import org.broadinstitute.sting.gatk.features.maf.MafCodec;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.codecs.CGVarCodec;
import org.broadinstitute.sting.utils.codecs.SoapSNPCodec;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.variant.vcf.VCFCodec;

public class SortROD {
    private static Logger logger = Logger.getRootLogger();

    public static void main(String[] args) {
        String inputArg;
        File refFile;
        String refarg;
        BasicConfigurator.configure();
        logger.setLevel(Level.INFO);
        if (args.length != 3) {
            SortROD.printUsage();
        }
        if (!(refarg = args[0]).endsWith(".fasta")) {
            System.err.println("Reference file name must end with .fasta");
            System.exit(1);
        }
        if (!(refFile = new File(refarg)).exists()) {
            System.err.println("Reference file " + refarg + " does not exist");
            System.exit(1);
        }
        String rodType = null;
        int pos = args[1].indexOf(":");
        if (pos == -1) {
            inputArg = args[1];
        } else {
            rodType = args[1].substring(0, pos);
            inputArg = args[1].substring(pos + 1);
        }
        File featureFile = new File(inputArg);
        if (!featureFile.exists()) {
            System.err.println("File " + featureFile.getAbsolutePath() + " doesn't exist");
            SortROD.printUsage();
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(args[2]));
        }
        catch (IOException e2) {
            System.err.println("Can not open output file " + args[2] + " for writing");
            System.exit(1);
        }
        AsciiFeatureCodec featureCodec = SortROD.getFeatureCodec(featureFile, rodType);
        ReferenceSequenceFile ref = ReferenceSequenceFileFactory.getReferenceSequenceFile(refFile);
        AsciiLineReader reader = null;
        try {
            reader = new AsciiLineReader(new PositionalBufferedStream(new FileInputStream(featureFile)));
        }
        catch (FileNotFoundException e3) {
            System.err.println("File " + featureFile.getAbsolutePath() + " doesn't exist");
            System.exit(1);
        }
        featureCodec.readHeader(reader);
        GenomeLocParser parser = new GenomeLocParser(ref.getSequenceDictionary());
        SortingCollection<String> sorter = SortingCollection.newInstance(String.class, new LineCodec(), new FeatureComparator(featureCodec, parser), 200000);
        int nLines = 0;
        try {
            String currentLine = reader.readLine();
            while (currentLine != null) {
                ++nLines;
                sorter.add(currentLine);
                currentLine = reader.readLine();
            }
            for (String s2 : sorter) {
                out.write(s2);
                out.write(10);
            }
            out.close();
        }
        catch (IOException e4) {
            System.err.println("Writing failed to the output file " + args[2]);
            System.exit(1);
        }
        logger.info("Sorting finished. Processed lines: " + nLines);
    }

    public static void printUsage() {
        System.err.println("Usage: java -jar SortROD.jar <reference> [<rodType>:]<inputFile> <outputFile>");
        System.err.println("    Where input can be of type: VCF (ends in .vcf or .VCF)");
        System.err.println("                                Bed (ends in .bed or .bed)");
        System.err.println("                                DbSNP (ends in .snp or .rod)");
        System.err.println("                                MAF (ends in .maf)");
        System.err.println("    If input file has non-standard extension, rodType can be specified");
        System.err.println("    (rodType always takes precedence over file extension, even if the");
        System.err.println("    latter is otherwise recognizable). rodType can be vcf, bed, dbsnp, or maf");
        System.err.println("    Reference is what the input file needs to be sorted against");
        System.exit(1);
    }

    public static AsciiFeatureCodec getFeatureCodec(File featureFile, String rodType) {
        if (rodType != null) {
            if (rodType.equals("vcf")) {
                return new VCFCodec();
            }
            if (rodType.equals("bed")) {
                return new BEDCodec();
            }
            if (rodType.equals("cgvar") || rodType.equals("CGVar")) {
                return new CGVarCodec();
            }
            if (rodType.equals("snp") || rodType.equals("dbsnp")) {
                return new OldDbSNPCodec();
            }
            if (rodType.equals("geli.calls") || rodType.equals("geli")) {
                return new GeliTextCodec();
            }
            if (rodType.equals("txt")) {
                return new SoapSNPCodec();
            }
            if (rodType.equals("maf")) {
                return new MafCodec();
            }
            throw new StingException("Explicitly specified rod type " + rodType + " is not recognized");
        }
        if (featureFile.getName().endsWith(".vcf") || featureFile.getName().endsWith(".VCF")) {
            return new VCFCodec();
        }
        if (featureFile.getName().endsWith(".bed") || featureFile.getName().endsWith(".BED")) {
            return new BEDCodec();
        }
        if (featureFile.getName().endsWith(".tsv") || featureFile.getName().endsWith(".TSV")) {
            return new CGVarCodec();
        }
        if (featureFile.getName().endsWith(".snp") || featureFile.getName().endsWith(".rod")) {
            return new OldDbSNPCodec();
        }
        if (featureFile.getName().endsWith(".geli.calls") || featureFile.getName().endsWith(".geli")) {
            return new GeliTextCodec();
        }
        if (featureFile.getName().endsWith(".txt") || featureFile.getName().endsWith(".TXT")) {
            return new SoapSNPCodec();
        }
        if (featureFile.getName().endsWith(".maf") || featureFile.getName().endsWith(".MAF")) {
            return new MafCodec();
        }
        throw new IllegalArgumentException("Unable to determine correct file type based on the file name, for file -> " + featureFile);
    }

    static class FeatureComparator
    implements Comparator<String> {
        AsciiFeatureCodec codec;
        GenomeLocParser parser;

        public FeatureComparator(AsciiFeatureCodec codec, GenomeLocParser parser) {
            this.codec = codec;
            this.parser = parser;
        }

        @Override
        public int compare(String o1, String o2) {
            Feature f1 = this.codec.decodeLoc(o1);
            Feature f2 = this.codec.decodeLoc(o2);
            if (f1 == null) {
                if (f2 == null) {
                    return 0;
                }
                return -1;
            }
            if (f2 == null) {
                return 1;
            }
            GenomeLoc l1 = this.parser.createGenomeLoc(f1.getChr(), f1.getStart(), f1.getEnd());
            GenomeLoc l2 = this.parser.createGenomeLoc(f2.getChr(), f2.getStart(), f2.getEnd());
            return l1.compareTo(l2);
        }
    }

    static class LineCodec
    implements SortingCollection.Codec<String> {
        OutputStream os;
        InputStream is;

        LineCodec() {
        }

        @Override
        public void setOutputStream(OutputStream outputStream) {
            this.os = outputStream;
        }

        @Override
        public void setInputStream(InputStream inputStream) {
            this.is = inputStream;
        }

        @Override
        public void encode(String s2) {
            try {
                this.os.write(s2.getBytes());
                this.os.write(10);
            }
            catch (IOException e2) {
                throw new StingException("SortingCollection: Write into temporary file failed", e2);
            }
        }

        @Override
        public String decode() {
            ArrayList<Byte> l2 = new ArrayList<Byte>(1024);
            try {
                int c2 = this.is.read();
                while (c2 != -1 && c2 != 10) {
                    l2.add((byte)c2);
                    c2 = this.is.read();
                }
            }
            catch (IOException e2) {
                throw new StingException("SortingCollection: Read from temporary file failed", e2);
            }
            return new String(this.toByteArray(l2));
        }

        @Override
        public SortingCollection.Codec<String> clone() {
            LineCodec codec = new LineCodec();
            codec.setInputStream(this.is);
            codec.setOutputStream(this.os);
            return codec;
        }

        private byte[] toByteArray(List<Byte> l2) {
            byte[] ret = new byte[l2.size()];
            for (int i2 = 0; i2 < l2.size(); ++i2) {
                ret[i2] = l2.get(i2);
            }
            return ret;
        }
    }
}

