/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.sam.SamFileHeaderMerger;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.sam.SimplifyingSAMFileWriter;
import org.broadinstitute.sting.utils.text.XReadLines;

public class SliceBams
extends CommandLineProgram {
    private static final Log log = Log.getInstance(SliceBams.class);
    @Usage
    public String USAGE = "Merges multiple SAM/BAM files into one BAM overlapping chr:start-stop interval .\n";
    @Option(shortName="I", doc="List of input BAM files")
    public File INPUT_LIST;
    @Option(shortName="O", doc="SAM or BAM file to write merged result to")
    public File OUTPUT;
    @Option(shortName="L", doc="Location to include")
    public String SLICE;
    private static final int PROGRESS_INTERVAL = 1000000;

    public static void main(String[] argv) {
        System.exit(new SliceBams().instanceMain(argv));
    }

    private List<File> parseInputFiles(File list) {
        try {
            ArrayList<File> files = new ArrayList<File>();
            for (String fileName : new XReadLines(list).readLines()) {
                files.add(new File(fileName));
            }
            return files;
        }
        catch (FileNotFoundException e2) {
            throw new PicardException("Couldn't read input list", e2);
        }
    }

    private SAMFileWriter createOutputBAM(List<File> inputBAMs) {
        ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>();
        log.info("Reading headers");
        int fileCounter = 1;
        for (File inFile : inputBAMs) {
            IoUtil.assertFileIsReadable(inFile);
            SAMFileReader inReader = new SAMFileReader(inFile, null);
            SAMFileHeader inHeader = inReader.getFileHeader();
            log.info("  Reading header from file " + inFile + " " + fileCounter++ + " of " + inputBAMs.size());
            headers.add(inHeader);
            inReader.close();
        }
        SamFileHeaderMerger headerMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, headers, true);
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(headerMerger.getMergedHeader(), false, this.OUTPUT);
        return new SimplifyingSAMFileWriter(out);
    }

    @Override
    protected int doWork() {
        SAMFileReader.setDefaultValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        SAMFileWriterFactory.setDefaultCreateIndexWhileWriting(true);
        List<File> inputBAMs = this.parseInputFiles(this.INPUT_LIST);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        SAMFileWriter out = this.createOutputBAM(inputBAMs);
        GenomeLocParser glParser = new GenomeLocParser(out.getFileHeader().getSequenceDictionary());
        GenomeLoc loc = glParser.parseGenomeLoc(this.SLICE);
        log.info("Reading BAM records");
        long numRecords = 1L;
        int fileCounter = 1;
        for (File inFile : inputBAMs) {
            IoUtil.assertFileIsReadable(inFile);
            log.info("  Reading file " + inFile + " " + fileCounter++ + " of " + inputBAMs.size());
            SAMFileReader reader = new SAMFileReader(inFile);
            SAMRecordIterator iterator = reader.queryOverlapping(loc.getContig(), loc.getStart(), loc.getStop());
            while (iterator.hasNext()) {
                SAMRecord record = (SAMRecord)iterator.next();
                out.addAlignment(record);
                if (numRecords % 1000000L != 0L) continue;
                log.info(numRecords + " records read.");
            }
            reader.close();
        }
        log.info("Finished reading inputs.");
        log.info("Sorting final output file.");
        out.close();
        return 0;
    }
}

