/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.tools;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.CommandLineProgram;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.interval.IntervalUtils;

public final class IntervalParsing
extends CommandLineProgram {
    private static Logger logger = Logger.getLogger(IntervalParsing.class);
    @Output
    protected PrintStream out;
    @Argument(shortName="R", required=true)
    public File reference;
    @Argument(shortName="targets", required=true)
    public List<File> intervalList;
    @Argument(shortName="action", required=true)
    public Action action;

    public static void main(String[] args) {
        try {
            IntervalParsing instance = new IntervalParsing();
            IntervalParsing.start(instance, args);
            System.exit(CommandLineProgram.result);
        }
        catch (UserException e2) {
            IntervalParsing.exitSystemWithUserError(e2);
        }
        catch (Exception e3) {
            IntervalParsing.exitSystemWithError(e3);
        }
    }

    @Override
    protected int execute() throws Exception {
        ArrayList<List<GenomeLoc>> intervals = new ArrayList<List<GenomeLoc>>(this.intervalList.size());
        GenomeLocParser genomeLocParser = new GenomeLocParser(new IndexedFastaSequenceFile(this.reference));
        for (File f2 : this.intervalList) {
            intervals.add(IntervalUtils.intervalFileToList(genomeLocParser, f2.getAbsolutePath()));
        }
        List<GenomeLoc> result = null;
        switch (this.action) {
            case UNION: {
                throw new ReviewedStingException("Not implemented");
            }
            case DIFFERENCE: {
                result = IntervalParsing.difference(intervals);
                break;
            }
            case INTERSECTION: {
                throw new ReviewedStingException("Not implemented");
            }
            default: {
                throw new ReviewedStingException("Not implemented");
            }
        }
        for (GenomeLoc interval : result) {
            this.out.println(interval);
        }
        this.out.close();
        return 0;
    }

    private static List<GenomeLoc> difference(List<List<GenomeLoc>> list) {
        return IntervalParsing.difference(list, 0);
    }

    private static List<GenomeLoc> difference(List<List<GenomeLoc>> list, int index) {
        if (list.size() < index + 1) {
            throw new ReviewedStingException("Not enough elements in the interval list");
        }
        List<GenomeLoc> result = list.get(index);
        for (int i2 = index + 1; i2 < list.size(); ++i2) {
            result = IntervalParsing.difference(result, list.get(i2));
        }
        return result;
    }

    private static List<GenomeLoc> difference(List<GenomeLoc> a2, List<GenomeLoc> b2) {
        ArrayList<GenomeLoc> result = new ArrayList<GenomeLoc>(a2.size());
        for (GenomeLoc interval : a2) {
            List<GenomeLoc> ints = IntervalParsing.difference(interval, b2);
            result.addAll(ints);
        }
        return result;
    }

    private static List<GenomeLoc> difference(GenomeLoc interval, List<GenomeLoc> b2) {
        int key;
        boolean overlaps;
        ArrayList<GenomeLoc> result = new ArrayList<GenomeLoc>();
        int left = 0;
        int right = b2.size();
        do {
            key = (left + right) / 2;
            GenomeLoc other = b2.get(key);
            overlaps = other.overlapsP(interval);
            int comp = other.compareTo(interval);
            if (comp > 0) {
                right = key - 1;
                continue;
            }
            if (comp >= 0) continue;
            left = key + 1;
        } while (!overlaps && right >= left);
        if (overlaps) {
            right = key + 1;
            for (left = key - 1; left >= 0 && b2.get(left).overlapsP(interval); --left) {
            }
            while (right < b2.size() && b2.get(right).overlapsP(interval)) {
                ++right;
            }
            ArrayList<GenomeLoc> partial = new ArrayList<GenomeLoc>();
            result.add(interval);
            for (int i2 = left + 1; i2 < right; ++i2) {
                for (GenomeLoc in : result) {
                    partial.addAll(in.subtract(b2.get(i2)));
                }
                result.clear();
                result.addAll(partial);
                partial.clear();
            }
        }
        return result;
    }

    public static enum Action {
        UNION,
        DIFFERENCE,
        INTERSECTION;

    }
}

