/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.tools;

import java.io.File;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;

public class FilterReads
extends CommandLineProgram {
    @Usage(programVersion="1.0")
    public String USAGE = "Filters reads: the output file will contain only reads satisfying all the selected criteria";
    @Option(shortName="I", doc="Input file (bam or sam) to extract reads from.", optional=false)
    public File IN = null;
    @Option(shortName="O", doc="Output file (bam or sam) to write extracted reads to.", optional=false)
    public File OUT = null;
    @Option(shortName="U", doc="Select only unmapped reads if true; only mapped reads if false; both if not specified.", optional=true)
    public Boolean UNMAPPED = null;
    @Option(shortName="MINQ", doc="Select only reads with minimum base quality across all bases at or above the specified value.", optional=true)
    public Integer MIN_QUAL = 0;
    @Option(shortName="AVQ", doc="Select only reads with average base quality at or above the specified value.", optional=true)
    public Double AVERAGE_QUAL = 0.0;
    @Option(shortName="MAPQ", doc="Select only reads with mapping quality at or above the specified value (does not affect unmapped reads, use 'U').", optional=true)
    public Integer MAPPING_QUAL = 0;
    @Option(shortName="MAXE", doc="Select only reads with edit distance from the reference at or below the specified value ('NM' tags must be present in the input file).", optional=true)
    public Integer MAX_ERRORS = INFINITY;
    @Option(shortName="MINE", doc="Select only reads with edit distance from the reference at or above the specified value ('NM' tags must be present in the input file).", optional=true)
    public Integer MIN_ERRORS = 0;
    private static int INFINITY = 1000000;
    UnmappedFilter uFilter;

    public static void main(String[] argv) {
        System.exit(new FilterReads().instanceMain(argv));
    }

    @Override
    protected int doWork() {
        this.uFilter = this.UNMAPPED == null ? UnmappedFilter.BOTH : (this.UNMAPPED != false ? UnmappedFilter.UNMAPPED : UnmappedFilter.MAPPED);
        SAMFileReader inReader = new SAMFileReader(this.IN);
        SAMFileWriter outWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(inReader.getFileHeader(), true, this.OUT);
        block4: for (SAMRecord read : inReader) {
            int nm;
            Object attr;
            switch (this.uFilter) {
                case UNMAPPED: {
                    if (read.getReadUnmappedFlag()) break;
                    continue block4;
                }
                case MAPPED: {
                    if (!read.getReadUnmappedFlag()) break;
                    continue block4;
                }
            }
            if (!read.getReadUnmappedFlag() && (read.getMappingQuality() < this.MAPPING_QUAL || this.MAX_ERRORS < INFINITY && (attr = read.getAttribute("NM")) != null && ((nm = ((Integer)attr).intValue()) > this.MAX_ERRORS || nm < this.MIN_ERRORS))) continue;
            if (this.MIN_QUAL > 0 || this.AVERAGE_QUAL > 0.0) {
                byte[] quals = read.getBaseQualities();
                double av_q = 0.0;
                boolean passed = true;
                for (int i2 = 0; i2 < quals.length; ++i2) {
                    if (quals[i2] < this.MIN_QUAL) {
                        passed = false;
                        break;
                    }
                    av_q += (double)quals[i2];
                }
                if (!passed || av_q / (double)read.getReadLength() < this.AVERAGE_QUAL) continue;
            }
            outWriter.addAlignment(read);
        }
        inReader.close();
        outWriter.close();
        return 0;
    }

    static enum UnmappedFilter {
        UNMAPPED,
        MAPPED,
        BOTH;

    }
}

