/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.na12878kb.core;

import com.google.gson.Gson;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.MongoDBManager;
import org.broadinstitute.sting.utils.exceptions.StingException;

public class NA12878DBArgumentCollection {
    public static final String DEFAULT_SPEC_PATH = "resources/NA12878kb.json";
    public static final String LOCALHOST_SPEC_PATH = "resources/NA12878kb_local.json";
    @Argument(fullName="useLocal", shortName="useLocal", doc="If true, the localhost MongoDB will be used; for testing only", required=false)
    protected boolean useLocal = false;
    String dbSpecPath = null;
    @Argument(fullName="dbToUse", shortName="dbToUse", doc="Which database should we connect to?", required=false)
    public DBType dbToUse = DBType.DEFAULT;
    @Argument(shortName="reset", required=false)
    public boolean resetDB = false;

    public MongoDBManager.Locator getLocator() {
        if (this.dbSpecPath == null) {
            this.dbSpecPath = NA12878DBArgumentCollection.getDBSpecPath(this.useLocal);
        }
        InputStream is = this.getInputStream(this.dbSpecPath);
        InputStreamReader reader = new InputStreamReader(is);
        MongoDBManager.Locator tmpLocator = new Gson().fromJson((Reader)reader, MongoDBManager.Locator.class);
        String dbName = tmpLocator.name;
        if (tmpLocator.specVersion == null) {
            dbName = dbName + this.dbToUse.getExtension();
        }
        try {
            ((Reader)reader).close();
            return new MongoDBManager.Locator(tmpLocator.host, tmpLocator.port, dbName, tmpLocator.sitesCollection, tmpLocator.callsetsCollection, tmpLocator.consensusCollection, tmpLocator.label, tmpLocator.specVersion);
        }
        catch (IOException e2) {
            throw new RuntimeException("Failed to close json reader for " + this.dbSpecPath, e2);
        }
    }

    private InputStream getInputStream(String specPath) throws StingException {
        InputStream is = this.getClass().getResourceAsStream(specPath);
        if (is != null) {
            return is;
        }
        if (specPath.toLowerCase().startsWith("http")) {
            try {
                URL url = new URL(specPath);
                return url.openStream();
            }
            catch (MalformedURLException e2) {
                throw new StingException("Malformed url for db spec path", e2);
            }
            catch (IOException e3) {
                throw new StingException("Error opening db spec", e3);
            }
        }
        try {
            return new FileInputStream(specPath);
        }
        catch (FileNotFoundException e4) {
            throw new StingException("db spec path not found", e4);
        }
    }

    public NA12878DBArgumentCollection() {
        this(false);
    }

    private static String getDBSpecPath(boolean useLocal) {
        return useLocal ? LOCALHOST_SPEC_PATH : DEFAULT_SPEC_PATH;
    }

    public NA12878DBArgumentCollection(boolean useLocal) {
        this.useLocal = useLocal;
    }

    public NA12878DBArgumentCollection(String dbSpecPath) {
        this(dbSpecPath, DBType.PRODUCTION);
    }

    public NA12878DBArgumentCollection(String dbSpecPath, DBType dbToUse) {
        this.dbSpecPath = dbSpecPath;
        this.dbToUse = dbToUse;
    }

    public static enum DBType {
        PRODUCTION("_production"),
        DEV("_development"),
        TEST("_test"),
        DEFAULT("_NA"),
        BLANK("");

        private String extension;
        private static final Random rand;

        private DBType(String extension) {
            this.extension = extension;
        }

        public String getExtension() {
            return this.extension.equals("_test") ? String.format("%s_%d_%d", this.extension, System.currentTimeMillis(), rand.nextInt()) : this.extension;
        }

        static {
            rand = new Random();
        }
    }
}

