/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.na12878kb.core;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.Mongo;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.exceptions.StingException;

public final class MongoDBManager {
    private static final Logger logger = Logger.getLogger(MongoDBManager.class);
    private static Map<Locator, DBWrapper> connections = new HashMap<Locator, DBWrapper>(5);

    public static DBWrapper getDB(Locator locator) {
        DBWrapper wrapper = connections.get(locator);
        if (wrapper == null) {
            wrapper = new DBWrapper(locator);
            connections.put(locator, wrapper);
        }
        return wrapper;
    }

    protected static void closeAll() {
        for (DBWrapper wrapper : connections.values()) {
            wrapper.close();
        }
    }

    public static class Locator {
        public final String host;
        public final Integer port;
        public final String name;
        public final String sitesCollection;
        public final String callsetsCollection;
        public final String consensusCollection;
        public final String label;
        public final Integer specVersion;

        public Locator(String host, int port, String name, String sitesCollection, String callsetsCollection, String consensusCollection, String label, Integer specVersion) {
            this.host = host;
            this.port = port;
            this.name = name;
            this.sitesCollection = sitesCollection;
            this.callsetsCollection = callsetsCollection;
            this.consensusCollection = consensusCollection;
            this.label = label;
            this.specVersion = specVersion;
        }

        public String toString() {
            return "Locator{host='" + this.host + '\'' + ", port=" + this.port + ", name='" + this.name + '\'' + '}';
        }
    }

    public static class DBWrapper {
        protected Mongo mongo;
        protected DB mongoDB;
        protected DBCollection sites;
        protected DBCollection callsets;
        protected DBCollection consensus;

        protected Mongo getMongo() {
            return this.mongo;
        }

        protected DBCollection getSites() {
            return this.sites;
        }

        protected DBCollection getCallsets() {
            return this.callsets;
        }

        protected DBCollection getConsensus() {
            return this.consensus;
        }

        protected void close() {
            this.mongo.close();
        }

        protected void delete() {
            this.mongoDB.dropDatabase();
        }

        private DBWrapper(Locator locator) {
            try {
                logger.info("Connecting to MongoDB host=" + locator.host + " port=" + locator.port + " name=" + locator.name);
                this.mongo = new Mongo(locator.host, locator.port);
                this.mongoDB = this.mongo.getDB(locator.name);
                this.sites = this.mongoDB.getCollection(locator.sitesCollection);
                this.callsets = this.mongoDB.getCollection(locator.callsetsCollection);
                this.consensus = this.mongoDB.getCollection(locator.consensusCollection);
            }
            catch (UnknownHostException e2) {
                throw new StingException(e2.getMessage(), e2);
            }
        }
    }
}

