/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.interval;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.tribble.index.interval.Interval;

public class IntervalTree {
    Node root;
    Node NIL;
    int size;

    public IntervalTree() {
        this.root = this.NIL = Node.NIL;
        this.size = 0;
    }

    public void insert(Interval interval) {
        Node node = new Node(interval);
        this.insert(node);
        ++this.size;
    }

    public int getSize() {
        return this.size;
    }

    public List<Interval> findOverlapping(Interval interval) {
        if (this.root().isNull()) {
            return Collections.emptyList();
        }
        ArrayList<Interval> results = new ArrayList<Interval>();
        this.searchAll(interval, this.root(), results);
        return results;
    }

    public String toString() {
        return this.root().toString();
    }

    private List<Interval> searchAll(Interval interval, Node node, List<Interval> results) {
        if (node.interval.overlaps(interval)) {
            results.add(node.interval);
        }
        if (!node.left.isNull() && node.left.max >= interval.start) {
            this.searchAll(interval, node.left, results);
        }
        if (!node.right.isNull() && node.right.min <= interval.end) {
            this.searchAll(interval, node.right, results);
        }
        return results;
    }

    public List<Interval> getIntervals() {
        if (this.root().isNull()) {
            return Collections.emptyList();
        }
        ArrayList<Interval> results = new ArrayList<Interval>(this.size);
        this.getAll(this.root(), results);
        return results;
    }

    private List<Interval> getAll(Node node, List<Interval> results) {
        results.add(node.interval);
        if (!node.left.isNull()) {
            this.getAll(node.left, results);
        }
        if (!node.right.isNull()) {
            this.getAll(node.right, results);
        }
        return results;
    }

    private int getRealMax(Node node) {
        if (node.isNull()) {
            return Integer.MIN_VALUE;
        }
        int leftMax = this.getRealMax(node.left);
        int rightMax = this.getRealMax(node.right);
        int nodeHigh = node.interval.end;
        int max1 = leftMax > rightMax ? leftMax : rightMax;
        return max1 > nodeHigh ? max1 : nodeHigh;
    }

    private int getRealMin(Node node) {
        if (node.isNull()) {
            return Integer.MAX_VALUE;
        }
        int leftMin = this.getRealMin(node.left);
        int rightMin = this.getRealMin(node.right);
        int nodeLow = node.interval.start;
        int min1 = leftMin < rightMin ? leftMin : rightMin;
        return min1 < nodeLow ? min1 : nodeLow;
    }

    private void insert(Node x2) {
        assert (x2 != null);
        assert (!x2.isNull());
        this.treeInsert(x2);
        x2.color = Node.RED;
        while (x2 != this.root && x2.parent.color == Node.RED) {
            Node y;
            if (x2.parent == x2.parent.parent.left) {
                y = x2.parent.parent.right;
                if (y.color == Node.RED) {
                    x2.parent.color = Node.BLACK;
                    y.color = Node.BLACK;
                    x2.parent.parent.color = Node.RED;
                    x2 = x2.parent.parent;
                    continue;
                }
                if (x2 == x2.parent.right) {
                    x2 = x2.parent;
                    this.leftRotate(x2);
                }
                x2.parent.color = Node.BLACK;
                x2.parent.parent.color = Node.RED;
                this.rightRotate(x2.parent.parent);
                continue;
            }
            y = x2.parent.parent.left;
            if (y.color == Node.RED) {
                x2.parent.color = Node.BLACK;
                y.color = Node.BLACK;
                x2.parent.parent.color = Node.RED;
                x2 = x2.parent.parent;
                continue;
            }
            if (x2 == x2.parent.left) {
                x2 = x2.parent;
                this.rightRotate(x2);
            }
            x2.parent.color = Node.BLACK;
            x2.parent.parent.color = Node.RED;
            this.leftRotate(x2.parent.parent);
        }
        this.root.color = Node.BLACK;
    }

    private Node root() {
        return this.root;
    }

    private void leftRotate(Node x2) {
        Node y = x2.right;
        x2.right = y.left;
        if (y.left != this.NIL) {
            y.left.parent = x2;
        }
        y.parent = x2.parent;
        if (x2.parent == this.NIL) {
            this.root = y;
        } else if (x2.parent.left == x2) {
            x2.parent.left = y;
        } else {
            x2.parent.right = y;
        }
        y.left = x2;
        x2.parent = y;
        this.applyUpdate(x2);
    }

    private void rightRotate(Node x2) {
        Node y = x2.left;
        x2.left = y.right;
        if (y.right != this.NIL) {
            y.right.parent = x2;
        }
        y.parent = x2.parent;
        if (x2.parent == this.NIL) {
            this.root = y;
        } else if (x2.parent.right == x2) {
            x2.parent.right = y;
        } else {
            x2.parent.left = y;
        }
        y.right = x2;
        x2.parent = y;
        this.applyUpdate(x2);
    }

    private void treeInsert(Node x2) {
        Node node = this.root;
        Node y = this.NIL;
        while (node != this.NIL) {
            y = node;
            if (x2.interval.start <= node.interval.start) {
                node = node.left;
                continue;
            }
            node = node.right;
        }
        x2.parent = y;
        if (y == this.NIL) {
            this.root = x2;
            x2.left = x2.right = this.NIL;
        } else if (x2.interval.start <= y.interval.start) {
            y.left = x2;
        } else {
            y.right = x2;
        }
        this.applyUpdate(x2);
    }

    private void applyUpdate(Node node) {
        while (!node.isNull()) {
            this.update(node);
            node = node.parent;
        }
    }

    private void update(Node node) {
        node.max = Math.max(Math.max(node.left.max, node.right.max), node.interval.end);
        node.min = Math.min(Math.min(node.left.min, node.right.min), node.interval.start);
    }

    public int size() {
        return this._size(this.root);
    }

    private int _size(Node node) {
        if (node.isNull()) {
            return 0;
        }
        return 1 + this._size(node.left) + this._size(node.right);
    }

    private boolean allRedNodesFollowConstraints(Node node) {
        if (node.isNull()) {
            return true;
        }
        if (node.color == Node.BLACK) {
            return this.allRedNodesFollowConstraints(node.left) && this.allRedNodesFollowConstraints(node.right);
        }
        return node.left.color == Node.BLACK && node.right.color == Node.BLACK && this.allRedNodesFollowConstraints(node.left) && this.allRedNodesFollowConstraints(node.right);
    }

    private boolean isBalancedBlackHeight(Node node) {
        if (node.isNull()) {
            return true;
        }
        return this.blackHeight(node.left) == this.blackHeight(node.right) && this.isBalancedBlackHeight(node.left) && this.isBalancedBlackHeight(node.right);
    }

    private int blackHeight(Node node) {
        if (node.isNull()) {
            return 0;
        }
        int leftBlackHeight = this.blackHeight(node.left);
        if (node.color == Node.BLACK) {
            return leftBlackHeight + 1;
        }
        return leftBlackHeight;
    }

    public boolean isValid() {
        if (this.root.color != Node.BLACK) {
            return false;
        }
        if (this.NIL.color != Node.BLACK) {
            return false;
        }
        if (!this.allRedNodesFollowConstraints(this.root)) {
            return false;
        }
        if (!this.isBalancedBlackHeight(this.root)) {
            return false;
        }
        return this.hasCorrectMaxFields(this.root) && this.hasCorrectMinFields(this.root);
    }

    private boolean hasCorrectMaxFields(Node node) {
        if (node.isNull()) {
            return true;
        }
        return this.getRealMax(node) == node.max && this.hasCorrectMaxFields(node.left) && this.hasCorrectMaxFields(node.right);
    }

    private boolean hasCorrectMinFields(Node node) {
        if (node.isNull()) {
            return true;
        }
        return this.getRealMin(node) == node.min && this.hasCorrectMinFields(node.left) && this.hasCorrectMinFields(node.right);
    }

    static class Node {
        public static boolean BLACK = false;
        public static boolean RED = true;
        Interval interval;
        int min;
        int max = Integer.MIN_VALUE;
        Node left;
        Node right;
        boolean color;
        Node parent;
        static Node NIL = new Node();

        private Node() {
            this.min = Integer.MAX_VALUE;
        }

        public void store(DataOutputStream dos) throws IOException {
            dos.writeInt(this.interval.start);
            dos.writeInt(this.interval.end);
            dos.writeInt(this.min);
            dos.writeInt(this.max);
        }

        public Node(Interval interval) {
            this();
            this.parent = NIL;
            this.left = NIL;
            this.right = NIL;
            this.interval = interval;
            this.color = RED;
        }

        public boolean isNull() {
            return this == NIL;
        }

        public String toString() {
            LinkedHashMap<Interval, Integer> keys = new LinkedHashMap<Interval, Integer>();
            if (this == NIL) {
                return "nil";
            }
            StringBuffer buf = new StringBuffer();
            this._toString(buf, keys);
            buf.append("\n");
            for (Map.Entry entry : keys.entrySet()) {
                buf.append(entry.getValue() + " = " + entry.getKey());
                buf.append("\n");
            }
            return buf.toString();
        }

        public void _toString(StringBuffer buf, Map<Interval, Integer> keys) {
            Integer rightKey;
            Integer leftKey;
            if (this == NIL) {
                buf.append("nil");
                buf.append("\n");
                return;
            }
            Integer selfKey = keys.get(this.interval);
            if (selfKey == null) {
                selfKey = keys.size();
                keys.put(this.interval, selfKey);
            }
            if ((leftKey = keys.get(this.left.interval)) == null) {
                leftKey = keys.size();
                keys.put(this.left.interval, leftKey);
            }
            if ((rightKey = keys.get(this.right.interval)) == null) {
                rightKey = keys.size();
                keys.put(this.right.interval, rightKey);
            }
            buf.append(selfKey + " -> " + leftKey + " , " + rightKey);
            buf.append("\n");
            this.left._toString(buf, keys);
            this.right._toString(buf, keys);
        }

        static {
            Node.NIL.color = BLACK;
            Node.NIL.parent = NIL;
            Node.NIL.left = NIL;
            Node.NIL.right = NIL;
        }
    }
}

