/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.example;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.BasicFeature;
import org.broad.tribble.BinaryFeatureCodec;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.FeatureReader;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.LineIterator;
import org.broad.tribble.readers.PositionalBufferedStream;

public class ExampleBinaryCodec
extends BinaryFeatureCodec<Feature> {
    public static final String HEADER_LINE = "# BinaryTestFeature";

    @Override
    public Feature decodeLoc(PositionalBufferedStream stream) throws IOException {
        return this.decode(stream);
    }

    @Override
    public Feature decode(PositionalBufferedStream stream) throws IOException {
        DataInputStream dis = new DataInputStream(stream);
        String contig = dis.readUTF();
        int start = dis.readInt();
        int stop = dis.readInt();
        return new BasicFeature(contig, start, stop);
    }

    @Override
    public FeatureCodecHeader readHeader(PositionalBufferedStream stream) throws IOException {
        AsciiLineReader nonReadAheadLineReader = new AsciiLineReader(stream);
        ArrayList<String> headerLines = new ArrayList<String>();
        long headerLengthInBytes = 0L;
        while (stream.peek() == 35) {
            headerLines.add(nonReadAheadLineReader.readLine());
            headerLengthInBytes = stream.getPosition();
        }
        return new FeatureCodecHeader(headerLines, headerLengthInBytes);
    }

    @Override
    public Class<Feature> getFeatureType() {
        return Feature.class;
    }

    @Override
    public boolean canDecode(String path) {
        return false;
    }

    public static <FEATURE_TYPE extends Feature> void convertToBinaryTest(File source, File dest, FeatureCodec<FEATURE_TYPE, LineIterator> codec) throws IOException {
        AbstractFeatureReader<FEATURE_TYPE, LineIterator> reader = AbstractFeatureReader.getFeatureReader(source.getAbsolutePath(), codec, false);
        FileOutputStream output = new FileOutputStream(dest);
        ExampleBinaryCodec.convertToBinaryTest(reader, output);
    }

    public static <FEATURE_TYPE extends Feature> void convertToBinaryTest(FeatureReader<FEATURE_TYPE> reader, OutputStream out) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        dos.writeBytes("# BinaryTestFeature\n");
        CloseableTribbleIterator<FEATURE_TYPE> it = reader.iterator();
        while (it.hasNext()) {
            Feature f2 = (Feature)it.next();
            dos.writeUTF(f2.getChr());
            dos.writeInt(f2.getStart());
            dos.writeInt(f2.getEnd());
        }
        dos.close();
        reader.close();
    }
}

