/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import junit.framework.Assert;
import net.sf.samtools.seekablestream.SeekableStream;
import net.sf.samtools.util.ftp.FTPClient;
import net.sf.samtools.util.ftp.FTPReply;
import org.apache.log4j.Logger;
import org.broad.igv.util.UserPasswordInputImpl;
import org.broad.igv.util.ftp.FTPUtils;

public class IGVSeekableFTPStream
extends SeekableStream {
    private static Logger log = Logger.getLogger(IGVSeekableFTPStream.class);
    private long position = 0L;
    private String host;
    private String path;
    private String userInfo;
    FTPClient ftp = null;
    private String source;
    private long length = -1L;

    public IGVSeekableFTPStream(URL url) throws IOException {
        this.source = url.toExternalForm();
        this.userInfo = url.getUserInfo();
        this.host = url.getHost();
        this.path = url.getPath();
        this.ftp = FTPUtils.connect(this.host, this.userInfo, new UserPasswordInputImpl());
    }

    @Override
    public void seek(long position) {
        this.position = position;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public boolean eof() throws IOException {
        return this.position() >= this.length();
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public long length() {
        if (this.length < 0L) {
            this.length = this.getLength();
        }
        return this.length;
    }

    private long getLength() {
        try {
            FTPReply reply = this.ftp.size(this.path);
            if (reply.isSuccess()) {
                return Long.parseLong(reply.getReplyString());
            }
        }
        catch (IOException e2) {
            log.error("Error getting length. " + e2.getMessage(), e2);
        }
        return -1L;
    }

    @Override
    public long skip(long n2) throws IOException {
        long bytesToSkip = n2;
        this.position += bytesToSkip;
        this.ftp.setRestPosition(this.position);
        return bytesToSkip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (this.ftp == null) {
            this.ftp = FTPUtils.connect(this.host, this.userInfo, new UserPasswordInputImpl());
        }
        if (offset < 0 || len < 0 || offset + len > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            FTPReply reply = this.ftp.pasv();
            Assert.assertTrue((boolean)reply.isSuccess());
            if (this.position > 0L) {
                this.ftp.setRestPosition(this.position);
            }
            reply = this.ftp.retr(this.path);
            InputStream is = this.ftp.getDataStream();
            while (n2 < len) {
                int count = is.read(buffer, offset + n2, len - n2);
                if (count < 0) {
                    if (n2 != 0) break;
                    int n3 = -1;
                    return n3;
                }
                n2 += count;
            }
            this.position += (long)n2;
            int n4 = n2;
            return n4;
        }
        catch (EOFException e2) {
            if (n2 < 0) {
                int n5 = -1;
                return n5;
            }
            this.position += (long)n2;
            int n6 = n2;
            return n6;
        }
        finally {
            this.ftp.disconnect();
            this.ftp = null;
        }
    }

    private void reconnect() throws IOException {
        if (this.ftp != null) {
            this.ftp.disconnect();
        }
        this.ftp = FTPUtils.connect(this.host, this.userInfo, new UserPasswordInputImpl());
    }

    @Override
    public void close() throws IOException {
        log.debug("close");
        if (this.ftp != null) {
            this.ftp.disconnect();
            this.ftp = null;
        }
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("read() is not supported on SeekableHTTPStream.  Must read in blocks.");
    }
}

