/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import com.jidesoft.plaf.LookAndFeelFactory;
import jargs.gnu.CmdLineParser;
import java.awt.Color;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import net.sf.samtools.seekablestream.SeekableStreamFactory;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.ui.DefaultExceptionHandler;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.ShutdownThread;
import org.broad.igv.ui.VersionUpdateDialog;
import org.broad.igv.ui.event.GlobalKeyDispatcher;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.RuntimeUtils;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class Main {
    private static Logger log = Logger.getLogger(Main.class);

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new DefaultExceptionHandler());
        Main.initApplication();
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        ImageIcon icon = new ImageIcon(Main.class.getResource("mainframeicon.png"));
        if (icon != null) {
            frame.setIconImage(icon.getImage());
        }
        Main.open(frame, args);
    }

    private static void initApplication() {
        int MB;
        long mem = RuntimeUtils.getAvailableMemory();
        if (mem < (long)(400 * (MB = 1000000))) {
            int mb = (int)(mem / (long)MB);
            JOptionPane.showMessageDialog(null, "Warning: IGV is running with minimal available memory (" + mb + " mb)");
        }
        DirectoryManager.initializeLog();
        log.info("Startup  " + Globals.applicationString());
        log.info("Java " + System.getProperty("java.version"));
        log.info("Default User Directory: " + DirectoryManager.getUserDirectory());
        log.info("OS: " + System.getProperty("os.name"));
        System.setProperty("http.agent", Globals.applicationString());
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        Main.updateTooltipSettings();
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        Main.checkVersion();
    }

    public static void updateTooltipSettings() {
        ToolTipManager.sharedInstance().setEnabled(true);
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        ToolTipManager.sharedInstance().setInitialDelay(prefMgr.getAsInt("TOOLTIP.INITIAL_DELAY"));
        ToolTipManager.sharedInstance().setReshowDelay(prefMgr.getAsInt("TOOLTIP.RESHOW_DELAY"));
        ToolTipManager.sharedInstance().setDismissDelay(prefMgr.getAsInt("TOOLTIP.DISMISS_DELAY"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkVersion() {
        int readTimeout = Globals.READ_TIMEOUT;
        int connectTimeout = Globals.CONNECT_TIMEOUT;
        try {
            Version thisVersion = Version.getVersion(Globals.VERSION);
            if (thisVersion == null) {
                return;
            }
            Globals.CONNECT_TIMEOUT = 5000;
            Globals.READ_TIMEOUT = 1000;
            final String serverVersionString = HttpUtils.getInstance().getContentsAsString(new URL(Globals.getVersionURL())).trim();
            final String skipString = PreferenceManager.getInstance().get("SKIP_VERSION");
            HashSet<String> skipVersion = new HashSet<String>(Arrays.asList(skipString.split(",")));
            if (skipVersion.contains(serverVersionString)) {
                return;
            }
            Version serverVersion = Version.getVersion(serverVersionString.trim());
            if (serverVersion == null) {
                return;
            }
            if (thisVersion.lessThan(serverVersion)) {
                final VersionUpdateDialog dlg = new VersionUpdateDialog(serverVersionString);
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        dlg.setVisible(true);
                        if (dlg.isSkipVersion()) {
                            String newSkipString = skipString + "," + serverVersionString;
                            PreferenceManager.getInstance().put("SKIP_VERSION", newSkipString);
                        }
                    }
                });
            }
        }
        catch (Exception e2) {
            log.error("Error checking version", e2);
        }
        finally {
            Globals.CONNECT_TIMEOUT = connectTimeout;
            Globals.READ_TIMEOUT = readTimeout;
        }
    }

    public static void open(Frame frame) {
        Main.open(frame, new String[0]);
    }

    public static void open(Frame frame, String[] args) {
        if (!(frame instanceof JFrame)) {
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    windowEvent.getComponent().setVisible(false);
                }
            });
        }
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e2) {
                ToolTipManager.sharedInstance().setEnabled(true);
            }

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                this.windowActivated(windowEvent);
            }
        });
        Main.initializeLookAndFeel();
        IGVArgs igvArgs = new IGVArgs(args);
        if (igvArgs.getPropertyOverrides() != null) {
            PreferenceManager.getInstance().loadOverrides(igvArgs.getPropertyOverrides());
        }
        if (igvArgs.getDataServerURL() != null) {
            PreferenceManager.getInstance().overrideDataServerURL(igvArgs.getDataServerURL());
        }
        if (igvArgs.getGenomeServerURL() != null) {
            PreferenceManager.getInstance().overrideGenomeServerURL(igvArgs.getGenomeServerURL());
        }
        HttpUtils.getInstance().updateProxySettings();
        SeekableStreamFactory.setInstance(IGVSeekableStreamFactory.getInstance());
        RuntimeUtils.loadPluginJars();
        IGV.createInstance(frame).startUp(igvArgs);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new GlobalKeyDispatcher());
    }

    private static void initializeLookAndFeel() {
        try {
            String lnf = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(lnf);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (Globals.IS_LINUX) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                UIManager.put("JideSplitPane.dividerSize", 5);
                UIManager.put("JideSplitPaneDivider.background", Color.darkGray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        LookAndFeelFactory.installJideExtension();
    }

    public static class IGVArgs {
        private String batchFile = null;
        private String sessionFile = null;
        private String dataFileString = null;
        private String locusString = null;
        private String propertyOverrides = null;
        private String genomeId = null;
        private String port = null;
        private String dataServerURL = null;
        private String genomeServerURL = null;
        private String indexFile = null;
        private String coverageFile = null;
        private String name = null;

        IGVArgs(String[] args) {
            if (args != null) {
                this.parseArgs(args);
            }
        }

        private void parseArgs(String[] args) {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option propertyFileOption = parser.addStringOption('o', "preferences");
            CmdLineParser.Option batchFileOption = parser.addStringOption('b', "batch");
            CmdLineParser.Option portOption = parser.addStringOption('p', "port");
            CmdLineParser.Option genomeOption = parser.addStringOption('g', "genome");
            CmdLineParser.Option dataServerOption = parser.addStringOption('d', "dataServerURL");
            CmdLineParser.Option genomeServerOption = parser.addStringOption('u', "genomeServerURL");
            CmdLineParser.Option indexFileOption = parser.addStringOption('i', "indexFile");
            CmdLineParser.Option coverageFileOption = parser.addStringOption('c', "coverageFile");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            try {
                parser.parse(args);
            }
            catch (CmdLineParser.IllegalOptionValueException e2) {
                e2.printStackTrace();
            }
            catch (CmdLineParser.UnknownOptionException e3) {
                e3.printStackTrace();
            }
            this.propertyOverrides = (String)parser.getOptionValue(propertyFileOption);
            this.batchFile = (String)parser.getOptionValue(batchFileOption);
            this.port = (String)parser.getOptionValue(portOption);
            this.genomeId = (String)parser.getOptionValue(genomeOption);
            this.dataServerURL = (String)parser.getOptionValue(dataServerOption);
            this.genomeServerURL = (String)parser.getOptionValue(genomeServerOption);
            this.indexFile = (String)parser.getOptionValue(indexFileOption);
            this.coverageFile = (String)parser.getOptionValue(coverageFileOption);
            this.name = (String)parser.getOptionValue(nameOption);
            String[] nonOptionArgs = parser.getRemainingArgs();
            if (nonOptionArgs != null && nonOptionArgs.length > 0) {
                String firstArg = nonOptionArgs[0];
                if (firstArg != null && !firstArg.equals("ignore")) {
                    log.info("Loading: " + firstArg);
                    if (firstArg.endsWith(".xml") || firstArg.endsWith(".php") || firstArg.endsWith(".php3") || firstArg.endsWith(".session")) {
                        this.sessionFile = firstArg;
                    } else {
                        this.dataFileString = firstArg;
                    }
                }
                if (nonOptionArgs.length > 1) {
                    this.locusString = nonOptionArgs[1];
                }
            }
        }

        private String checkEqualsAndExtractParamter(String arg) {
            if (arg == null) {
                return null;
            }
            int eq = arg.indexOf("=");
            if (eq > 0) {
                String key = arg.substring(0, eq);
                String val = arg.substring(eq + 1);
                if (key.equalsIgnoreCase("server")) {
                    PreferenceManager.getInstance().put("IONTORRENT.SERVER", val);
                    log.info("Got server: " + key + "=" + val);
                    return null;
                }
                if (key.equalsIgnoreCase("sessionURL") || key.equalsIgnoreCase("file")) {
                    if (val.endsWith(".xml") || val.endsWith(".php") || val.endsWith(".php3") || val.endsWith(".session")) {
                        log.info("Got session: " + key + "=" + val);
                        this.sessionFile = val;
                    } else {
                        log.info("Got dataFileString: " + key + "=" + val);
                        this.dataFileString = val;
                    }
                    return null;
                }
                if (key.equalsIgnoreCase("locus") || key.equalsIgnoreCase("position")) {
                    log.info("Got locus: " + key + "=" + val);
                    this.locusString = val;
                    return null;
                }
                log.info("Currently not handled: " + key + "=" + val);
                return null;
            }
            return arg;
        }

        public String getBatchFile() {
            return this.batchFile;
        }

        public String getSessionFile() {
            return this.sessionFile;
        }

        public String getDataFileString() {
            return this.dataFileString;
        }

        public String getLocusString() {
            return this.locusString;
        }

        public String getPropertyOverrides() {
            return this.propertyOverrides;
        }

        public String getGenomeId() {
            return this.genomeId;
        }

        public String getPort() {
            return this.port;
        }

        public String getDataServerURL() {
            return this.dataServerURL;
        }

        public String getGenomeServerURL() {
            return this.genomeServerURL;
        }

        public String getIndexFile() {
            return this.indexFile;
        }

        public String getCoverageFile() {
            return this.coverageFile;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Version {
        private int major;
        private int minor;
        private int build;

        public static Version getVersion(String versionString) {
            String[] tokens = versionString.split("\\.");
            if (tokens.length < 2) {
                return null;
            }
            try {
                int major = Integer.parseInt(tokens[0]);
                int minor = Integer.parseInt(tokens[1]);
                int build = tokens.length <= 2 ? 0 : Integer.parseInt(tokens[2]);
                return new Version(major, minor, build);
            }
            catch (NumberFormatException e2) {
                log.error("Error parsing version string: " + versionString);
                return null;
            }
        }

        private Version(int major, int minor, int build) {
            this.major = major;
            this.minor = minor;
            this.build = build;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getBuild() {
            return this.build;
        }

        public boolean lessThan(Version anotherVersion) {
            if (anotherVersion.major > this.major) {
                return true;
            }
            if (anotherVersion.major < this.major) {
                return false;
            }
            if (anotherVersion.minor > this.minor) {
                return true;
            }
            if (anotherVersion.minor < this.minor) {
                return false;
            }
            return anotherVersion.build > this.build;
        }
    }
}

