/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.data.AbstractDataSource;
import org.broad.igv.data.DataTile;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.collections.CollUtils;
import org.broad.tribble.Feature;

public class FeatureCollectionSource
implements FeatureSource {
    private TrackType type;
    private Map<String, List<Feature>> featureMap;
    CoverageDataSource coverageData;
    Genome genome;

    public FeatureCollectionSource(Iterable<? extends Feature> allFeatures, Genome genome) {
        this.genome = genome;
        this.initFeatures(allFeatures);
        this.coverageData = new CoverageDataSource(genome);
        this.coverageData.computeGenomeCoverage();
        this.sampleGenomeFeatures();
    }

    public Class getFeatureClass() {
        return IGVFeature.class;
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int startLocation, int endLocation, int zoom) {
        return this.coverageData == null ? Collections.emptyList() : this.coverageData.getSummaryScoresForRange(chr, startLocation, endLocation, zoom);
    }

    public Iterator<Feature> getFeatures(String chr, int start, int end) {
        return this.getFeatureList(chr, start, end).iterator();
    }

    public List<Feature> getFeatureList(String chr, int start, int end) {
        List<Feature> features = this.featureMap.get(chr);
        if (features == null) {
            return Collections.emptyList();
        }
        List<Feature> filteredFeatures = CollUtils.filter(features, FeatureUtils.getOverlapPredicate(chr, start, end));
        return filteredFeatures;
    }

    public List<Feature> getFeatures(String chr) {
        return this.featureMap.get(chr);
    }

    public Set<String> getChrs() {
        return this.featureMap.keySet();
    }

    @Override
    public int getFeatureWindowSize() {
        return 0;
    }

    @Override
    public void setFeatureWindowSize(int size) {
    }

    private void initFeatures(Iterable<? extends Feature> allFeatures) {
        this.featureMap = new HashMap<String, List<Feature>>();
        for (Feature feature : allFeatures) {
            List<Feature> fList = this.featureMap.get(feature.getChr());
            if (fList == null) {
                fList = new ArrayList<Feature>();
                this.featureMap.put(feature.getChr(), fList);
            }
            fList.add(feature);
        }
        for (List list : this.featureMap.values()) {
            FeatureUtils.sortFeatureList(list);
        }
        if (this.featureMap.size() < 100) {
            this.sampleGenomeFeatures();
        }
    }

    private void setFeatures(String chr, List<Feature> features) {
        FeatureUtils.sortFeatureList(features);
        this.featureMap.put(chr, features);
    }

    public TrackType getType() {
        return this.type;
    }

    public void setType(TrackType type) {
        this.type = type;
    }

    protected void sampleGenomeFeatures() {
        ArrayList<Feature> chrAllFeatures = new ArrayList<Feature>(1000);
        int sampleLength = (int)((double)this.genome.getNominalLength() / 700000.0);
        int lastFeaturePosition = -1;
        for (String chr : this.genome.getLongChromosomeNames()) {
            List<Feature> features = this.getFeatures(chr);
            if (features == null) continue;
            long offset = this.genome.getCumulativeOffset(chr);
            for (Feature feature : features) {
                if (!(feature instanceof IGVFeature)) continue;
                IGVFeature f2 = (IGVFeature)feature;
                int genStart = (int)((offset + (long)f2.getStart()) / 1000L);
                int genEnd = (int)((offset + (long)f2.getEnd()) / 1000L);
                if (genEnd <= lastFeaturePosition + sampleLength) continue;
                BasicFeature f22 = new BasicFeature("All", genStart, genEnd);
                if (f2 instanceof BasicFeature) {
                    BasicFeature bf = (BasicFeature)f2;
                    f22.setThickEnd((int)((offset + (long)bf.getThickEnd()) / 1000L));
                    f22.setThickStart((int)((offset + (long)bf.getThickStart()) / 1000L));
                    f22.setName(f2.getName());
                }
                chrAllFeatures.add(f22);
                lastFeaturePosition = genEnd;
            }
        }
        this.setFeatures("All", chrAllFeatures);
    }

    protected void computeGenomeCoverage() {
        int nBins = 1000;
        int[] starts = new int[nBins];
        int[] ends = new int[nBins];
        float[] values = new float[nBins];
        Arrays.fill(values, 0.0f);
        Genome currentGenome = GenomeManager.getInstance().getCurrentGenome();
        double step = (double)currentGenome.getNominalLength() / 1000.0 / (double)nBins;
        for (int i2 = 0; i2 < nBins; ++i2) {
            starts[i2] = (int)((double)i2 * step);
            ends[i2] = (int)((double)(i2 + 1) * step);
        }
        for (String chr : currentGenome.getLongChromosomeNames()) {
            List<Feature> features = this.featureMap.get(chr);
            if (features == null) continue;
            long offset = currentGenome.getCumulativeOffset(chr);
            for (Feature f2 : features) {
                int genStart = (int)((offset + (long)f2.getStart()) / 1000L);
                int genEnd = (int)((offset + (long)f2.getEnd()) / 1000L);
                int binStart = (int)((double)genStart / step);
                int binEnd = (int)((double)genEnd / step);
                for (int i3 = binStart; i3 <= binEnd; ++i3) {
                    values[i3] = values[i3] + 1.0f;
                }
            }
        }
        this.coverageData.dataCache.put("All", new DataTile(starts, ends, values, null));
    }

    class CoverageDataSource
    extends AbstractDataSource {
        int windowSize;
        double dataMin;
        double dataMax;
        Map<String, DataTile> dataCache;

        CoverageDataSource(Genome genome) {
            super(genome);
            this.windowSize = 1000;
            this.dataMin = 0.0;
            this.dataMax = 0.0;
            this.dataCache = new HashMap<String, DataTile>();
        }

        @Override
        protected DataTile getRawData(String chr, int startLocation, int endLocation) {
            DataTile coverageData = this.dataCache.get(chr);
            if (coverageData == null) {
                coverageData = this.computeCoverage(chr, startLocation, endLocation);
                this.dataCache.put(chr, coverageData);
            }
            return coverageData;
        }

        @Override
        protected List<LocusScore> getPrecomputedSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
            return null;
        }

        @Override
        public int getLongestFeature(String chr) {
            return this.windowSize;
        }

        @Override
        public double getDataMax() {
            return this.dataMax;
        }

        @Override
        public double getDataMin() {
            return this.dataMin;
        }

        @Override
        public TrackType getTrackType() {
            return TrackType.OTHER;
        }

        private DataTile computeCoverage(String chr, int start, int end) {
            int nBins = (end - start) / this.windowSize + 1;
            int[] starts = new int[nBins];
            int[] ends = new int[nBins];
            for (int i2 = 0; i2 < nBins; ++i2) {
                starts[i2] = start + i2 * this.windowSize;
                ends[i2] = starts[i2] + this.windowSize;
            }
            float[] values = new float[nBins];
            List features = (List)FeatureCollectionSource.this.featureMap.get(chr);
            if (features != null) {
                for (Feature f2 : features) {
                    int startBin = f2.getStart() / this.windowSize;
                    int endBin = f2.getEnd() / this.windowSize;
                    for (int i3 = startBin; i3 < endBin; ++i3) {
                        values[i3] = values[i3] + 1.0f;
                        this.dataMax = Math.max(this.dataMax, (double)values[i3]);
                    }
                }
            }
            return new DataTile(starts, ends, values, null);
        }

        protected void computeGenomeCoverage() {
            int nBins = 1000;
            int[] starts = new int[nBins];
            int[] ends = new int[nBins];
            float[] values = new float[nBins];
            Arrays.fill(values, 0.0f);
            double step = (double)this.genome.getNominalLength() / 1000.0 / (double)nBins;
            for (int i2 = 0; i2 < nBins; ++i2) {
                starts[i2] = (int)((double)i2 * step);
                ends[i2] = (int)((double)(i2 + 1) * step);
            }
            for (String chr : this.genome.getLongChromosomeNames()) {
                List features = (List)FeatureCollectionSource.this.featureMap.get(chr);
                if (features == null) continue;
                long offset = this.genome.getCumulativeOffset(chr);
                for (Feature f2 : features) {
                    int genStart = (int)((offset + (long)f2.getStart()) / 1000L);
                    int genEnd = (int)((offset + (long)f2.getEnd()) / 1000L);
                    int binStart = Math.min(values.length - 1, (int)((double)genStart / step));
                    int binEnd = Math.min(values.length - 1, (int)((double)genEnd / step));
                    for (int i3 = binStart; i3 <= binEnd; ++i3) {
                        values[i3] = values[i3] + 1.0f;
                        this.dataMax = Math.max(this.dataMax, (double)values[i3]);
                    }
                }
            }
            this.dataCache.put("All", new DataTile(starts, ends, values, null));
        }

        public String getValueString(String chr, double position, ReferenceFrame frame) {
            int zoom = Math.max(0, frame.getZoom());
            List<LocusScore> scores = this.getSummaryScoresForRange(chr, (int)position - 10, (int)position + 10, zoom);
            double bpPerPixel = frame.getScale();
            int minWidth = (int)(2.0 * bpPerPixel);
            if (scores == null) {
                return "";
            }
            LocusScore score = FeatureUtils.getFeatureAt(position, minWidth, scores);
            return score == null ? "" : "Mean count: " + score.getScore();
        }
    }
}

