/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import net.sf.samtools.util.StringUtil;

public class AlignmentUtils {
    public static boolean compareBases(byte refbase, byte readbase) {
        if (readbase == 61) {
            return true;
        }
        if (refbase > 90) {
            refbase = (byte)(refbase - 32);
        }
        if (readbase > 90) {
            readbase = (byte)(readbase - 32);
        }
        if (refbase == readbase) {
            return true;
        }
        switch (refbase) {
            case 78: {
                return true;
            }
            case 85: {
                return readbase == 84;
            }
            case 77: {
                return readbase == 65 || readbase == 67;
            }
            case 82: {
                return readbase == 65 || readbase == 71;
            }
            case 87: {
                return readbase == 65 || readbase == 84;
            }
            case 83: {
                return readbase == 67 || readbase == 71;
            }
            case 89: {
                return readbase == 67 || readbase == 84;
            }
            case 75: {
                return readbase == 71 || readbase == 84;
            }
            case 86: {
                return readbase == 65 || readbase == 67 || readbase == 71;
            }
            case 72: {
                return readbase == 65 || readbase == 67 || readbase == 84;
            }
            case 68: {
                return readbase == 65 || readbase == 71 || readbase == 84;
            }
            case 66: {
                return readbase == 67 || readbase == 71 || readbase == 84;
            }
        }
        return false;
    }

    static boolean isMisMatch(byte[] reference, byte[] read, boolean isSoftClipped, int idx) {
        if (reference == null) {
            return false;
        }
        boolean misMatch = false;
        if (isSoftClipped) {
            byte readbase = read[idx];
            misMatch = readbase != 61;
        } else {
            int referenceLength = reference.length;
            byte refbase = idx < referenceLength ? reference[idx] : (byte)0;
            byte readbase = read[idx];
            misMatch = readbase != 61 && idx < referenceLength && refbase != 0 && !AlignmentUtils.compareBases(refbase, readbase);
        }
        return misMatch;
    }

    public static byte[] reverseComplementCopy(byte[] bases) {
        int lastIndex = bases.length - 1;
        byte[] out = new byte[bases.length];
        for (int i2 = 0; i2 <= lastIndex; ++i2) {
            out[lastIndex - i2] = AlignmentUtils.complement(bases[i2]);
        }
        return out;
    }

    public static void reverseComplement(byte[] bases) {
        int lastIndex = bases.length - 1;
        int i2 = 0;
        for (int j2 = lastIndex; i2 < j2; ++i2, --j2) {
            byte tmp = AlignmentUtils.complement(bases[i2]);
            bases[i2] = AlignmentUtils.complement(bases[j2]);
            bases[j2] = tmp;
        }
        if (bases.length % 2 == 1) {
            bases[i2] = AlignmentUtils.complement(bases[i2]);
        }
    }

    public static final byte complement(byte b2) {
        switch (b2) {
            case 97: {
                return 116;
            }
            case 99: {
                return 103;
            }
            case 103: {
                return 99;
            }
            case 116: {
                return 97;
            }
            case 65: {
                return 84;
            }
            case 67: {
                return 71;
            }
            case 71: {
                return 67;
            }
            case 84: {
                return 65;
            }
        }
        return b2;
    }

    public static String reverseComplement(String sequenceData) {
        byte[] bases = StringUtil.stringToBytes(sequenceData);
        AlignmentUtils.reverseComplement(bases);
        return StringUtil.bytesToString(bases);
    }
}

