/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import com.iontorrent.data.FlowDistribution;
import com.iontorrent.data.ReadInfo;
import com.iontorrent.utils.LocationListener;
import com.iontorrent.utils.SimpleDialog;
import com.iontorrent.views.FlowSignalDistributionPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.genome.ChromosomeNameComparator;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.goby.GobyCountArchiveDataSource;
import org.broad.igv.lists.GeneList;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.DownsampledInterval;
import org.broad.igv.sam.FeatureRenderer;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PackedAlignments;
import org.broad.igv.sam.PairedAlignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.Row;
import org.broad.igv.sam.SpliceJunctionFinderTrack;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.session.Session;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.tools.PFMExporter;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.InsertSizeSettingsDialog;
import org.broad.igv.ui.SashimiPlot;
import org.broad.igv.ui.color.ColorTable;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.color.PaletteColorTable;
import org.broad.igv.ui.event.AlignmentTrackEvent;
import org.broad.igv.ui.event.AlignmentTrackEventListener;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.Pair;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.Utilities;
import org.broad.igv.util.blat.BlatClient;
import org.broad.igv.util.collections.CollUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@XmlType(factoryMethod="getNextTrack")
@XmlSeeAlso(value={RenderOptions.class})
public class AlignmentTrack
extends AbstractTrack
implements AlignmentTrackEventListener {
    private static Logger log = Logger.getLogger(AlignmentTrack.class);
    static final int GROUP_MARGIN = 5;
    static final int TOP_MARGIN = 20;
    static final int DS_MARGIN_0 = 2;
    static final int DOWNAMPLED_ROW_HEIGHT = 3;
    static final int DS_MARGIN_2 = 5;
    private boolean showSpliceJunctions;
    protected static final Map<BisulfiteContext, String> bisulfiteContextToPubString = new HashMap<BisulfiteContext, String>();
    protected static final Map<BisulfiteContext, Pair<byte[], byte[]>> bisulfiteContextToContextString;
    static final ShadeBasesOption DEFAULT_SHADE_BASES_OPTION;
    static final ColorOption DEFAULT_COLOR_OPTION;
    static final boolean DEFAULT_SHOWALLBASES = false;
    static final BisulfiteContext DEFAULT_BISULFITE_CONTEXT;
    private boolean ionTorrent;
    private SequenceTrack sequenceTrack;
    private CoverageTrack coverageTrack;
    private SpliceJunctionFinderTrack spliceJunctionTrack;
    private RenderOptions renderOptions = new RenderOptions();
    private int expandedHeight = 14;
    private int maxSquishedHeight;
    private int squishedHeight = this.maxSquishedHeight = 4;
    private FeatureRenderer renderer;
    private double minVisibleScale = 25.0;
    private HashMap<String, Color> selectedReadNames = new HashMap();
    private int selectionColorIndex = 0;
    private int minHeight = 50;
    private AlignmentDataManager dataManager;
    private Genome genome;
    JComponent parent;
    private Rectangle alignmentsRect;
    private Rectangle downsampleRect;
    private ColorTable readNamePalette;

    public AlignmentTrack(ResourceLocator locator, AlignmentDataManager dataManager, Genome genome) {
        super(locator);
        this.genome = genome;
        this.dataManager = dataManager;
        this.ionTorrent = dataManager.isIonTorrent();
        this.minimumHeight = 50;
        this.maximumHeight = Integer.MAX_VALUE;
        PreferenceManager prefs = PreferenceManager.getInstance();
        this.setShowSpliceJunctions(prefs.getAsBoolean("SAM.SHOW_JUNCTION_TRACK"));
        float maxRange = prefs.getAsFloat("SAM.MAX_VISIBLE_RANGE");
        this.minVisibleScale = maxRange * 1000.0f / 700.0f;
        this.renderer = AlignmentRenderer.getInstance();
        this.setDisplayMode(Track.DisplayMode.EXPANDED);
        if (prefs.getAsBoolean("SAM.SHOW_REF_SEQ")) {
            this.sequenceTrack = new SequenceTrack("Reference sequence");
            this.sequenceTrack.setHeight(14);
        }
        if (this.renderOptions.getColorOption() == ColorOption.BISULFITE) {
            this.setExperimentType(ExperimentType.BISULFITE);
        }
        this.readNamePalette = new PaletteColorTable(ColorUtilities.getDefaultPalette());
        if (!Globals.isHeadless()) {
            IGV.getInstance().addAlignmentTrackEventListener(this);
        }
    }

    public void setExperimentType(ExperimentType type) {
        this.dataManager.setExperimentType(type);
        if (this.spliceJunctionTrack != null) {
            this.spliceJunctionTrack.setVisible(type != ExperimentType.BISULFITE);
        }
    }

    public void setCoverageTrack(CoverageTrack coverageTrack) {
        this.coverageTrack = coverageTrack;
        this.coverageTrack.setRenderOptions(this.renderOptions);
    }

    @XmlElement(name="RenderOptions")
    private void setRenderOptions(RenderOptions renderOptions) {
        this.renderOptions = renderOptions;
        if (this.coverageTrack != null) {
            this.coverageTrack.setRenderOptions(this.renderOptions);
        }
    }

    private RenderOptions getRenderOptions() {
        return this.renderOptions;
    }

    public CoverageTrack getCoverageTrack() {
        return this.coverageTrack;
    }

    public void setSpliceJunctionTrack(SpliceJunctionFinderTrack spliceJunctionTrack) {
        this.spliceJunctionTrack = spliceJunctionTrack;
        if (this.dataManager.getExperimentType() == ExperimentType.BISULFITE) {
            spliceJunctionTrack.setVisible(false);
        }
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        return new PopupMenu(te);
    }

    @Override
    public void setHeight(int preferredHeight) {
        super.setHeight(preferredHeight);
        this.minimumHeight = preferredHeight;
    }

    @Override
    public int getHeight() {
        if (this.parent != null && this.parent instanceof DataPanel && ((DataPanel)this.parent).getFrame().getScale() > this.minVisibleScale) {
            return this.minimumHeight;
        }
        int nGroups = this.dataManager.getMaxGroupCount();
        int h2 = Math.max(this.minHeight, this.getNLevels() * this.getRowHeight() + nGroups * 5 + 20 + 2 + 3 + 5);
        h2 = Math.min(this.maximumHeight, h2);
        return h2;
    }

    private int getRowHeight() {
        return this.getDisplayMode() == Track.DisplayMode.EXPANDED ? this.expandedHeight : this.squishedHeight;
    }

    private int getNLevels() {
        return this.dataManager.getNLevels();
    }

    @Override
    public void load(RenderContext context) {
        this.dataManager.load(context, this.renderOptions, true);
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        int seqHeight;
        this.parent = context.getPanel();
        int n2 = seqHeight = this.sequenceTrack == null ? 0 : this.sequenceTrack.getHeight();
        if (seqHeight > 0) {
            Rectangle seqRect = new Rectangle(rect);
            seqRect.height = seqHeight;
            this.sequenceTrack.render(context, seqRect);
        }
        rect.y += 2;
        if (context.getScale() > this.minVisibleScale) {
            Rectangle visibleRect = context.getVisibleRect().intersection(rect);
            Graphics2D g2 = context.getGraphic2DForColor(Color.gray);
            GraphicUtils.drawCenteredText("Zoom in to see alignments.", visibleRect, g2);
            return;
        }
        this.downsampleRect = new Rectangle(rect);
        this.downsampleRect.height = 3;
        this.renderDownsampledIntervals(context, this.downsampleRect);
        this.alignmentsRect = new Rectangle(rect);
        this.alignmentsRect.y += 8;
        this.renderAlignments(context, this.alignmentsRect);
    }

    private void renderDownsampledIntervals(RenderContext context, Rectangle downsampleRect) {
        if (!context.getVisibleRect().intersects(downsampleRect)) {
            return;
        }
        AlignmentInterval loadedInterval = this.dataManager.getLoadedInterval(context.getReferenceFrame().getCurrentRange());
        if (loadedInterval == null) {
            return;
        }
        Graphics2D g2 = context.getGraphic2DForColor(Color.black);
        List<DownsampledInterval> intervals = loadedInterval.getDownsampledIntervals();
        for (DownsampledInterval interval : intervals) {
            int x0 = context.bpToScreenPixel(interval.getStart());
            int x1 = context.bpToScreenPixel(interval.getEnd());
            int w2 = Math.max(1, x1 - x0);
            if (w2 > 5) {
                --w2;
            }
            g2.fillRect(x0, downsampleRect.y, w2, downsampleRect.height);
        }
    }

    private void renderAlignments(RenderContext context, Rectangle inputRect) {
        boolean leaveMargin;
        PackedAlignments groups = this.dataManager.getGroups(context, this.renderOptions);
        Map<String, PEStats> peStats = this.dataManager.getPEStats();
        if (peStats != null) {
            this.renderOptions.peStats = peStats;
        }
        if (groups == null) {
            return;
        }
        Rectangle visibleRect = context.getVisibleRect();
        boolean bl = leaveMargin = this.getDisplayMode() == Track.DisplayMode.EXPANDED;
        if (this.renderOptions.isPairedArcView()) {
            this.maximumHeight = (int)inputRect.getHeight();
            AlignmentRenderer.getInstance().clearCurveMaps();
        } else {
            this.maximumHeight = Integer.MAX_VALUE;
        }
        double y = inputRect.getY();
        double h2 = this.expandedHeight;
        if (this.getDisplayMode() != Track.DisplayMode.EXPANDED) {
            int visHeight = visibleRect.height;
            int depth = this.dataManager.getNLevels();
            this.squishedHeight = depth == 0 ? Math.min(this.maxSquishedHeight, Math.max(1, this.expandedHeight)) : Math.min(this.maxSquishedHeight, Math.max(1, Math.min(this.expandedHeight, visHeight / depth)));
            h2 = this.squishedHeight;
        }
        Graphics2D groupBorderGraphics = context.getGraphic2DForColor(AlignmentRenderer.GROUP_DIVIDER_COLOR);
        int nGroups = groups.size();
        int groupNumber = 0;
        for (Map.Entry entry : groups.entrySet()) {
            ++groupNumber;
            List rows = (List)entry.getValue();
            for (Row row : rows) {
                if (visibleRect != null && y > visibleRect.getMaxY()) {
                    return;
                }
                if (this.renderOptions.isPairedArcView()) {
                    y = Math.min((double)(this.getY() + this.getHeight()), visibleRect.getMaxY());
                    y -= h2;
                }
                if (y + h2 > visibleRect.getY()) {
                    Rectangle rowRectangle = new Rectangle(inputRect.x, (int)y, inputRect.width, (int)h2);
                    this.renderer.renderAlignments(row.alignments, context, rowRectangle, inputRect, this.renderOptions, leaveMargin, this.selectedReadNames);
                }
                y += h2;
            }
            if (groupNumber < nGroups) {
                int borderY = (int)y + 2;
                groupBorderGraphics.drawLine(inputRect.x, borderY, inputRect.width, borderY);
            }
            y += 5.0;
        }
        int bottom = inputRect.y + inputRect.height;
        groupBorderGraphics.drawLine(inputRect.x, bottom, inputRect.width, bottom);
    }

    public boolean sortRows(SortOption option, ReferenceFrame referenceFrame, double location, String tag) {
        return this.dataManager.sortRows(option, referenceFrame, location, tag);
    }

    public void groupAlignments(GroupOption option, List<ReferenceFrame> referenceFrames) {
        if (this.renderOptions.groupByOption != option) {
            this.renderOptions.groupByOption = option == GroupOption.NONE ? null : option;
            this.dataManager.repackAlignments(referenceFrames, this.renderOptions);
        }
    }

    public void packAlignments(List<ReferenceFrame> referenceFrames) {
        this.dataManager.repackAlignments(referenceFrames, this.renderOptions);
    }

    public void copyToClipboard(TrackClickEvent e2, Alignment alignment, double location) {
        if (alignment != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(alignment.getValueString(location, null).replace("<br>", "\n"));
            buf.append("\n");
            buf.append("Alignment start position = " + alignment.getChr() + ":" + (alignment.getAlignmentStart() + 1));
            buf.append("\n");
            buf.append(alignment.getReadSequence());
            StringSelection stringSelection = new StringSelection(buf.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    public void copyFlowSignalDistribution(TrackClickEvent e2, int location) {
        ArrayList<FlowDistribution> dists = this.getFlowSignalDistribution(e2.getFrame(), location);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        String json = "";
        for (FlowDistribution dist : dists) {
            json = json + dist.toJson() + "\n";
        }
        clipboard.setContents(new StringSelection(json), null);
    }

    private ArrayList<FlowDistribution> getFlowSignalDistribution(ReferenceFrame frame, int location) {
        return this.getFlowSignalDistribution(frame, location, true, true);
    }

    private ArrayList<FlowDistribution> getFlowSignalDistribution(ReferenceFrame frame, int location, boolean forward, boolean reverse) {
        ArrayList alleletrees = new ArrayList();
        int nrflows = 0;
        ArrayList<FlowDistribution> alleledist = new ArrayList<FlowDistribution>();
        String bases = "";
        ArrayList<ArrayList<ReadInfo>> allelereadinfos = new ArrayList<ArrayList<ReadInfo>>();
        AlignmentInterval interval = this.dataManager.getLoadedInterval(frame.getCurrentRange());
        Iterator<Alignment> alignmentIterator = interval.getAlignmentIterator();
        while (alignmentIterator.hasNext()) {
            int n2;
            Alignment alignment = alignmentIterator.next();
            if (alignment.isNegativeStrand() && !reverse || !alignment.isNegativeStrand() && !forward || !alignment.contains(location)) continue;
            if (alignment.getAlignmentStart() == location || alignment.getAlignmentEnd() == location) {
                log.info(location + " for read " + alignment.getReadName() + " is at an end, not taking it");
                continue;
            }
            boolean hideFirstHPs = PreferenceManager.getInstance().getAsBoolean("IONTORRENT.FLOWDIST_HIDE_FIRST_HP");
            if (hideFirstHPs) {
                int pos;
                char baseatpos = (char)alignment.getBase(location);
                n2 = 1;
                for (pos = alignment.getAlignmentStart(); pos < location; ++pos) {
                    if ((char)alignment.getBase(pos) == baseatpos) continue;
                    n2 = 0;
                    break;
                }
                if (n2 != 0) {
                    log.info("Got all same bases " + baseatpos + " for read " + alignment.getReadName() + " at START.");
                    continue;
                }
                n2 = 1;
                for (pos = location + 1; pos < alignment.getAlignmentEnd(); ++pos) {
                    if ((char)alignment.getBase(pos) == baseatpos) continue;
                    n2 = 0;
                    break;
                }
                if (n2 != 0) {
                    log.info("Got all same bases " + baseatpos + " for read " + alignment.getReadName() + " at END");
                    continue;
                }
            }
            AlignmentBlock[] blocks = alignment.getAlignmentBlocks();
            for (n2 = 0; n2 < blocks.length; ++n2) {
                AlignmentBlock block = blocks[n2];
                int posinblock = location - block.getStart();
                if (!block.contains(location) || !block.hasFlowSignals()) continue;
                int flownr = block.getFlowSignalSubContext(posinblock).getFlowOrderIndex();
                ++nrflows;
                short flowSignal = block.getFlowSignalSubContext(posinblock).getCurrentSignal();
                char base = (char)block.getBase(posinblock);
                int whichbase = bases.indexOf(base);
                TreeMap<Short, Integer> map = null;
                ArrayList<ReadInfo> readinfos = null;
                if (whichbase < 0) {
                    bases = bases + base;
                    map = new TreeMap<Short, Integer>();
                    alleletrees.add(map);
                    readinfos = new ArrayList<ReadInfo>();
                    allelereadinfos.add(readinfos);
                } else {
                    map = (TreeMap<Short, Integer>)alleletrees.get(whichbase);
                    readinfos = (ArrayList<ReadInfo>)allelereadinfos.get(whichbase);
                }
                ReadInfo readinfo = new ReadInfo(alignment.getReadName(), flownr, flowSignal, base);
                readinfos.add(readinfo);
                if (map.containsKey(flowSignal)) {
                    map.put(flowSignal, (Integer)map.get(flowSignal) + 1);
                    continue;
                }
                map.put(flowSignal, 1);
            }
        }
        String locus = Locus.getFormattedLocusString(frame.getChrName(), location, location);
        int which = 0;
        for (TreeMap treeMap : alleletrees) {
            String name = "";
            name = forward && reverse ? name + "both strand" : (forward ? name + "forward strand" : name + "reverse strand");
            char base = bases.charAt(which);
            name = name + ", " + base + ", " + nrflows + " flows";
            String info = locus + ", " + bases;
            FlowDistribution dist = new FlowDistribution(location, nrflows, treeMap, name, base, forward, reverse, info);
            dist.setReadInfos((ArrayList)allelereadinfos.get(which));
            alleledist.add(dist);
            ++which;
        }
        return alleledist;
    }

    public void gotoMate(TrackClickEvent te, Alignment alignment) {
        if (alignment != null) {
            ReadMate mate = alignment.getMate();
            if (mate != null && mate.isMapped()) {
                this.setSelected(alignment);
                String chr = mate.getChr();
                int start = mate.start - 1;
                double range = te.getFrame().getEnd() - te.getFrame().getOrigin();
                int newStart = (int)Math.max(0.0, (double)(start + (alignment.getEnd() - alignment.getStart()) / 2) - range / 2.0);
                int newEnd = newStart + (int)range;
                te.getFrame().jumpTo(chr, newStart, newEnd);
                te.getFrame().recordHistory();
            } else {
                MessageUtils.showMessage("Alignment does not have mate, or it is not mapped.");
            }
        }
    }

    public void splitScreenMate(TrackClickEvent te, Alignment alignment) {
        if (alignment != null) {
            ReadMate mate = alignment.getMate();
            if (mate != null && mate.isMapped()) {
                this.setSelected(alignment);
                String mateChr = mate.getChr();
                int mateStart = mate.start - 1;
                ReferenceFrame frame = te.getFrame();
                String locus1 = frame.getFormattedLocusString();
                Range range = frame.getCurrentRange();
                int length = range.getLength();
                int s2 = Math.max(0, mateStart - length / 2);
                int e2 = s2 + length;
                String startStr = NumberFormat.getInstance().format(s2);
                String endStr = NumberFormat.getInstance().format(e2);
                String mateLocus = mateChr + ":" + startStr + "-" + endStr;
                Session currentSession = IGV.getInstance().getSession();
                List<Object> loci = null;
                if (FrameManager.isGeneListMode()) {
                    loci = new ArrayList(FrameManager.getFrames().size());
                    for (ReferenceFrame ref : FrameManager.getFrames()) {
                        String string = ref.getName();
                        if (Locus.fromString(string) != null) {
                            loci.add(string);
                            continue;
                        }
                        loci.add(ref.getFormattedLocusString());
                    }
                    loci.add(mateLocus);
                } else {
                    loci = Arrays.asList(locus1, mateLocus);
                }
                StringBuffer listName = new StringBuffer();
                for (String string : loci) {
                    listName.append(string + "   ");
                }
                GeneList geneList = new GeneList(listName.toString(), loci, false);
                currentSession.setCurrentGeneList(geneList);
                Comparator<String> comparator = new Comparator<String>(){

                    @Override
                    public int compare(String n0, String n1) {
                        ReferenceFrame f0 = FrameManager.getFrame(n0);
                        ReferenceFrame f1 = FrameManager.getFrame(n1);
                        int chrComp = ChromosomeNameComparator.get().compare(f0.getChrName(), f1.getChrName());
                        if (chrComp != 0) {
                            return chrComp;
                        }
                        return f0.getCurrentRange().getStart() - f1.getCurrentRange().getStart();
                    }
                };
                currentSession.sortGeneList(comparator);
                IGV.getInstance().resetFrames();
            } else {
                MessageUtils.showMessage("Alignment does not have mate, or it is not mapped.");
            }
        }
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return 0.0f;
    }

    public AlignmentDataManager getDataManager() {
        return this.dataManager;
    }

    @XmlAttribute
    public boolean isShowSpliceJunctions() {
        return this.showSpliceJunctions;
    }

    private void setShowSpliceJunctions(boolean showSpliceJunctions) {
        this.showSpliceJunctions = showSpliceJunctions;
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        if (this.downsampleRect != null && y > this.downsampleRect.y && y <= this.downsampleRect.y + this.downsampleRect.height) {
            AlignmentInterval loadedInterval = this.dataManager.getLoadedInterval(frame.getCurrentRange());
            if (loadedInterval == null) {
                return null;
            }
            List<DownsampledInterval> intervals = loadedInterval.getDownsampledIntervals();
            DownsampledInterval interval = FeatureUtils.getFeatureAt(position, 0, intervals);
            if (interval != null) {
                return interval.getValueString();
            }
            return null;
        }
        if (this.renderOptions.isPairedArcView()) {
            LocusScore feature = null;
            double xloc = (position - frame.getOrigin()) / frame.getScale();
            SortedSet<Shape> arcs = AlignmentRenderer.getInstance().curveOverlap(xloc);
            int halfLength = 2;
            int sideLength = 2 * halfLength;
            for (Shape curve : arcs) {
                if (!curve.intersects(xloc - (double)halfLength, y - halfLength, sideLength, sideLength)) continue;
                feature = AlignmentRenderer.getInstance().getAlignmentForCurve(curve);
                break;
            }
            return feature == null ? null : feature.getValueString(position, this.getWindowFunction());
        }
        Alignment feature = this.getAlignmentAt(position, y, frame);
        return feature == null ? null : feature.getValueString(position, this.getWindowFunction());
    }

    private Alignment getAlignment(TrackClickEvent te) {
        MouseEvent e2 = te.getMouseEvent();
        ReferenceFrame frame = te.getFrame();
        if (frame == null) {
            return null;
        }
        double location = frame.getChromosomePosition(e2.getX());
        return this.getAlignmentAt(location, e2.getY(), frame);
    }

    private Alignment getAlignmentAt(double position, int y, ReferenceFrame frame) {
        if (this.alignmentsRect == null) {
            return null;
        }
        PackedAlignments groups = this.dataManager.getGroupedAlignmentsContaining(position, frame);
        if (groups == null || groups.isEmpty()) {
            return null;
        }
        int h2 = this.getDisplayMode() == Track.DisplayMode.EXPANDED ? this.expandedHeight : this.squishedHeight;
        int startY = this.alignmentsRect.y;
        boolean leaveMargin = this.getDisplayMode() == Track.DisplayMode.EXPANDED;
        for (List rows : groups.values()) {
            int endY = startY + rows.size() * h2;
            if (y >= startY && y < endY) {
                int levelNumber = (y - startY) / h2;
                Row row = (Row)rows.get(levelNumber);
                List<Alignment> features = row.alignments;
                int buffer = 0;
                return FeatureUtils.getFeatureAt(position, buffer, features);
            }
            startY = endY + 5;
        }
        return null;
    }

    @Override
    public void onAlignmentTrackEvent(AlignmentTrackEvent e2) {
        AlignmentTrackEvent.Type type = e2.getType();
        switch (type) {
            case VISIBILITY_WINDOW: {
                this.visibilityWindowChanged();
                break;
            }
            case RELOAD: 
            case SPLICE_JUNCTION: {
                this.dataManager.initLoadOptions();
                this.clearCaches();
            }
        }
    }

    private void visibilityWindowChanged() {
        PreferenceManager prefs = PreferenceManager.getInstance();
        float maxRange = prefs.getAsFloat("SAM.MAX_VISIBLE_RANGE");
        this.minVisibleScale = maxRange * 1000.0f / 700.0f;
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        ReferenceFrame frame;
        MouseEvent e2 = te.getMouseEvent();
        if ((Globals.IS_MAC && e2.isMetaDown() || !Globals.IS_MAC && e2.isControlDown()) && (frame = te.getFrame()) != null) {
            this.selectAlignment(e2, frame);
            if (this.parent != null) {
                this.parent.repaint();
            }
            return true;
        }
        if (IGV.getInstance().isShowDetailsOnClick()) {
            this.openTooltipWindow(te);
        }
        return false;
    }

    private void selectAlignment(MouseEvent e2, ReferenceFrame frame) {
        double location = frame.getChromosomePosition(e2.getX());
        Alignment alignment = this.getAlignmentAt(location, e2.getY(), frame);
        if (alignment != null) {
            if (this.selectedReadNames.containsKey(alignment.getReadName())) {
                this.selectedReadNames.remove(alignment.getReadName());
            } else {
                this.setSelected(alignment);
            }
        }
    }

    private void setSelected(Alignment alignment) {
        Color c2 = this.readNamePalette.get(alignment.getReadName());
        this.selectedReadNames.put(alignment.getReadName(), c2);
    }

    public void clearCaches() {
        this.dataManager.clear();
    }

    public static void refresh() {
        IGV.getInstance().getContentPane().getMainPanel().invalidate();
        IGV.getInstance().repaintDataPanels();
    }

    public static boolean isBisulfiteColorType(ColorOption o2) {
        return o2.equals((Object)ColorOption.BISULFITE) || o2.equals((Object)ColorOption.NOMESEQ);
    }

    public static String getBisulfiteContextPubStr(BisulfiteContext item) {
        return bisulfiteContextToPubString.get((Object)item);
    }

    public static byte[] getBisulfiteContextPreContext(BisulfiteContext item) {
        Pair<byte[], byte[]> pair = bisulfiteContextToContextString.get((Object)item);
        return pair.getFirst();
    }

    public static byte[] getBisulfiteContextPostContext(BisulfiteContext item) {
        Pair<byte[], byte[]> pair = bisulfiteContextToContextString.get((Object)item);
        return pair.getSecond();
    }

    @Override
    public void restorePersistentState(Node node, int version) throws JAXBException {
        super.restorePersistentState(node, version);
        boolean hasRenderSubTag = false;
        try {
            if (node.hasChildNodes()) {
                NodeList list = node.getChildNodes();
                for (int ii = 0; ii < list.getLength(); ++ii) {
                    Node item = list.item(ii);
                    if (!item.getNodeName().equals("RenderOptions")) continue;
                    hasRenderSubTag = true;
                    break;
                }
            }
            if (hasRenderSubTag) {
                return;
            }
            RenderOptions ro = (RenderOptions)IGVSessionReader.getJAXBContext().createUnmarshaller().unmarshal(node, RenderOptions.class).getValue();
            String shadeBasesKey = "shadeBases";
            String value = Utilities.getNullSafe(node.getAttributes(), shadeBasesKey);
            if (value != null) {
                if (value.equals("false")) {
                    ro.shadeBasesOption = ShadeBasesOption.NONE;
                } else if (value.equals("true")) {
                    ro.shadeBasesOption = ShadeBasesOption.QUALITY;
                }
            }
            this.setRenderOptions(ro);
        }
        catch (JAXBException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void setViewAsPairs(boolean vAP) {
        if (vAP && this.renderOptions.groupByOption == GroupOption.STRAND) {
            boolean ungroup = MessageUtils.confirm("\"View as pairs\" is incompatible with \"Group by strand\". Ungroup?");
            if (ungroup) {
                this.renderOptions.groupByOption = null;
            } else {
                return;
            }
        }
        this.dataManager.setViewAsPairs(vAP, this.renderOptions);
        AlignmentTrack.refresh();
    }

    public boolean isPairedArcView() {
        return this.renderOptions.isPairedArcView();
    }

    public void setPairedArcView(boolean option) {
        if (option == this.isPairedArcView()) {
            return;
        }
        if (option) {
            this.setViewAsPairs(false);
        }
        this.renderOptions.setPairedArcView(option);
        this.dataManager.repackAlignments(FrameManager.getFrames(), this.renderOptions);
        AlignmentTrack.refresh();
    }

    public static void sortAlignmentTracks(SortOption option, String tag) {
        IGV.getInstance().sortAlignmentTracks(option, tag);
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        prefMgr.put("SAM>SORT_OPTION", option.toString());
        prefMgr.put("SAM.SORT_BY_TAG", tag);
        AlignmentTrack.refresh();
    }

    private void showFlowSignalDistribution(final int location, final ReferenceFrame frame, final boolean forward, final boolean reverse) {
        FlowDistribution[] distributions = this.getFlowDistributions(forward, reverse, frame, location);
        final FlowSignalDistributionPanel distributionPanel = new FlowSignalDistributionPanel(distributions);
        LocationListener listener = new LocationListener(){

            @Override
            public void locationChanged(int newLocation) {
                log.info("Got new location from panel: " + newLocation + ", (old location was: " + location + ")");
                FlowDistribution[] newdist = AlignmentTrack.this.getFlowDistributions(forward, reverse, frame, newLocation);
                distributionPanel.setDistributions(newdist);
                frame.centerOnLocation(newLocation + 1);
                IGV.repaintPanelsHeadlessSafe();
            }
        };
        distributionPanel.setListener(listener);
        SimpleDialog dia = new SimpleDialog("Flow Signal Distribution", distributionPanel, 800, 500);
    }

    private FlowDistribution[] getFlowDistributions(boolean forward, boolean reverse, ReferenceFrame frame, int location) {
        FlowDistribution[] distributions = null;
        if (forward || reverse) {
            ArrayList<FlowDistribution> dists = this.getFlowSignalDistribution(frame, location, forward, reverse);
            distributions = new FlowDistribution[dists.size()];
            for (int i2 = 0; i2 < dists.size(); ++i2) {
                distributions[i2] = dists.get(i2);
            }
        } else {
            int i3;
            ArrayList<FlowDistribution> distsf = this.getFlowSignalDistribution(frame, location, true, false);
            ArrayList<FlowDistribution> distsr = this.getFlowSignalDistribution(frame, location, false, true);
            distributions = new FlowDistribution[distsf.size() + distsr.size()];
            for (i3 = 0; i3 < distsf.size(); ++i3) {
                distributions[i3] = distsf.get(i3);
            }
            for (i3 = 0; i3 < distsr.size(); ++i3) {
                distributions[i3 + distsf.size()] = distsr.get(i3);
            }
        }
        return distributions;
    }

    private static AlignmentTrack getNextTrack() {
        return (AlignmentTrack)IGVSessionReader.getNextTrack();
    }

    static {
        bisulfiteContextToPubString.put(BisulfiteContext.CG, "CG");
        bisulfiteContextToPubString.put(BisulfiteContext.CHH, "CHH");
        bisulfiteContextToPubString.put(BisulfiteContext.CHG, "CHG");
        bisulfiteContextToPubString.put(BisulfiteContext.HCG, "HCG");
        bisulfiteContextToPubString.put(BisulfiteContext.GCH, "GCH");
        bisulfiteContextToPubString.put(BisulfiteContext.WCG, "WCG");
        bisulfiteContextToContextString = new HashMap<BisulfiteContext, Pair<byte[], byte[]>>();
        bisulfiteContextToContextString.put(BisulfiteContext.CG, new Pair<byte[], byte[]>(new byte[0], new byte[]{71}));
        bisulfiteContextToContextString.put(BisulfiteContext.CHH, new Pair<byte[], byte[]>(new byte[0], new byte[]{72, 72}));
        bisulfiteContextToContextString.put(BisulfiteContext.CHG, new Pair<byte[], byte[]>(new byte[0], new byte[]{72, 71}));
        bisulfiteContextToContextString.put(BisulfiteContext.HCG, new Pair<byte[], byte[]>(new byte[]{72}, new byte[]{71}));
        bisulfiteContextToContextString.put(BisulfiteContext.GCH, new Pair<byte[], byte[]>(new byte[]{71}, new byte[]{72}));
        bisulfiteContextToContextString.put(BisulfiteContext.WCG, new Pair<byte[], byte[]>(new byte[]{87}, new byte[]{71}));
        DEFAULT_SHADE_BASES_OPTION = ShadeBasesOption.QUALITY;
        DEFAULT_COLOR_OPTION = ColorOption.INSERT_SIZE;
        DEFAULT_BISULFITE_CONTEXT = BisulfiteContext.CG;
    }

    private static class Deselector
    implements ActionListener {
        private JMenuItem toDeselect;
        private JMenuItem parent;

        Deselector(JMenuItem parent, JMenuItem toDeselect) {
            this.parent = parent;
            this.toDeselect = toDeselect;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            if (this.parent.isSelected()) {
                this.toDeselect.setSelected(false);
            }
        }
    }

    class PopupMenu
    extends IGVPopupMenu {
        PopupMenu(TrackClickEvent e2) {
            ArrayList<Track> tracks = new ArrayList<Track>();
            tracks.add(AlignmentTrack.this);
            JLabel popupTitle = new JLabel("  " + AlignmentTrack.this.getName(), 0);
            Font newFont = this.getFont().deriveFont(1, 12.0f);
            popupTitle.setFont(newFont);
            if (popupTitle != null) {
                this.add(popupTitle);
            }
            this.addSeparator();
            this.add(TrackMenuUtils.getTrackRenameItem(tracks));
            this.addCopyToClipboardItem(e2);
            if (AlignmentTrack.this.ionTorrent) {
                this.addCopyFlowSignalDistributionToClipboardItem(e2);
                this.addIonTorrentAuxiliaryViews(e2);
            }
            this.addSeparator();
            this.addGroupMenuItem();
            this.addSortMenuItem();
            this.addColorByMenuItem();
            this.addSeparator();
            this.addShadeBaseByMenuItem();
            JMenuItem misMatchesItem = this.addShowMismatchesMenuItem();
            JMenuItem showAllItem = this.addShowAllBasesMenuItem();
            misMatchesItem.addActionListener(new Deselector(misMatchesItem, showAllItem));
            showAllItem.addActionListener(new Deselector(showAllItem, misMatchesItem));
            this.addSeparator();
            this.addViewAsPairsMenuItem();
            boolean viewPairArcsPresent = Boolean.parseBoolean(System.getProperty("pairedArcViewPresent", "false"));
            if (viewPairArcsPresent) {
                this.addViewPairedArcsMenuItem();
            }
            this.addGoToMate(e2);
            this.showMateRegion(e2);
            this.addInsertSizeMenuItem();
            this.addSeparator();
            this.addPackMenuItem();
            this.addShowCoverageItem();
            if (AlignmentTrack.this.spliceJunctionTrack != null) {
                this.addShowSpliceJuntionItem();
            }
            this.addLoadCoverageDataItem();
            this.addSeparator();
            TrackMenuUtils.addDisplayModeItems(tracks, this);
            this.addSeparator();
            this.addSelectByNameItem();
            this.addClearSelectionsMenuItem();
            this.addSeparator();
            this.addCopySequenceItem(e2);
            if (Globals.isDevelopment()) {
                this.addBlatItem(e2);
            }
            this.addConsensusSequence(e2);
            boolean showSashimi = true;
            if (showSashimi) {
                this.addSeparator();
                JMenuItem sashimi = new JMenuItem("Sashimi Plot");
                sashimi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        SashimiPlot.getSashimiPlot(null);
                    }
                });
                this.add(sashimi);
            }
            this.addSeparator();
            this.add(TrackMenuUtils.getRemoveMenuItem(tracks));
        }

        private void addConsensusSequence(TrackClickEvent e2) {
            JMenuItem item = new JMenuItem("Copy consensus sequence");
            final ReferenceFrame frame = e2.getFrame() == null && FrameManager.getFrames().size() == 1 ? FrameManager.getFrames().get(0) : e2.getFrame();
            item.setEnabled(frame != null);
            this.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (frame == null) {
                        MessageUtils.showMessage("Unknown region bounds, cannot export consensus");
                        return;
                    }
                    int start = (int)frame.getOrigin();
                    int end = (int)frame.getEnd();
                    if (end - start > 1000000) {
                        MessageUtils.showMessage("Cannot export region more than 1 Megabase");
                        return;
                    }
                    AlignmentInterval interval = AlignmentTrack.this.dataManager.getLoadedInterval(frame.getCurrentRange());
                    AlignmentCounts counts = interval.getCounts();
                    String text = PFMExporter.createPFMText(counts, frame.getChrName(), start, end);
                    StringUtils.copyTextToClipboard(text);
                }
            });
        }

        private JMenu getBisulfiteContextMenuItem(ButtonGroup group) {
            JMenu bisulfiteContextMenu = new JMenu("bisulfite mode");
            JRadioButtonMenuItem nomeESeqOption = null;
            boolean showNomeESeq = PreferenceManager.getInstance().getAsBoolean("SAM.NOMESEQ_ENABLED");
            if (showNomeESeq) {
                nomeESeqOption = new JRadioButtonMenuItem("NOMe-seq bisulfite mode");
                nomeESeqOption.setSelected(AlignmentTrack.this.renderOptions.colorOption == ColorOption.NOMESEQ);
                nomeESeqOption.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        PopupMenu.this.setColorOption(ColorOption.NOMESEQ);
                        AlignmentTrack.refresh();
                    }
                });
                group.add(nomeESeqOption);
            }
            for (final BisulfiteContext item : BisulfiteContext.values()) {
                String optionStr = AlignmentTrack.getBisulfiteContextPubStr(item);
                JRadioButtonMenuItem m1 = new JRadioButtonMenuItem(optionStr);
                m1.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.bisulfiteContext == item);
                m1.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        PopupMenu.this.setColorOption(ColorOption.BISULFITE);
                        PopupMenu.this.setBisulfiteContext(item);
                        AlignmentTrack.refresh();
                    }
                });
                bisulfiteContextMenu.add(m1);
                group.add(m1);
            }
            if (nomeESeqOption != null) {
                bisulfiteContextMenu.add(nomeESeqOption);
            }
            return bisulfiteContextMenu;
        }

        public void addSelectByNameItem() {
            JMenuItem item = new JMenuItem("Select by name...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    String val = MessageUtils.showInputDialog("Enter read name: ");
                    if (val != null && val.trim().length() > 0) {
                        AlignmentTrack.this.selectedReadNames.put(val, AlignmentTrack.this.readNamePalette.get(val));
                        AlignmentTrack.refresh();
                    }
                }
            });
            this.add(item);
        }

        private JCheckBoxMenuItem getGroupMenuItem(String label, final GroupOption option) {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(label);
            mi.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.groupByOption == option);
            if (option == GroupOption.NONE) {
                mi.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.groupByOption == null);
            }
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    IGV.getInstance().groupAlignmentTracks(option);
                    AlignmentTrack.refresh();
                }
            });
            return mi;
        }

        public void addGroupMenuItem() {
            JMenu groupMenu = new JMenu("Group alignments by");
            ButtonGroup group = new ButtonGroup();
            LinkedHashMap<String, GroupOption> mappings = new LinkedHashMap<String, GroupOption>();
            mappings.put("none", GroupOption.NONE);
            mappings.put("read strand", GroupOption.STRAND);
            mappings.put("first-in-pair strand", GroupOption.FIRST_OF_PAIR_STRAND);
            mappings.put("sample", GroupOption.SAMPLE);
            mappings.put("read group", GroupOption.READ_GROUP);
            mappings.put("chromosome of mate", GroupOption.MATE_CHROMOSOME);
            String addExtraStr = System.getProperty("enable.groupby.extras", "false");
            boolean addExtras = Boolean.parseBoolean(addExtraStr);
            if (addExtras) {
                mappings.put("pair orientation", GroupOption.PAIR_ORIENTATION);
            }
            for (Map.Entry el : mappings.entrySet()) {
                JCheckBoxMenuItem mi = this.getGroupMenuItem((String)el.getKey(), (GroupOption)((Object)el.getValue()));
                groupMenu.add(mi);
                group.add(mi);
            }
            JCheckBoxMenuItem tagOption = new JCheckBoxMenuItem("tag");
            tagOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    String tag = MessageUtils.showInputDialog("Enter tag", AlignmentTrack.this.renderOptions.getGroupByTag());
                    if (tag != null && tag.trim().length() > 0) {
                        AlignmentTrack.this.renderOptions.setGroupByTag(tag);
                        IGV.getInstance().groupAlignmentTracks(GroupOption.TAG);
                        AlignmentTrack.refresh();
                    }
                }
            });
            tagOption.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.groupByOption == GroupOption.TAG);
            groupMenu.add(tagOption);
            group.add(tagOption);
            this.add(groupMenu);
        }

        private JMenuItem getSortMenuItem(String label, final SortOption option) {
            JMenuItem mi = new JMenuItem(label);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    AlignmentTrack.sortAlignmentTracks(option, null);
                }
            });
            return mi;
        }

        public void addSortMenuItem() {
            JMenu sortMenu = new JMenu("Sort alignments by");
            LinkedHashMap<String, SortOption> mappings = new LinkedHashMap<String, SortOption>();
            mappings.put("start location", SortOption.START);
            mappings.put("read strand", SortOption.STRAND);
            mappings.put("first-of-pair strand", SortOption.FIRST_OF_PAIR_STRAND);
            mappings.put("base", SortOption.NUCLEOTIDE);
            mappings.put("mapping quality", SortOption.QUALITY);
            mappings.put("sample", SortOption.SAMPLE);
            mappings.put("read group", SortOption.READ_GROUP);
            if (AlignmentTrack.this.dataManager.isPairedEnd()) {
                mappings.put("insert size", SortOption.INSERT_SIZE);
                mappings.put("chromosome of mate", SortOption.MATE_CHR);
            }
            for (Map.Entry el : mappings.entrySet()) {
                sortMenu.add(this.getSortMenuItem((String)el.getKey(), (SortOption)((Object)el.getValue())));
            }
            JMenuItem tagOption = new JMenuItem("tag");
            tagOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    String tag = MessageUtils.showInputDialog("Enter tag", AlignmentTrack.this.renderOptions.getSortByTag());
                    if (tag != null && tag.trim().length() > 0) {
                        AlignmentTrack.this.renderOptions.setSortByTag(tag);
                        AlignmentTrack.sortAlignmentTracks(SortOption.TAG, tag);
                    }
                }
            });
            sortMenu.add(tagOption);
            this.add(sortMenu);
        }

        private void setBisulfiteContext(BisulfiteContext option) {
            ((AlignmentTrack)AlignmentTrack.this).renderOptions.bisulfiteContext = option;
            PreferenceManager.getInstance().put("SAM.BISULFITE_CONTEXT", option.toString());
        }

        private void setColorOption(ColorOption option) {
            AlignmentTrack.this.renderOptions.colorOption = option;
            PreferenceManager.getInstance().put("SAM.COLOR_BY", option.toString());
            ExperimentType t2 = option == ColorOption.BISULFITE ? ExperimentType.BISULFITE : ExperimentType.OTHER;
            AlignmentTrack.this.setExperimentType(t2);
        }

        private JRadioButtonMenuItem getColorMenuItem(String label, final ColorOption option) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(label);
            mi.setSelected(AlignmentTrack.this.renderOptions.colorOption == option);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    PopupMenu.this.setColorOption(option);
                    AlignmentTrack.refresh();
                }
            });
            return mi;
        }

        public void addColorByMenuItem() {
            JMenu colorMenu = new JMenu("Color alignments by");
            ButtonGroup group = new ButtonGroup();
            LinkedHashMap<String, ColorOption> mappings = new LinkedHashMap<String, ColorOption>();
            mappings.put("no color", ColorOption.NONE);
            if (AlignmentTrack.this.dataManager.isPairedEnd()) {
                mappings.put("insert size", ColorOption.INSERT_SIZE);
                mappings.put("pair orientation", ColorOption.PAIR_ORIENTATION);
                mappings.put("insert size and pair orientation", ColorOption.UNEXPECTED_PAIR);
            }
            mappings.put("read strand", ColorOption.READ_STRAND);
            if (AlignmentTrack.this.dataManager.isPairedEnd()) {
                mappings.put("first-of-pair strand", ColorOption.FIRST_OF_PAIR_STRAND);
            }
            mappings.put("read group", ColorOption.READ_GROUP);
            mappings.put("sample", ColorOption.SAMPLE);
            for (Map.Entry el : mappings.entrySet()) {
                JRadioButtonMenuItem mi = this.getColorMenuItem((String)el.getKey(), (ColorOption)((Object)el.getValue()));
                colorMenu.add(mi);
                group.add(mi);
            }
            JRadioButtonMenuItem tagOption = new JRadioButtonMenuItem("tag");
            tagOption.setSelected(AlignmentTrack.this.renderOptions.colorOption == ColorOption.TAG);
            tagOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    PopupMenu.this.setColorOption(ColorOption.TAG);
                    String tag = MessageUtils.showInputDialog("Enter tag", AlignmentTrack.this.renderOptions.getColorByTag());
                    if (tag != null && tag.trim().length() > 0) {
                        AlignmentTrack.this.renderOptions.setColorByTag(tag);
                        PreferenceManager.getInstance();
                        AlignmentTrack.refresh();
                    }
                }
            });
            colorMenu.add(tagOption);
            group.add(tagOption);
            colorMenu.add(this.getBisulfiteContextMenuItem(group));
            this.add(colorMenu);
        }

        public void addPackMenuItem() {
            JMenuItem item = new JMenuItem("Re-pack alignments");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            IGV.getInstance().packAlignmentTracks();
                            AlignmentTrack.refresh();
                        }
                    });
                }
            });
            this.add(item);
        }

        public void addCopyToClipboardItem(final TrackClickEvent te) {
            MouseEvent me = te.getMouseEvent();
            JMenuItem item = new JMenuItem("Copy read details to clipboard");
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                item.setEnabled(false);
            } else {
                final double location = frame.getChromosomePosition(me.getX());
                final Alignment alignment = AlignmentTrack.this.getAlignmentAt(location, me.getY(), frame);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        AlignmentTrack.this.copyToClipboard(te, alignment, location);
                    }
                });
                if (alignment == null) {
                    item.setEnabled(false);
                }
            }
            this.add(item);
        }

        public void addCopyFlowSignalDistributionToClipboardItem(final TrackClickEvent te) {
            MouseEvent me = te.getMouseEvent();
            JMenuItem item = new JMenuItem("Copy the flow signal distrubtion for this base to the clipboard");
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                item.setEnabled(false);
            } else {
                final int location = (int)frame.getChromosomePosition(me.getX());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        AlignmentTrack.this.copyFlowSignalDistribution(te, location);
                    }
                });
            }
            this.add(item);
        }

        public void addViewPairedArcsMenuItem() {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("View paired arcs");
            item.setSelected(AlignmentTrack.this.isPairedArcView());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    boolean isPairedArcView = item.isSelected();
                    AlignmentTrack.this.setPairedArcView(isPairedArcView);
                }
            });
            item.setEnabled(AlignmentTrack.this.dataManager.isPairedEnd());
            this.add(item);
        }

        public void addViewAsPairsMenuItem() {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("View as pairs");
            item.setSelected(AlignmentTrack.this.renderOptions.isViewPairs());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    boolean viewAsPairs = item.isSelected();
                    AlignmentTrack.this.setViewAsPairs(viewAsPairs);
                }
            });
            item.setEnabled(AlignmentTrack.this.dataManager.isPairedEnd());
            this.add(item);
        }

        public void addGoToMate(final TrackClickEvent te) {
            JMenuItem item = new JMenuItem("Go to mate");
            MouseEvent e2 = te.getMouseEvent();
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                item.setEnabled(false);
            } else {
                double location = frame.getChromosomePosition(e2.getX());
                final Alignment alignment = AlignmentTrack.this.getAlignmentAt(location, e2.getY(), frame);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        AlignmentTrack.this.gotoMate(te, alignment);
                    }
                });
                if (alignment == null || !alignment.isPaired() || !alignment.getMate().isMapped()) {
                    item.setEnabled(false);
                }
            }
            this.add(item);
        }

        public void showMateRegion(final TrackClickEvent te) {
            JMenuItem item = new JMenuItem("View mate region in split screen");
            MouseEvent e2 = te.getMouseEvent();
            ReferenceFrame frame = te.getFrame();
            if (frame == null) {
                item.setEnabled(false);
            } else {
                double location = frame.getChromosomePosition(e2.getX());
                Alignment clickedAlignment = AlignmentTrack.this.getAlignmentAt(location, e2.getY(), frame);
                if (clickedAlignment instanceof PairedAlignment) {
                    Alignment first = ((PairedAlignment)clickedAlignment).getFirstAlignment();
                    Alignment second = ((PairedAlignment)clickedAlignment).getSecondAlignment();
                    clickedAlignment = first.contains(location) ? first : (second.contains(location) ? second : null);
                }
                final Alignment alignment = clickedAlignment;
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        AlignmentTrack.this.splitScreenMate(te, alignment);
                    }
                });
                if (alignment == null || !alignment.isPaired() || !alignment.getMate().isMapped()) {
                    item.setEnabled(false);
                }
            }
            this.add(item);
        }

        public void addClearSelectionsMenuItem() {
            JMenuItem item = new JMenuItem("Clear selections");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    AlignmentTrack.this.selectedReadNames.clear();
                    AlignmentTrack.refresh();
                }
            });
            this.add(item);
        }

        public JMenuItem addShowAllBasesMenuItem() {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show all bases");
            if (AlignmentTrack.this.renderOptions.colorOption != ColorOption.BISULFITE && AlignmentTrack.this.renderOptions.colorOption != ColorOption.NOMESEQ) {
                item.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.showAllBases);
            }
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    AlignmentTrack.this.renderOptions.setShowAllBases(item.isSelected());
                    AlignmentTrack.refresh();
                }
            });
            this.add(item);
            return item;
        }

        public JMenuItem addShowMismatchesMenuItem() {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show mismatched bases");
            item.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.showMismatches);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    AlignmentTrack.this.renderOptions.setShowMismatches(item.isSelected());
                    AlignmentTrack.refresh();
                }
            });
            this.add(item);
            return item;
        }

        public void addInsertSizeMenuItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Set insert size options ...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    InsertSizeSettingsDialog dlg = new InsertSizeSettingsDialog(IGV.getMainFrame(), AlignmentTrack.this.renderOptions);
                    dlg.setModal(true);
                    dlg.setVisible(true);
                    if (!dlg.isCanceled()) {
                        AlignmentTrack.this.renderOptions.setComputeIsizes(dlg.isComputeIsize());
                        AlignmentTrack.this.renderOptions.setMinInsertSizePercentile(dlg.getMinPercentile());
                        AlignmentTrack.this.renderOptions.setMaxInsertSizePercentile(dlg.getMaxPercentile());
                        if (AlignmentTrack.this.renderOptions.isComputeIsizes()) {
                            AlignmentTrack.this.dataManager.updatePEStats(AlignmentTrack.this.renderOptions);
                        }
                        AlignmentTrack.this.renderOptions.setMinInsertSize(dlg.getMinThreshold());
                        AlignmentTrack.this.renderOptions.setMaxInsertSize(dlg.getMaxThreshold());
                        AlignmentTrack.refresh();
                    }
                }
            });
            item.setEnabled(AlignmentTrack.this.dataManager.isPairedEnd());
            this.add(item);
        }

        public void addShadeBaseByMenuItem() {
            if (AlignmentTrack.this.ionTorrent) {
                JMenu groupMenu = new JMenu("Shade bases by...");
                ButtonGroup group = new ButtonGroup();
                LinkedHashMap<String, ShadeBasesOption> mappings = new LinkedHashMap<String, ShadeBasesOption>();
                mappings.put("none", ShadeBasesOption.NONE);
                mappings.put("quality", ShadeBasesOption.QUALITY);
                mappings.put("read flow signal deviation", ShadeBasesOption.FLOW_SIGNAL_DEVIATION_READ);
                mappings.put("reference flow signal deviation", ShadeBasesOption.FLOW_SIGNAL_DEVIATION_REFERENCE);
                for (Map.Entry el : mappings.entrySet()) {
                    JCheckBoxMenuItem mi = this.getShadeBasesMenuItem((String)el.getKey(), (ShadeBasesOption)((Object)el.getValue()));
                    groupMenu.add(mi);
                    group.add(mi);
                }
                this.add(groupMenu);
            } else {
                final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Shade base by quality");
                item.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.shadeBasesOption == ShadeBasesOption.QUALITY);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        UIUtilities.invokeOnEventThread(new Runnable(){

                            @Override
                            public void run() {
                                ((AlignmentTrack)AlignmentTrack.this).renderOptions.shadeBasesOption = item.isSelected() ? ShadeBasesOption.QUALITY : ShadeBasesOption.NONE;
                                AlignmentTrack.refresh();
                            }
                        });
                    }
                });
                this.add(item);
            }
        }

        private JCheckBoxMenuItem getShadeBasesMenuItem(String label, final ShadeBasesOption option) {
            final JCheckBoxMenuItem mi = new JCheckBoxMenuItem(label);
            mi.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.shadeBasesOption == option);
            if (option == ShadeBasesOption.NONE) {
                mi.setSelected(((AlignmentTrack)AlignmentTrack.this).renderOptions.shadeBasesOption == null || ((AlignmentTrack)AlignmentTrack.this).renderOptions.shadeBasesOption == option);
            }
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            ((AlignmentTrack)AlignmentTrack.this).renderOptions.shadeBasesOption = mi.isSelected() ? option : ShadeBasesOption.NONE;
                            AlignmentTrack.refresh();
                        }
                    });
                }
            });
            return mi;
        }

        public void addShowCoverageItem() {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show coverage track");
            item.setSelected(AlignmentTrack.this.getCoverageTrack() != null && AlignmentTrack.this.getCoverageTrack().isVisible());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            if (AlignmentTrack.this.getCoverageTrack() != null) {
                                AlignmentTrack.this.getCoverageTrack().setVisible(item.isSelected());
                                AlignmentTrack.refresh();
                                IGV.getInstance().repaintNamePanels();
                            }
                        }
                    });
                }
            });
            this.add(item);
        }

        private void addShowSpliceJuntionItem() {
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show junction track");
            item.setSelected(AlignmentTrack.this.spliceJunctionTrack != null && AlignmentTrack.this.spliceJunctionTrack.isVisible());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            if (AlignmentTrack.this.spliceJunctionTrack != null) {
                                AlignmentTrack.this.spliceJunctionTrack.setVisible(item.isSelected());
                                AlignmentTrack.refresh();
                                IGV.getInstance().repaintNamePanels();
                            }
                        }
                    });
                }
            });
            item.setEnabled(AlignmentTrack.this.spliceJunctionTrack != null);
            this.add(item);
        }

        public void addLoadCoverageDataItem() {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Load coverage data...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    UIUtilities.invokeOnEventThread(new Runnable(){

                        @Override
                        public void run() {
                            PreferenceManager prefs = PreferenceManager.getInstance();
                            File initDirectory = prefs.getLastTrackDirectory();
                            File file = FileDialogUtils.chooseFile("Select coverage file", initDirectory, 0);
                            if (file != null) {
                                prefs.setLastTrackDirectory(file.getParentFile());
                                String path = file.getAbsolutePath();
                                if (path.endsWith(".tdf") || path.endsWith(".tdf")) {
                                    TDFReader reader = TDFReader.getReader(file.getAbsolutePath());
                                    TDFDataSource ds = new TDFDataSource(reader, 0, PopupMenu.this.getName() + " coverage", AlignmentTrack.this.genome);
                                    AlignmentTrack.this.getCoverageTrack().setDataSource(ds);
                                    AlignmentTrack.refresh();
                                } else if (path.endsWith(".counts")) {
                                    GobyCountArchiveDataSource ds = new GobyCountArchiveDataSource(file);
                                    AlignmentTrack.this.getCoverageTrack().setDataSource(ds);
                                    AlignmentTrack.refresh();
                                } else {
                                    MessageUtils.showMessage("Coverage data must be in .tdf format");
                                }
                            }
                        }
                    });
                }
            });
            this.add(item);
        }

        public void addCopySequenceItem(TrackClickEvent te) {
            JMenuItem item = new JMenuItem("Copy read sequence");
            this.add(item);
            Alignment alignment = AlignmentTrack.this.getAlignment(te);
            if (alignment == null) {
                item.setEnabled(false);
                return;
            }
            final String seq = alignment.getReadSequence();
            if (seq == null) {
                item.setEnabled(false);
                return;
            }
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    StringUtils.copyTextToClipboard(seq);
                }
            });
        }

        public void addBlatItem(TrackClickEvent te) {
            JMenuItem item = new JMenuItem("Blat read sequence");
            this.add(item);
            Alignment alignment = AlignmentTrack.this.getAlignment(te);
            if (alignment == null) {
                item.setEnabled(false);
                return;
            }
            final String seq = alignment.getReadSequence();
            if (seq == null) {
                item.setEnabled(false);
                return;
            }
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent aEvt) {
                    BlatClient.doBlatQuery(seq);
                }
            });
        }

        private void addIonTorrentAuxiliaryViews(final TrackClickEvent e2) {
            JMenu groupMenu = new JMenu("View flow signal distrubtion for this base for");
            ButtonGroup group = new ButtonGroup();
            JCheckBoxMenuItem itemb = new JCheckBoxMenuItem("forward and reverse (2 data series)");
            groupMenu.add(itemb);
            group.add(itemb);
            itemb.setSelected(true);
            itemb.setFont(itemb.getFont().deriveFont(1));
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("both strands combined");
            groupMenu.add(item);
            group.add(item);
            JCheckBoxMenuItem itemf = new JCheckBoxMenuItem("forward strand only");
            groupMenu.add(itemf);
            group.add(itemf);
            JCheckBoxMenuItem itemr = new JCheckBoxMenuItem("reverse strand only");
            groupMenu.add(itemr);
            group.add(itemr);
            ReferenceFrame frame = e2.getFrame();
            if (frame == null) {
                item.setEnabled(false);
                itemf.setEnabled(false);
                itemr.setEnabled(false);
                itemb.setEnabled(false);
            } else {
                final int location = (int)frame.getChromosomePosition(e2.getMouseEvent().getX());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        AlignmentTrack.this.showFlowSignalDistribution(location, e2.getFrame(), true, true);
                    }
                });
                itemf.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        AlignmentTrack.this.showFlowSignalDistribution(location, e2.getFrame(), true, false);
                    }
                });
                itemr.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        AlignmentTrack.this.showFlowSignalDistribution(location, e2.getFrame(), false, true);
                    }
                });
                itemb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent aEvt) {
                        AlignmentTrack.this.showFlowSignalDistribution(location, e2.getFrame(), false, false);
                    }
                });
            }
            this.add(groupMenu);
        }
    }

    @XmlType(name="RenderOptions")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RenderOptions {
        public static final String NAME = "RenderOptions";
        @XmlAttribute
        ShadeBasesOption shadeBasesOption;
        @XmlAttribute
        boolean shadeCenters;
        @XmlAttribute
        boolean flagUnmappedPairs;
        @XmlAttribute
        boolean showAllBases;
        boolean showMismatches = true;
        private boolean computeIsizes;
        @XmlAttribute
        private int minInsertSize;
        @XmlAttribute
        private int maxInsertSize;
        private double minInsertSizePercentile;
        private double maxInsertSizePercentile;
        @XmlAttribute
        private ColorOption colorOption;
        @XmlAttribute
        GroupOption groupByOption = null;
        BisulfiteContext bisulfiteContext;
        private boolean viewPairs = false;
        private boolean pairedArcView = false;
        public boolean flagZeroQualityAlignments = true;
        Map<String, PEStats> peStats;
        @XmlAttribute
        private String colorByTag;
        @XmlAttribute
        private String groupByTag;
        @XmlAttribute
        private String sortByTag;
        private boolean flagLargeInsertions;
        private int largeInsertionsThreshold;

        public void setShowAllBases(boolean showAllBases) {
            this.showAllBases = showAllBases;
            if (showAllBases) {
                this.showMismatches = false;
            }
        }

        public void setShowMismatches(boolean showMismatches) {
            this.showMismatches = showMismatches;
            if (showMismatches) {
                this.showAllBases = false;
            }
        }

        RenderOptions() {
            PreferenceManager prefs = PreferenceManager.getInstance();
            String shadeOptionString = prefs.get("SAM.SHADE_BASE_QUALITY");
            this.shadeBasesOption = shadeOptionString.equals("false") ? ShadeBasesOption.NONE : (shadeOptionString.equals("true") ? ShadeBasesOption.QUALITY : ShadeBasesOption.valueOf(shadeOptionString));
            this.shadeCenters = prefs.getAsBoolean("SAM.SHADE_CENTER");
            this.flagUnmappedPairs = prefs.getAsBoolean("SAM.FLAG_UNMAPPED_PAIR");
            this.computeIsizes = prefs.getAsBoolean("SAM.COMPUTE_ISIZES");
            this.minInsertSize = prefs.getAsInt("SAM.MIN_INSERT_SIZE_THRESHOLD");
            this.maxInsertSize = prefs.getAsInt("SAM.INSERT_SIZE_THRESHOLD");
            this.minInsertSizePercentile = prefs.getAsFloat("SAM.MIN_ISIZE_MIN_PERCENTILE");
            this.maxInsertSizePercentile = prefs.getAsFloat("SAM.ISIZE_MAX_PERCENTILE");
            this.showAllBases = false;
            this.colorOption = CollUtils.valueOf(ColorOption.class, prefs.get("SAM.COLOR_BY"), ColorOption.NONE);
            this.groupByOption = null;
            this.flagZeroQualityAlignments = prefs.getAsBoolean("SAM.FLAG_ZERO_QUALITY");
            this.bisulfiteContext = DEFAULT_BISULFITE_CONTEXT;
            this.colorByTag = prefs.get("SAM.COLOR_BY_TAG");
            this.sortByTag = prefs.get("SAM.SORT_BY_TAG");
            this.groupByTag = prefs.get("SAM.GROUP_BY_TAG");
            this.peStats = new HashMap<String, PEStats>();
            this.flagLargeInsertions = prefs.getAsBoolean("SAM.FLAG_LARGE_INSERTIONS");
            this.largeInsertionsThreshold = prefs.getAsInt("SAM.LARGE_INSERTIONS_THRESOLD");
        }

        private <T extends Enum<T>> T getFromMap(Map<String, String> attributes, String key, Class<T> clazz, T defaultValue) {
            String value = attributes.get(key);
            if (value == null) {
                return defaultValue;
            }
            return CollUtils.valueOf(clazz, value, defaultValue);
        }

        private String getFromMap(Map<String, String> attributes, String key, String defaultValue) {
            String value = attributes.get(key);
            if (value == null) {
                return defaultValue;
            }
            return value;
        }

        public boolean isPairedArcView() {
            return this.pairedArcView;
        }

        public void setPairedArcView(boolean pairedArcView) {
            this.pairedArcView = pairedArcView;
        }

        public int getMinInsertSize() {
            return this.minInsertSize;
        }

        public void setMinInsertSize(int minInsertSize) {
            this.minInsertSize = minInsertSize;
        }

        public int getMaxInsertSize() {
            return this.maxInsertSize;
        }

        public boolean isViewPairs() {
            return this.viewPairs;
        }

        public void setViewPairs(boolean viewPairs) {
            this.viewPairs = viewPairs;
        }

        public boolean isComputeIsizes() {
            return this.computeIsizes;
        }

        public void setComputeIsizes(boolean computeIsizes) {
            this.computeIsizes = computeIsizes;
        }

        public double getMinInsertSizePercentile() {
            return this.minInsertSizePercentile;
        }

        public void setMinInsertSizePercentile(double minInsertSizePercentile) {
            this.minInsertSizePercentile = minInsertSizePercentile;
        }

        public double getMaxInsertSizePercentile() {
            return this.maxInsertSizePercentile;
        }

        public void setMaxInsertSizePercentile(double maxInsertSizePercentile) {
            this.maxInsertSizePercentile = maxInsertSizePercentile;
        }

        public void setMaxInsertSize(int maxInsertSize) {
            this.maxInsertSize = maxInsertSize;
        }

        public ColorOption getColorOption() {
            return this.colorOption;
        }

        public void setColorOption(ColorOption colorOption) {
            this.colorOption = colorOption;
        }

        public void setColorByTag(String colorByTag) {
            this.colorByTag = colorByTag;
            PreferenceManager.getInstance().put("SAM.COLOR_BY_TAG", colorByTag);
        }

        public String getColorByTag() {
            return this.colorByTag;
        }

        public String getSortByTag() {
            return this.sortByTag;
        }

        public void setSortByTag(String sortByTag) {
            this.sortByTag = sortByTag;
        }

        public String getGroupByTag() {
            return this.groupByTag;
        }

        public void setGroupByTag(String groupByTag) {
            this.groupByTag = groupByTag;
        }

        public GroupOption getGroupByOption() {
            return this.groupByOption;
        }

        public boolean isFlagLargeInsertions() {
            return this.flagLargeInsertions;
        }

        public int getLargeInsertionsThreshold() {
            return this.largeInsertionsThreshold;
        }
    }

    static enum OrientationType {
        RR,
        LL,
        RL,
        LR,
        UNKNOWN;

    }

    public static enum BisulfiteContext {
        CG,
        CHH,
        CHG,
        HCG,
        GCH,
        WCG;

    }

    public static enum GroupOption {
        STRAND,
        SAMPLE,
        READ_GROUP,
        FIRST_OF_PAIR_STRAND,
        TAG,
        PAIR_ORIENTATION,
        MATE_CHROMOSOME,
        NONE;

    }

    public static enum SortOption {
        START,
        STRAND,
        NUCLEOTIDE,
        QUALITY,
        SAMPLE,
        READ_GROUP,
        INSERT_SIZE,
        FIRST_OF_PAIR_STRAND,
        MATE_CHR,
        TAG;

    }

    public static enum ColorOption {
        INSERT_SIZE,
        READ_STRAND,
        FIRST_OF_PAIR_STRAND,
        PAIR_ORIENTATION,
        SAMPLE,
        READ_GROUP,
        BISULFITE,
        NOMESEQ,
        TAG,
        NONE,
        UNEXPECTED_PAIR;

    }

    public static enum ExperimentType {
        RNA,
        BISULFITE,
        OTHER;

    }

    public static enum ShadeBasesOption {
        NONE,
        QUALITY,
        FLOW_SIGNAL_DEVIATION_READ,
        FLOW_SIGNAL_DEVIATION_REFERENCE;

    }
}

