/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.repeats;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.broad.igv.Globals;
import org.broad.tribble.readers.AsciiLineReader;

public class RepeatMaskSplitter {
    public static void main(String[] args) {
        File file = new File("/Users/jrobinso/Downloads/Repeats/RepMask_3.2.7_hg18.tab");
        RepeatMaskSplitter.split(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void split(File file) {
        boolean binCol = false;
        int millDivCol = 2;
        int millDelCol = 3;
        int millInsCol = 4;
        int chrCol = 5;
        int startCol = 6;
        int endCol = 7;
        int strandCol = 9;
        int namCol = 10;
        int classCol = 11;
        int famCol = 12;
        HashMap fileMappings = new HashMap();
        AsciiLineReader reader = null;
        HashMap<String, PrintWriter> writers = new HashMap<String, PrintWriter>();
        try {
            String repClass;
            String nextLine;
            String lastChr = "";
            reader = new AsciiLineReader(new FileInputStream(file));
            reader.readLine();
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens = Globals.tabPattern.split(nextLine, -1);
                String chr = tokens[chrCol];
                if (!chr.equals(lastChr)) {
                    RepeatMaskSplitter.closeWriters(writers);
                }
                lastChr = chr;
                repClass = tokens[classCol];
                if (repClass.contains("?")) continue;
                String fileKey = chr + "." + repClass;
                PrintWriter pw = writers.get(fileKey);
                if (pw == null) {
                    File dir = new File(file.getParent(), repClass);
                    if (!dir.exists()) {
                        dir.mkdir();
                        fileMappings.put(repClass, new LinkedHashMap());
                    }
                    Map fMap = (Map)fileMappings.get(repClass);
                    String fn = fileKey + ".bed";
                    fMap.put(chr, fn);
                    File outputFile = new File(dir, fn);
                    pw = new PrintWriter(new FileWriter(outputFile));
                    writers.put(fileKey, pw);
                }
                String name = "Repeat " + tokens[4] + ", family " + tokens[6];
                pw.print(chr);
                pw.print("\t");
                pw.print(Integer.parseInt(tokens[startCol]));
                pw.print("\t");
                pw.print(Integer.parseInt(tokens[endCol]));
                pw.print("\t");
                pw.print(name);
                pw.print("\t");
                pw.print(tokens[strandCol]);
                pw.println();
            }
            for (Map.Entry entry : fileMappings.entrySet()) {
                repClass = (String)entry.getKey();
                File dir = new File(file.getParent(), repClass);
                File listFile = new File(dir, repClass + "_files.list.txt");
                Properties props = new Properties();
                for (Map.Entry entry2 : ((LinkedHashMap)entry.getValue()).entrySet()) {
                    props.put(entry2.getKey(), entry2.getValue());
                }
                FileOutputStream os = new FileOutputStream(listFile);
                props.store(os, "");
                os.close();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            reader.close();
            RepeatMaskSplitter.closeWriters(writers);
        }
    }

    private static void closeWriters(HashMap<String, PrintWriter> writers) {
        for (PrintWriter pw : writers.values()) {
            pw.close();
        }
        writers.clear();
    }
}

