/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.plugin.mongovariant;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.dev.api.IGVPlugin;
import org.broad.igv.dev.api.LoadHandler;
import org.broad.igv.plugin.mongovariant.VariantReviewDialog;
import org.broad.igv.plugin.mongovariant.VariantReviewSource;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackLoader;
import org.broad.igv.track.TrackMenuItemBuilder;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.PanelName;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;
import org.broad.igv.variant.Variant;
import org.broad.igv.variant.VariantTrack;
import org.broad.igv.variant.vcf.VCFVariant;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.NA12878DBArgumentCollection;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class VariantReviewPlugin
implements IGVPlugin {
    private static Logger log = Logger.getLogger(VariantTrack.class);
    private static final String SHOW_REVIEW_KEY = "SHOW_VARIANT_REVIEW";
    private static boolean hasReviewTrack = false;
    private static boolean showReviewOption = Boolean.parseBoolean(IGV.getInstance().getSession().getPersistent("SHOW_VARIANT_REVIEW", "false"));
    private static final String VARIANT_DB_EXT = "variant.db.json";
    private static ResourceLocator defaultLocator;
    private static final String DB_PATH_KEY = "VARIANT_DB_PATH";
    public static final String DB_PATH_DEFAULT = "resources/NA12878kb.json";
    private static final String PREFERENTIAL_SAMPLE_KEY = "PREFERENTIAL_SAMPLE";
    public static final String DEFAULT_PREFERENTIAL_SAMPLE = "NA12878";
    private static String preferentialSampleName;
    private static String dbSpecPath;

    @Override
    public void init() {
        if (showReviewOption) {
            if (!Globals.checkJavaVersion("1.7")) {
                log.error("VariantReviewPlugin requires Java 7 or higher. This plugin will be disabled");
                return;
            }
            NA12878DBArgumentCollection col = new NA12878DBArgumentCollection();
            this.initMenuItems();
            TrackLoader.registerHandler(VARIANT_DB_EXT, new TrackLoadHandler());
        }
    }

    private boolean isSingleVariantTrack(Collection<Track> tracks) {
        if (tracks.size() != 1) {
            return false;
        }
        Track track = tracks.iterator().next();
        return track instanceof VariantTrack;
    }

    private static ResourceLocator loadVariantReviewTrack(String dbSpecPath, List<Track> newTracks, String trackName) {
        ResourceLocator locator = new ResourceLocator(dbSpecPath);
        locator.setName(trackName);
        VariantReviewSource.loadVariantReview(locator, newTracks);
        return locator;
    }

    private void initMenuItems() {
        final JMenuItem loadReviewTrackItem = new JMenuItem("Load Review Track");
        loadReviewTrackItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ArrayList<Track> newTracks = new ArrayList<Track>(1);
                ResourceLocator locator = VariantReviewPlugin.loadVariantReviewTrack(VariantReviewPlugin.getDbSpecPath(), newTracks, "NA12878 KB");
                if (defaultLocator == null) {
                    defaultLocator = locator;
                }
                IGV.getInstance().addTracks(newTracks, PanelName.DATA_PANEL);
                hasReviewTrack = true;
                loadReviewTrackItem.setEnabled(!hasReviewTrack);
            }
        });
        IGV.getInstance().addOtherToolMenu(loadReviewTrackItem);
        TrackMenuUtils.addTrackMenuItemBuilder(new TrackMenuItemBuilder(){

            @Override
            public JMenuItem build(Collection<Track> selectedTracks, TrackClickEvent te) {
                if (!VariantReviewPlugin.this.isSingleVariantTrack(selectedTracks)) {
                    return null;
                }
                Track track = selectedTracks.iterator().next();
                VariantTrack vTrack = (VariantTrack)track;
                final Variant variant = vTrack.getSelectedVariant(te);
                ResourceLocator trackLocator = vTrack.getResourceLocator();
                if (!trackLocator.getPath().toLowerCase().endsWith(VariantReviewPlugin.VARIANT_DB_EXT) && defaultLocator != null) {
                    trackLocator = defaultLocator;
                }
                String dbName = trackLocator.getName();
                final String dbSpecPath = trackLocator.getPath();
                JMenuItem addReviewMenuItem = new JMenuItem("Submit Review to " + dbName);
                addReviewMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e2) {
                        VariantContext vc = VCFVariant.getVariantContext(variant);
                        new VariantReviewDialog(IGV.getMainFrame(), vc, dbSpecPath).setVisible(true);
                    }
                });
                addReviewMenuItem.setEnabled(variant != null);
                return addReviewMenuItem;
            }
        });
    }

    public static String getPreferentialSampleName() {
        if (preferentialSampleName == null) {
            preferentialSampleName = IGV.getPersistent(PREFERENTIAL_SAMPLE_KEY, DEFAULT_PREFERENTIAL_SAMPLE);
        }
        return preferentialSampleName;
    }

    public static String getDbSpecPath() {
        if (dbSpecPath == null) {
            dbSpecPath = IGV.getPersistent(DB_PATH_KEY, DB_PATH_DEFAULT);
        }
        return dbSpecPath;
    }

    private static class TrackLoadHandler
    implements LoadHandler {
        private TrackLoadHandler() {
        }

        @Override
        public void load(String path, List<Track> newTracks) throws IOException {
            String name = Utilities.getFileNameFromURL(path);
            ResourceLocator locator = VariantReviewPlugin.loadVariantReviewTrack(path, newTracks, name);
            if (defaultLocator == null) {
                defaultLocator = locator;
            }
        }
    }
}

