/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.plugin.mongocollab;

import com.mongodb.DBCollection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.broad.igv.plugin.mongocollab.DBFeature;
import org.broad.igv.plugin.mongocollab.MongoCollabPlugin;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.color.ColorChooserPanel;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.tribble.Feature;

public class FeatureAnnotDialog
extends JDialog {
    private static Logger log = Logger.getLogger(MongoCollabPlugin.class);
    private DBCollection collection;
    private DBFeature dbFeat;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panel4;
    private JLabel label7;
    private JTextField chrField;
    private JPanel panel5;
    private JLabel label8;
    private JTextField startField;
    private JPanel panel6;
    private JLabel label9;
    private JTextField stopField;
    private JPanel panel7;
    private JLabel color;
    private ColorChooserPanel colorField;
    private JPanel panel9;
    private JLabel name;
    private JTextField nameField;
    private JPanel panel8;
    private JLabel label11;
    private JTextField descField;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;
    private JButton delButton;

    FeatureAnnotDialog(Frame owner, DBCollection collection, Feature feature) {
        super(owner);
        this.initComponents();
        if (collection == null) {
            throw new IllegalArgumentException("DBCollection must not be null");
        }
        this.collection = collection;
        this.dbFeat = feature instanceof DBFeature ? (DBFeature)feature : DBFeature.create(feature);
        this.initComponentData(this.dbFeat);
    }

    private void initComponentData(DBFeature feature) {
        this.setTitle("Add/Save Feature in " + this.collection.getFullName());
        this.chrField.setText(feature.getChr());
        this.startField.setText("" + (feature.getStart() + 1));
        this.stopField.setText("" + feature.getEnd());
        this.nameField.setText(feature.getName());
        this.descField.setText("" + feature.getDescription());
        this.colorField.setSelectedColor(feature.getColor());
        if (this.dbFeat.get_id() == null) {
            this.delButton.setVisible(false);
        }
        this.validate();
    }

    private void cancelButtonActionPerformed(ActionEvent e2) {
        this.setVisible(false);
    }

    private DBFeature createDBObjectFromFields() {
        int end;
        int start;
        try {
            start = Integer.parseInt(this.startField.getText()) - 1;
            end = Integer.parseInt(this.stopField.getText());
        }
        catch (NumberFormatException e2) {
            MessageUtils.showErrorMessage(e2.getMessage(), e2);
            return null;
        }
        if (start >= end) {
            String msg = String.format("Start (%s) must be less than End (%s), but it's greater or equal", start, end);
            MessageUtils.showMessage(msg);
            return null;
        }
        this.dbFeat.setChr(this.chrField.getText());
        this.dbFeat.setStart(start);
        this.dbFeat.setEnd(end);
        this.dbFeat.setColor(this.colorField.getSelectedColor());
        this.dbFeat.setDescription(this.descField.getText());
        this.dbFeat.setName(this.nameField.getText());
        return this.dbFeat;
    }

    private void okButtonActionPerformed(ActionEvent e2) {
        DBFeature featDBObject = this.createDBObjectFromFields();
        String errorMessage = MongoCollabPlugin.saveFeature(this.collection, featDBObject);
        if (errorMessage != null) {
            MessageUtils.showErrorMessage(errorMessage, new IOException(errorMessage));
        } else {
            this.setVisible(false);
            this.refreshTrack();
        }
    }

    private void refreshTrack() {
        for (FeatureTrack ft : IGV.getInstance().getFeatureTracks()) {
            if (ft.getId() == null || !ft.getId().equals(this.collection.getFullName())) continue;
            ft.clearPackedFeatures();
        }
        IGV.getInstance().repaintDataPanels();
    }

    private void delButtonActionPerformed(ActionEvent e2) {
        MongoCollabPlugin.removeFeature(this.collection, this.dbFeat);
        this.setVisible(false);
        this.refreshTrack();
    }

    private void createUIComponents() {
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel4 = new JPanel();
        this.label7 = new JLabel();
        this.chrField = new JTextField();
        this.panel5 = new JPanel();
        this.label8 = new JLabel();
        this.startField = new JTextField();
        this.panel6 = new JPanel();
        this.label9 = new JLabel();
        this.stopField = new JTextField();
        this.panel7 = new JPanel();
        this.color = new JLabel();
        this.colorField = new ColorChooserPanel();
        this.panel9 = new JPanel();
        this.name = new JLabel();
        this.nameField = new JTextField();
        this.panel8 = new JPanel();
        this.label11 = new JLabel();
        this.descField = new JTextField();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.delButton = new JButton();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setPreferredSize(new Dimension(600, 150));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 0));
        this.panel4.setMaximumSize(new Dimension(46, 1000));
        this.panel4.setLayout(new BoxLayout(this.panel4, 1));
        this.label7.setText("Chr");
        this.label7.setHorizontalAlignment(2);
        this.label7.setVerticalAlignment(1);
        this.label7.setLabelFor(this.chrField);
        this.panel4.add(this.label7);
        this.panel4.add(this.chrField);
        this.contentPanel.add(this.panel4);
        this.panel5.setMaximumSize(new Dimension(100, 1000));
        this.panel5.setMinimumSize(new Dimension(80, 32));
        this.panel5.setPreferredSize(new Dimension(80, 32));
        this.panel5.setLayout(new BoxLayout(this.panel5, 1));
        this.label8.setText("Start");
        this.label8.setHorizontalAlignment(2);
        this.label8.setMaximumSize(new Dimension(100, 16));
        this.panel5.add(this.label8);
        this.panel5.add(this.startField);
        this.contentPanel.add(this.panel5);
        this.panel6.setMaximumSize(new Dimension(100, 1000));
        this.panel6.setMinimumSize(new Dimension(80, 32));
        this.panel6.setPreferredSize(new Dimension(80, 32));
        this.panel6.setLayout(new BoxLayout(this.panel6, 1));
        this.label9.setText("End");
        this.label9.setHorizontalAlignment(2);
        this.label9.setMaximumSize(new Dimension(100, 16));
        this.panel6.add(this.label9);
        this.panel6.add(this.stopField);
        this.contentPanel.add(this.panel6);
        this.panel7.setMaximumSize(new Dimension(80, 1000));
        this.panel7.setMinimumSize(new Dimension(60, 44));
        this.panel7.setPreferredSize(new Dimension(60, 44));
        this.panel7.setToolTipText("Click to edit");
        this.panel7.setLayout(new BoxLayout(this.panel7, 1));
        this.color.setText("Color");
        this.color.setHorizontalAlignment(2);
        this.color.setMaximumSize(new Dimension(100, 16));
        this.panel7.add(this.color);
        this.colorField.setSelectedColor(DBFeature.DEFAULT_COLOR);
        this.panel7.add(this.colorField);
        this.contentPanel.add(this.panel7);
        this.panel9.setMaximumSize(new Dimension(200, 1000));
        this.panel9.setMinimumSize(new Dimension(100, 44));
        this.panel9.setPreferredSize(new Dimension(100, 44));
        this.panel9.setLayout(new BoxLayout(this.panel9, 1));
        this.name.setText("Name");
        this.name.setHorizontalAlignment(2);
        this.name.setMaximumSize(new Dimension(100, 16));
        this.panel9.add(this.name);
        this.panel9.add(this.nameField);
        this.contentPanel.add(this.panel9);
        this.panel8.setMaximumSize(new Dimension(500, 1000));
        this.panel8.setMinimumSize(new Dimension(100, 32));
        this.panel8.setPreferredSize(new Dimension(100, 32));
        this.panel8.setLayout(new BoxLayout(this.panel8, 1));
        this.label11.setText("Description");
        this.label11.setHorizontalAlignment(2);
        this.label11.setMaximumSize(new Dimension(100, 16));
        this.label11.setLabelFor(this.descField);
        this.label11.setAlignmentX(1.0f);
        this.panel8.add(this.label11);
        this.descField.setPreferredSize(new Dimension(100, 28));
        this.descField.setMinimumSize(new Dimension(100, 28));
        this.panel8.add(this.descField);
        this.contentPanel.add(this.panel8);
        this.dialogPane.add((Component)this.contentPanel, "North");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 85, 0};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0, 0.0};
        this.okButton.setText("Save");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FeatureAnnotDialog.this.okButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FeatureAnnotDialog.this.cancelButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.delButton.setText("Delete");
        this.delButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                FeatureAnnotDialog.this.delButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.delButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(700, 160);
        this.setLocationRelativeTo(this.getOwner());
    }
}

