/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.variant.vcf.VCFVariant;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.AsciiLineReaderIterator;
import org.broad.tribble.readers.LocationAware;
import org.broad.tribble.readers.PositionalBufferedStream;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class BCF2WrapperCodec
implements FeatureCodec<VCFVariant, PositionalBufferedStream> {
    private static Logger log = Logger.getLogger(BCF2WrapperCodec.class);
    FeatureCodec<VariantContext, PositionalBufferedStream> wrappedCodec;
    Genome genome;

    public BCF2WrapperCodec(FeatureCodec<VariantContext, PositionalBufferedStream> wrappedCodec, Genome genome) {
        this.wrappedCodec = wrappedCodec;
        this.genome = genome;
    }

    @Override
    public VCFVariant decode(PositionalBufferedStream stream) throws IOException {
        VariantContext vc = this.wrappedCodec.decode(stream);
        if (vc == null) {
            return null;
        }
        String chr = this.genome == null ? vc.getChr() : this.genome.getChromosomeAlias(vc.getChr());
        return new VCFVariant(vc, chr);
    }

    @Override
    public Feature decodeLoc(PositionalBufferedStream stream) throws IOException {
        return this.wrappedCodec.decodeLoc(stream);
    }

    @Override
    public FeatureCodecHeader readHeader(PositionalBufferedStream stream) throws IOException {
        return this.wrappedCodec.readHeader(stream);
    }

    @Override
    public Class<VCFVariant> getFeatureType() {
        return VCFVariant.class;
    }

    @Override
    public boolean canDecode(String path) {
        return path.endsWith(".bcf");
    }

    @Override
    public LocationAware makeIndexableSourceFromStream(InputStream bufferedInputStream) {
        PositionalBufferedStream pbs = bufferedInputStream instanceof PositionalBufferedStream ? (PositionalBufferedStream)bufferedInputStream : new PositionalBufferedStream(bufferedInputStream);
        return new AsciiLineReaderIterator(new AsciiLineReader(pbs));
    }

    @Override
    public boolean isDone(PositionalBufferedStream positionalBufferedStream) {
        try {
            return positionalBufferedStream.isDone();
        }
        catch (IOException e2) {
            log.error(e2.getMessage(), e2);
            return true;
        }
    }

    @Override
    public void close(PositionalBufferedStream positionalBufferedStream) {
        positionalBufferedStream.close();
    }

    @Override
    public PositionalBufferedStream makeSourceFromStream(InputStream bufferedInputStream) {
        return new PositionalBufferedStream(bufferedInputStream);
    }
}

