/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cursor;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.cursor.CursorRegion;
import org.broad.igv.cursor.CursorTrack;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.AsciiFeatureCodec;

public class CursorUtils {
    public static List<CursorRegion> createRegions(CursorTrack track) {
        ArrayList<CursorRegion> frames = new ArrayList<CursorRegion>();
        Map<String, List<BasicFeature>> featureMap = track.getFeatureMap();
        for (List<BasicFeature> flist : featureMap.values()) {
            for (BasicFeature feature : flist) {
                int locaction = (feature.getStart() + feature.getEnd()) / 2;
                frames.add(new CursorRegion(feature.getChr(), locaction));
            }
        }
        return frames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CursorTrack loadTrack(String peakFile) throws IOException {
        AsciiFeatureCodec codec = (AsciiFeatureCodec)CodecFactory.getCodec(new ResourceLocator(peakFile), null);
        HashMap<String, List<BasicFeature>> featureMap = new HashMap<String, List<BasicFeature>>();
        BufferedReader br = null;
        TrackProperties props = null;
        try {
            String nextLine;
            br = ParsingUtils.openBufferedReader(peakFile);
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.startsWith("track")) {
                    props = new TrackProperties();
                    ParsingUtils.parseTrackLine(nextLine, props);
                    continue;
                }
                BasicFeature f2 = (BasicFeature)codec.decode(nextLine);
                if (f2 == null) continue;
                String chr = f2.getChr();
                ArrayList<BasicFeature> featureList = (ArrayList<BasicFeature>)featureMap.get(chr);
                if (featureList == null) {
                    featureList = new ArrayList<BasicFeature>();
                    featureMap.put(chr, featureList);
                }
                featureList.add(f2);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        for (List featureList : featureMap.values()) {
            Collections.sort(featureList, new Comparator<BasicFeature>(){

                @Override
                public int compare(BasicFeature o1, BasicFeature o2) {
                    return o1.getStart() - o2.getStart();
                }
            });
        }
        CursorTrack track = new CursorTrack(featureMap, codec.getFeatureType());
        String trackName = new File(peakFile).getName();
        Color trackColor = null;
        if (props != null) {
            trackColor = props.getColor();
            trackName = props.getName();
        }
        if (trackColor == null && trackName != null) {
            if (trackName.toLowerCase().contains("k4me3")) {
                trackColor = new Color(0, 150, 0);
            } else if (trackName.toLowerCase().contains("k27me3")) {
                trackColor = new Color(150, 0, 0);
            }
        }
        if (trackName != null) {
            track.setName(trackName);
        }
        if (trackColor != null) {
            track.setColor(trackColor);
        }
        return track;
    }
}

