/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cursor;

import java.util.Iterator;
import java.util.List;
import org.broad.igv.cursor.CursorTrack;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.FeatureUtils;
import org.broad.tribble.Feature;

public class CursorRegion
implements Feature {
    String chr;
    int location;

    public CursorRegion(String chr, int location) {
        this.chr = chr;
        this.location = location;
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public int getStart() {
        return this.location;
    }

    @Override
    public int getEnd() {
        return this.location + 1;
    }

    public int getLocation() {
        return this.location;
    }

    public double getScore(CursorTrack t2, int frameBPWidth) {
        int longest = t2.getLongestFeatureLength(this.chr);
        List<BasicFeature> features = t2.getFeatures(this.chr);
        double score = -1.0;
        if (features == null) {
            return score;
        }
        FeatureIterator iter = this.getFeatureIterator(features, longest, frameBPWidth);
        while (iter.hasNext()) {
            BasicFeature f2 = iter.next();
            score = Math.max((double)t2.getSignal(f2), score);
        }
        return score;
    }

    public FeatureIterator getFeatureIterator(List<BasicFeature> features, int longest, int frameBPWidth) {
        return new FeatureIterator(features, longest, frameBPWidth);
    }

    class FeatureIterator
    implements Iterator<BasicFeature> {
        int bpStart;
        int bpEnd;
        int longest;
        BasicFeature nextFeature;
        Iterator<BasicFeature> features;

        FeatureIterator(List<BasicFeature> features, int longest, int frameBPWidth) {
            this.longest = longest;
            this.bpStart = CursorRegion.this.location - frameBPWidth / 2;
            this.bpEnd = CursorRegion.this.location + frameBPWidth / 2;
            int s0 = longest < 0 ? 0 : this.bpStart - longest;
            int startIdx = FeatureUtils.getIndexBefore(s0, features);
            this.features = features.subList(startIdx, features.size()).iterator();
            this.advance();
        }

        private void advance() {
            BasicFeature f2;
            this.nextFeature = null;
            while (this.features.hasNext() && (f2 = this.features.next()).getStart() < this.bpEnd) {
                if (f2.getEnd() < this.bpStart || f2.getStart() >= this.bpEnd) continue;
                this.nextFeature = f2;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextFeature != null;
        }

        @Override
        public BasicFeature next() {
            BasicFeature retValue = this.nextFeature;
            this.advance();
            return retValue;
        }

        @Override
        public void remove() {
        }
    }
}

