/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class ECAlgorithms {
    public static ECPoint sumOfTwoMultiplies(ECPoint P, BigInteger a2, ECPoint Q, BigInteger b2) {
        ECCurve.F2m f2mCurve;
        ECCurve c2 = P.getCurve();
        if (!c2.equals(Q.getCurve())) {
            throw new IllegalArgumentException("P and Q must be on same curve");
        }
        if (c2 instanceof ECCurve.F2m && (f2mCurve = (ECCurve.F2m)c2).isKoblitz()) {
            return P.multiply(a2).add(Q.multiply(b2));
        }
        return ECAlgorithms.implShamirsTrick(P, a2, Q, b2);
    }

    public static ECPoint shamirsTrick(ECPoint P, BigInteger k2, ECPoint Q, BigInteger l2) {
        if (!P.getCurve().equals(Q.getCurve())) {
            throw new IllegalArgumentException("P and Q must be on same curve");
        }
        return ECAlgorithms.implShamirsTrick(P, k2, Q, l2);
    }

    private static ECPoint implShamirsTrick(ECPoint P, BigInteger k2, ECPoint Q, BigInteger l2) {
        int m2 = Math.max(k2.bitLength(), l2.bitLength());
        ECPoint Z = P.add(Q);
        ECPoint R = P.getCurve().getInfinity();
        for (int i2 = m2 - 1; i2 >= 0; --i2) {
            R = R.twice();
            if (k2.testBit(i2)) {
                if (l2.testBit(i2)) {
                    R = R.add(Z);
                    continue;
                }
                R = R.add(P);
                continue;
            }
            if (!l2.testBit(i2)) continue;
            R = R.add(Q);
        }
        return R;
    }
}

